/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.view;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOneControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractPolySequencerView;

public class OxiOnePolySequencerView
extends AbstractPolySequencerView<OxiOneControlSurface, OxiOneConfiguration> {
    public OxiOnePolySequencerView(OxiOneControlSurface surface, IModel model, boolean useTrackColor) {
        super(surface, model, useTrackColor, 16, 8, 4);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        boolean init = ((OxiOneControlSurface)this.surface).isPressed(ButtonID.PUNCH_IN);
        boolean end = ((OxiOneControlSurface)this.surface).isPressed(ButtonID.PUNCH_OUT);
        if (init || end) {
            if (velocity == 0) {
                INoteClip clip = this.getClip();
                int lengthOfOnePage = this.getLengthOfOnePage(this.numColumns * this.numSequencerRows);
                int offset = clip.getEditPage() * lengthOfOnePage;
                int index = note - ((OxiOneControlSurface)this.surface).getPadGrid().getStartNote();
                int x = index % this.numColumns;
                int y = index / this.numColumns;
                int step = this.numColumns * (this.numRows - 1 - y) + x;
                double lengthOfOnePad = Resolution.getValueAt(this.getResolutionIndex());
                double pos = (double)offset + (double)step * lengthOfOnePad;
                double newStart = init ? pos : clip.getLoopStart();
                double newLength = end ? Math.max(pos - newStart + lengthOfOnePad, lengthOfOnePad) : clip.getLoopLength();
                clip.setLoopStart(newStart);
                clip.setLoopLength(newLength);
                clip.setPlayRange(newStart, newStart + newLength);
            }
            return;
        }
        super.onGridNote(note, velocity);
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.isActive()) {
            return;
        }
        int index = note - ((OxiOneControlSurface)this.surface).getPadGrid().getStartNote();
        int x = index % this.numColumns;
        int y = index / this.numColumns;
        int step = this.numColumns * (this.numRows - 1 - y) + x;
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), step, 0);
        INoteClip clip = this.getClip();
        for (int row = 0; row < 128; ++row) {
            notePosition.setNote(row);
            if (clip.getStep(notePosition).getState() != StepState.START) continue;
            this.editNote(clip, notePosition, true);
        }
        ((OxiOneControlSurface)this.surface).consumePads();
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (ButtonID.isSceneButton(buttonID)) {
            this.onSceneButton(buttonID, event);
        }
    }
}

