/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.view;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOneControlSurface;
import de.mossgrabers.controller.oxi.one.controller.OxiOnePadGrid;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.view.AbstractSessionView;

public class OxiOneMixView
extends AbstractSessionView<OxiOneControlSurface, OxiOneConfiguration> {
    public OxiOneMixView(OxiOneControlSurface surface, IModel model) {
        super("Track Mixer", surface, model, 4, 16, true);
        int redLo = 6;
        int redHi = 4;
        boolean black = false;
        boolean white = true;
        int green = 2;
        int amber = 11;
        LightInfo isRecording = new LightInfo(4, -1, false);
        LightInfo isRecordingQueued = new LightInfo(4, 0, true);
        LightInfo isPlaying = new LightInfo(2, -1, false);
        LightInfo isPlayingQueued = new LightInfo(2, 2, true);
        LightInfo hasContent = new LightInfo(11, 1, false);
        LightInfo noContent = new LightInfo(0, -1, false);
        LightInfo recArmed = new LightInfo(6, -1, false);
        this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, hasContent, noContent, recArmed);
    }

    @Override
    public void drawGrid() {
        OxiOnePadGrid padGrid = ((OxiOneControlSurface)this.surface).getPadGrid();
        boolean colorTrackStates = ((OxiOneConfiguration)((OxiOneControlSurface)this.surface).getConfiguration()).isColorTrackStates();
        ITrackBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < tb.getPageSize(); ++i) {
            ITrack track = (ITrack)tb.getItem(i);
            if (track.doesExist()) {
                int colorIndex = this.colorManager.getColorIndex(DAWColor.getColorID(track.getColor()));
                if (track.isSelected()) {
                    padGrid.lightEx(i, 0, colorIndex, 1, false);
                } else {
                    padGrid.lightEx(i, 0, colorIndex);
                }
                padGrid.lightEx(i, 1, OxiOneMixView.getTrackStateColor(track.isMute(), colorTrackStates, 14, 16));
                padGrid.lightEx(i, 2, OxiOneMixView.getTrackStateColor(track.isSolo(), colorTrackStates, 7, 9));
                padGrid.lightEx(i, 3, OxiOneMixView.getTrackStateColor(track.isRecArm(), colorTrackStates, 4, 6));
                continue;
            }
            padGrid.lightEx(i, 3, 0);
            padGrid.lightEx(i, 2, 0);
            padGrid.lightEx(i, 1, 0);
            padGrid.lightEx(i, 0, 0);
        }
        super.drawGrid();
    }

    private static int getTrackStateColor(boolean state, boolean colorTrackStates, int activeColor, int inActiveColor) {
        if (state) {
            return activeColor;
        }
        return colorTrackStates ? inActiveColor : 0;
    }

    @Override
    public void onGridNote(int note, int velocity) {
        int row = note / 16;
        if (row < 4) {
            super.onGridNote(note, velocity);
        } else {
            int index = note % 16;
            ITrack track = (ITrack)this.model.getCurrentTrackBank().getItem(index);
            if (velocity == 0) {
                switch (row) {
                    case 7: {
                        OxiOneConfiguration configuration = (OxiOneConfiguration)((OxiOneControlSurface)this.surface).getConfiguration();
                        if (configuration.isDeleteModeActive()) {
                            configuration.toggleDeleteModeActive();
                            track.remove();
                            break;
                        }
                        if (configuration.isDuplicateModeActive()) {
                            configuration.toggleDuplicateModeActive();
                            track.duplicate();
                            break;
                        }
                        track.selectOrExpandGroup();
                        break;
                    }
                    case 6: {
                        track.toggleMute();
                        break;
                    }
                    case 5: {
                        track.toggleSolo();
                        break;
                    }
                    case 4: {
                        track.toggleRecArm();
                        break;
                    }
                }
            }
        }
        if (velocity == 0 && ((OxiOneControlSurface)this.surface).isPressed(ButtonID.SESSION)) {
            ((OxiOneControlSurface)this.surface).setTriggerConsumed(ButtonID.SESSION);
            ((OxiOneControlSurface)this.surface).recallPreferredView(this.model.getCursorTrack());
        }
    }

    @Override
    protected boolean handleButtonCombinations(ITrack track, ISlot slot) {
        if (!track.doesExist()) {
            return true;
        }
        if (this.isButtonCombination(ButtonID.STOP)) {
            track.stop(this.isAlternateFunction());
            return true;
        }
        return super.handleButtonCombinations(track, slot);
    }

    @Override
    protected int getYOffset() {
        return 4;
    }
}

