/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.view;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOneControlSurface;
import de.mossgrabers.controller.oxi.one.controller.OxiOnePadGrid;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractDrum8View;

public class OxiOneDrum8View
extends AbstractDrum8View<OxiOneControlSurface, OxiOneConfiguration> {
    public OxiOneDrum8View(OxiOneControlSurface surface, IModel model) {
        super(surface, model, 8, 16, 16, true);
    }

    @Override
    public void drawGrid() {
        if (((OxiOneControlSurface)this.surface).isPressed(ButtonID.MUTE)) {
            OxiOnePadGrid padGrid = ((OxiOneControlSurface)this.surface).getPadGrid();
            if (!this.isActive()) {
                padGrid.turnOff();
                return;
            }
            int black = this.model.getColorManager().getColorIndex("BUTTON_COLOR_OFF");
            boolean hasDrumPads = this.primary.hasDrumPads();
            IDrumPadBank drumPadBank = this.primary.getDrumPadBank();
            for (int sound = 0; sound < this.lanes; ++sound) {
                IDrumPad drumPad = drumPadBank.getItem(sound);
                if (hasDrumPads && drumPad.doesExist()) {
                    start = 3;
                    String padColor = DAWColor.getColorID(drumPad.getColor());
                    int y = this.allRows - 1 - sound;
                    padGrid.lightEx(0, y, padColor);
                    padGrid.lightEx(1, y, drumPad.isMute() ? 14 : 16);
                    padGrid.lightEx(2, y, drumPad.isSolo() ? 7 : 9);
                } else {
                    start = 0;
                }
                for (int col = start; col < this.clipCols; ++col) {
                    int x = col % this.numColumns;
                    int y = this.lanes - 1 - sound;
                    padGrid.lightEx(x, y, black);
                }
            }
            return;
        }
        super.drawGrid();
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (((OxiOneControlSurface)this.surface).isMutePressed()) {
            int y;
            if (velocity != 0 || !this.isActive() || !this.primary.hasDrumPads()) {
                return;
            }
            int index = note - ((OxiOneControlSurface)this.surface).getPadGrid().getStartNote();
            int x = index % this.numColumns;
            int sound = y = index / this.numColumns;
            IDrumPadBank drumPadBank = this.primary.getDrumPadBank();
            IDrumPad drumPad = drumPadBank.getItem(sound);
            if (!drumPad.doesExist()) {
                return;
            }
            switch (x) {
                case 0: {
                    drumPad.select();
                    if (((OxiOneControlSurface)this.surface).getModeManager().isActive(new Modes[]{Modes.DEVICE_LAYER})) break;
                    ((OxiOneControlSurface)this.surface).getDisplay().notify(drumPad.getName(12));
                    break;
                }
                case 1: {
                    drumPad.toggleMute();
                    break;
                }
                case 2: {
                    drumPad.toggleSolo();
                    break;
                }
            }
            return;
        }
        boolean init = ((OxiOneControlSurface)this.surface).isPressed(ButtonID.PUNCH_IN);
        boolean end = ((OxiOneControlSurface)this.surface).isPressed(ButtonID.PUNCH_OUT);
        if (init || end) {
            if (velocity == 0) {
                INoteClip clip = this.getClip();
                int lengthOfOnePage = this.getLengthOfOnePage(this.sequencerSteps);
                int offset = clip.getEditPage() * lengthOfOnePage;
                int index = note - ((OxiOneControlSurface)this.surface).getPadGrid().getStartNote();
                int x = index % this.numColumns;
                double lengthOfOnePad = Resolution.getValueAt(this.getResolutionIndex());
                double pos = (double)offset + (double)x * lengthOfOnePad;
                double newStart = init ? pos : clip.getLoopStart();
                double newLength = end ? Math.max(pos - newStart + lengthOfOnePad, lengthOfOnePad) : clip.getLoopLength();
                clip.setLoopStart(newStart);
                clip.setLoopLength(newLength);
                clip.setPlayRange(newStart, newStart + newLength);
            }
            return;
        }
        super.onGridNote(note, velocity);
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.isActive()) {
            return;
        }
        int index = note - ((OxiOneControlSurface)this.surface).getPadGrid().getStartNote();
        ((OxiOneControlSurface)this.surface).getButton(ButtonID.get(ButtonID.PAD1, index)).setConsumed();
        int stepX = index % this.numColumns;
        int stepY = this.scales.getDrumOffset() + index / this.numColumns;
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), stepX, stepY);
        this.editNote(this.getClip(), notePosition, false);
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (ButtonID.isSceneButton(buttonID)) {
            this.onSceneButton(buttonID, event);
        }
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int row, int velocity, int accentVelocity) {
        if (((OxiOneControlSurface)this.surface).isPressed(ButtonID.REPEAT) || ((OxiOneControlSurface)this.surface).isPressed(ButtonID.ACCENT)) {
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, ((OxiOneControlSurface)this.surface).isPressed(ButtonID.REPEAT));
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, row, velocity, accentVelocity);
    }
}

