/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.mode;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOneControlSurface;
import de.mossgrabers.controller.oxi.one.mode.IOxiModeDisplay;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleValueMenuComponent;
import de.mossgrabers.framework.mode.device.ParameterMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FourKnobProvider;
import java.util.Optional;

public class OxiOneParameterMode
extends ParameterMode<OxiOneControlSurface, OxiOneConfiguration>
implements IOxiModeDisplay {
    private int selectedKnobIndex = 0;
    private final IParameterProvider[] paramProviders = new IParameterProvider[3];
    private int selectedProviderIndex = 0;

    public OxiOneParameterMode(OxiOneControlSurface surface, IModel model) {
        super(surface, model, false);
        this.setControls(ContinuousID.createSequentialList(ContinuousID.KNOB1, 4));
        this.paramProviders[0] = new FourKnobProvider(surface, new BankParameterProvider(model.getCursorDevice().getParameterBank()), ButtonID.SHIFT);
        this.paramProviders[1] = new FourKnobProvider(surface, new BankParameterProvider(model.getProject().getParameterBank()), ButtonID.SHIFT);
        this.paramProviders[2] = new FourKnobProvider(surface, new BankParameterProvider(model.getCursorTrack().getParameterBank()), ButtonID.SHIFT);
        this.setMode();
    }

    @Override
    public void selectPreviousItem() {
        if (this.selectedProviderIndex == 0) {
            this.model.getCursorDevice().selectPrevious();
        }
    }

    @Override
    public void selectNextItem() {
        if (this.selectedProviderIndex == 0) {
            this.model.getCursorDevice().selectNext();
        }
    }

    @Override
    public boolean hasPreviousItem() {
        return this.selectedProviderIndex == 0 && this.model.getCursorDevice().canSelectPrevious();
    }

    @Override
    public boolean hasNextItem() {
        return this.selectedProviderIndex == 0 && this.model.getCursorDevice().canSelectNext();
    }

    @Override
    public void toggleDisplay() {
        this.selectedProviderIndex = (this.selectedProviderIndex + 1) % 3;
        this.setMode();
    }

    @Override
    public void setTouchedKnob(int knobIndex, boolean isTouched) {
        super.setTouchedKnob(knobIndex, isTouched);
        if (isTouched) {
            this.selectedKnobIndex = knobIndex;
        }
    }

    @Override
    public void updateDisplay() {
        int offset;
        IGraphicDisplay display = ((OxiOneControlSurface)this.surface).getGraphicsDisplay();
        int n = offset = ((OxiOneControlSurface)this.surface).isShiftPressed() ? 4 : 0;
        String name = this.selectedProviderIndex == 0 ? (this.model.hasSelectedDevice() ? this.model.getCursorDevice().getName(8) : "No device") : (this.selectedProviderIndex == 1 ? "Project" : "Track");
        IParameterBank paramBank = this.getParamBank();
        Optional pageName = paramBank.getPageBank().getSelectedItem();
        String desc = name + ": " + (pageName.isPresent() ? (String)pageName.get() : "None");
        IParameter p = (IParameter)this.bank.getItem(offset + this.selectedKnobIndex);
        Object paramLine = p.getName(5);
        int value = -1;
        if (!((String)paramLine).isEmpty()) {
            value = p.getValue();
            paramLine = (String)paramLine + ": " + p.getDisplayedValue(6);
        }
        String[] menu = new String[4];
        for (int i = 0; i < 4; ++i) {
            menu[i] = ((IParameter)paramBank.getItem(offset + i)).getName(4);
        }
        display.addElement(new TitleValueMenuComponent(desc, (String)paramLine, menu, value, false));
        display.send();
    }

    private void setMode() {
        this.switchBanks(this.getParamBank());
        this.setParameterProvider(this.paramProviders[this.selectedProviderIndex]);
        this.bindControls();
    }

    private IParameterBank getParamBank() {
        if (this.selectedProviderIndex == 0) {
            return this.model.getCursorDevice().getParameterBank();
        }
        if (this.selectedProviderIndex == 1) {
            return this.model.getProject().getParameterBank();
        }
        return this.model.getCursorTrack().getParameterBank();
    }
}

