/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc.module;

import de.mossgrabers.controller.osc.OSCConfiguration;
import de.mossgrabers.controller.osc.exception.IllegalParameterException;
import de.mossgrabers.controller.osc.exception.MissingCommandException;
import de.mossgrabers.controller.osc.exception.UnknownCommandException;
import de.mossgrabers.controller.osc.module.AbstractModule;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.RecordQuantization;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.osc.IOpenSoundControlWriter;
import de.mossgrabers.framework.parameter.IParameter;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Optional;

public class TrackModule
extends AbstractModule {
    private final OSCConfiguration configuration;

    public TrackModule(IHost host, IModel model, IOpenSoundControlWriter writer, OSCConfiguration configuration) {
        super(host, model, writer);
        this.configuration = configuration;
    }

    @Override
    public String[] getSupportedCommands() {
        return new String[]{"track", "master"};
    }

    @Override
    public void execute(String command, LinkedList<String> path, Object value) throws IllegalParameterException, UnknownCommandException, MissingCommandException {
        switch (command) {
            case "track": {
                String subCommand = TrackModule.getSubCommand(path);
                try {
                    int trackNo = Integer.parseInt(subCommand) - 1;
                    this.parseTrackValue((ITrack)this.model.getCurrentTrackBank().getItem(trackNo), path, value);
                }
                catch (NumberFormatException ex) {
                    this.parseTrackCommands(subCommand, path, value);
                }
                break;
            }
            case "master": {
                this.parseTrackValue(this.model.getMasterTrack(), path, value);
                break;
            }
            default: {
                throw new UnknownCommandException(command);
            }
        }
    }

    @Override
    public void flush(boolean dump) {
        ITrackBank trackBank = this.model.getCurrentTrackBank();
        for (int i = 0; i < trackBank.getPageSize(); ++i) {
            this.flushTrack(this.writer, "/track/" + (i + 1) + "/", (ITrack)trackBank.getItem(i), dump);
        }
        this.flushTrack(this.writer, "/master/", this.model.getMasterTrack(), dump);
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        this.flushTrack(this.writer, "/track/selected/", cursorTrack, dump);
        this.writer.sendOSC("/track/toggleBank", this.model.isEffectTrackBankActive() ? 1 : 0, dump);
        this.writer.sendOSC("/track/hasParent", trackBank.hasParent(), dump);
        String paramAddress = "/track/param/";
        IParameterBank parameterBank = this.model.getCursorTrack().getParameterBank();
        for (int i = 0; i < parameterBank.getPageSize(); ++i) {
            int oneplus = i + 1;
            this.flushParameterData(this.writer, "/track/param/" + oneplus + "/", (IParameter)parameterBank.getItem(i), dump);
        }
        IParameterPageBank parameterPageBank = parameterBank.getPageBank();
        int selectedParameterPage = parameterPageBank.getSelectedItemIndex();
        for (int i = 0; i < parameterPageBank.getPageSize(); ++i) {
            int oneplus = i + 1;
            String pageName = (String)parameterPageBank.getItem(i);
            String pageAddress = "/track/page/" + oneplus + "/";
            this.writer.sendOSC(pageAddress + "exists", !pageName.isBlank(), dump);
            this.writer.sendOSC(pageAddress, pageName, dump);
            this.writer.sendOSC(pageAddress + "name", pageName, dump);
            this.writer.sendOSC(pageAddress + "selected", selectedParameterPage == i, dump);
        }
        Optional selectedItem = parameterPageBank.getSelectedItem();
        this.writer.sendOSC("/track/page/selected/name", selectedItem.isPresent() ? (String)selectedItem.get() : "", dump);
    }

    private void flushTrack(IOpenSoundControlWriter writer, String trackAddress, ITrack track, boolean dump) {
        writer.sendOSC(trackAddress + "exists", track.doesExist(), dump);
        ChannelType type = track.getType();
        writer.sendOSC(trackAddress + "type", type == null ? null : type.name().toLowerCase(Locale.US), dump);
        writer.sendOSC(trackAddress + "activated", track.isActivated(), dump);
        writer.sendOSC(trackAddress + "selected", track.isSelected(), dump);
        writer.sendOSC(trackAddress + "isGroup", track.isGroup(), dump);
        writer.sendOSC(trackAddress + "name", track.getName(), dump);
        writer.sendOSC(trackAddress + "volumeStr", track.getVolumeStr(), dump);
        writer.sendOSC(trackAddress + "volume", track.getVolume(), dump);
        writer.sendOSC(trackAddress + "panStr", track.getPanStr(), dump);
        writer.sendOSC(trackAddress + "pan", track.getPan(), dump);
        writer.sendOSC(trackAddress + "mute", track.isMute(), dump);
        writer.sendOSC(trackAddress + "solo", track.isSolo(), dump);
        writer.sendOSC(trackAddress + "recarm", track.isRecArm(), dump);
        writer.sendOSC(trackAddress + "monitor", track.isMonitor(), dump);
        writer.sendOSC(trackAddress + "autoMonitor", track.isAutoMonitor(), dump);
        writer.sendOSC(trackAddress + "canHoldNotes", track.canHoldNotes(), dump);
        writer.sendOSC(trackAddress + "canHoldAudioData", track.canHoldAudioData(), dump);
        writer.sendOSC(trackAddress + "position", track.getPosition(), dump);
        if (track instanceof ICursorTrack) {
            ICursorTrack cursorTrack = (ICursorTrack)track;
            writer.sendOSC(trackAddress + "pinned", cursorTrack.isPinned(), dump);
        }
        ISendBank sendBank = track.getSendBank();
        for (int i = 0; i < sendBank.getPageSize(); ++i) {
            this.flushParameterData(writer, trackAddress + "send/" + (i + 1) + "/", (IParameter)sendBank.getItem(i), dump);
        }
        ISlotBank slotBank = track.getSlotBank();
        for (int i = 0; i < slotBank.getPageSize(); ++i) {
            ISlot slot = (ISlot)slotBank.getItem(i);
            String clipAddress = trackAddress + "clip/" + (i + 1) + "/";
            writer.sendOSC(clipAddress + "name", slot.getName(), dump);
            writer.sendOSC(clipAddress + "isSelected", slot.isSelected(), dump);
            writer.sendOSC(clipAddress + "hasContent", slot.hasContent(), dump);
            writer.sendOSC(clipAddress + "isPlaying", slot.isPlaying(), dump);
            writer.sendOSC(clipAddress + "isRecording", slot.isRecording(), dump);
            writer.sendOSC(clipAddress + "isPlayingQueued", slot.isPlayingQueued(), dump);
            writer.sendOSC(clipAddress + "isRecordingQueued", slot.isRecordingQueued(), dump);
            writer.sendOSC(clipAddress + "isStopQueued", slot.isStopQueued(), dump);
            ColorEx color = slot.getColor();
            writer.sendOSCColor(clipAddress + "color", color.getRed(), color.getGreen(), color.getBlue(), dump);
        }
        ColorEx color = track.getColor();
        writer.sendOSCColor(trackAddress + "color", color.getRed(), color.getGreen(), color.getBlue(), dump);
        String crossfadeMode = track.getCrossfadeParameter().getDisplayedValue();
        writer.sendOSC(trackAddress + "crossfadeMode/A", "A".equals(crossfadeMode), dump);
        writer.sendOSC(trackAddress + "crossfadeMode/B", "B".equals(crossfadeMode), dump);
        writer.sendOSC(trackAddress + "crossfadeMode/AB", "AB".equals(crossfadeMode), dump);
        writer.sendOSC(trackAddress + "recordQuantization", track.getRecordQuantizationGrid().getValue(), dump);
        writer.sendOSC(trackAddress + "vu", this.configuration.isEnableVUMeters() ? track.getVu() : 0, dump);
    }

    private void parseTrackCommands(String command, LinkedList<String> path, Object value) throws UnknownCommandException, MissingCommandException, IllegalParameterException {
        ITrackBank tb = this.model.getCurrentTrackBank();
        block16 : switch (command) {
            case "indicate": {
                String indicateCommand = TrackModule.getSubCommand(path);
                boolean isTrue = TrackModule.isTrigger(value);
                switch (indicateCommand) {
                    case "volume": {
                        for (int i = 0; i < tb.getPageSize(); ++i) {
                            ((ITrack)tb.getItem(i)).setVolumeIndication(isTrue);
                        }
                        break block16;
                    }
                    case "pan": {
                        for (int i = 0; i < tb.getPageSize(); ++i) {
                            ((ITrack)tb.getItem(i)).setPanIndication(isTrue);
                        }
                        break block16;
                    }
                    case "send": {
                        int sendIndex = Integer.parseInt(path.get(0)) - 1;
                        for (int i = 0; i < tb.getPageSize(); ++i) {
                            ((ISend)((ITrack)tb.getItem(i)).getSendBank().getItem(sendIndex)).setIndication(isTrue);
                        }
                        break block16;
                    }
                    default: {
                        throw new UnknownCommandException(indicateCommand);
                    }
                }
            }
            case "bank": {
                String bankCommand;
                switch (bankCommand = TrackModule.getSubCommand(path)) {
                    case "page": {
                        if ("+".equals(TrackModule.getSubCommand(path))) {
                            tb.selectNextPage();
                            break block16;
                        }
                        tb.selectPreviousPage();
                        break block16;
                    }
                    case "+": {
                        tb.scrollForwards();
                        break block16;
                    }
                    case "-": {
                        tb.scrollBackwards();
                        break block16;
                    }
                }
                throw new UnknownCommandException(bankCommand);
            }
            case "+": {
                int index1;
                Optional selTrack1 = tb.getSelectedItem();
                int n = index1 = selTrack1.isEmpty() ? 0 : ((ITrack)selTrack1.get()).getIndex() + 1;
                if (index1 == tb.getPageSize()) {
                    tb.selectNextPage();
                    return;
                }
                ((ITrack)tb.getItem(index1)).select();
                break;
            }
            case "-": {
                int index2;
                Optional selTrack2 = tb.getSelectedItem();
                int n = index2 = selTrack2.isEmpty() ? 0 : ((ITrack)selTrack2.get()).getIndex() - 1;
                if (index2 == -1) {
                    tb.selectPreviousPage();
                    return;
                }
                ((ITrack)tb.getItem(index2)).select();
                break;
            }
            case "add": {
                String subCommand2 = TrackModule.getSubCommand(path);
                IApplication application = this.model.getApplication();
                switch (subCommand2) {
                    case "audio": {
                        this.model.getTrackBank().addChannel(ChannelType.AUDIO);
                        break block16;
                    }
                    case "effect": {
                        application.addEffectTrack();
                        break block16;
                    }
                    case "instrument": {
                        this.model.getTrackBank().addChannel(ChannelType.INSTRUMENT);
                        break block16;
                    }
                }
                throw new UnknownCommandException(subCommand2);
            }
            case "stop": 
            case "stopAlt": {
                this.model.getCurrentTrackBank().stop("stopAlt".equals(command));
                break;
            }
            case "vu": {
                this.configuration.setVUMetersEnabled(TrackModule.isTrigger(value));
                break;
            }
            case "toggleBank": {
                if (this.model.getEffectTrackBank() == null) {
                    return;
                }
                this.model.toggleCurrentTrackBank();
                ITrackBank tbNew = this.model.getCurrentTrackBank();
                ITrackBank tbOther = this.model.isEffectTrackBankActive() ? this.model.getTrackBank() : this.model.getEffectTrackBank();
                Optional selectedTrack = tbNew.getSelectedItem();
                if (selectedTrack.isEmpty()) {
                    ((ITrack)tbNew.getItem(0)).select();
                }
                for (int i = 0; i < tbNew.getPageSize(); ++i) {
                    ITrack otherTrack = (ITrack)tbOther.getItem(i);
                    otherTrack.setVolumeIndication(false);
                    otherTrack.setPanIndication(false);
                    ITrack track = (ITrack)tbNew.getItem(i);
                    track.setVolumeIndication(true);
                    track.setPanIndication(true);
                }
                break;
            }
            case "parent": {
                if (this.configuration.isTrackNavigationFlat()) break;
                tb.selectParent();
                break;
            }
            case "select": 
            case "selected": {
                ICursorTrack cursorTrack = this.model.getCursorTrack();
                if (!cursorTrack.doesExist()) break;
                this.parseTrackValue(cursorTrack, path, value);
                break;
            }
            case "param": {
                this.parseParamValue(path, value);
                break;
            }
            case "page": {
                this.parsePageValue(path, value);
                break;
            }
            default: {
                throw new UnknownCommandException(command);
            }
        }
    }

    private void parseTrackValue(ITrack track, LinkedList<String> path, Object value) throws IllegalParameterException, MissingCommandException, UnknownCommandException {
        String command;
        block22 : switch (command = TrackModule.getSubCommand(path)) {
            case "name": {
                if (value == null) break;
                track.setName(value.toString());
                break;
            }
            case "activated": {
                track.setIsActivated(TrackModule.isTrigger(value));
                break;
            }
            case "crossfadeMode": {
                switch (TrackModule.getSubCommand(path)) {
                    case "A": {
                        track.getCrossfadeParameter().setNormalizedValue(0.0);
                        break block22;
                    }
                    case "B": {
                        track.getCrossfadeParameter().setNormalizedValue(1.0);
                        break block22;
                    }
                }
                track.getCrossfadeParameter().setNormalizedValue(0.5);
                break;
            }
            case "recordQuantization": {
                track.setRecordQuantizationGrid(RecordQuantization.lookup(value.toString()));
                break;
            }
            case "select": 
            case "selected": {
                if (!TrackModule.isTrigger(value)) break;
                track.selectOrExpandGroup();
                break;
            }
            case "duplicate": {
                track.duplicate();
                break;
            }
            case "remove": {
                track.remove();
                break;
            }
            case "volume": {
                if (path.isEmpty()) {
                    track.setVolume(TrackModule.toInteger(value));
                    break;
                }
                if ("indicate".equals(path.get(0))) {
                    track.setVolumeIndication(TrackModule.isTrigger(value));
                    break;
                }
                if ("reset".equals(path.get(0))) {
                    track.resetVolume();
                    break;
                }
                if (!"touched".equals(path.get(0))) break;
                track.touchVolume(TrackModule.isTrigger(value));
                break;
            }
            case "pan": {
                if (path.isEmpty()) {
                    track.setPan(TrackModule.toInteger(value));
                    break;
                }
                if ("indicate".equals(path.get(0))) {
                    track.setPanIndication(TrackModule.isTrigger(value));
                    break;
                }
                if ("reset".equals(path.get(0))) {
                    track.resetPan();
                    break;
                }
                if (!"touched".equals(path.get(0))) break;
                track.touchPan(TrackModule.isTrigger(value));
                break;
            }
            case "mute": {
                if (value == null) {
                    track.toggleMute();
                    break;
                }
                track.setMute(TrackModule.isTrigger(value));
                break;
            }
            case "solo": {
                if (value == null) {
                    track.toggleSolo();
                    break;
                }
                track.setSolo(TrackModule.isTrigger(value));
                break;
            }
            case "recarm": {
                if (value == null) {
                    track.toggleRecArm();
                    break;
                }
                track.setRecArm(TrackModule.isTrigger(value));
                break;
            }
            case "monitor": {
                if (value == null) {
                    track.toggleMonitor();
                    break;
                }
                track.setMonitor(TrackModule.isTrigger(value));
                break;
            }
            case "autoMonitor": {
                if (value == null) {
                    track.toggleAutoMonitor();
                    break;
                }
                track.setAutoMonitor(TrackModule.isTrigger(value));
                break;
            }
            case "send": {
                int sendNo = Integer.parseInt(path.removeFirst()) - 1;
                TrackModule.parseSendValue(track, sendNo, path, value);
                break;
            }
            case "clip": {
                this.parseClipValue(track, path, value);
                break;
            }
            case "enter": {
                if (!TrackModule.isTrigger(value) || !track.isGroup()) break;
                if (this.configuration.isTrackNavigationFlat()) {
                    track.toggleGroupExpanded();
                    break;
                }
                track.setGroupExpanded(true);
                track.enter();
                break;
            }
            case "color": {
                Optional<ColorEx> color = TrackModule.matchColor(TrackModule.toString(value));
                if (!color.isPresent()) break;
                track.setColor(color.get());
                break;
            }
            case "pinned": {
                if (!(track instanceof ICursorTrack)) break;
                ICursorTrack cursorTrack = (ICursorTrack)track;
                if (value == null) {
                    cursorTrack.togglePinned();
                    break;
                }
                cursorTrack.setPinned(TrackModule.isTrigger(value));
                break;
            }
            default: {
                throw new UnknownCommandException(command);
            }
        }
    }

    private void parseClipValue(ITrack track, LinkedList<String> path, Object value) throws UnknownCommandException, MissingCommandException, IllegalParameterException {
        String command = TrackModule.getSubCommand(path);
        try {
            int clipNo = Integer.parseInt(command) - 1;
            String clipCommand = TrackModule.getSubCommand(path);
            ISlot slot = (ISlot)track.getSlotBank().getItem(clipNo);
            switch (clipCommand) {
                case "select": 
                case "selected": {
                    slot.select();
                    break;
                }
                case "launch": {
                    slot.launch(TrackModule.toInteger(value) > 0, false);
                    break;
                }
                case "launchAlt": {
                    slot.launch(TrackModule.toInteger(value) > 0, true);
                    return;
                }
                case "record": {
                    this.model.recordNoteClip(track, slot);
                    break;
                }
                case "create": {
                    this.model.createNoteClip(track, slot, TrackModule.toInteger(value), true);
                    break;
                }
                case "duplicate": {
                    slot.duplicate();
                    break;
                }
                case "remove": {
                    slot.remove();
                    break;
                }
                case "color": {
                    Optional<ColorEx> color = TrackModule.matchColor(TrackModule.toString(value));
                    if (color.isPresent()) {
                        slot.setColor(color.get());
                    }
                    break;
                }
                default: {
                    throw new UnknownCommandException(clipCommand);
                }
            }
        }
        catch (NumberFormatException ex) {
            switch (command) {
                case "stop": {
                    track.stop(false);
                    break;
                }
                case "returntoarrangement": {
                    track.returnToArrangement();
                    break;
                }
                default: {
                    throw new UnknownCommandException(command);
                }
            }
        }
    }

    private static void parseSendValue(ITrack track, int sendIndex, LinkedList<String> path, Object value) throws UnknownCommandException, MissingCommandException, IllegalParameterException {
        String command;
        ISend send = (ISend)track.getSendBank().getItem(sendIndex);
        if (send == null) {
            return;
        }
        switch (command = TrackModule.getSubCommand(path)) {
            case "activated": {
                if (!TrackModule.isTrigger(value)) break;
                send.toggleEnabled();
                break;
            }
            case "volume": {
                if (path.isEmpty()) {
                    send.setValue(TrackModule.toInteger(value));
                    break;
                }
                if ("indicate".equals(path.get(0))) {
                    send.setIndication(TrackModule.isTrigger(value));
                    break;
                }
                if ("reset".equals(path.get(0))) {
                    send.resetValue();
                    break;
                }
                if (!"touched".equals(path.get(0))) break;
                send.touchValue(TrackModule.isTrigger(value));
                break;
            }
            default: {
                throw new UnknownCommandException(command);
            }
        }
    }

    private void parseParamValue(LinkedList<String> path, Object value) throws UnknownCommandException, MissingCommandException, IllegalParameterException {
        IParameterBank parameterBank = this.model.getCursorTrack().getParameterBank();
        String subCommand = TrackModule.getSubCommand(path);
        try {
            int paramNo = Integer.parseInt(subCommand) - 1;
            TrackModule.parseFXParamValue((IParameter)parameterBank.getItem(paramNo), path, value);
        }
        catch (NumberFormatException ex) {
            switch (subCommand) {
                case "+": {
                    if (!TrackModule.isTrigger(value)) break;
                    parameterBank.selectNextItem();
                    break;
                }
                case "-": {
                    if (!TrackModule.isTrigger(value)) break;
                    parameterBank.selectPreviousItem();
                    break;
                }
                case "bank": {
                    String subCommand2 = TrackModule.getSubCommand(path);
                    if ("page".equals(subCommand2)) {
                        IParameterPageBank pageBank = parameterBank.getPageBank();
                        String directionCommand = TrackModule.getSubCommand(path);
                        if ("+".equals(directionCommand)) {
                            pageBank.selectNextPage();
                            break;
                        }
                        pageBank.selectPreviousPage();
                        break;
                    }
                    throw new UnknownCommandException(subCommand2);
                }
                default: {
                    throw new UnknownCommandException(subCommand);
                }
            }
        }
    }

    private void parsePageValue(LinkedList<String> path, Object value) throws UnknownCommandException, MissingCommandException, IllegalParameterException {
        IParameterBank parameterBank = this.model.getCursorTrack().getParameterBank();
        IParameterPageBank parameterPageBank = parameterBank.getPageBank();
        String subCommand = TrackModule.getSubCommand(path);
        if ("select".equals(subCommand) || "selected".equals(subCommand)) {
            parameterPageBank.selectPage(TrackModule.toInteger(value) - 1);
        } else {
            try {
                int index = Integer.parseInt(subCommand) - 1;
                parameterPageBank.selectPage(index);
            }
            catch (NumberFormatException ex2) {
                throw new UnknownCommandException(subCommand);
            }
        }
    }

    private static void parseFXParamValue(IParameter param, LinkedList<String> path, Object value) throws MissingCommandException, IllegalParameterException, UnknownCommandException {
        String command;
        switch (command = TrackModule.getSubCommand(path)) {
            case "value": {
                param.setValue(TrackModule.toInteger(value));
                break;
            }
            case "indicate": {
                param.setIndication(TrackModule.isTrigger(value));
                break;
            }
            case "reset": {
                param.resetValue();
                break;
            }
            case "touched": {
                param.touchValue(TrackModule.isTrigger(value));
                break;
            }
            default: {
                throw new UnknownCommandException(command);
            }
        }
    }
}

