/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc.module;

import de.mossgrabers.controller.osc.exception.IllegalParameterException;
import de.mossgrabers.controller.osc.exception.MissingCommandException;
import de.mossgrabers.controller.osc.exception.UnknownCommandException;
import de.mossgrabers.controller.osc.module.AbstractModule;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.osc.IOpenSoundControlWriter;
import java.util.LinkedList;
import java.util.Optional;

public class SceneModule
extends AbstractModule {
    public SceneModule(IHost host, IModel model, IOpenSoundControlWriter writer) {
        super(host, model, writer);
    }

    @Override
    public String[] getSupportedCommands() {
        return new String[]{"scene"};
    }

    @Override
    public void execute(String command, LinkedList<String> path, Object value) throws IllegalParameterException, UnknownCommandException, MissingCommandException {
        if (!"scene".equals(command)) {
            throw new UnknownCommandException(command);
        }
        String sceneCommand = SceneModule.getSubCommand(path);
        ISceneBank sceneBank = this.model.getCurrentTrackBank().getSceneBank();
        block7 : switch (sceneCommand) {
            case "bank": {
                String subCommand2;
                switch (subCommand2 = SceneModule.getSubCommand(path)) {
                    case "+": {
                        if (!SceneModule.isTrigger(value)) break block7;
                        sceneBank.selectNextPage();
                        break block7;
                    }
                    case "-": {
                        if (!SceneModule.isTrigger(value)) break block7;
                        sceneBank.selectPreviousPage();
                        break block7;
                    }
                    default: {
                        throw new UnknownCommandException(subCommand2);
                    }
                }
            }
            case "+": {
                if (!SceneModule.isTrigger(value)) break;
                sceneBank.scrollForwards();
                break;
            }
            case "-": {
                if (!SceneModule.isTrigger(value)) break;
                sceneBank.scrollBackwards();
                break;
            }
            case "create": {
                if (!SceneModule.isTrigger(value)) break;
                this.model.getProject().createSceneFromPlayingLauncherClips();
                break;
            }
            case "add": {
                if (!SceneModule.isTrigger(value)) break;
                this.model.getProject().createScene();
                break;
            }
            default: {
                String sceneCommand2;
                int sceneIndex = Integer.parseInt(sceneCommand);
                IScene scene = (IScene)sceneBank.getItem(sceneIndex - 1);
                switch (sceneCommand2 = SceneModule.getSubCommand(path)) {
                    case "select": {
                        if (!SceneModule.isTrigger(value)) break block7;
                        scene.select();
                        break block7;
                    }
                    case "launch": {
                        scene.launch(SceneModule.isTrigger(value), false);
                        break block7;
                    }
                    case "launchAlt": {
                        scene.launch(SceneModule.isTrigger(value), false);
                        break block7;
                    }
                    case "duplicate": {
                        scene.duplicate();
                        break block7;
                    }
                    case "remove": {
                        scene.remove();
                        break block7;
                    }
                    case "name": {
                        if (value == null || !scene.doesExist()) break block7;
                        scene.setName(value.toString());
                        break block7;
                    }
                    case "color": {
                        Optional<ColorEx> color = SceneModule.matchColor(SceneModule.toString(value));
                        if (!color.isPresent() || !scene.doesExist()) break block7;
                        scene.setColor(color.get());
                        break block7;
                    }
                    default: {
                        throw new UnknownCommandException(sceneCommand2);
                    }
                }
            }
        }
    }

    @Override
    public void flush(boolean dump) {
        ISceneBank sceneBank = this.model.getSceneBank();
        for (int i = 0; i < sceneBank.getPageSize(); ++i) {
            IScene scene = (IScene)sceneBank.getItem(i);
            String sceneAddress = "/scene/" + (i + 1) + "/";
            this.writer.sendOSC(sceneAddress + "exists", scene.doesExist(), dump);
            this.writer.sendOSC(sceneAddress + "name", scene.getName(), dump);
            this.writer.sendOSC(sceneAddress + "selected", scene.isSelected(), dump);
            ColorEx color = scene.getColor();
            if (color == null) {
                color = ColorEx.BLACK;
            }
            this.writer.sendOSCColor(sceneAddress + "color", color.getRed(), color.getGreen(), color.getBlue(), dump);
        }
    }
}

