/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc.module;

import de.mossgrabers.controller.osc.OSCConfiguration;
import de.mossgrabers.controller.osc.exception.IllegalParameterException;
import de.mossgrabers.controller.osc.exception.MissingCommandException;
import de.mossgrabers.controller.osc.exception.UnknownCommandException;
import de.mossgrabers.controller.osc.module.AbstractModule;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.EqualizerBandType;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.IDevice;
import de.mossgrabers.framework.daw.data.IEqualizerDevice;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.bank.IDeviceBank;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.daw.data.bank.ILayerBank;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.empty.EmptyLayer;
import de.mossgrabers.framework.osc.IOpenSoundControlWriter;
import de.mossgrabers.framework.parameter.IParameter;
import java.util.LinkedList;
import java.util.Optional;

public class DeviceModule
extends AbstractModule {
    private final OSCConfiguration configuration;

    public DeviceModule(IHost host, IModel model, IOpenSoundControlWriter writer, OSCConfiguration configuration) {
        super(host, model, writer);
        this.configuration = configuration;
    }

    @Override
    public String[] getSupportedCommands() {
        return new String[]{"device", "primary", "eq"};
    }

    @Override
    public void execute(String command, LinkedList<String> path, Object value) throws IllegalParameterException, UnknownCommandException, MissingCommandException {
        switch (command) {
            case "device": {
                this.parseCursorDeviceValue(this.model.getCursorDevice(), path, value);
                break;
            }
            case "primary": {
                this.parseDeviceValue(this.model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT), path, value);
                break;
            }
            case "eq": {
                IEqualizerDevice specificDevice = (IEqualizerDevice)this.model.getSpecificDevice(DeviceID.EQ);
                if (this.parseEqValue(specificDevice, path, value)) break;
                this.parseDeviceValue(specificDevice, path, value);
                break;
            }
            default: {
                throw new UnknownCommandException(command);
            }
        }
    }

    @Override
    public void flush(boolean dump) {
        int i;
        ICursorDevice cd = this.model.getCursorDevice();
        this.flushDevice(this.writer, "/device/", cd, dump);
        this.writer.sendOSC("/device/pinned", cd.isPinned(), dump);
        if (cd.hasDrumPads()) {
            IDrumPadBank drumPadBank = cd.getDrumPadBank();
            for (i = 0; i < drumPadBank.getPageSize(); ++i) {
                this.flushDeviceLayer(this.writer, "/device/drumpad/" + (i + 1) + "/", drumPadBank.getItem(i), dump);
            }
        }
        ILayerBank layerBank = cd.getLayerBank();
        for (i = 0; i < layerBank.getPageSize(); ++i) {
            this.flushDeviceLayer(this.writer, "/device/layer/" + (i + 1) + "/", (IChannel)layerBank.getItem(i), dump);
        }
        Optional selectedLayer = layerBank.getSelectedItem();
        this.flushDeviceLayer(this.writer, "/device/layer/selected/", selectedLayer.isEmpty() ? EmptyLayer.getInstance(layerBank.getPageSize()) : (IChannel)selectedLayer.get(), dump);
        this.flushDevice(this.writer, "/primary/", this.model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT), dump);
        this.flushDevice(this.writer, "/eq/", this.model.getSpecificDevice(DeviceID.EQ), dump);
    }

    private void flushDevice(IOpenSoundControlWriter writer, String deviceAddress, ISpecificDevice device, boolean dump) {
        int oneplus;
        int i;
        writer.sendOSC(deviceAddress + "exists", device.doesExist(), dump);
        writer.sendOSC(deviceAddress + "name", device.getName(), dump);
        writer.sendOSC(deviceAddress + "bypass", !device.isEnabled(), dump);
        writer.sendOSC(deviceAddress + "expand", device.isExpanded(), dump);
        writer.sendOSC(deviceAddress + "parameters", device.isParameterPageSectionVisible(), dump);
        writer.sendOSC(deviceAddress + "window", device.isWindowOpen(), dump);
        if (device instanceof IEqualizerDevice) {
            IEqualizerDevice equalizer = (IEqualizerDevice)device;
            for (int i2 = 0; i2 < equalizer.getBandCount(); ++i2) {
                int oneplus2 = i2 + 1;
                writer.sendOSC(deviceAddress + "type/" + oneplus2 + "/value", equalizer.getTypeID(i2).name().toLowerCase(), dump);
                this.flushParameterData(writer, deviceAddress + "gain/" + oneplus2 + "/", equalizer.getGainParameter(i2), dump);
                this.flushParameterData(writer, deviceAddress + "freq/" + oneplus2 + "/", equalizer.getFrequencyParameter(i2), dump);
                this.flushParameterData(writer, deviceAddress + "q/" + oneplus2 + "/", equalizer.getQParameter(i2), dump);
            }
            return;
        }
        if (device instanceof ICursorDevice) {
            ICursorDevice cursorDevice = (ICursorDevice)device;
            int positionInBank = device.getIndex();
            IDeviceBank deviceBank = cursorDevice.getDeviceBank();
            for (i = 0; i < deviceBank.getPageSize(); ++i) {
                oneplus = i + 1;
                IDevice siblingDevice = (IDevice)deviceBank.getItem(i);
                String siblingAddress = deviceAddress + "sibling/" + oneplus + "/";
                writer.sendOSC(siblingAddress + "exists", siblingDevice.doesExist(), dump);
                writer.sendOSC(siblingAddress + "name", siblingDevice.getName(), dump);
                writer.sendOSC(siblingAddress + "bypass", !siblingDevice.isEnabled(), dump);
                writer.sendOSC(siblingAddress + "selected", i == positionInBank, dump);
            }
        }
        IParameterBank parameterBank = device.getParameterBank();
        for (int i3 = 0; i3 < parameterBank.getPageSize(); ++i3) {
            int oneplus3 = i3 + 1;
            this.flushParameterData(writer, deviceAddress + "param/" + oneplus3 + "/", (IParameter)parameterBank.getItem(i3), dump);
        }
        IParameterPageBank parameterPageBank = device.getParameterBank().getPageBank();
        int selectedParameterPage = parameterPageBank.getSelectedItemIndex();
        for (i = 0; i < parameterPageBank.getPageSize(); ++i) {
            oneplus = i + 1;
            String pageName = (String)parameterPageBank.getItem(i);
            String pageAddress = deviceAddress + "page/" + oneplus + "/";
            writer.sendOSC(pageAddress + "exists", !pageName.isBlank(), dump);
            writer.sendOSC(pageAddress, pageName, dump);
            writer.sendOSC(pageAddress + "name", pageName, dump);
            writer.sendOSC(pageAddress + "selected", selectedParameterPage == i, dump);
        }
        Optional selectedItem = parameterPageBank.getSelectedItem();
        writer.sendOSC(deviceAddress + "page/selected/name", selectedItem.isPresent() ? (String)selectedItem.get() : "", dump);
    }

    private void flushDeviceLayer(IOpenSoundControlWriter writer, String deviceAddress, IChannel channel, boolean dump) {
        if (channel == null) {
            return;
        }
        writer.sendOSC(deviceAddress + "exists", channel.doesExist(), dump);
        writer.sendOSC(deviceAddress + "activated", channel.isActivated(), dump);
        writer.sendOSC(deviceAddress + "selected", channel.isSelected(), dump);
        writer.sendOSC(deviceAddress + "name", channel.getName(), dump);
        writer.sendOSC(deviceAddress + "volumeStr", channel.getVolumeStr(), dump);
        writer.sendOSC(deviceAddress + "volume", channel.getVolume(), dump);
        writer.sendOSC(deviceAddress + "panStr", channel.getPanStr(), dump);
        writer.sendOSC(deviceAddress + "pan", channel.getPan(), dump);
        writer.sendOSC(deviceAddress + "mute", channel.isMute(), dump);
        writer.sendOSC(deviceAddress + "solo", channel.isSolo(), dump);
        ISendBank sendBank = channel.getSendBank();
        for (int i = 0; i < sendBank.getPageSize(); ++i) {
            this.flushParameterData(writer, deviceAddress + "send/" + (i + 1) + "/", (IParameter)sendBank.getItem(i), dump);
        }
        if (this.configuration.isEnableVUMeters()) {
            writer.sendOSC(deviceAddress + "vu", channel.getVu(), dump);
        }
        ColorEx color = channel.getColor();
        writer.sendOSCColor(deviceAddress + "color", color.getRed(), color.getGreen(), color.getBlue(), dump);
    }

    private void parseCursorDeviceValue(ICursorDevice cursorDevice, LinkedList<String> path, Object value) throws UnknownCommandException, MissingCommandException, IllegalParameterException {
        String command;
        block7 : switch (command = DeviceModule.getSubCommand(path)) {
            case "sibling": {
                String subCommand2;
                String siblingIndex = DeviceModule.getSubCommand(path);
                int siblingNo = Integer.parseInt(siblingIndex);
                switch (subCommand2 = DeviceModule.getSubCommand(path)) {
                    case "select": 
                    case "selected": {
                        if (!DeviceModule.isTrigger(value) || cursorDevice == null) break block7;
                        ((IDevice)cursorDevice.getDeviceBank().getItem(siblingNo - 1)).select();
                        break block7;
                    }
                    default: {
                        throw new UnknownCommandException(subCommand2);
                    }
                }
            }
            case "bank": {
                if (cursorDevice == null) break;
                String subCommand3 = DeviceModule.getSubCommand(path);
                if ("page".equals(subCommand3)) {
                    String directionCommand = DeviceModule.getSubCommand(path);
                    if ("+".equals(directionCommand)) {
                        cursorDevice.getDeviceBank().selectNextPage();
                        break;
                    }
                    cursorDevice.getDeviceBank().selectPreviousPage();
                    break;
                }
                throw new UnknownCommandException(subCommand3);
            }
            case "+": {
                if (!DeviceModule.isTrigger(value)) break;
                cursorDevice.selectNext();
                break;
            }
            case "-": {
                if (!DeviceModule.isTrigger(value)) break;
                cursorDevice.selectPrevious();
                break;
            }
            case "pinned": {
                if (value == null) {
                    cursorDevice.togglePinned();
                    break;
                }
                cursorDevice.setPinned(DeviceModule.isTrigger(value));
                break;
            }
            default: {
                path.add(0, command);
                this.parseDeviceValue(cursorDevice, path, value);
            }
        }
    }

    private void parseDeviceValue(ISpecificDevice device, LinkedList<String> path, Object value) throws UnknownCommandException, MissingCommandException, IllegalParameterException {
        String command;
        IParameterBank parameterBank = device.getParameterBank();
        IParameterPageBank parameterPageBank = parameterBank.getPageBank();
        block15 : switch (command = DeviceModule.getSubCommand(path)) {
            case "page": {
                String subCommand;
                switch (subCommand = DeviceModule.getSubCommand(path)) {
                    case "select": 
                    case "selected": {
                        parameterPageBank.selectPage(DeviceModule.toInteger(value) - 1);
                        break block15;
                    }
                }
                try {
                    int index = Integer.parseInt(subCommand) - 1;
                    parameterPageBank.selectPage(index);
                    break;
                }
                catch (NumberFormatException ex) {
                    throw new UnknownCommandException(subCommand);
                }
            }
            case "duplicate": {
                device.duplicate();
                break;
            }
            case "remove": {
                device.remove();
                break;
            }
            case "bypass": {
                device.toggleEnabledState();
                break;
            }
            case "expand": {
                device.toggleExpanded();
                break;
            }
            case "parameters": {
                device.toggleParameterPageSectionVisible();
                break;
            }
            case "window": {
                device.toggleWindowOpen();
                break;
            }
            case "indicate": {
                String subCommand4 = DeviceModule.getSubCommand(path);
                if ("param".equals(subCommand4)) {
                    for (int i = 0; i < parameterBank.getPageSize(); ++i) {
                        ((IParameter)parameterBank.getItem(i)).setIndication(DeviceModule.isTrigger(value));
                    }
                    break;
                }
                throw new UnknownCommandException(subCommand4);
            }
            case "param": {
                String subCommand5 = DeviceModule.getSubCommand(path);
                try {
                    int paramNo = Integer.parseInt(subCommand5) - 1;
                    DeviceModule.parseFXParamValue((IParameter)parameterBank.getItem(paramNo), path, value);
                    break;
                }
                catch (NumberFormatException ex) {
                    if (!DeviceModule.isTrigger(value)) break;
                    switch (subCommand5) {
                        case "+": {
                            parameterPageBank.scrollForwards();
                            break block15;
                        }
                        case "-": {
                            parameterPageBank.scrollBackwards();
                            break block15;
                        }
                        case "bank": {
                            String subCommand6 = DeviceModule.getSubCommand(path);
                            if ("page".equals(subCommand6)) {
                                String subCommand7 = DeviceModule.getSubCommand(path);
                                if ("+".equals(subCommand7)) {
                                    parameterPageBank.selectNextPage();
                                    break block15;
                                }
                                parameterPageBank.selectPreviousPage();
                                break block15;
                            }
                            throw new UnknownCommandException(subCommand6);
                        }
                    }
                    throw new UnknownCommandException(subCommand5);
                }
            }
            case "drumpad": {
                if (!device.hasDrumPads()) break;
                this.parseLayerOrDrumpad(device, path, value);
                break;
            }
            case "layer": {
                this.parseLayerOrDrumpad(device, path, value);
                break;
            }
            default: {
                this.host.println("Unknown Device command: " + command);
            }
        }
    }

    private boolean parseEqValue(IEqualizerDevice equalizerDevice, LinkedList<String> path, Object value) throws MissingCommandException, UnknownCommandException, IllegalParameterException {
        String command;
        switch (command = DeviceModule.getSubCommand(path)) {
            case "type": {
                String subCommand1 = DeviceModule.getSubCommand(path);
                try {
                    int bandNo = Integer.parseInt(subCommand1) - 1;
                    equalizerDevice.setType(bandNo, EqualizerBandType.valueOf(DeviceModule.toString(value).toUpperCase()));
                }
                catch (NumberFormatException ex) {
                    throw new UnknownCommandException(subCommand1);
                }
                return true;
            }
            case "gain": {
                String subCommand2 = DeviceModule.getSubCommand(path);
                try {
                    int bandNo = Integer.parseInt(subCommand2) - 1;
                    equalizerDevice.getGainParameter(bandNo).setValue(DeviceModule.toInteger(value));
                }
                catch (NumberFormatException ex) {
                    throw new UnknownCommandException(subCommand2);
                }
                return true;
            }
            case "freq": {
                String subCommand3 = DeviceModule.getSubCommand(path);
                try {
                    int bandNo = Integer.parseInt(subCommand3) - 1;
                    equalizerDevice.getFrequencyParameter(bandNo).setValue(DeviceModule.toInteger(value));
                }
                catch (NumberFormatException ex) {
                    throw new UnknownCommandException(subCommand3);
                }
                return true;
            }
            case "q": {
                String subCommand4 = DeviceModule.getSubCommand(path);
                try {
                    int bandNo = Integer.parseInt(subCommand4) - 1;
                    equalizerDevice.getQParameter(bandNo).setValue(DeviceModule.toInteger(value));
                }
                catch (NumberFormatException ex) {
                    throw new UnknownCommandException(subCommand4);
                }
                return true;
            }
            case "add": {
                ICursorTrack cursorTrack = this.model.getCursorTrack();
                if (cursorTrack.doesExist() && DeviceModule.isTrigger(value)) {
                    cursorTrack.addEqualizerDevice();
                }
                return true;
            }
        }
        path.add(0, command);
        return false;
    }

    private void parseLayerOrDrumpad(ISpecificDevice device, LinkedList<String> path, Object value) throws MissingCommandException, UnknownCommandException, IllegalParameterException {
        ILayerBank layerBank = device.getLayerBank();
        String command = DeviceModule.getSubCommand(path);
        try {
            Optional selectedLayer;
            int layerNo = "selected".equals(command) || "select".equals(command) ? ((selectedLayer = layerBank.getSelectedItem()).isEmpty() ? -1 : ((ILayer)selectedLayer.get()).getIndex()) : Integer.parseInt(command) - 1;
            this.parseDeviceLayerValue(device, layerNo, path, value);
        }
        catch (NumberFormatException ex) {
            switch (command) {
                case "parent": {
                    if (!device.doesExist() || !(device instanceof ICursorDevice)) break;
                    ICursorDevice cursorDevice = (ICursorDevice)device;
                    cursorDevice.selectParent();
                    cursorDevice.selectChannel();
                    break;
                }
                case "+": {
                    layerBank.selectNextItem();
                    break;
                }
                case "-": {
                    layerBank.selectPreviousItem();
                    break;
                }
                case "page": {
                    if (path.isEmpty()) {
                        this.host.println("Missing Layer/Drumpad Page subcommand: " + command);
                        return;
                    }
                    if ("+".equals(path.get(0))) {
                        layerBank.selectNextPage();
                        break;
                    }
                    layerBank.selectPreviousPage();
                    break;
                }
                default: {
                    throw new UnknownCommandException(command);
                }
            }
        }
    }

    private void parseDeviceLayerValue(ISpecificDevice cursorDevice, int layerIndex, LinkedList<String> path, Object value) throws UnknownCommandException, IllegalParameterException, MissingCommandException {
        String command = DeviceModule.getSubCommand(path);
        ILayerBank layerBank = cursorDevice.getLayerBank();
        if (layerIndex >= layerBank.getPageSize()) {
            this.host.println("Layer or drumpad index larger than page size: " + layerIndex);
            return;
        }
        IChannel layer = (IChannel)layerBank.getItem(layerIndex);
        switch (command) {
            case "activated": {
                layer.setIsActivated(DeviceModule.toInteger(value) > 0);
                break;
            }
            case "select": 
            case "selected": {
                layer.select();
                break;
            }
            case "name": {
                if (value == null) break;
                layer.setName(value.toString());
                break;
            }
            case "volume": {
                if (path.isEmpty()) {
                    layer.setVolume(DeviceModule.toInteger(value));
                    break;
                }
                if ("indicate".equals(path.get(0))) {
                    layer.setVolumeIndication(DeviceModule.isTrigger(value));
                    break;
                }
                if ("reset".equals(path.get(0))) {
                    layer.resetVolume();
                    break;
                }
                if (!"touched".equals(path.get(0))) break;
                layer.touchVolume(DeviceModule.isTrigger(value));
                break;
            }
            case "pan": {
                if (path.isEmpty()) {
                    layer.setPan(DeviceModule.toInteger(value));
                    break;
                }
                if ("indicate".equals(path.get(0))) {
                    layer.setPanIndication(DeviceModule.isTrigger(value));
                    break;
                }
                if ("reset".equals(path.get(0))) {
                    layer.resetPan();
                    break;
                }
                if (!"touched".equals(path.get(0))) break;
                layer.touchPan(DeviceModule.isTrigger(value));
                break;
            }
            case "mute": {
                if (value == null) {
                    layer.toggleMute();
                    break;
                }
                layer.setMute(DeviceModule.isTrigger(value));
                break;
            }
            case "solo": {
                if (value == null) {
                    layer.toggleSolo();
                    break;
                }
                layer.setSolo(DeviceModule.isTrigger(value));
                break;
            }
            case "send": {
                int sendNo = Integer.parseInt(path.removeFirst()) - 1;
                if (path.isEmpty()) {
                    return;
                }
                String cmd = path.removeFirst();
                ISend send = (ISend)layer.getSendBank().getItem(sendNo);
                if ("volume".equals(cmd)) {
                    if (path.isEmpty()) {
                        send.setValue(DeviceModule.toInteger(value));
                        break;
                    }
                    if ("indicate".equals(path.get(0))) {
                        send.setIndication(DeviceModule.isTrigger(value));
                        break;
                    }
                    if (!"touched".equals(path.get(0))) break;
                    send.touchValue(DeviceModule.isTrigger(value));
                    break;
                }
                if ("activated".equals(cmd)) {
                    if (!DeviceModule.isTrigger(value)) break;
                    send.toggleEnabled();
                    break;
                }
                throw new UnknownCommandException(cmd);
            }
            case "enter": {
                layer.enter();
                break;
            }
            default: {
                throw new UnknownCommandException(command);
            }
        }
    }

    private static void parseFXParamValue(IParameter param, LinkedList<String> path, Object value) throws MissingCommandException, IllegalParameterException, UnknownCommandException {
        String command;
        switch (command = DeviceModule.getSubCommand(path)) {
            case "value": {
                param.setValue(DeviceModule.toInteger(value));
                break;
            }
            case "indicate": {
                param.setIndication(DeviceModule.isTrigger(value));
                break;
            }
            case "reset": {
                param.resetValue();
                break;
            }
            case "touched": {
                param.touchValue(DeviceModule.isTrigger(value));
                break;
            }
            default: {
                throw new UnknownCommandException(command);
            }
        }
    }
}

