/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc.module;

import de.mossgrabers.controller.osc.exception.IllegalParameterException;
import de.mossgrabers.controller.osc.exception.MissingCommandException;
import de.mossgrabers.controller.osc.exception.UnknownCommandException;
import de.mossgrabers.controller.osc.module.AbstractModule;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.osc.IOpenSoundControlWriter;
import java.util.LinkedList;
import java.util.Optional;

public class ClipModule
extends AbstractModule {
    public ClipModule(IHost host, IModel model, IOpenSoundControlWriter writer) {
        super(host, model, writer);
    }

    @Override
    public String[] getSupportedCommands() {
        return new String[]{"clip"};
    }

    @Override
    public void execute(String command, LinkedList<String> path, Object value) throws IllegalParameterException, UnknownCommandException, MissingCommandException {
        if (!"clip".equals(command)) {
            throw new UnknownCommandException(command);
        }
        String subCommand = ClipModule.getSubCommand(path);
        boolean isStopallAlt = "stopallAlt".equals(subCommand);
        if (isStopallAlt || "stopall".equals(subCommand)) {
            this.model.getTrackBank().stop(isStopallAlt);
            return;
        }
        INoteClip cursorClip = this.model.getCursorClip();
        switch (subCommand) {
            case "pinned": {
                if (value == null) {
                    cursorClip.togglePinned();
                } else {
                    cursorClip.setPinned(ClipModule.isTrigger(value));
                }
                return;
            }
            case "quantize": {
                if (cursorClip.doesExist()) {
                    cursorClip.quantize(1.0);
                }
                return;
            }
            case "name": {
                if (value == null || !cursorClip.doesExist()) break;
                cursorClip.setName(value.toString());
                break;
            }
            case "color": {
                Optional<ColorEx> color = ClipModule.matchColor(ClipModule.toString(value));
                if (!color.isPresent() || !cursorClip.doesExist()) break;
                cursorClip.setColor(color.get());
                break;
            }
        }
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        if (!cursorTrack.doesExist()) {
            return;
        }
        boolean isAlternative = "stopAlt".equals(subCommand);
        if (isAlternative || "stop".equals(subCommand)) {
            cursorTrack.stop(isAlternative);
            return;
        }
        ISlotBank slotBank = cursorTrack.getSlotBank();
        switch (subCommand) {
            case "+": {
                slotBank.selectNextItem();
                return;
            }
            case "-": {
                slotBank.selectPreviousItem();
                return;
            }
        }
        Optional selectedSlotOptional = slotBank.getSelectedItem();
        if (selectedSlotOptional.isEmpty()) {
            return;
        }
        ISlot selectedSlot = (ISlot)selectedSlotOptional.get();
        switch (subCommand) {
            case "launch": {
                selectedSlot.launch(ClipModule.toInteger(value) > 0, false);
                return;
            }
            case "launchAlt": {
                selectedSlot.launch(ClipModule.toInteger(value) > 0, true);
                return;
            }
            case "record": {
                this.model.recordNoteClip(cursorTrack, selectedSlot);
                return;
            }
            case "create": {
                this.model.createNoteClip(cursorTrack, selectedSlot, ClipModule.toInteger(value), true);
                return;
            }
        }
        throw new UnknownCommandException(command);
    }

    @Override
    public void flush(boolean dump) {
        INoteClip cursorClip = this.model.getCursorClip();
        this.writer.sendOSC("/clip/exists", cursorClip.doesExist(), dump);
        this.writer.sendOSC("/clip/pinned", cursorClip.isPinned(), dump);
        ColorEx color = cursorClip.getColor();
        if (color == null) {
            color = ColorEx.BLACK;
        }
        this.writer.sendOSCColor("/clip/color", color.getRed(), color.getGreen(), color.getBlue(), dump);
    }
}

