/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.slmkiii.view;

import de.mossgrabers.controller.novation.slmkiii.SLMkIIIConfiguration;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.view.AbstractSessionView;

public class SessionView
extends AbstractSessionView<SLMkIIIControlSurface, SLMkIIIConfiguration> {
    public SessionView(SLMkIIIControlSurface surface, IModel model) {
        super("Session", surface, model, 2, 8, true);
        LightInfo isRecording = new LightInfo(5, 5, false);
        LightInfo isRecordingQueued = new LightInfo(7, 7, true);
        LightInfo isPlaying = new LightInfo(20, 21, false);
        LightInfo isPlayingQueued = new LightInfo(20, 21, true);
        LightInfo hasContent = new LightInfo(96, -1, false);
        LightInfo noContent = new LightInfo(0, -1, false);
        LightInfo recArmed = new LightInfo(7, -1, false);
        this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, hasContent, noContent, recArmed);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        int index = note - 36;
        int t = index % this.columns;
        int s = this.rows - 1 - index / this.columns;
        ITrackBank tb = this.model.getCurrentTrackBank();
        if (this.isBirdsEyeActive()) {
            ISceneBank sceneBank = tb.getSceneBank();
            int numTracks = tb.getPageSize();
            int numScenes = sceneBank.getPageSize();
            int trackPosition = ((ITrack)tb.getItem(0)).getPosition() / numTracks;
            int scenePosition = sceneBank.getScrollPosition() / numScenes;
            int selX = trackPosition;
            int selY = scenePosition;
            int padsX = this.columns;
            int padsY = this.rows;
            int offsetX = selX / padsX * padsX;
            int offsetY = selY / padsY * padsY;
            tb.scrollTo(offsetX * numTracks + t * padsX);
            sceneBank.scrollTo(offsetY * numScenes + s * padsY);
            return;
        }
        ITrack track = (ITrack)tb.getItem(t);
        if (this.isButtonCombination(ButtonID.DUPLICATE)) {
            if (track.doesExist()) {
                ((ISlot)track.getSlotBank().getItem(s)).duplicate();
            }
            return;
        }
        if (this.isButtonCombination(ButtonID.STOP)) {
            track.stop(false);
            return;
        }
        super.onGridNote(note, velocity);
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        if (!ButtonID.isSceneButton(buttonID)) {
            return super.getButtonColor(buttonID);
        }
        ColorManager colorManager = this.model.getColorManager();
        IScene s = (IScene)this.model.getSceneBank().getItem(buttonID.ordinal() - ButtonID.SCENE1.ordinal());
        if (!s.doesExist()) {
            return colorManager.getColorIndex("COLOR_SELECTED_OFF");
        }
        return colorManager.getColorIndex(s.isSelected() ? "COLOR_SELECTED_SCENE" : "COLOR_SCENE");
    }
}

