/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.slmkiii.view;

import de.mossgrabers.controller.novation.slmkiii.SLMkIIIConfiguration;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractDrumView;
import java.util.List;
import java.util.Optional;

public class DrumView
extends AbstractDrumView<SLMkIIIControlSurface, SLMkIIIConfiguration> {
    private static final int NUM_DISPLAY_COLS = 16;
    private boolean isPlayMode = true;

    public DrumView(SLMkIIIControlSurface surface, IModel model) {
        super("Drum", surface, model, 2, 16, true);
        this.allRows = 2;
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        int index = note - 36;
        int offsetY = this.scales.getDrumOffset();
        if (this.isPlayMode) {
            this.setSelectedPad(index, velocity);
            this.keyManager.setKeyPressed(offsetY + this.getSelectedPad(), velocity);
        } else if (this.isActive()) {
            int x = index % this.numColumns;
            int y = index / this.numColumns;
            this.handleSequencerArea(index, x, y, offsetY, velocity);
        }
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.isActive() || this.isPlayMode) {
            return;
        }
        int index = note - 36;
        ((SLMkIIIControlSurface)this.surface).getButton(ButtonID.get(ButtonID.PAD1, index)).setConsumed();
        int x = index % this.numColumns;
        int y = index / this.numColumns;
        int step = this.numColumns * (1 - y) + x;
        int row = this.scales.getDrumOffset() + this.getSelectedPad();
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), step, row);
        this.editNote(this.getClip(), notePosition, false);
    }

    @Override
    public void updateNoteMapping() {
        this.delayedUpdateNoteMapping(this.model.canSelectedTrackHoldNotes() && this.isPlayMode ? this.scales.getDrumMatrix() : EMPTY_TABLE);
    }

    @Override
    public void drawGrid() {
        IPadGrid padGrid = ((SLMkIIIControlSurface)this.surface).getPadGrid();
        IDrumDevice primary = this.model.getDrumDevice();
        IDrumPadBank drumPadBank = primary.getDrumPadBank();
        if (this.isPlayMode) {
            for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 8; ++x) {
                    int index = 8 * y + x;
                    padGrid.lightEx(x, 1 - y, this.getDrumPadColor(index, drumPadBank, false));
                }
            }
            return;
        }
        if (!this.isActive()) {
            padGrid.turnOff();
            return;
        }
        INoteClip clip = this.getClip();
        int step = clip.getCurrentStep();
        int hiStep = this.isInXRange(step) ? step % this.sequencerSteps : -1;
        int offsetY = this.scales.getDrumOffset();
        int channel = this.configuration.getMidiEditChannel();
        int selPad = this.getSelectedPad();
        List<NotePosition> editNotes = this.getEditNotes();
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), 0, 0);
        for (int col = 0; col < 16; ++col) {
            int noteRow = offsetY + selPad;
            notePosition.setStep(col);
            notePosition.setNote(noteRow);
            IStepInfo stepInfo = clip.getStep(notePosition);
            boolean hilite = col == hiStep;
            int x = col % 8;
            int y = col / 8;
            Optional<ColorEx> rowColor = this.getPadColor(primary, this.selectedPad);
            padGrid.lightEx(x, y, this.getStepColor(stepInfo, hilite, rowColor, channel, col, noteRow, editNotes));
        }
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN) {
            return;
        }
        if (buttonID == ButtonID.SCENE1) {
            this.isPlayMode = !this.isPlayMode;
            this.updateNoteMapping();
            ((SLMkIIIControlSurface)this.surface).getDisplay().notify(this.isPlayMode ? "Play / Select" : "Steps");
        } else {
            if (!this.isActive()) {
                return;
            }
            ModeManager modeManager = ((SLMkIIIControlSurface)this.surface).getModeManager();
            if (modeManager.isActive(new Modes[]{Modes.GROOVE})) {
                modeManager.restore();
            } else {
                modeManager.setActive(Modes.GROOVE);
            }
        }
    }

    public boolean isPlayMode() {
        return this.isPlayMode;
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        if (buttonID == ButtonID.SCENE1) {
            return this.isPlayMode ? 21 : 45;
        }
        if (buttonID == ButtonID.SCENE2) {
            if (!this.isActive()) {
                return 0;
            }
            return ((SLMkIIIControlSurface)this.surface).getModeManager().isActive(new Modes[]{Modes.GROOVE}) ? 57 : 1;
        }
        return super.getButtonColor(buttonID);
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int velocity) {
        boolean isShiftPressed = ((SLMkIIIControlSurface)this.surface).isShiftPressed();
        if (isShiftPressed) {
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, isShiftPressed);
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, velocity);
    }
}

