/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.slmkiii.controller;

import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.LightGuideImpl;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.KeyManager;

public class SLMkIIILightGuide
extends LightGuideImpl {
    private final IModel model;
    private final Scales keyboardScales;
    private final KeyManager keyboardManager;

    public SLMkIIILightGuide(IModel model, ColorManager colorManager, IMidiOutput output) {
        super(0, 61, colorManager, output);
        this.model = model;
        this.keyboardScales = new Scales(model.getValueChanger(), 36, 97, 61, 1);
        this.keyboardScales.setChromatic(true);
        this.keyboardManager = new KeyManager(this.model, this.keyboardScales, this);
        this.keyboardManager.setNoteMatrix(this.keyboardScales.getNoteMatrix());
        ITrackBank tb = model.getTrackBank();
        tb.addSelectionObserver((index, isSelected) -> this.keyboardManager.clearPressedKeys());
        tb.addNoteObserver(this.keyboardManager::call);
    }

    @Override
    protected void sendNoteState(int channel, int note, int color) {
        this.output.sendNoteEx(15, note, color);
    }

    public void setActive(boolean enable) {
        this.output.sendSysex("F0 00 20 29 02 0A 01 05 0" + (enable ? (char)'1' : '0') + " F7");
    }

    public void draw(boolean isEnabled) {
        boolean isRecording = this.model.hasRecordingState();
        Scales scales = this.model.getScales();
        this.keyboardScales.setScaleOffsetByIndex(scales.getScaleOffsetIndex());
        this.keyboardScales.setScale(scales.getScale());
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        for (int i = this.keyboardScales.getStartNote(); i < this.keyboardScales.getEndNote(); ++i) {
            this.light(i - 36, this.getGridColor(isEnabled, isRecording, cursorTrack, i));
        }
    }

    public void updateKeyboardNote(int key, int velocity) {
        int note = this.keyboardManager.map(key);
        if (note != -1) {
            this.keyboardManager.setAllKeysPressed(note, velocity);
        }
    }

    private String getGridColor(boolean isEnabled, boolean isRecording, ITrack track, int note) {
        if (!isEnabled) {
            return "PLAY_VIEW_COLOR_OFF";
        }
        if (this.keyboardManager.isKeyPressed(note)) {
            return isRecording ? "PLAY_VIEW_COLOR_RECORD" : "PLAY_VIEW_COLOR_PLAY";
        }
        return AbstractView.replaceOctaveColorWithTrackColor(track, this.keyboardManager.getColor(note));
    }
}

