/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.sl.mode;

import de.mossgrabers.controller.novation.sl.SLConfiguration;
import de.mossgrabers.controller.novation.sl.controller.SLControlSurface;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.mode.track.TrackMode;

public class SLTrackMode
extends TrackMode<SLControlSurface, SLConfiguration> {
    public SLTrackMode(SLControlSurface surface, IModel model) {
        super(surface, model, true, ContinuousID.createSequentialList(ContinuousID.KNOB1, 8));
    }

    @Override
    public void updateDisplay() {
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        ITextDisplay d = ((SLControlSurface)this.surface).getTextDisplay().clearRow(0).clearRow(1);
        if (!cursorTrack.doesExist()) {
            d.setRow(0, "                        Please select a track...                       ").done(0).done(1);
            return;
        }
        d.setCell(0, 0, "Volume").setCell(1, 0, cursorTrack.getVolumeStr(8)).setCell(0, 1, "Pan").setCell(1, 1, cursorTrack.getPanStr(8));
        int sendStart = 2;
        int sendCount = 6;
        ISendBank sendBank = cursorTrack.getSendBank();
        if (sendBank.getPageSize() > 0) {
            for (int i = 0; i < 6; ++i) {
                int pos = 2 + i;
                ISend send = (ISend)sendBank.getItem(i);
                if (!send.doesExist()) continue;
                d.setCell(0, pos, send.getName(8)).setCell(1, pos, send.getDisplayedValue(8));
            }
        }
        d.done(0).done(1);
    }

    @Override
    public void onActivate() {
        if (!this.isActive) {
            super.onActivate();
        }
    }

    @Override
    public void onDeactivate() {
    }
}

