/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.sl.controller;

import de.mossgrabers.framework.controller.display.AbstractTextDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.controller.hardware.IHwTextDisplay;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.StringUtils;

public class SLDisplay
extends AbstractTextDisplay {
    public static final String RIGHT_ARROW = ">";
    private static final int[] ROW_MAP = new int[]{0, 2, 1, 3};
    private final IHwTextDisplay hwTextDisplay1;
    private final IHwTextDisplay hwTextDisplay2;

    public SLDisplay(IHost host, IMidiOutput output, IHwTextDisplay hwTextDisplay1, IHwTextDisplay hwTextDisplay2) {
        super(host, output, 4, 8, 72);
        this.hwTextDisplay1 = hwTextDisplay1;
        this.hwTextDisplay2 = hwTextDisplay2;
    }

    @Override
    protected void updateLine(int row, String text, String previousText) {
        if (row == 0) {
            this.hwTextDisplay1.setLine(0, this.convertCharacterset(text));
        } else if (row == 1) {
            this.hwTextDisplay1.setLine(1, this.convertCharacterset(text));
        } else if (row == 2) {
            this.hwTextDisplay2.setLine(0, this.convertCharacterset(text));
        } else if (row == 3) {
            this.hwTextDisplay2.setLine(1, this.convertCharacterset(text));
        }
        this.writeLine(row, text, previousText);
    }

    @Override
    public ITextDisplay clearCell(int row, int column) {
        this.cells[row * this.noOfCells + column] = "         ";
        return this;
    }

    @Override
    public ITextDisplay setBlock(int row, int block, String value) {
        int cell = 2 * block;
        if (value.length() > 9) {
            this.cells[row * 8 + cell] = value.substring(0, 9);
            this.cells[row * 8 + cell + 1] = StringUtils.pad(value.substring(9), 8) + " ";
        } else {
            this.cells[row * 8 + cell] = StringUtils.pad(value, 9);
            this.clearCell(row, cell + 1);
        }
        return this;
    }

    @Override
    public ITextDisplay setCell(int row, int column, String value) {
        try {
            this.cells[row * this.noOfCells + column] = StringUtils.pad(value, 8) + " ";
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.host.error("Display array index out of bounds.", ex);
        }
        return this;
    }

    @Override
    public void writeLine(int row, String text, String previousText) {
        int length = text.length();
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = text.charAt(i);
        }
        this.output.sendSysex("F0 00 20 29 03 03 12 00 04 00 02 01 00 " + SLDisplay.uint7ToHex(ROW_MAP[row] + 1) + "04 " + StringUtils.toHexStr(array) + "00 F7");
    }

    @Override
    public void shutdown() {
        this.notify("Please start " + this.host.getName() + " to play...");
    }

    private static String uint7ToHex(int x) {
        int upper = x >> 4 & 7;
        int lower = x & 0xF;
        return Integer.toString(upper, 16) + Integer.toString(lower, 16) + " ";
    }

    public IHwTextDisplay getHwTextDisplay1() {
        return this.hwTextDisplay1;
    }

    public IHwTextDisplay getHwTextDisplay2() {
        return this.hwTextDisplay2;
    }
}

