/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.command.trigger;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.novation.launchpad.view.SessionView;
import de.mossgrabers.controller.novation.launchpad.view.UserView;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.command.trigger.mode.CursorCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.GrooveParameterID;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.IScrollableView;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.FrameworkException;
import de.mossgrabers.framework.view.TransposeView;
import de.mossgrabers.framework.view.Views;
import de.mossgrabers.framework.view.sequencer.AbstractSequencerView;

public class LaunchpadCursorCommand
extends CursorCommand<LaunchpadControlSurface, LaunchpadConfiguration> {
    private static final int REPEAT_SPEED = 300;
    private final Scales scales;
    private final ITransport transport;

    public LaunchpadCursorCommand(Direction direction, IModel model, LaunchpadControlSurface surface) {
        super(direction, model, surface, false);
        this.scales = this.model.getScales();
        this.transport = this.model.getTransport();
    }

    @Override
    protected void updateArrowStates() {
        Object f = ((LaunchpadControlSurface)this.surface).getViewManager().getActive();
        if (f instanceof IScrollableView) {
            IScrollableView view = (IScrollableView)f;
            view.updateScrollStates(this.scrollStates);
        } else {
            this.scrollStates.setAll(false);
        }
    }

    @Override
    protected void scrollLeft() {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        switch ((Views)((Object)viewManager.getActiveID())) {
            case CONTROL: {
                break;
            }
            case USER: {
                Object f = viewManager.get(Views.USER);
                if (!(f instanceof UserView)) break;
                UserView userView = (UserView)f;
                userView.selectPreviousPage();
                break;
            }
            case SHIFT: {
                viewManager.setTemporary(Views.SHUFFLE);
                break;
            }
            case PLAY: 
            case CHORDS: {
                this.scales.prevScale();
                String name = this.scales.getScale().getName();
                ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScale(name);
                ((LaunchpadControlSurface)this.surface).getDisplay().notify(name);
                break;
            }
            case PIANO: 
            case DRUM64: {
                break;
            }
            case SEQUENCER: 
            case RAINDROPS: 
            case POLY_SEQUENCER: 
            case DRUM: 
            case DRUM4: 
            case DRUM8: {
                IView activeView = (IView)viewManager.getActive();
                if (!(activeView instanceof AbstractSequencerView)) break;
                AbstractSequencerView sequencerView = (AbstractSequencerView)activeView;
                sequencerView.onLeft(ButtonEvent.DOWN);
                this.mvHelper.notifyEditPage(sequencerView.getClip());
                break;
            }
            case DEVICE: {
                ICursorDevice cursorDevice = this.model.getCursorDevice();
                cursorDevice.getParameterBank().scrollBackwards();
                this.mvHelper.notifySelectedParameterPage();
                break;
            }
            case BROWSER: {
                this.model.getBrowser().previousContentType();
                break;
            }
            case SESSION: {
                IMode volumeMode = (IMode)((LaunchpadControlSurface)this.surface).getModeManager().get(Modes.VOLUME);
                if (volumeMode == null) {
                    return;
                }
                SessionView sessionView = (SessionView)((LaunchpadControlSurface)this.surface).getViewManager().get(Views.SESSION);
                if (sessionView.isBirdsEyeActive()) {
                    volumeMode.selectPreviousItemPage();
                } else {
                    volumeMode.selectPreviousItem();
                }
                ((LaunchpadControlSurface)this.surface).setTriggerConsumed(ButtonID.SHIFT);
                this.mvHelper.notifySelectedTrack();
                break;
            }
            case TRACK_VOLUME: 
            case TRACK_PAN: 
            case TRACK_SENDS: 
            case MIX: {
                IMode mode = (IMode)((LaunchpadControlSurface)this.surface).getModeManager().get(Modes.VOLUME);
                if (mode == null) break;
                mode.selectPreviousItem();
                break;
            }
            case SHUFFLE: {
                if (((LaunchpadControlSurface)this.surface).isPressed(ButtonID.RIGHT)) break;
                this.triggerChangeShuffle(-10, ButtonID.LEFT);
                break;
            }
            case TEMPO: {
                if (((LaunchpadControlSurface)this.surface).isPressed(ButtonID.RIGHT)) break;
                this.triggerChangeTempo(-10, ButtonID.LEFT);
                break;
            }
            case PROJECT: {
                this.triggerChangeZoom1(false);
                break;
            }
            case CLIP_LENGTH: 
            case NOTE_EDIT_VIEW: {
                break;
            }
            default: {
                throw new FrameworkException("Missing cursor key left handling for view.");
            }
        }
    }

    @Override
    protected void scrollRight() {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        switch ((Views)((Object)viewManager.getActiveID())) {
            case CONTROL: {
                break;
            }
            case USER: {
                Object f = viewManager.get(Views.USER);
                if (!(f instanceof UserView)) break;
                UserView userView = (UserView)f;
                userView.selectNextPage();
                break;
            }
            case SHIFT: {
                viewManager.setTemporary(Views.SHUFFLE);
                break;
            }
            case PLAY: 
            case CHORDS: {
                this.scales.nextScale();
                String name = this.scales.getScale().getName();
                ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScale(name);
                ((LaunchpadControlSurface)this.surface).getDisplay().notify(name);
                break;
            }
            case PIANO: 
            case DRUM64: {
                break;
            }
            case SEQUENCER: 
            case RAINDROPS: 
            case POLY_SEQUENCER: 
            case DRUM: 
            case DRUM4: 
            case DRUM8: {
                IView activeView = (IView)viewManager.getActive();
                if (!(activeView instanceof AbstractSequencerView)) break;
                AbstractSequencerView sequencerView = (AbstractSequencerView)activeView;
                sequencerView.onRight(ButtonEvent.DOWN);
                this.mvHelper.notifyEditPage(sequencerView.getClip());
                break;
            }
            case DEVICE: {
                ICursorDevice cursorDevice = this.model.getCursorDevice();
                cursorDevice.getParameterBank().scrollForwards();
                this.mvHelper.notifySelectedParameterPage();
                break;
            }
            case BROWSER: {
                this.model.getBrowser().nextContentType();
                break;
            }
            case SESSION: {
                IMode volumeMode = (IMode)((LaunchpadControlSurface)this.surface).getModeManager().get(Modes.VOLUME);
                if (volumeMode == null) {
                    return;
                }
                SessionView sessionView = (SessionView)((LaunchpadControlSurface)this.surface).getViewManager().get(Views.SESSION);
                if (sessionView.isBirdsEyeActive()) {
                    volumeMode.selectNextItemPage();
                } else {
                    volumeMode.selectNextItem();
                }
                ((LaunchpadControlSurface)this.surface).setTriggerConsumed(ButtonID.SHIFT);
                this.mvHelper.notifySelectedTrack();
                break;
            }
            case TRACK_VOLUME: 
            case TRACK_PAN: 
            case TRACK_SENDS: 
            case MIX: {
                IMode mode = (IMode)((LaunchpadControlSurface)this.surface).getModeManager().get(Modes.VOLUME);
                if (mode == null) break;
                mode.selectNextItem();
                break;
            }
            case SHUFFLE: {
                if (((LaunchpadControlSurface)this.surface).isPressed(ButtonID.LEFT)) break;
                this.triggerChangeShuffle(10, ButtonID.RIGHT);
                break;
            }
            case TEMPO: {
                if (((LaunchpadControlSurface)this.surface).isPressed(ButtonID.LEFT)) break;
                this.triggerChangeTempo(10, ButtonID.RIGHT);
                break;
            }
            case PROJECT: {
                this.triggerChangeZoom1(true);
                break;
            }
            case CLIP_LENGTH: 
            case NOTE_EDIT_VIEW: {
                break;
            }
            default: {
                throw new FrameworkException("Missing cursor key right handling for view.");
            }
        }
    }

    @Override
    protected void scrollUp() {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        switch ((Views)((Object)viewManager.getActiveID())) {
            case CONTROL: {
                break;
            }
            case USER: {
                Object f = viewManager.get(Views.USER);
                if (!(f instanceof UserView)) break;
                UserView userView = (UserView)f;
                userView.setMode(true);
                break;
            }
            case SHIFT: {
                viewManager.setTemporary(Views.TEMPO);
                break;
            }
            case PLAY: 
            case CHORDS: 
            case PIANO: 
            case DRUM64: 
            case SEQUENCER: 
            case RAINDROPS: 
            case POLY_SEQUENCER: 
            case DRUM: 
            case DRUM4: 
            case DRUM8: {
                ((TransposeView)viewManager.getActive()).onOctaveUp(ButtonEvent.DOWN);
                break;
            }
            case DEVICE: {
                this.model.getCursorDevice().selectPrevious();
                this.mvHelper.notifySelectedDevice();
                break;
            }
            case BROWSER: {
                ICursorDevice cursorDevice = this.model.getCursorDevice();
                if (!cursorDevice.doesExist()) break;
                this.model.getBrowser().insertBeforeCursorDevice();
                break;
            }
            case SESSION: {
                SessionView sessionView = (SessionView)((LaunchpadControlSurface)this.surface).getViewManager().get(Views.SESSION);
                if (sessionView.isBirdsEyeActive()) {
                    this.getSceneBank().selectPreviousPage();
                } else {
                    super.scrollUp();
                }
                ((LaunchpadControlSurface)this.surface).setTriggerConsumed(ButtonID.SHIFT);
                break;
            }
            case TRACK_VOLUME: 
            case TRACK_PAN: 
            case TRACK_SENDS: 
            case MIX: {
                super.scrollUp();
                break;
            }
            case SHUFFLE: {
                if (((LaunchpadControlSurface)this.surface).isPressed(ButtonID.DOWN)) break;
                this.triggerChangeShuffle(1, ButtonID.UP);
                break;
            }
            case TEMPO: {
                if (((LaunchpadControlSurface)this.surface).isPressed(ButtonID.DOWN)) break;
                this.triggerChangeTempo(1, ButtonID.UP);
                break;
            }
            case PROJECT: {
                this.model.getApplication().incTrackHeight();
                break;
            }
            case CLIP_LENGTH: 
            case NOTE_EDIT_VIEW: {
                break;
            }
            default: {
                throw new FrameworkException("Missing cursor key up handling for view.");
            }
        }
    }

    @Override
    protected void scrollDown() {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        switch ((Views)((Object)viewManager.getActiveID())) {
            case CONTROL: {
                break;
            }
            case USER: {
                Object f = viewManager.get(Views.USER);
                if (!(f instanceof UserView)) break;
                UserView userView = (UserView)f;
                userView.setMode(false);
                break;
            }
            case SHIFT: {
                viewManager.setTemporary(Views.TEMPO);
                break;
            }
            case PLAY: 
            case CHORDS: 
            case PIANO: 
            case DRUM64: 
            case SEQUENCER: 
            case RAINDROPS: 
            case POLY_SEQUENCER: 
            case DRUM: 
            case DRUM4: 
            case DRUM8: {
                ((TransposeView)viewManager.getActive()).onOctaveDown(ButtonEvent.DOWN);
                break;
            }
            case DEVICE: {
                this.model.getCursorDevice().selectNext();
                this.mvHelper.notifySelectedDevice();
                break;
            }
            case BROWSER: {
                ICursorDevice cursorDevice = this.model.getCursorDevice();
                if (!cursorDevice.doesExist()) break;
                this.model.getBrowser().insertAfterCursorDevice();
                break;
            }
            case SESSION: {
                SessionView sessionView = (SessionView)((LaunchpadControlSurface)this.surface).getViewManager().get(Views.SESSION);
                if (sessionView.isBirdsEyeActive()) {
                    this.getSceneBank().selectNextPage();
                } else {
                    super.scrollDown();
                }
                ((LaunchpadControlSurface)this.surface).setTriggerConsumed(ButtonID.SHIFT);
                break;
            }
            case TRACK_VOLUME: 
            case TRACK_PAN: 
            case TRACK_SENDS: 
            case MIX: {
                super.scrollDown();
                break;
            }
            case SHUFFLE: {
                if (((LaunchpadControlSurface)this.surface).isPressed(ButtonID.UP)) break;
                this.triggerChangeShuffle(-1, ButtonID.DOWN);
                break;
            }
            case TEMPO: {
                if (((LaunchpadControlSurface)this.surface).isPressed(ButtonID.UP)) break;
                this.triggerChangeTempo(-1, ButtonID.DOWN);
                break;
            }
            case PROJECT: {
                this.model.getApplication().decTrackHeight();
                break;
            }
            case CLIP_LENGTH: 
            case NOTE_EDIT_VIEW: {
                break;
            }
            default: {
                throw new FrameworkException("Missing cursor key down handling for view.");
            }
        }
    }

    private void triggerChangeTempo(int amount, ButtonID buttonID) {
        if (!((LaunchpadControlSurface)this.surface).isPressed(buttonID)) {
            return;
        }
        this.transport.setTempo(this.transport.getTempo() + (double)amount);
        ((LaunchpadControlSurface)this.surface).scheduleTask(() -> this.triggerChangeTempo(amount, buttonID), 300L);
    }

    private void triggerChangeShuffle(int amount, ButtonID buttonID) {
        if (!((LaunchpadControlSurface)this.surface).isPressed(buttonID)) {
            return;
        }
        IParameter shuffleParam = this.model.getGroove().getParameter(GrooveParameterID.SHUFFLE_AMOUNT);
        int max = this.model.getValueChanger().getUpperBound() - 1;
        int a = (int)Math.round((double)(amount * max) / 100.0);
        shuffleParam.setValue(Math.min(max, shuffleParam.getValue() + a));
        ((LaunchpadControlSurface)this.surface).scheduleTask(() -> this.triggerChangeShuffle(amount, buttonID), 300L);
    }

    private void triggerChangeZoom1(boolean in) {
        if (!((LaunchpadControlSurface)this.surface).isPressed(in ? ButtonID.RIGHT : ButtonID.LEFT)) {
            return;
        }
        IApplication application = this.model.getApplication();
        if (in) {
            application.zoomIn();
        } else {
            application.zoomOut();
        }
        ((LaunchpadControlSurface)this.surface).scheduleTask(() -> this.triggerChangeZoom1(in), 300L);
    }

    @Override
    protected ButtonEvent getTriggerEvent() {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        switch ((Views)((Object)viewManager.getActiveID())) {
            case SEQUENCER: 
            case POLY_SEQUENCER: 
            case DRUM: 
            case DRUM4: 
            case DRUM8: {
                return ButtonEvent.UP;
            }
        }
        return ButtonEvent.DOWN;
    }
}

