/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchkey.mini.view;

import de.mossgrabers.controller.novation.launchkey.mini.LaunchkeyMiniMk3Configuration;
import de.mossgrabers.controller.novation.launchkey.mini.controller.LaunchkeyMiniMk3ControlSurface;
import de.mossgrabers.controller.novation.launchkey.mini.controller.LaunchkeyPadGrid;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.Pair;
import de.mossgrabers.framework.view.AbstractSessionView;
import de.mossgrabers.framework.view.Views;
import java.util.List;

public class SessionView
extends AbstractSessionView<LaunchkeyMiniMk3ControlSurface, LaunchkeyMiniMk3Configuration> {
    public static final List<Modes> PAD_MODES = List.of(Modes.REC_ARM, Modes.TRACK_SELECT, Modes.MUTE, Modes.SOLO, Modes.STOP_CLIP);
    private Modes padMode = null;

    public SessionView(LaunchkeyMiniMk3ControlSurface surface, IModel model) {
        super("Session", surface, model, 2, 8, true);
        LightInfo isRecording = new LightInfo(6, 6, false);
        LightInfo isRecordingQueued = new LightInfo(7, 7, true);
        LightInfo isPlaying = new LightInfo(24, 22, false);
        LightInfo isPlayingQueued = new LightInfo(24, 22, true);
        LightInfo hasContent = new LightInfo(10, -1, false);
        LightInfo noContent = new LightInfo(0, -1, false);
        LightInfo recArmed = new LightInfo(7, -1, false);
        this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, hasContent, noContent, recArmed);
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        ColorManager colorManager = this.model.getColorManager();
        int colorScene = colorManager.getColorIndex("COLOR_SCENE");
        int colorSceneSelected = colorManager.getColorIndex("COLOR_SELECTED_SCENE");
        int colorSceneOff = colorManager.getColorIndex("COLOR_SELECTED_OFF");
        ISceneBank sceneBank = this.model.getSceneBank();
        IScene s = (IScene)sceneBank.getItem(0);
        if (buttonID == ButtonID.SCENE1) {
            if (!s.doesExist()) {
                return colorSceneOff;
            }
            return s.isSelected() ? colorSceneSelected : colorScene;
        }
        if (this.padMode == null) {
            s = (IScene)sceneBank.getItem(1);
            if (!s.doesExist()) {
                return colorSceneOff;
            }
            return s.isSelected() ? colorSceneSelected : colorScene;
        }
        switch (this.padMode) {
            case REC_ARM: {
                return 5;
            }
            case TRACK_SELECT: {
                return 3;
            }
            case MUTE: {
                return 9;
            }
            case SOLO: {
                return 13;
            }
            case STOP_CLIP: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public void drawGrid() {
        boolean controlModeIsOff = this.padMode == null;
        this.rows = controlModeIsOff ? 2 : 1;
        super.drawGrid();
        if (controlModeIsOff) {
            return;
        }
        ITrackBank tb = this.model.getCurrentTrackBank();
        LaunchkeyPadGrid pads = ((LaunchkeyMiniMk3ControlSurface)this.surface).getPadGrid();
        block7: for (int x = 0; x < this.columns; ++x) {
            ITrack track = (ITrack)tb.getItem(x);
            boolean exists = track.doesExist();
            switch (this.padMode) {
                case REC_ARM: {
                    int recColor = 0;
                    if (exists) {
                        recColor = track.isRecArm() ? 5 : 7;
                    }
                    pads.lightEx(x, 1, recColor);
                    continue block7;
                }
                case TRACK_SELECT: {
                    int selectColor = 0;
                    if (exists) {
                        selectColor = track.isSelected() ? 3 : 1;
                    }
                    pads.lightEx(x, 1, selectColor);
                    continue block7;
                }
                case MUTE: {
                    int muteColor = 0;
                    if (exists) {
                        muteColor = track.isMute() ? 9 : 11;
                    }
                    pads.lightEx(x, 1, muteColor);
                    continue block7;
                }
                case SOLO: {
                    int soloColor = 0;
                    if (exists) {
                        soloColor = track.isSolo() ? 13 : 15;
                    }
                    pads.lightEx(x, 1, soloColor);
                    continue block7;
                }
                case STOP_CLIP: {
                    pads.lightEx(x, 1, exists ? 4 : 0);
                    continue block7;
                }
            }
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        Pair<Integer, Integer> padPos = this.getPad(note);
        int row = padPos.getValue();
        if (row == 0 || this.padMode == null) {
            super.onGridNote(note, velocity);
        } else if (velocity != 0) {
            this.handleFirstRowModes(padPos.getKey());
        }
    }

    @Override
    public void onGridNoteLongPress(int note) {
        Pair<Integer, Integer> padPos = this.getPad(note);
        int row = padPos.getValue();
        if (row == 0 || this.padMode == null) {
            super.onGridNoteLongPress(note);
        }
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID)) {
            return;
        }
        int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        ISceneBank sceneBank = this.model.getCurrentTrackBank().getSceneBank();
        if (((LaunchkeyMiniMk3ControlSurface)this.surface).isShiftPressed()) {
            if (event != ButtonEvent.UP) {
                return;
            }
            if (index == 0) {
                if (this.padMode == null) {
                    sceneBank.selectPreviousPage();
                } else {
                    sceneBank.scrollBackwards();
                }
            } else if (this.padMode == null) {
                sceneBank.selectNextPage();
            } else {
                sceneBank.scrollForwards();
            }
            return;
        }
        if (event == ButtonEvent.DOWN) {
            if (index == 1) {
                ((LaunchkeyMiniMk3ControlSurface)this.surface).getViewManager().setActive(Views.CONTROL);
            }
            return;
        }
        if (event == ButtonEvent.UP) {
            IScene scene = (IScene)sceneBank.getItem(index);
            scene.select();
            scene.launch(true, false);
        }
    }

    @Override
    protected Pair<Integer, Integer> getPad(int note) {
        Pair<Integer, Integer> pad = super.getPad(note);
        if (this.padMode != null) {
            pad.setValue(pad.getValue() == 0 ? -1 : 0);
        }
        return pad;
    }

    public Modes getPadMode() {
        return this.padMode;
    }

    public void setPadMode(Modes padMode) {
        this.padMode = padMode;
    }

    private void handleFirstRowModes(int column) {
        ITrack track = (ITrack)this.model.getCurrentTrackBank().getItem(column);
        switch (this.padMode) {
            case REC_ARM: {
                track.toggleRecArm();
                break;
            }
            case TRACK_SELECT: {
                this.selectTrack(column);
                break;
            }
            case MUTE: {
                track.toggleMute();
                break;
            }
            case SOLO: {
                track.toggleSolo();
                break;
            }
            case STOP_CLIP: {
                track.stop(false);
                break;
            }
        }
    }
}

