/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.mode.main;

import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.controller.novation.launchcontrol.mode.main.XLAbstractTrackMode;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.PanParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.SendParameterProvider;
import java.util.List;

public class XLTrackMixMode
extends XLAbstractTrackMode {
    public XLTrackMixMode(LaunchControlXLControlSurface surface, IModel model, List<ContinuousID> controls) {
        super("Send A, B & Panorama", surface, model, controls);
        SendParameterProvider sendParameterProvider1 = new SendParameterProvider(model, 0, 0);
        SendParameterProvider sendParameterProvider2 = new SendParameterProvider(model, 1, 0);
        PanParameterProvider panParameterProvider = new PanParameterProvider(model);
        BankParameterProvider deviceParameterProvider = new BankParameterProvider(this.model.getCursorDevice().getParameterBank());
        this.setParameterProviders(new CombinedParameterProvider(sendParameterProvider1, sendParameterProvider2, panParameterProvider), new CombinedParameterProvider(sendParameterProvider1, sendParameterProvider2, deviceParameterProvider));
    }

    @Override
    public int getKnobValue(int index) {
        int row = index / 8;
        int column = index % 8;
        ITrack track = (ITrack)this.model.getTrackBank().getItem(column);
        switch (row) {
            case 0: {
                return ((ISend)track.getSendBank().getItem(0)).getValue();
            }
            case 1: {
                return ((ISend)track.getSendBank().getItem(1)).getValue();
            }
            case 2: {
                if (this.configuration.isDeviceActive()) {
                    return ((IParameter)this.model.getCursorDevice().getParameterBank().getItem(column)).getValue();
                }
                return track.getPan();
            }
        }
        return 0;
    }

    @Override
    public void setKnobColor(int row, int column, int value) {
        int green = 0;
        int red = 0;
        switch (row) {
            case 0: {
                green = value == 0 ? 0 : value / 42 + 1;
                break;
            }
            case 1: {
                red = value == 0 ? 0 : value / 42 + 1;
                break;
            }
            case 2: {
                int n = green = value == 0 ? 0 : value / 42 + 1;
                if (this.configuration.isDeviceActive()) {
                    red = green == 0 ? 0 : 1;
                    break;
                }
                red = green;
                break;
            }
            default: {
                return;
            }
        }
        ((LaunchControlXLControlSurface)this.surface).setKnobLEDColor(row, column, green, red);
    }
}

