/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.mode.main;

import de.mossgrabers.controller.novation.launchcontrol.LaunchControlXLConfiguration;
import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLTemporaryButtonMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.main.XLAbstractMainMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.INoteEditor;
import de.mossgrabers.framework.mode.INoteEditorMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameter.NoteAttribute;
import de.mossgrabers.framework.parameter.NoteParameter;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.KeyManager;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class XLBaseNoteEditMode
extends XLAbstractMainMode<IItem>
implements INoteEditorMode,
INoteEditor {
    protected final int clipRows;
    protected final int clipCols;
    protected final IHost host;
    protected final ISpecificDevice firstInstrument;
    protected final Scales scales;
    protected final KeyManager keyManager;
    protected final FixedParameterProvider chanceParameterProvider;
    protected final FixedParameterProvider repeatParameterProvider;
    protected final FixedParameterProvider velocitySpreadParameterProvider;
    protected final FixedParameterProvider panParameterProvider;
    protected final BankParameterProvider deviceParameterProvider;

    protected XLBaseNoteEditMode(String name, LaunchControlXLControlSurface surface, IModel model, int clipRows, int clipCols, List<ContinuousID> controls) {
        super(name, surface, model, null, controls);
        this.host = model.getHost();
        this.scales = model.getScales();
        this.scales.setDrumDefaultOffset(8);
        this.keyManager = new KeyManager(model, this.scales, surface.getPadGrid());
        this.clipRows = clipRows;
        this.clipCols = clipCols;
        this.firstInstrument = model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT);
        this.deviceParameterProvider = new BankParameterProvider(this.firstInstrument.getParameterBank());
        IValueChanger valueChanger = this.model.getValueChanger();
        IDisplay display = surface.getDisplay();
        ArrayList<IParameter> chanceParameters = new ArrayList<IParameter>(8);
        ArrayList<IParameter> repeatParameters = new ArrayList<IParameter>(8);
        ArrayList<IParameter> velocitySpreadParameters = new ArrayList<IParameter>(8);
        ArrayList<IParameter> panParameters = new ArrayList<IParameter>(8);
        for (int i = 0; i < 8; ++i) {
            chanceParameters.add(new NoteParameter(i, NoteAttribute.CHANCE, display, model, this, valueChanger));
            repeatParameters.add(new NoteParameter(i, NoteAttribute.REPEAT, display, model, this, valueChanger));
            velocitySpreadParameters.add(new NoteParameter(i, NoteAttribute.VELOCITY_SPREAD, display, model, this, valueChanger));
            panParameters.add(new NoteParameter(i, NoteAttribute.PANORAMA, display, model, this, valueChanger));
        }
        this.chanceParameterProvider = new FixedParameterProvider(chanceParameters);
        this.repeatParameterProvider = new FixedParameterProvider(repeatParameters);
        this.velocitySpreadParameterProvider = new FixedParameterProvider(velocitySpreadParameters);
        this.panParameterProvider = new FixedParameterProvider(panParameters);
        this.getClip();
    }

    @Override
    public void onKnobValue(int index, int value) {
        int row = index / 8;
        if (row != 3) {
            return;
        }
        INoteClip clip = this.getClip();
        NotePosition notePosition = this.getNotePosition(index).get(0);
        if (notePosition.getNote() < 0) {
            return;
        }
        IStepInfo stepInfo = clip.getStep(notePosition);
        if (stepInfo.getState() == StepState.OFF) {
            return;
        }
        IValueChanger valueChanger = this.model.getValueChanger();
        double normalizedValue = valueChanger.toNormalizedValue(value);
        clip.updateStepVelocity(notePosition, normalizedValue);
        IDisplay display = ((LaunchControlXLControlSurface)this.surface).getDisplay();
        display.notify("Velocity: " + StringUtils.formatPercentage(normalizedValue));
    }

    @Override
    public void setKnobColor(int row, int column, int value) {
        int green = 0;
        int red = 0;
        switch (row) {
            case 0: {
                green = value == 0 ? 0 : value / 42 + 1;
                break;
            }
            case 1: {
                red = value == 0 ? 0 : value / 42 + 1;
                break;
            }
            case 2: {
                int n = green = value == 0 ? 0 : value / 42 + 1;
                if (this.configuration.isDeviceActive()) {
                    red = green == 0 ? 0 : 1;
                    break;
                }
                red = green;
                break;
            }
            default: {
                return;
            }
        }
        ((LaunchControlXLControlSurface)this.surface).setKnobLEDColor(row, column, green, red);
    }

    @Override
    protected void handleRow2(int index, ButtonEvent event) {
        ModeManager trackButtonModeManager = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager();
        switch (index) {
            case 0: {
                if (event == ButtonEvent.DOWN) {
                    trackButtonModeManager.setTemporary(Modes.INSTRUMENT_DEVICE_PARAMS);
                    return;
                }
                if (event != ButtonEvent.UP) break;
                if (!((XLTemporaryButtonMode)trackButtonModeManager.get(Modes.INSTRUMENT_DEVICE_PARAMS)).hasBeenUsed()) {
                    this.toggleDeviceActive();
                }
                trackButtonModeManager.restore();
                break;
            }
            case 1: {
                Modes activeIDIgnoreTemporary = (Modes)((Object)trackButtonModeManager.getActiveIDIgnoreTemporary());
                Modes modeID = activeIDIgnoreTemporary == Modes.DEVICE_LAYER_MUTE ? this.getSequencerMode() : Modes.DEVICE_LAYER_MUTE;
                this.alternativeModeSelect(event, modeID, Modes.CONFIGURATION);
                break;
            }
            case 2: {
                Modes activeIDIgnoreTemporary2 = (Modes)((Object)trackButtonModeManager.getActiveIDIgnoreTemporary());
                Modes modeID2 = activeIDIgnoreTemporary2 == Modes.DEVICE_LAYER_SOLO ? this.getSequencerMode() : Modes.DEVICE_LAYER_SOLO;
                this.alternativeModeSelect(event, modeID2, Modes.CLIP);
                break;
            }
            case 3: {
                Modes activeIDIgnoreTemporary3 = (Modes)((Object)trackButtonModeManager.getActiveIDIgnoreTemporary());
                Modes modeID3 = activeIDIgnoreTemporary3 == Modes.LOOP_LENGTH ? this.getSequencerMode() : Modes.LOOP_LENGTH;
                this.alternativeModeSelect(event, modeID3, Modes.TRANSPORT);
                break;
            }
        }
    }

    protected abstract Modes getSequencerMode();

    @Override
    public int getButtonColor(ButtonID buttonID) {
        ModeManager trackModeManager = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager();
        switch (buttonID) {
            case DEVICE: {
                return ((LaunchControlXLConfiguration)((LaunchControlXLControlSurface)this.surface).getConfiguration()).isDeviceActive() ? 127 : 0;
            }
            case MUTE: {
                return trackModeManager.isActive(new Modes[]{Modes.DEVICE_LAYER_MUTE}) ? 127 : 0;
            }
            case SOLO: {
                return trackModeManager.isActive(new Modes[]{Modes.DEVICE_LAYER_SOLO}) ? 127 : 0;
            }
            case REC_ARM: {
                return trackModeManager.isActive(new Modes[]{Modes.LOOP_LENGTH}) ? 127 : 0;
            }
            case ROW1_1: 
            case ROW1_2: 
            case ROW1_3: 
            case ROW1_4: 
            case ROW1_5: 
            case ROW1_6: 
            case ROW1_7: 
            case ROW1_8: {
                int index = buttonID.ordinal() - ButtonID.ROW1_1.ordinal();
                if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.REC_ARM)) {
                    return super.getTransportButtonColor(index);
                }
                return this.getFirstRowColor(index);
            }
        }
        return 12;
    }

    @Override
    public final INoteClip getClip() {
        return this.model.getNoteClip(this.clipCols, this.clipRows);
    }

    protected abstract int getNoteRow(int var1, int var2);

    protected abstract int getFirstRowColor(int var1);

    @Override
    public void selectPreviousItemPage() {
        if (this.isButtonCombination(ButtonID.DEVICE)) {
            Object f = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().getActive();
            if (f instanceof XLTemporaryButtonMode) {
                XLTemporaryButtonMode tempMode = (XLTemporaryButtonMode)f;
                tempMode.setHasBeenUsed();
            }
            this.model.getCursorDevice().selectPrevious();
            this.mvHelper.notifySelectedDevice();
            return;
        }
        if (this.isButtonCombination(ButtonID.SOLO)) {
            Object f = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().getActive();
            if (f instanceof XLTemporaryButtonMode) {
                XLTemporaryButtonMode tempMode = (XLTemporaryButtonMode)f;
                tempMode.setHasBeenUsed();
            }
            this.model.getSceneBank().selectPreviousPage();
            this.mvHelper.notifyScenePage();
            return;
        }
        INoteClip clip = this.getClip();
        clip.scrollStepsPageBackwards();
        this.mvHelper.notifyEditPage(clip);
    }

    @Override
    public void selectNextItemPage() {
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.DEVICE)) {
            Object f = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().getActive();
            if (f instanceof XLTemporaryButtonMode) {
                XLTemporaryButtonMode tempMode = (XLTemporaryButtonMode)f;
                tempMode.setHasBeenUsed();
            }
            this.model.getCursorDevice().selectNext();
            this.mvHelper.notifySelectedDevice();
            return;
        }
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.SOLO)) {
            Object f = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().getActive();
            if (f instanceof XLTemporaryButtonMode) {
                XLTemporaryButtonMode tempMode = (XLTemporaryButtonMode)f;
                tempMode.setHasBeenUsed();
            }
            this.model.getSceneBank().selectNextPage();
            this.mvHelper.notifyScenePage();
            return;
        }
        INoteClip clip = this.getClip();
        clip.scrollStepsPageForward();
        this.mvHelper.notifyEditPage(clip);
    }

    @Override
    public boolean hasPreviousItemPage() {
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.DEVICE)) {
            return this.model.getCursorDevice().canSelectPrevious();
        }
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.SOLO)) {
            return this.model.getSceneBank().canScrollPageBackwards();
        }
        return true;
    }

    @Override
    public boolean hasNextItemPage() {
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.DEVICE)) {
            return this.model.getCursorDevice().canSelectNext();
        }
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.SOLO)) {
            return this.model.getSceneBank().canScrollPageForwards();
        }
        return true;
    }

    @Override
    public INoteEditor getNoteEditor() {
        return this;
    }

    @Override
    public List<NotePosition> getNotePosition(int parameterIndex) {
        int column = parameterIndex % 8;
        int channel = this.configuration.getMidiEditChannel();
        int noteRow = this.getNoteRow(channel, column);
        return Collections.singletonList(new NotePosition(channel, column, noteRow));
    }

    @Override
    public void setNote(INoteClip clip, NotePosition notePosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addNote(INoteClip clip, NotePosition notePosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNote(INoteClip clip, NotePosition notePosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNoteEdited(INoteClip clip, NotePosition notePosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearNotes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<NotePosition> getNotes() {
        throw new UnsupportedOperationException();
    }
}

