/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.view;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractDrumView;

public class DrumView
extends AbstractDrumView<MaschineControlSurface, MaschineConfiguration> {
    private boolean isShifted = false;
    private boolean isSequencerVisible = false;
    private boolean isGridEditor = false;

    public DrumView(MaschineControlSurface surface, IModel model) {
        super("Drum", surface, model, 0, 4, 4, 128, 16, true, true);
        this.sequencerSteps = 16;
    }

    public void toggleSequencerVisible() {
        this.isSequencerVisible = !this.isSequencerVisible;
        this.updateNoteMapping();
    }

    public boolean isSequencerVisible() {
        return this.isSequencerVisible;
    }

    public void toggleGridEditor() {
        this.isGridEditor = !this.isGridEditor;
        this.updateNoteMapping();
    }

    public boolean isGridEditor() {
        return this.isGridEditor;
    }

    public void toggleShifted() {
        this.isShifted = !this.isShifted;
        this.updateNoteMapping();
    }

    @Override
    public void updateNoteMapping() {
        if (this.isShifted || this.isSequencerVisible || this.isGridEditor) {
            this.delayedUpdateNoteMapping(EMPTY_TABLE);
        } else {
            super.updateNoteMapping();
        }
    }

    @Override
    public void drawGrid() {
        if (this.isGridEditor) {
            int i;
            IPadGrid padGrid = ((MaschineControlSurface)this.surface).getPadGrid();
            for (i = 0; i < 8; ++i) {
                padGrid.light(36 + i, this.getButtonColorID(ButtonID.get(ButtonID.SCENE1, 7 - i)));
            }
            for (i = 8; i < 12; ++i) {
                padGrid.light(36 + i, 0);
            }
            for (i = 12; i < 14; ++i) {
                padGrid.light(36 + i, 42);
            }
            for (i = 14; i < 16; ++i) {
                padGrid.light(36 + i, 0);
            }
            return;
        }
        if (this.isSequencerVisible) {
            INoteClip clip = this.getClip();
            boolean isActive = this.isActive();
            IDrumDevice primary = this.model.getDrumDevice();
            this.drawSequencerSteps(clip, isActive, this.scales.getDrumOffset() + this.selectedPad, this.getPadColor(primary, this.selectedPad), y -> 3 - y);
            return;
        }
        if (this.isShifted) {
            this.drawShiftedGrid();
        } else {
            super.drawGrid();
        }
    }

    private void drawShiftedGrid() {
        int i;
        boolean isKeyboardEnabled = this.model.canSelectedTrackHoldNotes();
        IPadGrid padGrid = ((MaschineControlSurface)this.surface).getPadGrid();
        for (i = 36; i < 50; ++i) {
            padGrid.light(i, 0);
        }
        for (i = 50; i < 52; ++i) {
            padGrid.light(i, isKeyboardEnabled ? 11 : 0);
        }
    }

    @Override
    public void onGridNote(int key, int velocity) {
        int index = key - 36;
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        if (this.isGridEditor) {
            if (velocity == 0) {
                return;
            }
            if (index < 8) {
                this.setResolutionIndex(index);
            } else {
                INoteClip clip = this.getClip();
                if (index == 12) {
                    clip.scrollStepsPageBackwards();
                } else if (index == 13) {
                    clip.scrollStepsPageForward();
                }
                this.mvHelper.notifyEditPage(clip);
            }
            return;
        }
        if (this.isSequencerVisible) {
            int x = index % this.numColumns;
            int y = index / this.numColumns;
            int offsetY = this.scales.getDrumOffset();
            if (this.isActive()) {
                this.handleSequencerArea(index, x, y, offsetY, velocity);
            }
            return;
        }
        if (!this.isShifted) {
            super.onGridNote(key, velocity);
            return;
        }
        if (velocity == 0) {
            return;
        }
        switch (index) {
            case 14: {
                this.onOctaveDown(ButtonEvent.DOWN);
                break;
            }
            case 15: {
                this.onOctaveUp(ButtonEvent.DOWN);
                break;
            }
        }
        this.updateNoteMapping();
    }

    @Override
    protected void handleSequencerArea(int index, int x, int y, int offsetY, int velocity) {
        int yMod = 3 - y;
        super.handleSequencerArea(index, x, yMod, offsetY, velocity);
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int velocity) {
        if (this.isButtonCombination(ButtonID.MUTE)) {
            IStepInfo stepInfo = clip.getStep(notePosition);
            StepState isSet = stepInfo.getState();
            if (isSet == StepState.START) {
                this.getClip().updateStepMuteState(notePosition, !stepInfo.isMuted());
            }
            return true;
        }
        ModeManager modeManager = ((MaschineControlSurface)this.surface).getModeManager();
        if (modeManager.isActive(new Modes[]{Modes.NOTE})) {
            this.model.getHost().showNotification("Note " + Scales.formatNoteAndOctave(notePosition.getNote(), -3) + " - Step " + Integer.toString(notePosition.getStep() + 1));
            this.editNote(clip, notePosition, true);
            return true;
        }
        boolean isSelectPressed = ((MaschineControlSurface)this.surface).isSelectPressed();
        if (isSelectPressed) {
            ((MaschineControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, isSelectPressed);
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, velocity);
    }

    @Override
    protected int getPadIndex(int step) {
        int x = step % this.numColumns;
        int y = step / this.numColumns;
        return y * this.numColumns + x;
    }
}

