/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.mode;

import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.data.empty.EmptyParameter;
import de.mossgrabers.framework.mode.INoteEditor;
import de.mossgrabers.framework.mode.INoteEditorMode;
import de.mossgrabers.framework.mode.NoteEditor;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameter.NoteAttribute;
import de.mossgrabers.framework.parameter.NoteParameter;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class EditNoteMode
extends BaseMode
implements INoteEditorMode {
    private final IHost host;
    private final NoteEditor noteEditor;
    private final Map<Page, IParameterProvider> pageParamProviders = new EnumMap<Page, IParameterProvider>(Page.class);
    private Page page = Page.NOTE;
    private final Map<NoteAttribute, IParameter> notePartameters = new EnumMap<NoteAttribute, IParameter>(NoteAttribute.class);
    private NoteAttribute activeNoteAttribute = NoteAttribute.VELOCITY;

    public EditNoteMode(MaschineControlSurface surface, IModel model) {
        super("Edit note", surface, model, surface.getMaschine().hasMCUDisplay() ? DEFAULT_KNOB_IDS : null);
        this.host = this.model.getHost();
        this.noteEditor = new NoteEditor();
        this.selectedParam = 2;
        IValueChanger valueChanger = model.getValueChanger();
        IDisplay display = surface.getMaschine().hasMCUDisplay() ? null : surface.getDisplay();
        NoteParameter durationParameter = new NoteParameter(NoteAttribute.DURATION, display, model, this.noteEditor, valueChanger);
        NoteParameter velocityParameter = new NoteParameter(NoteAttribute.VELOCITY, display, model, this.noteEditor, valueChanger);
        NoteParameter gainParameter = new NoteParameter(NoteAttribute.GAIN, display, model, this.noteEditor, valueChanger);
        NoteParameter panParameter = new NoteParameter(NoteAttribute.PANORAMA, display, model, this.noteEditor, valueChanger);
        NoteParameter transposeParameter = new NoteParameter(NoteAttribute.TRANSPOSE, display, model, this.noteEditor, valueChanger);
        NoteParameter pressureParameter = new NoteParameter(NoteAttribute.PRESSURE, display, model, this.noteEditor, valueChanger);
        this.notePartameters.put(NoteAttribute.DURATION, durationParameter);
        this.notePartameters.put(NoteAttribute.VELOCITY, velocityParameter);
        this.notePartameters.put(NoteAttribute.GAIN, gainParameter);
        this.notePartameters.put(NoteAttribute.PANORAMA, panParameter);
        this.notePartameters.put(NoteAttribute.TRANSPOSE, transposeParameter);
        this.notePartameters.put(NoteAttribute.PRESSURE, pressureParameter);
        this.pageParamProviders.put(Page.NOTE, new FixedParameterProvider(EmptyParameter.INSTANCE, durationParameter, durationParameter, velocityParameter, new NoteParameter(NoteAttribute.VELOCITY_SPREAD, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.RELEASE_VELOCITY, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.CHANCE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.OCCURRENCE, null, model, this.noteEditor, valueChanger)));
        this.pageParamProviders.put(Page.EXPRESSIONS, new FixedParameterProvider(EmptyParameter.INSTANCE, durationParameter, durationParameter, gainParameter, panParameter, transposeParameter, new NoteParameter(NoteAttribute.TIMBRE, null, model, this.noteEditor, valueChanger), pressureParameter));
        this.pageParamProviders.put(Page.REPEAT, new FixedParameterProvider(EmptyParameter.INSTANCE, durationParameter, durationParameter, velocityParameter, new NoteParameter(NoteAttribute.REPEAT, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.REPEAT_CURVE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.REPEAT_VELOCITY_CURVE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.REPEAT_VELOCITY_END, null, model, this.noteEditor, valueChanger)));
        this.rebind();
    }

    @Override
    public void onKnobValue(int index, int value) {
        if (this.controls.isEmpty()) {
            this.notePartameters.get((Object)this.activeNoteAttribute).changeValue(value);
            return;
        }
        int idx = index < 0 ? this.selectedParam : index;
        this.defaultParameterProvider.get(idx).changeValue(value);
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        List<NotePosition> notes = this.noteEditor.getNotes();
        if (notes.isEmpty()) {
            return;
        }
        if (isTouched && ((MaschineControlSurface)this.surface).isDeletePressed()) {
            ((MaschineControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            int idx = index < 0 ? this.selectedParam : index;
            this.defaultParameterProvider.get(idx).resetValue();
            return;
        }
        INoteClip clip = this.noteEditor.getClip();
        if (isTouched) {
            clip.startEdit(notes);
        } else {
            clip.stopEdit();
        }
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((MaschineControlSurface)this.surface).getTextDisplay().clear();
        List<NotePosition> notes = this.noteEditor.getNotes();
        if (notes.isEmpty()) {
            d.setBlock(0, 0, "Please select");
            d.setBlock(0, 1, "a note...");
            d.allDone();
            return;
        }
        NotePosition notePosition = notes.get(0);
        IStepInfo stepInfo = this.noteEditor.getClip().getStep(notePosition);
        d.setCell(0, 0, "Note");
        if (notes.size() > 1) {
            d.setCell(1, 0, "*:" + notes.size());
        } else {
            d.setCell(1, 0, (String)(stepInfo == null ? "-" : Integer.toString(notePosition.getStep() + 1) + ":" + Scales.formatNoteAndOctave(notePosition.getNote(), -3)));
        }
        d.setCell(0, 1, this.mark("Length", 2));
        if (stepInfo == null) {
            d.setCell(1, 2, "-");
        } else {
            String[] formatLength = this.formatLength(stepInfo.getDuration()).split(":");
            d.setCell(1, 1, formatLength[0]);
            d.setCell(1, 2, ":" + formatLength[1]);
        }
        switch (this.page.ordinal()) {
            default: {
                d.setCell(0, 3, this.mark("Velocity", 3)).setCell(1, 3, stepInfo == null ? "-" : StringUtils.formatPercentage(stepInfo.getVelocity()));
                if (this.host.supports(NoteAttribute.VELOCITY_SPREAD)) {
                    d.setCell(0, 4, this.mark("Spread", 4)).setCell(1, 4, stepInfo == null ? "-" : StringUtils.formatPercentage(stepInfo.getVelocitySpread()));
                }
                if (this.host.supports(NoteAttribute.RELEASE_VELOCITY)) {
                    d.setCell(0, 5, this.mark("R-Vel", 5)).setCell(1, 5, stepInfo == null ? "-" : StringUtils.formatPercentage(stepInfo.getReleaseVelocity()));
                }
                if (this.host.supports(NoteAttribute.CHANCE)) {
                    d.setCell(0, 6, this.mark("Chance", 6)).setCell(1, 6, stepInfo == null ? "-" : StringUtils.formatPercentage(stepInfo.getChance()));
                }
                if (!this.host.supports(NoteAttribute.OCCURRENCE)) break;
                d.setCell(0, 7, this.mark("Occurnce", 7)).setCell(1, 7, stepInfo == null ? "-" : StringUtils.optimizeName(stepInfo.getOccurrence().getName(), 8));
                break;
            }
            case 1: {
                d.setCell(0, 3, this.mark("Gain", 3)).setCell(1, 3, stepInfo == null ? "-" : StringUtils.formatPercentage(stepInfo.getGain()));
                d.setCell(0, 4, this.mark("Pan", 4)).setCell(1, 4, stepInfo == null ? "-" : StringUtils.formatPercentage(stepInfo.getPan()));
                d.setCell(0, 5, this.mark("Pitch", 5)).setCell(1, 5, stepInfo == null ? "-" : String.format("%.1f", stepInfo.getTranspose()));
                d.setCell(0, 6, this.mark("Timbre", 6)).setCell(1, 6, stepInfo == null ? "-" : StringUtils.formatPercentage(stepInfo.getTimbre()));
                d.setCell(0, 7, this.mark("Pressure", 7)).setCell(1, 7, stepInfo == null ? "-" : StringUtils.formatPercentage(stepInfo.getPressure()));
                break;
            }
            case 2: {
                d.setCell(0, 3, this.mark("Velocity", 3)).setCell(1, 3, stepInfo == null ? "-" : StringUtils.formatPercentage(stepInfo.getVelocity()));
                d.setCell(0, 4, this.mark("Count", 4)).setCell(1, 4, stepInfo == null ? "-" : stepInfo.getFormattedRepeatCount());
                d.setCell(0, 5, this.mark("Curve", 5)).setCell(1, 5, stepInfo == null ? "-" : StringUtils.formatPercentage(stepInfo.getRepeatCurve()));
                d.setCell(0, 6, this.mark("V-Curve", 6)).setCell(1, 6, stepInfo == null ? "-" : StringUtils.formatPercentage(stepInfo.getRepeatVelocityCurve()));
                d.setCell(0, 7, this.mark("V-End", 7)).setCell(1, 7, stepInfo == null ? "-" : StringUtils.formatPercentage(stepInfo.getRepeatVelocityEnd()));
            }
        }
        d.allDone();
    }

    @Override
    public void selectNextItem() {
        if (this.hasNextItem()) {
            ++this.selectedParam;
        }
    }

    @Override
    public void selectPreviousItem() {
        if (this.hasPreviousItem()) {
            --this.selectedParam;
        }
    }

    @Override
    public boolean hasPreviousItem() {
        return this.selectedParam > 2;
    }

    @Override
    public boolean hasNextItem() {
        return this.selectedParam < 7;
    }

    @Override
    public void selectPreviousItemPage() {
        if (this.host.supports(NoteAttribute.TIMBRE)) {
            if (this.page == Page.EXPRESSIONS) {
                this.page = Page.NOTE;
            } else if (this.page == Page.REPEAT) {
                this.page = Page.EXPRESSIONS;
            }
            this.rebind();
        }
    }

    @Override
    public void selectNextItemPage() {
        if (this.host.supports(NoteAttribute.TIMBRE)) {
            if (this.page == Page.NOTE) {
                this.page = Page.EXPRESSIONS;
            } else if (this.page == Page.EXPRESSIONS) {
                this.page = Page.REPEAT;
            }
            this.rebind();
        }
    }

    @Override
    public boolean hasPreviousItemPage() {
        return this.host.supports(NoteAttribute.TIMBRE) && this.page.ordinal() > 0;
    }

    @Override
    public boolean hasNextItemPage() {
        return this.host.supports(NoteAttribute.TIMBRE) && this.page.ordinal() < Page.REPEAT.ordinal();
    }

    private String formatLength(double duration) {
        return StringUtils.formatMeasures(this.model.getTransport().getQuartersPerMeasure(), duration, 0, true);
    }

    public NoteAttribute getActiveParameter() {
        return this.activeNoteAttribute;
    }

    public void selectActiveParameter(NoteAttribute noteAttribute) {
        this.activeNoteAttribute = noteAttribute;
    }

    @Override
    public INoteEditor getNoteEditor() {
        return this.noteEditor;
    }

    private void rebind() {
        if (this.controls.isEmpty()) {
            return;
        }
        this.setParameterProvider(this.pageParamProviders.get((Object)this.page));
        this.bindControls();
    }

    private static enum Page {
        NOTE,
        EXPRESSIONS,
        REPEAT;

    }
}

