/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.command.trigger;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.mode.EditNoteMode;
import de.mossgrabers.controller.ni.maschine.mk3.mode.MaschineVolumeMode;
import de.mossgrabers.framework.command.trigger.mode.ModeMultiSelectCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.NoteAttribute;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class VolumePanSendCommand
extends ModeMultiSelectCommand<MaschineControlSurface, MaschineConfiguration> {
    public VolumePanSendCommand(IModel model, MaschineControlSurface surface) {
        super(model, surface, Modes.VOLUME, Modes.PAN, Modes.SEND1, Modes.SEND2, Modes.SEND3, Modes.SEND4, Modes.SEND5, Modes.SEND6, Modes.SEND7, Modes.SEND8);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        ModeManager modeManager = ((MaschineControlSurface)this.surface).getModeManager();
        if (modeManager.isActive(new Modes[]{Modes.NOTE}) && ((MaschineControlSurface)this.surface).getViewManager().isActive(new Views[]{Views.DRUM, Views.PLAY})) {
            if (event == ButtonEvent.DOWN) {
                EditNoteMode mode = (EditNoteMode)modeManager.get(Modes.NOTE);
                boolean isVelocity = mode.getActiveParameter() == NoteAttribute.VELOCITY;
                mode.selectActiveParameter(isVelocity ? NoteAttribute.GAIN : NoteAttribute.VELOCITY);
                ((MaschineControlSurface)this.surface).getDisplay().notify(isVelocity ? "Gain" : "Velocity");
            }
            return;
        }
        if (((MaschineControlSurface)this.surface).isShiftPressed()) {
            if (event == ButtonEvent.DOWN) {
                ((MaschineControlSurface)this.surface).setStopConsumed();
                ((MaschineVolumeMode)modeManager.get(Modes.VOLUME)).toggleDisplayVU();
            }
            return;
        }
        super.execute(event, velocity);
    }
}

