/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.command.continuous;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.framework.command.continuous.KnobRowModeCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IBank;
import java.util.Optional;

public class MainKnobRowModeCommand
extends KnobRowModeCommand<MaschineControlSurface, MaschineConfiguration> {
    public MainKnobRowModeCommand(IModel model, MaschineControlSurface surface) {
        super(-1, model, surface);
    }

    @Override
    public void execute(int value) {
        if (((MaschineControlSurface)this.surface).isPressed(ButtonID.SCENE1)) {
            this.switchPage(ButtonID.SCENE1, this.model.getSceneBank(), value);
            return;
        }
        if (((MaschineControlSurface)this.surface).isPressed(ButtonID.CLIP)) {
            Optional selectedTrack = this.model.getCurrentTrackBank().getSelectedItem();
            if (selectedTrack.isPresent()) {
                this.switchPage(ButtonID.CLIP, ((ITrack)selectedTrack.get()).getSlotBank(), value);
            }
            return;
        }
        if (((MaschineControlSurface)this.surface).isPressed(ButtonID.TRACK)) {
            this.switchPage(ButtonID.TRACK, this.model.getCurrentTrackBank(), value);
            return;
        }
        if (((MaschineControlSurface)this.surface).isPressed(ButtonID.SOLO)) {
            this.switchPage(ButtonID.SOLO, this.model.getCurrentTrackBank(), value);
            return;
        }
        if (((MaschineControlSurface)this.surface).isPressed(ButtonID.MUTE)) {
            this.switchPage(ButtonID.MUTE, this.model.getCurrentTrackBank(), value);
            return;
        }
        if (((MaschineControlSurface)this.surface).isPressed(ButtonID.ACCENT)) {
            int speed = this.model.getValueChanger().decode(value);
            ((MaschineControlSurface)this.surface).setTriggerConsumed(ButtonID.ACCENT);
            MaschineConfiguration configuration = (MaschineConfiguration)((MaschineControlSurface)this.surface).getConfiguration();
            int v = Math.min(Math.max(1, configuration.getFixedAccentValue() + speed), 127);
            configuration.setFixedAccentValue(v);
            ((MaschineControlSurface)this.surface).getDisplay().notify("Fixed Accent: " + v);
            return;
        }
        super.execute(value);
    }

    private void switchPage(ButtonID buttonID, IBank<?> bank, int value) {
        int speed = this.model.getValueChanger().decode(value);
        ((MaschineControlSurface)this.surface).setTriggerConsumed(buttonID);
        if (speed < 0) {
            bank.selectPreviousPage();
        } else {
            bank.selectNextPage();
        }
    }
}

