/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam.view;

import de.mossgrabers.controller.ni.maschine.jam.MaschineJamConfiguration;
import de.mossgrabers.controller.ni.maschine.jam.controller.MaschineJamControlSurface;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.midi.INoteRepeat;
import de.mossgrabers.framework.featuregroup.AbstractView;

public class NoteRepeatView
extends AbstractView<MaschineJamControlSurface, MaschineJamConfiguration> {
    public NoteRepeatView(MaschineJamControlSurface surface, IModel model) {
        super("Note Repeat", surface, model);
    }

    @Override
    public void drawGrid() {
        int i;
        int i2;
        IPadGrid padGrid = ((MaschineJamControlSurface)this.surface).getPadGrid();
        IHost host = this.model.getHost();
        INoteRepeat noteRepeat = ((MaschineJamControlSurface)this.surface).getMidiInput().getDefaultNoteInput().getNoteRepeat();
        if (host.supports(Capability.NOTE_REPEAT_OCTAVES)) {
            int octaves = noteRepeat.getOctaves();
            for (i2 = 0; i2 < 8; ++i2) {
                padGrid.light(36 + i2, i2 == octaves ? 30 : 77);
            }
        } else {
            for (i = 36; i < 44; ++i) {
                padGrid.light(i, 0);
            }
        }
        for (i = 44; i < 52; ++i) {
            padGrid.light(i, 0);
        }
        int periodIndex = Resolution.getMatch(noteRepeat.getPeriod());
        padGrid.light(79, periodIndex == 0 ? 38 : 37);
        padGrid.light(71, periodIndex == 2 ? 38 : 37);
        padGrid.light(63, periodIndex == 4 ? 38 : 37);
        padGrid.light(55, periodIndex == 6 ? 38 : 37);
        padGrid.light(80, periodIndex == 1 ? 62 : 61);
        padGrid.light(72, periodIndex == 3 ? 62 : 61);
        padGrid.light(64, periodIndex == 5 ? 62 : 61);
        padGrid.light(56, periodIndex == 7 ? 62 : 61);
        if (host.supports(Capability.NOTE_REPEAT_LENGTH)) {
            int lengthIndex = Resolution.getMatch(noteRepeat.getNoteLength());
            padGrid.light(81, lengthIndex == 0 ? 38 : 37);
            padGrid.light(73, lengthIndex == 2 ? 38 : 37);
            padGrid.light(65, lengthIndex == 4 ? 38 : 37);
            padGrid.light(57, lengthIndex == 6 ? 38 : 37);
            padGrid.light(82, lengthIndex == 1 ? 62 : 61);
            padGrid.light(74, lengthIndex == 3 ? 62 : 61);
            padGrid.light(66, lengthIndex == 5 ? 62 : 61);
            padGrid.light(58, lengthIndex == 7 ? 62 : 61);
        } else {
            padGrid.light(81, 0);
            padGrid.light(73, 0);
            padGrid.light(65, 0);
            padGrid.light(57, 0);
            padGrid.light(82, 0);
            padGrid.light(74, 0);
            padGrid.light(66, 0);
            padGrid.light(58, 0);
        }
        for (i2 = 52; i2 < 55; ++i2) {
            padGrid.light(i2, 0);
        }
        for (i2 = 59; i2 < 63; ++i2) {
            padGrid.light(i2, 0);
        }
        for (i2 = 67; i2 < 71; ++i2) {
            padGrid.light(i2, 0);
        }
        padGrid.light(75, 0);
        if (host.supports(Capability.NOTE_REPEAT_MODE)) {
            padGrid.light(76, 34);
            padGrid.light(77, 34);
        } else {
            padGrid.light(76, 0);
            padGrid.light(77, 0);
        }
        for (i2 = 78; i2 < 79; ++i2) {
            padGrid.light(i2, 0);
        }
        for (i2 = 83; i2 < 100; ++i2) {
            padGrid.light(i2, 0);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        IHost host = this.model.getHost();
        MaschineJamConfiguration configuration = (MaschineJamConfiguration)((MaschineJamControlSurface)this.surface).getConfiguration();
        switch (note) {
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                if (host.supports(Capability.NOTE_REPEAT_OCTAVES)) {
                    int octave = note - 36;
                    configuration.setNoteRepeatOctave(octave);
                    ((MaschineJamControlSurface)this.surface).scheduleTask(() -> ((MaschineJamControlSurface)this.surface).getDisplay().notify("Note Repeat Octave: " + octave), 100L);
                }
                return;
            }
            case 76: 
            case 77: {
                if (!host.supports(Capability.NOTE_REPEAT_MODE)) break;
                configuration.setPrevNextNoteRepeatMode(note == 77);
                ((MaschineJamControlSurface)this.surface).scheduleTask(() -> ((MaschineJamControlSurface)this.surface).getDisplay().notify("Note Repeat Mode: " + configuration.getNoteRepeatMode().getName()), 100L);
                break;
            }
            case 79: {
                this.setPeriod(0);
                return;
            }
            case 80: {
                this.setPeriod(1);
                return;
            }
            case 71: {
                this.setPeriod(2);
                return;
            }
            case 72: {
                this.setPeriod(3);
                return;
            }
            case 63: {
                this.setPeriod(4);
                return;
            }
            case 64: {
                this.setPeriod(5);
                return;
            }
            case 55: {
                this.setPeriod(6);
                return;
            }
            case 56: {
                this.setPeriod(7);
                return;
            }
            case 81: {
                this.setNoteLength(0);
                return;
            }
            case 82: {
                this.setNoteLength(1);
                return;
            }
            case 73: {
                this.setNoteLength(2);
                return;
            }
            case 74: {
                this.setNoteLength(3);
                return;
            }
            case 65: {
                this.setNoteLength(4);
                return;
            }
            case 66: {
                this.setNoteLength(5);
                return;
            }
            case 57: {
                this.setNoteLength(6);
                return;
            }
            case 58: {
                this.setNoteLength(7);
                return;
            }
        }
    }

    private void setPeriod(int index) {
        ((MaschineJamConfiguration)((MaschineJamControlSurface)this.surface).getConfiguration()).setNoteRepeatPeriod(Resolution.values()[index]);
        ((MaschineJamControlSurface)this.surface).scheduleTask(() -> ((MaschineJamControlSurface)this.surface).getDisplay().notify("Period: " + Resolution.getNameAt(index)), 100L);
    }

    private void setNoteLength(int index) {
        if (this.model.getHost().supports(Capability.NOTE_REPEAT_LENGTH)) {
            ((MaschineJamConfiguration)((MaschineJamControlSurface)this.surface).getConfiguration()).setNoteRepeatLength(Resolution.values()[index]);
            ((MaschineJamControlSurface)this.surface).scheduleTask(() -> ((MaschineJamControlSurface)this.surface).getDisplay().notify("Note Length: " + Resolution.getNameAt(index)), 100L);
        }
    }
}

