/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.core.controller;

import de.mossgrabers.controller.ni.maschine.core.command.trigger.EncoderMode;
import de.mossgrabers.controller.ni.maschine.core.view.IMaschineView;
import de.mossgrabers.framework.MVHelper;
import de.mossgrabers.framework.command.TempoCommand;
import de.mossgrabers.framework.command.continuous.SwingCommand;
import de.mossgrabers.framework.command.core.ContinuousCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.hardware.IHwContinuousControl;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.IProject;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameter.LoopStartParameter;
import de.mossgrabers.framework.parameter.PlayPositionParameter;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;

public class EncoderModeManager<S extends IControlSurface<C>, C extends Configuration>
implements ContinuousCommand {
    private static final Map<EncoderMode, String> MODE_LABELS = new EnumMap<EncoderMode, String>(EncoderMode.class);
    private static final Map<EncoderMode, String> TOGGLED_MODE_LABELS = new EnumMap<EncoderMode, String>(EncoderMode.class);
    protected final IHwContinuousControl encoder;
    protected final IModel model;
    protected final S surface;
    protected final MVHelper<S, C> mvHelper;
    private EncoderMode activeEncoderMode = null;
    private EncoderMode temporaryEncoderMode = null;
    private boolean isFunctionToggled = false;
    private final TempoCommand<S, C> tempoCommand;
    private final SwingCommand<S, C> swingCommand;
    private final PlayPositionParameter playPositionParameter;
    private final LoopStartParameter loopStartParameter;

    public EncoderModeManager(IHwContinuousControl encoder, IModel model, S surface) {
        this.encoder = encoder;
        this.model = model;
        this.surface = surface;
        this.mvHelper = new MVHelper(model, surface);
        this.tempoCommand = new TempoCommand(model, surface);
        this.swingCommand = new SwingCommand(model, surface);
        IValueChanger valueChanger = model.getValueChanger();
        ITransport transport = model.getTransport();
        this.playPositionParameter = new PlayPositionParameter(valueChanger, transport, (IControlSurface<?>)surface);
        this.loopStartParameter = new LoopStartParameter(valueChanger, transport, (IControlSurface<?>)surface);
        this.model.getTrackBank().addSelectionObserver((index, isSelected) -> this.handleTrackChange(isSelected));
    }

    public EncoderMode getActiveEncoderMode() {
        return this.activeEncoderMode;
    }

    public void setActiveEncoderMode(EncoderMode encoderMode) {
        if (this.activeEncoderMode == encoderMode) {
            return;
        }
        this.activeEncoderMode = encoderMode;
        this.updateBinding();
    }

    public void toggleFunction() {
        this.isFunctionToggled = !this.isFunctionToggled;
        this.updateBinding();
    }

    public boolean isActiveEncoderMode(EncoderMode encoderMode) {
        return this.activeEncoderMode == encoderMode;
    }

    public void enableTemporaryEncodeMode(EncoderMode encoderMode) {
        this.temporaryEncoderMode = encoderMode;
        this.encoder.bind((IParameter)null);
        this.mvHelper.delayDisplay(() -> MODE_LABELS.get((Object)this.temporaryEncoderMode));
    }

    public void disableTemporaryEncodeMode() {
        this.temporaryEncoderMode = null;
        this.updateBinding();
    }

    private void updateBinding() {
        IParameter parameter;
        if (this.temporaryEncoderMode != null) {
            return;
        }
        switch (this.activeEncoderMode) {
            case OFF: {
                parameter = null;
                break;
            }
            case PLAY_POSITION: {
                parameter = this.isFunctionToggled ? this.loopStartParameter : this.playPositionParameter;
                break;
            }
            case SELECTED_TRACK_VOLUME: 
            case SELECTED_TRACK_PANORAMA: {
                Optional selectedTrack = this.model.getTrackBank().getSelectedItem();
                if (selectedTrack.isEmpty()) {
                    return;
                }
                ITrack t = (ITrack)selectedTrack.get();
                parameter = this.isFunctionToggled || this.activeEncoderMode == EncoderMode.SELECTED_TRACK_PANORAMA ? t.getPanParameter() : t.getVolumeParameter();
                break;
            }
            case METRONOME_VOLUME: {
                parameter = this.model.getTransport().getMetronomeVolumeParameter();
                break;
            }
            case CUE_VOLUME: 
            case CUE_MIX: {
                IProject project = this.model.getProject();
                parameter = this.isFunctionToggled || this.activeEncoderMode == EncoderMode.CUE_MIX ? project.getCueMixParameter() : project.getCueVolumeParameter();
                break;
            }
            default: {
                IMasterTrack masterTrack = this.model.getMasterTrack();
                parameter = this.isFunctionToggled || this.activeEncoderMode == EncoderMode.MASTER_PANORAMA ? masterTrack.getPanParameter() : masterTrack.getVolumeParameter();
            }
        }
        this.encoder.bind(parameter);
        this.notifyMode();
    }

    protected void notifyMode() {
        this.mvHelper.delayDisplay(() -> this.isFunctionToggled ? TOGGLED_MODE_LABELS.get((Object)this.activeEncoderMode) : MODE_LABELS.get((Object)this.activeEncoderMode));
    }

    private void handleTrackChange(boolean isSelected) {
        if (!isSelected || this.activeEncoderMode != EncoderMode.SELECTED_TRACK_VOLUME && this.activeEncoderMode != EncoderMode.SELECTED_TRACK_PANORAMA) {
            return;
        }
        Optional selectedTrack = this.model.getTrackBank().getSelectedItem();
        if (selectedTrack.isPresent()) {
            this.encoder.bind(((ITrack)selectedTrack.get()).getVolumeParameter());
        }
    }

    @Override
    public void execute(int value) {
        if (this.temporaryEncoderMode == null) {
            return;
        }
        switch (this.temporaryEncoderMode) {
            case TEMPORARY_TEMPO: {
                this.tempoCommand.execute(value);
                break;
            }
            case TEMPORARY_SWING: {
                this.swingCommand.execute(value);
                break;
            }
            case TEMPORARY_PERFORM: 
            case TEMPORARY_NOTES: 
            case TEMPORARY_LOCK: 
            case TEMPORARY_TUNE: {
                IView activeView = (IView)this.surface.getViewManager().getActive();
                if (!(activeView instanceof IMaschineView)) break;
                IMaschineView maschineView = (IMaschineView)((Object)activeView);
                maschineView.changeOption(this.temporaryEncoderMode, value);
                break;
            }
            case TEMPORARY_BROWSER: {
                this.handleBrowser(value);
                break;
            }
        }
    }

    private void handleBrowser(int value) {
        IBrowser browser = this.model.getBrowser();
        boolean increase = this.model.getValueChanger().isIncrease(value);
        if (this.surface.isShiftPressed()) {
            if (increase) {
                browser.nextContentType();
            } else {
                browser.previousContentType();
            }
            return;
        }
        if (this.surface.isSelectPressed()) {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            if (!cursorDevice.doesExist()) {
                return;
            }
            if (increase) {
                browser.insertAfterCursorDevice();
            } else {
                browser.insertBeforeCursorDevice();
            }
            return;
        }
        if (increase) {
            browser.selectNextResult();
        } else {
            browser.selectPreviousResult();
        }
    }

    public boolean isLit(EncoderMode encoderMode) {
        return this.isActiveEncoderMode(encoderMode);
    }

    static {
        MODE_LABELS.put(EncoderMode.OFF, "Off");
        MODE_LABELS.put(EncoderMode.MASTER_VOLUME, "Master: Volume");
        MODE_LABELS.put(EncoderMode.MASTER_PANORAMA, "Master: Panorama");
        MODE_LABELS.put(EncoderMode.SELECTED_TRACK_VOLUME, "Selected track: Volume");
        MODE_LABELS.put(EncoderMode.SELECTED_TRACK_PANORAMA, "Selected track: Panorama");
        MODE_LABELS.put(EncoderMode.METRONOME_VOLUME, "Metronome: Volume");
        MODE_LABELS.put(EncoderMode.CUE_VOLUME, "Cue: Volume");
        MODE_LABELS.put(EncoderMode.CUE_MIX, "Cue: Mix");
        MODE_LABELS.put(EncoderMode.TEMPORARY_TEMPO, "Tempo");
        MODE_LABELS.put(EncoderMode.TEMPORARY_SWING, "Swing");
        MODE_LABELS.put(EncoderMode.PLAY_POSITION, "Play Position");
        TOGGLED_MODE_LABELS.put(EncoderMode.OFF, "Off");
        TOGGLED_MODE_LABELS.put(EncoderMode.MASTER_VOLUME, "Master: Panorama");
        TOGGLED_MODE_LABELS.put(EncoderMode.MASTER_PANORAMA, "Master: Panorama");
        TOGGLED_MODE_LABELS.put(EncoderMode.SELECTED_TRACK_VOLUME, "Selected track: Panorama");
        TOGGLED_MODE_LABELS.put(EncoderMode.SELECTED_TRACK_PANORAMA, "Selected track: Panorama");
        TOGGLED_MODE_LABELS.put(EncoderMode.METRONOME_VOLUME, "Metronome: Volume");
        TOGGLED_MODE_LABELS.put(EncoderMode.CUE_VOLUME, "Cue: Mix");
        TOGGLED_MODE_LABELS.put(EncoderMode.CUE_MIX, "Cue: Mix");
        TOGGLED_MODE_LABELS.put(EncoderMode.TEMPORARY_TEMPO, "Tempo");
        TOGGLED_MODE_LABELS.put(EncoderMode.TEMPORARY_SWING, "Swing");
        TOGGLED_MODE_LABELS.put(EncoderMode.PLAY_POSITION, "Loop Start");
    }
}

