/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.core.command.trigger;

import de.mossgrabers.controller.ni.maschine.core.MaschineColorManager;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractSequencerView;
import java.util.Optional;

public class GroupButtonCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private final int index;

    public GroupButtonCommand(IModel model, S surface, int index) {
        super(model, surface);
        this.index = index;
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.surface.isPressed(ButtonID.SENDS)) {
            this.surface.setTriggerConsumed(ButtonID.SENDS);
            this.surface.getModeManager().setActive(Modes.get(Modes.SEND1, this.index));
            this.mvHelper.notifySelectedSend(this.index);
            return;
        }
        ITrackBank trackBank = this.model.getCurrentTrackBank();
        ITrack track = (ITrack)trackBank.getItem(this.index);
        if (!track.doesExist()) {
            return;
        }
        if (this.surface.isPressed(ButtonID.SOLO)) {
            this.surface.setTriggerConsumed(ButtonID.SOLO);
            track.toggleSolo();
            return;
        }
        if (this.surface.isPressed(ButtonID.MUTE)) {
            this.surface.setTriggerConsumed(ButtonID.MUTE);
            track.toggleMute();
            return;
        }
        if (this.surface.isPressed(ButtonID.RECORD)) {
            this.surface.setTriggerConsumed(ButtonID.RECORD);
            track.toggleRecArm();
            return;
        }
        if (this.surface.isPressed(ButtonID.DELETE)) {
            this.surface.setTriggerConsumed(ButtonID.DELETE);
            track.remove();
            return;
        }
        if (this.surface.isPressed(ButtonID.DUPLICATE)) {
            this.surface.setTriggerConsumed(ButtonID.DUPLICATE);
            track.duplicate();
            return;
        }
        if (this.surface.isPressed(ButtonID.GROOVE)) {
            IView active = (IView)this.surface.getViewManager().getActive();
            if (active instanceof AbstractSequencerView) {
                AbstractSequencerView sequencerView = (AbstractSequencerView)active;
                sequencerView.setResolutionIndex(this.index);
            }
            return;
        }
        track.selectOrExpandGroup();
    }

    public int getButtonColor() {
        ITrackBank trackBank = this.model.getCurrentTrackBank();
        if (this.surface.isPressed(ButtonID.SENDS)) {
            ISend send;
            Optional selectedTrack = trackBank.getSelectedItem();
            if (selectedTrack.isEmpty()) {
                ITrack item = (ITrack)trackBank.getItem(0);
                Optional<Object> optional = selectedTrack = item.doesExist() ? Optional.of(item) : Optional.empty();
            }
            if (selectedTrack.isPresent() && (send = (ISend)((ITrack)selectedTrack.get()).getSendBank().getItem(this.index)).doesExist()) {
                return 78;
            }
            return 0;
        }
        ITrack track = (ITrack)trackBank.getItem(this.index);
        if (!track.doesExist()) {
            return 0;
        }
        if (this.surface.isPressed(ButtonID.SOLO)) {
            return track.isSolo() ? 42 : 76;
        }
        if (this.surface.isPressed(ButtonID.MUTE)) {
            return track.isMute() ? 22 : 76;
        }
        if (this.surface.isPressed(ButtonID.RECORD)) {
            return track.isRecArm() ? 6 : 76;
        }
        if (this.surface.isPressed(ButtonID.GROOVE)) {
            IView active = (IView)this.surface.getViewManager().getActive();
            if (active instanceof AbstractSequencerView) {
                AbstractSequencerView sequencerView = (AbstractSequencerView)active;
                return sequencerView.getResolutionIndex() == this.index ? 30 : 76;
            }
            return 0;
        }
        return ((MaschineColorManager)this.model.getColorManager()).dimOrHighlightColor(track.getColor(), track.isSelected());
    }
}

