/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mkii.controller;

import de.mossgrabers.controller.ni.kontrol.mkii.KontrolProtocolConfiguration;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KontrolProtocolControlSurface
extends AbstractControlSurface<KontrolProtocolConfiguration> {
    public static final int CMD_HELLO = 1;
    public static final int CMD_GOODBYE = 2;
    public static final int KONTROL_PLAY = 16;
    public static final int KONTROL_RESTART = 17;
    public static final int KONTROL_RECORD = 18;
    public static final int KONTROL_COUNT_IN = 19;
    public static final int KONTROL_STOP = 20;
    public static final int KONTROL_CLEAR = 21;
    public static final int KONTROL_LOOP = 22;
    public static final int KONTROL_METRO = 23;
    public static final int KONTROL_TAP_TEMPO = 24;
    public static final int KONTROL_UNDO = 32;
    public static final int KONTROL_REDO = 33;
    public static final int KONTROL_QUANTIZE = 34;
    public static final int KONTROL_AUTOMATION = 35;
    public static final int KONTROL_NAVIGATE_TRACKS = 48;
    public static final int KONTROL_NAVIGATE_BANKS = 49;
    public static final int KONTROL_NAVIGATE_CLIPS = 50;
    public static final int KONTROL_NAVIGATE_MOVE_TRANSPORT = 52;
    public static final int KONTROL_NAVIGATE_MOVE_LOOP = 53;
    public static final int KONTROL_TRACK_AVAILABLE = 64;
    public static final int KONTROL_TRACK_INSTANCE = 65;
    public static final int KONTROL_TRACK_SELECTED = 66;
    public static final int KONTROL_TRACK_MUTE = 67;
    public static final int KONTROL_TRACK_SOLO = 68;
    public static final int KONTROL_TRACK_RECARM = 69;
    public static final int KONTROL_TRACK_VOLUME_TEXT = 70;
    public static final int KONTROL_TRACK_PAN_TEXT = 71;
    public static final int KONTROL_TRACK_NAME = 72;
    public static final int KONTROL_TRACK_VU = 73;
    public static final int KONTROL_TRACK_MUTED_BY_SOLO = 74;
    public static final int KONTROL_TRACK_VOLUME = 80;
    public static final int KONTROL_TRACK_PAN = 88;
    public static final int KONTROL_PLAY_SELECTED_CLIP = 96;
    public static final int KONTROL_STOP_CLIP = 97;
    public static final int KONTROL_PLAY_SCENE = 98;
    public static final int KONTROL_RECORD_SESSION = 99;
    public static final int KONTROL_CHANGE_SELECTED_TRACK_VOLUME = 100;
    public static final int KONTROL_CHANGE_SELECTED_TRACK_PAN = 101;
    public static final int KONTROL_SELECTED_TRACK_MUTE = 102;
    public static final int KONTROL_SELECTED_TRACK_SOLO = 103;
    public static final int KONTROL_SELECTED_TRACK_AVAILABLE = 104;
    public static final int KONTROL_SELECTED_TRACK_MUTED_BY_SOLO = 105;
    private final int requiredVersion;
    private int protocolVersion = 3;
    private final ValueCache valueCache = new ValueCache();
    private final Object cacheLock = new Object();
    private final Object handshakeLock = new Object();
    private boolean isConnectedToNIHIA = false;

    public KontrolProtocolControlSurface(IHost host, ColorManager colorManager, KontrolProtocolConfiguration configuration, IMidiOutput output, IMidiInput input, int version) {
        super(host, configuration, colorManager, output, input, null, 800.0, 300.0);
        this.requiredVersion = version;
        this.defaultMidiChannel = 15;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalShutdown() {
        super.internalShutdown();
        Object object = this.handshakeLock;
        synchronized (object) {
            this.isConnectedToNIHIA = false;
            for (int i = 0; i < 8; ++i) {
                this.sendKontrolTrackSysEx(64, 0, i);
            }
            this.sendCommand(2, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectedToNIHIA() {
        Object object = this.handshakeLock;
        synchronized (object) {
            return this.isConnectedToNIHIA;
        }
    }

    public void initHandshake() {
        this.sendCommand(1, this.requiredVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handshakeSuccess(int protocol) {
        Object object = this.handshakeLock;
        synchronized (object) {
            this.setProtocolVersion(protocol);
            this.clearCache();
            this.isConnectedToNIHIA = true;
        }
    }

    @Override
    public void setTrigger(BindType bindType, int channel, int cc, int value) {
        this.sendCommand(cc, value);
    }

    public void sendCommand(int command, int value) {
        this.output.sendCCEx(15, command, value);
    }

    public void sendKontrolTrackSysEx(int stateID, int value, int track) {
        this.sendKontrolTrackSysEx(stateID, value, track, "");
    }

    public void sendKontrolTrackSysEx(int stateID, int value, int track, String info) {
        this.sendKontrolTrackSysEx(stateID, value, track, StringUtils.fixASCII(info).chars().toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        Object object = this.cacheLock;
        synchronized (object) {
            this.valueCache.clearCache();
        }
        super.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKontrolTrackSysEx(int stateID, int value, int track, int[] info) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.valueCache.store(track, stateID, value, info)) {
                return;
            }
        }
        int[] data = new int[3 + info.length];
        data[0] = stateID;
        data[1] = value;
        data[2] = track;
        for (int i = 0; i < info.length; ++i) {
            data[3 + i] = info[i];
        }
        this.output.sendSysex("F0 00 21 09 00 00 44 43 01 00 " + StringUtils.toHexStr(data) + "F7");
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    private static class ValueCache {
        private final List<List<int[]>> cache = new ArrayList<List<int[]>>(8);

        public ValueCache() {
            this.clearCache();
        }

        public final void clearCache() {
            for (int i = 0; i < 8; ++i) {
                ArrayList<int[]> e = new ArrayList<int[]>(128);
                for (int j = 0; j < 128; ++j) {
                    e.add(new int[0]);
                }
                this.cache.add(e);
            }
        }

        public boolean store(int track, int stateID, int value, int[] data) {
            List<int[]> trackItem = this.cache.get(track);
            int[] values = trackItem.get(stateID);
            int[] newValues = new int[1 + data.length];
            newValues[0] = value;
            if (data.length > 0) {
                System.arraycopy(data, 0, newValues, 1, data.length);
            }
            if (Arrays.equals(values, newValues)) {
                return true;
            }
            trackItem.set(stateID, newValues);
            return false;
        }
    }
}

