/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mkii;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import java.util.List;

public class KontrolProtocolConfiguration
extends AbstractConfiguration {
    private static final Integer FLIP_TRACK_CLIP_NAVIGATION = 52;
    private static final Integer FLIP_CLIP_SCENE_NAVIGATION = 53;
    private static final Integer MODE_SWITCH_BUTTON = 54;
    private static final String CATEGORY_NAVIGATION = "Navigation";
    private static final String[] MODE_SWITCH_BUTTONS = new String[]{"Off", "Auto", "Loop", "Metronome", "Quantize", "Redo", "Restart", "Stop", "Tempo"};
    private final int version;
    private boolean flipTrackClipNavigation = false;
    private boolean flipClipSceneNavigation = false;
    private SwitchButton modeSwitchButton = SwitchButton.OFF;

    public KontrolProtocolConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes, int version) {
        super(host, valueChanger, arpeggiatorModes);
        this.version = version;
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        IEnumSetting modeSwitchButtonSetting = globalSettings.getEnumSetting("Switch modes with", "Hardware Setup", MODE_SWITCH_BUTTONS, MODE_SWITCH_BUTTONS[this.version >= 3 ? 7 : 0]);
        modeSwitchButtonSetting.addValueObserver(value -> {
            this.modeSwitchButton = SwitchButton.values()[KontrolProtocolConfiguration.lookupIndex(MODE_SWITCH_BUTTONS, value)];
            this.notifyObservers(MODE_SWITCH_BUTTON);
        });
        this.isSettingActive.add(MODE_SWITCH_BUTTON);
        this.activateBehaviourOnStopSetting(globalSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateRecordButtonSetting(globalSettings);
        this.activateShiftedRecordButtonSetting(globalSettings);
        IEnumSetting flipTrackClipNavigationSetting = globalSettings.getEnumSetting("Flip track/clip navigation", CATEGORY_NAVIGATION, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        flipTrackClipNavigationSetting.addValueObserver(value -> {
            this.flipTrackClipNavigation = ON_OFF_OPTIONS[1].equals(value);
            this.notifyObservers(FLIP_TRACK_CLIP_NAVIGATION);
        });
        this.isSettingActive.add(FLIP_TRACK_CLIP_NAVIGATION);
        IEnumSetting flipClipSceneNavigationSetting = globalSettings.getEnumSetting("Flip clip/scene navigation", CATEGORY_NAVIGATION, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        flipClipSceneNavigationSetting.addValueObserver(value -> {
            this.flipClipSceneNavigation = ON_OFF_OPTIONS[1].equals(value);
            this.notifyObservers(FLIP_CLIP_SCENE_NAVIGATION);
        });
        this.isSettingActive.add(FLIP_CLIP_SCENE_NAVIGATION);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
        this.activateKnobSpeedSetting(globalSettings, 0, 20);
    }

    public boolean isFlipTrackClipNavigation() {
        return this.flipTrackClipNavigation;
    }

    public boolean isFlipClipSceneNavigation() {
        return this.flipClipSceneNavigation;
    }

    public SwitchButton getModeSwitchButton() {
        return this.modeSwitchButton;
    }

    public static enum SwitchButton {
        OFF,
        AUTO,
        LOOP,
        METRONOME,
        QUANTIZE,
        REDO,
        RESTART,
        STOP,
        TEMPO;

    }
}

