/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mki.mode;

import de.mossgrabers.controller.ni.kontrol.mki.controller.Kontrol1ControlSurface;
import de.mossgrabers.controller.ni.kontrol.mki.controller.Kontrol1Display;
import de.mossgrabers.controller.ni.kontrol.mki.mode.AbstractKontrol1Mode;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.scale.Scales;
import java.util.Locale;

public class ScaleMode
extends AbstractKontrol1Mode<IItem> {
    private final Scales scales;

    public ScaleMode(Kontrol1ControlSurface surface, IModel model) {
        super("Scales", surface, model);
        this.scales = this.model.getScales();
    }

    @Override
    public void updateDisplay() {
        Kontrol1Display d = (Kontrol1Display)((Kontrol1ControlSurface)this.surface).getDisplay();
        d.clear();
        d.setCell(0, 0, "SCALE");
        d.setCell(0, 1, "SCALE").setCell(1, 1, this.scales.getScale().getName().toUpperCase(Locale.US));
        d.setCell(0, 2, "BASE").setCell(1, 2, Scales.BASES.get(this.scales.getScaleOffsetIndex()));
        d.allDone();
    }

    @Override
    public void onKnobValue(int index, int value) {
        boolean isInc = value <= 63;
        switch (index) {
            case 0: {
                if (isInc) {
                    this.scales.nextScale();
                    break;
                }
                this.scales.prevScale();
                break;
            }
            case 1: {
                if (isInc) {
                    this.scales.setScaleOffsetByIndex(this.scales.getScaleOffsetIndex() + 1);
                    break;
                }
                this.scales.setScaleOffsetByIndex(this.scales.getScaleOffsetIndex() - 1);
                break;
            }
            default: {
                return;
            }
        }
        this.updateScalePreferences();
    }

    @Override
    public void selectPreviousItem() {
        this.scales.prevScale();
        this.updateScalePreferences();
    }

    @Override
    public void selectNextItem() {
        this.scales.nextScale();
        this.updateScalePreferences();
    }

    @Override
    public void selectPreviousItemPage() {
        this.scales.prevScaleOffset();
        this.updateScalePreferences();
    }

    @Override
    public void selectNextItemPage() {
        this.scales.nextScaleOffset();
        this.updateScalePreferences();
    }

    @Override
    public void onBack() {
        ((Kontrol1ControlSurface)this.surface).getModeManager().restore();
    }

    @Override
    public void onEnter() {
        ((Kontrol1ControlSurface)this.surface).getModeManager().restore();
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        switch (buttonID) {
            case MUTE: 
            case SOLO: 
            case BROWSE: {
                return "BUTTON_STATE_ON";
            }
        }
        return "BUTTON_STATE_OFF";
    }

    private void updateScalePreferences() {
        this.scales.updateScaleProperties((Configuration)((Kontrol1ControlSurface)this.surface).getConfiguration());
    }
}

