/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mki.controller;

import de.mossgrabers.controller.ni.kontrol.mki.Kontrol1Configuration;
import de.mossgrabers.controller.ni.kontrol.mki.controller.Kontrol1LightGuide;
import de.mossgrabers.controller.ni.kontrol.mki.controller.Kontrol1UsbDevice;
import de.mossgrabers.controller.ni.kontrol.mki.controller.UIChangeCallback;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.OutputID;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwContinuousControl;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Kontrol1ControlSurface
extends AbstractControlSurface<Kontrol1Configuration>
implements UIChangeCallback {
    public static final int BUTTON_MAIN_ENCODER = 1;
    public static final int BUTTON_PRESET_UP = 2;
    public static final int BUTTON_ENTER = 3;
    public static final int BUTTON_PRESET_DOWN = 4;
    public static final int BUTTON_BROWSE = 5;
    public static final int BUTTON_INSTANCE = 6;
    public static final int BUTTON_OCTAVE_DOWN = 7;
    public static final int BUTTON_OCTAVE_UP = 8;
    public static final int BUTTON_STOP = 9;
    public static final int BUTTON_REC = 10;
    public static final int BUTTON_PLAY = 11;
    public static final int BUTTON_NAVIGATE_RIGHT = 12;
    public static final int BUTTON_NAVIGATE_DOWN = 13;
    public static final int BUTTON_NAVIGATE_LEFT = 14;
    public static final int BUTTON_BACK = 15;
    public static final int BUTTON_NAVIGATE_UP = 16;
    public static final int BUTTON_SHIFT = 17;
    public static final int BUTTON_SCALE = 18;
    public static final int BUTTON_ARP = 19;
    public static final int BUTTON_LOOP = 20;
    public static final int BUTTON_PAGE_RIGHT = 21;
    public static final int BUTTON_PAGE_LEFT = 22;
    public static final int BUTTON_RWD = 23;
    public static final int BUTTON_FWD = 24;
    public static final int TOUCH_ENCODER_1 = 25;
    public static final int TOUCH_ENCODER_2 = 26;
    public static final int TOUCH_ENCODER_3 = 27;
    public static final int TOUCH_ENCODER_4 = 28;
    public static final int TOUCH_ENCODER_5 = 29;
    public static final int TOUCH_ENCODER_6 = 30;
    public static final int TOUCH_ENCODER_7 = 31;
    public static final int TOUCH_ENCODER_8 = 32;
    public static final int TOUCH_ENCODER_MAIN = 33;
    public static final int ENCODER_1 = 40;
    public static final int ENCODER_2 = 41;
    public static final int ENCODER_3 = 42;
    public static final int ENCODER_4 = 43;
    public static final int ENCODER_5 = 44;
    public static final int ENCODER_6 = 45;
    public static final int ENCODER_7 = 46;
    public static final int ENCODER_8 = 47;
    public static final int MAIN_ENCODER = 48;
    private static final Map<Integer, ButtonID> BUTTON_MAP = new HashMap<Integer, ButtonID>();
    private static final Map<Integer, ContinuousID> CONTINUOUS_MAP;
    private final Kontrol1UsbDevice usbDevice;

    public Kontrol1ControlSurface(IHost host, ColorManager colorManager, Kontrol1Configuration configuration, IMidiInput input, Kontrol1UsbDevice usbDevice) {
        super(0, host, configuration, colorManager, null, input, null, null, 800.0, 300.0);
        this.usbDevice = usbDevice;
        this.lightGuide = new Kontrol1LightGuide(colorManager, usbDevice);
        this.createLightGuide();
    }

    @Override
    protected void createLightGuide() {
        if (this.lightGuide == null) {
            return;
        }
        for (int i = 0; i < this.usbDevice.getNumKeys(); ++i) {
            int index = i;
            this.createLight(OutputID.get(OutputID.LIGHT_GUIDE1, i), () -> {
                int firstNote = this.usbDevice.getFirstNote();
                int note = firstNote + index;
                if (note >= 128) {
                    return -1;
                }
                return this.lightGuide.getLightInfo(note).getEncoded();
            }, state -> {
                int firstNote = this.usbDevice.getFirstNote();
                int note = firstNote + index;
                this.lightGuide.sendState(note);
            }, colorIndex -> this.colorManager.getColor(colorIndex, null), null);
        }
    }

    @Override
    protected void internalShutdown() {
        this.usbDevice.turnOffButtonLEDs();
        for (int i = 0; i < 88; ++i) {
            this.usbDevice.setKeyLED(i, 0, 0, 0);
        }
        this.updateKeyLEDs();
        this.getTextDisplay().clear().notify(" START  " + this.host.getName().toUpperCase(Locale.US) + " TO PLAY");
        super.internalShutdown();
    }

    @Override
    protected void updateGrid() {
        super.updateGrid();
        this.updateKeyLEDs();
    }

    @Override
    public void setTrigger(BindType bindType, int channel, int cc, int value) {
        this.usbDevice.setButtonLED(cc, value);
    }

    @Override
    public void buttonChange(int usbControlNumber, boolean isPressed) {
        ButtonID buttonID = BUTTON_MAP.get(usbControlNumber);
        if (buttonID == null) {
            ContinuousID continuousID = CONTINUOUS_MAP.get(usbControlNumber);
            if (continuousID == null) {
                return;
            }
            IHwContinuousControl continuous = this.getContinuous(continuousID);
            if (isPressed) {
                if (!continuous.isTouched()) {
                    continuous.triggerTouch(true);
                }
            } else if (continuous.isTouched()) {
                continuous.triggerTouch(false);
            }
            return;
        }
        if (isPressed) {
            if (!this.isPressed(buttonID)) {
                this.getButton(buttonID).trigger(ButtonEvent.DOWN);
            }
        } else if (this.isPressed(buttonID)) {
            this.getButton(buttonID).trigger(ButtonEvent.UP);
        }
    }

    @Override
    public void mainEncoderChanged(boolean valueIncreased) {
        this.getContinuous(ContinuousID.MASTER_KNOB).getCommand().execute(valueIncreased ? 3 : 125);
    }

    @Override
    public void encoderChanged(int encIndex, int change) {
        int v = this.isShiftPressed() ? (change < 0 ? 127 : 1) : (change < 0 ? 127 + change : change);
        this.getContinuous(ContinuousID.get(ContinuousID.KNOB1, encIndex)).getCommand().execute(v);
    }

    @Override
    public void octaveChanged(int firstNote) {
        int endNote = firstNote + this.usbDevice.getNumKeys() - 1;
        this.getDisplay().notify(Scales.formatDrumNote(firstNote) + " to " + Scales.formatDrumNote(endNote));
    }

    public void updateButtonLEDs() {
        this.usbDevice.updateButtonLEDs();
    }

    public void updateKeyLEDs() {
        this.usbDevice.updateKeyLEDs();
    }

    @Override
    protected void updateViewControls() {
        super.updateViewControls();
        this.updateButtonLEDs();
    }

    @Override
    protected void handleCC(int data1, int data2) {
        if (data1 != 1) {
            super.handleCC(data1, data2);
        }
    }

    @Override
    protected void handlePitchbend(int data1, int data2) {
    }

    @Override
    protected void handleNoteOff(int data1, int data2) {
    }

    @Override
    protected void handleNoteOn(int data1, int data2) {
    }

    static {
        BUTTON_MAP.put(17, ButtonID.SHIFT);
        BUTTON_MAP.put(18, ButtonID.SCALES);
        BUTTON_MAP.put(19, ButtonID.METRONOME);
        BUTTON_MAP.put(11, ButtonID.PLAY);
        BUTTON_MAP.put(10, ButtonID.RECORD);
        BUTTON_MAP.put(9, ButtonID.STOP);
        BUTTON_MAP.put(23, ButtonID.REWIND);
        BUTTON_MAP.put(24, ButtonID.FORWARD);
        BUTTON_MAP.put(20, ButtonID.LOOP);
        BUTTON_MAP.put(22, ButtonID.PAGE_LEFT);
        BUTTON_MAP.put(21, ButtonID.PAGE_RIGHT);
        BUTTON_MAP.put(1, ButtonID.MASTERTRACK);
        BUTTON_MAP.put(13, ButtonID.ARROW_DOWN);
        BUTTON_MAP.put(16, ButtonID.ARROW_UP);
        BUTTON_MAP.put(14, ButtonID.ARROW_LEFT);
        BUTTON_MAP.put(12, ButtonID.ARROW_RIGHT);
        BUTTON_MAP.put(15, ButtonID.MUTE);
        BUTTON_MAP.put(3, ButtonID.SOLO);
        BUTTON_MAP.put(5, ButtonID.BROWSE);
        CONTINUOUS_MAP = new HashMap<Integer, ContinuousID>();
        for (int i = 0; i < 8; ++i) {
            CONTINUOUS_MAP.put(25 + i, ContinuousID.get(ContinuousID.KNOB1, i));
        }
        CONTINUOUS_MAP.put(33, ContinuousID.MASTER_KNOB);
    }
}

