/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mki;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import java.util.List;

public class Kontrol1Configuration
extends AbstractConfiguration {
    public static final Integer SCALE_IS_ACTIVE = 50;
    private IEnumSetting scaleIsActiveSetting;
    private boolean scaleIsActive;

    public Kontrol1Configuration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes) {
        super(host, valueChanger, arpeggiatorModes);
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        this.scaleIsActiveSetting = documentSettings.getEnumSetting("Is active", "Scales", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.scaleIsActiveSetting.addValueObserver(value -> {
            this.scaleIsActive = "On".equals(value);
            this.notifyObservers(SCALE_IS_ACTIVE);
        });
        this.isSettingActive.add(SCALE_IS_ACTIVE);
        this.activateScaleSetting(documentSettings);
        this.activateScaleBaseSetting(documentSettings);
        this.activateBehaviourOnStopSetting(globalSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateFlipRecordSetting(globalSettings);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateEnableVUMetersSetting(globalSettings);
        this.activateKnobSpeedSetting(globalSettings);
    }

    public boolean isScaleIsActive() {
        return this.scaleIsActive;
    }

    public void toggleScaleIsActive() {
        this.scaleIsActiveSetting.set(ON_OFF_OPTIONS[this.scaleIsActive ? 0 : 1]);
    }
}

