/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.controller;

import de.mossgrabers.framework.controller.display.AbstractTextDisplay;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiOutput;

public class MCUAssignmentDisplay
extends AbstractTextDisplay {
    private final int[] assignmentBuffer = new int[2];

    public MCUAssignmentDisplay(IHost host, IMidiOutput output) {
        super(host, output, 1, 1, 2);
    }

    @Override
    public void writeLine(int row, String text, String previousText) {
        for (int i = 0; i < 2; ++i) {
            int c = text.charAt(i);
            if (this.assignmentBuffer[i] == c) continue;
            int value = c >= 64 ? c - 64 : c;
            this.output.sendCC(75 - i, value);
            this.assignmentBuffer[i] = c;
        }
    }

    @Override
    public void shutdown() {
        this.writeLine(0, "  ", "");
    }
}

