/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.command.trigger;

import de.mossgrabers.controller.mackie.mcu.MCUConfiguration;
import de.mossgrabers.controller.mackie.mcu.command.trigger.MCUFlipCommand;
import de.mossgrabers.controller.mackie.mcu.command.trigger.MCUMoveTrackBankCommand;
import de.mossgrabers.controller.mackie.mcu.command.trigger.ModeSwitcher;
import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.framework.command.trigger.FootswitchCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class AssignableCommand
extends FootswitchCommand<MCUControlSurface, MCUConfiguration> {
    private final ModeSwitcher switcher;
    private final MCUFlipCommand flipCommand;
    private final MCUMoveTrackBankCommand previousTrackCommand;
    private final MCUMoveTrackBankCommand nextTrackCommand;

    public AssignableCommand(int index, IModel model, MCUControlSurface surface) {
        super(model, surface, index);
        this.switcher = new ModeSwitcher(surface);
        this.flipCommand = new MCUFlipCommand(model, surface);
        this.previousTrackCommand = new MCUMoveTrackBankCommand(this.model, surface, true, true);
        this.nextTrackCommand = new MCUMoveTrackBankCommand(this.model, surface, true, false);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        MCUConfiguration configuration = (MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration();
        switch (this.getSetting()) {
            case 15: {
                if (event != ButtonEvent.DOWN) break;
                this.switcher.scrollDown();
                break;
            }
            case 16: {
                if (event != ButtonEvent.DOWN) break;
                this.switcher.scrollUp();
                break;
            }
            case 17: {
                if (event != ButtonEvent.DOWN) {
                    return;
                }
                ModeManager modeManager = ((MCUControlSurface)this.surface).getModeManager();
                if (modeManager.isActive(new Modes[]{Modes.MARKERS})) {
                    modeManager.restore();
                } else {
                    modeManager.setActive(Modes.MARKERS);
                }
                IMode mode = (IMode)modeManager.getActive();
                if (mode == null) break;
                ((MCUControlSurface)this.surface).getDisplay().notify(mode.getName());
                break;
            }
            case 18: {
                this.flipCommand.executeNormal(event);
                break;
            }
            case 19: {
                if (event != ButtonEvent.DOWN) {
                    return;
                }
                configuration.toggleMotorFaders();
                this.mvHelper.delayDisplay(() -> "Motor Faders: " + (configuration.hasMotorFaders() ? "On" : "Off"));
                break;
            }
            case 20: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getTransport().togglePunchIn();
                break;
            }
            case 21: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getTransport().togglePunchOut();
                break;
            }
            case 22: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getCursorDevice().toggleEnabledState();
                break;
            }
            case 23: {
                this.previousTrackCommand.execute(event, velocity);
                break;
            }
            case 24: {
                this.nextTrackCommand.execute(event, velocity);
                break;
            }
            case 25: {
                if (event != ButtonEvent.DOWN) {
                    return;
                }
                String assignableActionID = configuration.getAssignableAction(this.index);
                if (assignableActionID == null) break;
                this.model.getApplication().invokeAction(assignableActionID);
                break;
            }
            default: {
                super.execute(event, velocity);
            }
        }
    }

    @Override
    protected int getSetting() {
        return ((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).getAssignable(this.index);
    }

    public boolean isActive() {
        switch (this.getSetting()) {
            case 0: {
                return this.model.getTransport().isPlaying();
            }
            case 1: {
                return this.model.getTransport().isRecording();
            }
            case 3: {
                return this.model.getTransport().isLauncherOverdub();
            }
            case 8: {
                return "ARRANGE".equals(this.model.getApplication().getPanelLayout());
            }
            case 9: {
                return "MIX".equals(this.model.getApplication().getPanelLayout());
            }
            case 10: {
                return "EDIT".equals(this.model.getApplication().getPanelLayout());
            }
            case 17: {
                return ((MCUControlSurface)this.surface).getModeManager().isActive(new Modes[]{Modes.MARKERS});
            }
            case 18: {
                return ((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).useFadersAsKnobs();
            }
            case 19: {
                return ((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).hasMotorFaders();
            }
            case 20: {
                return this.model.getTransport().isPunchInEnabled();
            }
            case 21: {
                return this.model.getTransport().isPunchOutEnabled();
            }
            case 22: {
                return this.model.getCursorDevice().isEnabled();
            }
        }
        return false;
    }
}

