/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu;

import de.mossgrabers.controller.mackie.mcu.controller.MCUDeviceType;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IActionSetting;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import java.util.Arrays;
import java.util.List;

public class MCUConfiguration
extends AbstractConfiguration {
    private static final String MCU_DEVICE_1_LEFT = "MCU Device 1 - left";
    public static final Integer ZOOM_STATE = 50;
    public static final Integer DISPLAY_MODE_TIME_OR_BEATS = 51;
    public static final Integer DISPLAY_MODE_TICKS_OR_TEMPO = 52;
    public static final Integer MAIN_DISPLAY = 53;
    public static final Integer SECOND_DISPLAY = 54;
    public static final Integer HAS_SEGMENT_DISPLAY = 55;
    public static final Integer HAS_ASSIGNMENT_DISPLAY = 56;
    public static final Integer HAS_MOTOR_FADERS = 57;
    public static final Integer HAS_ONLY_1_FADER = 58;
    public static final Integer DISPLAY_TRACK_NAMES = 59;
    public static final Integer USE_VERT_ZOOM_FOR_MODES = 60;
    public static final Integer USE_FADERS_AS_KNOBS = 61;
    public static final Integer TOUCH_SELECTS_CHANNEL = 62;
    public static final Integer TOUCH_CHANNEL_VOLUME_MODE = 63;
    public static final Integer ALWAYS_SEND_VU_METERS = 64;
    public static final Integer ICON_VU_METER = 65;
    public static final Integer PIN_FXTRACKS_TO_LAST_CONTROLLER = 66;
    public static final Integer X_TOUCH_DISPLAY_COLORS = 67;
    public static final int FOOTSWITCH_PREV_MODE = 15;
    public static final int FOOTSWITCH_NEXT_MODE = 16;
    public static final int FOOTSWITCH_SHOW_MARKER_MODE = 17;
    public static final int FOOTSWITCH_USE_FADERS_LIKE_EDIT_KNOBS = 18;
    public static final int FOOTSWITCH_TOGGLE_MOTOR_FADERS_ON_OFF = 19;
    public static final int FOOTSWITCH_PUNCH_IN = 20;
    public static final int FOOTSWITCH_PUNCH_OUT = 21;
    public static final int FOOTSWITCH_DEVICE_ON_OFF = 22;
    public static final int PREV_CHANNEL = 23;
    public static final int NEXT_CHANNEL = 24;
    public static final int FOOTSWITCH_ACTION = 25;
    private static final String CATEGORY_EXTENDER_SETUP = "Extender Setup (requires restart)";
    private static final String CATEGORY_SEGMENT_DISPLAY = "Segment Display";
    private static final String CATEGORY_TRACKS = "Tracks (requires restart)";
    private static final String CATEGORY_ASSIGNABLE_BUTTONS = "Assignable buttons";
    private static final String DEVICE_SELECT = "<Select a profile>";
    private static final String DEVICE_ASPARION_D700 = "Asparion D700";
    private static final String DEVICE_BEHRINGER_X_TOUCH = "Behringer X-Touch";
    private static final String DEVICE_BEHRINGER_X_TOUCH_ONE = "Behringer X-Touch One";
    private static final String DEVICE_ICON_PLATFORM_M = "iCON Platform M / M+";
    private static final String DEVICE_ICON_QCON_PRO_X = "iCON QConPro X";
    private static final String DEVICE_ICON_QCON_V1M = "iCON V1-M";
    private static final String DEVICE_MACKIE_MCU_PRO = "Mackie MCU Pro";
    private static final String DEVICE_ZOOM_R16 = "Zoom R16";
    private static final String[] DEVICE_OPTIONS = new String[]{"<Select a profile>", "Asparion D700", "Behringer X-Touch", "Behringer X-Touch One", "iCON Platform M / M+", "iCON QConPro X", "iCON V1-M", "Mackie MCU Pro", "Zoom R16"};
    private static final String[] ASSIGNABLE_VALUES = new String[]{"Toggle Play", "Toggle Record", "Stop All Clips", "Toggle Clip Overdub", "Undo", "Tap Tempo", "New Button", "Clip Based Looper", "Panel layout arrange", "Panel layout mix", "Panel layout edit", "Add instrument track", "Add audio track", "Add effect track", "Quantize", "Previous mode", "Next mode", "Marker mode", "Toggle use faders like editing knobs", "Toggle motor faders on/off", "Punch In", "Punch Out", "Device on/off", "Channel Prev", "Channel Next", "Action"};
    private static final String[] ASSIGNABLE_BUTTON_NAMES = new String[]{"Footswitch 1", "Footswitch 2", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8"};
    private static final int[] ASSIGNABLE_BUTTON_DEFAULTS = new int[]{0, 1, 11, 12, 13, 6, 14, 20, 21, 22};
    private static final String[] TIME_OR_BEATS_OPTIONS = new String[]{"Time", "Beats"};
    private static final String[] TEMPO_OR_TICKS_OPTIONS = new String[]{"Ticks", "Tempo"};
    private static final String[] MCU_DEVICE_TYPE_OPTIONS = new String[]{"Main", "Extender", "Mackie Extender"};
    private static final String[][] MCU_DEVICE_DESCRIPTORS = new String[][]{{"MCU Device 1"}, {"MCU Device 1 - left", "MCU Device 2 - right"}, {"MCU Device 1 - left", "MCU Device 2 - center", "MCU Device 3 - right"}, {"MCU Device 1 - left", "MCU Device 2", "MCU Device 3", "MCU Device 4 - right"}};
    private static final String[] MAIN_DISPLAY_OPTIONS = new String[]{"Off", "Asparion", "Mackie - 6 characters", "Mackie - 7 characters"};
    private static final String[] DISPLAY_COLORS_OPTIONS = new String[]{"Off", "Asparion", "Behringer", "iCON"};
    private static final String[] VU_METER_STYLES = new String[]{"Off", "Asparion", "iCON", "Mackie"};
    private static final String[] SECOND_DISPLAY_OPTIONS = new String[]{"Off", "Asparion", "iCON QCon Pro-X", "iCON V1-M"};
    private IEnumSetting zoomStateSetting;
    private IEnumSetting displayTimeSetting;
    private IEnumSetting tempoOrTicksSetting;
    private IEnumSetting displayTrackNamesSetting;
    private IEnumSetting useFadersAsKnobsSetting;
    private IEnumSetting vuMeterStyleSetting;
    private IEnumSetting hasMotorFadersSetting;
    private boolean zoomState;
    private boolean displayTime;
    private boolean displayTicks;
    private MainDisplay mainDisplay;
    private SecondDisplay secondDisplay;
    private boolean hasSegmentDisplay;
    private boolean hasAssignmentDisplay;
    private boolean hasMotorFaders;
    private boolean hasOnly1Fader;
    private boolean displayTrackNames;
    private boolean useVertZoomForModes;
    private boolean useFadersAsKnobs;
    private boolean alwaysSendVuMeters;
    private VUMeterStyle vuMeterStyle;
    private DisplayColors displayColors;
    private boolean touchSelectsChannel;
    private boolean touchChannelVolumeMode;
    private final int[] assignableFunctions = new int[ASSIGNABLE_BUTTON_NAMES.length];
    private final String[] assignableFunctionActions = new String[ASSIGNABLE_BUTTON_NAMES.length];
    private final MCUDeviceType[] deviceTyes;
    private boolean includeFXTracksInTrackBank;
    private boolean pinFXTracksToLastController;

    public MCUConfiguration(IHost host, IValueChanger valueChanger, int numMCUDevices, List<ArpeggiatorMode> arpeggiatorModes) {
        super(host, valueChanger, arpeggiatorModes);
        Arrays.fill(this.assignableFunctions, 0);
        Arrays.fill(this.assignableFunctionActions, "");
        this.deviceTyes = new MCUDeviceType[numMCUDevices];
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        this.activateHardwareSettings(globalSettings);
        this.activateExtenderSettings(globalSettings);
        this.activateSegmentDisplaySettings(globalSettings);
        this.activateTracksSettings(globalSettings);
        this.activateAssignableSettings(globalSettings);
        this.activateBehaviourOnStopSetting(globalSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateFlipRecordSetting(globalSettings);
        this.activateQuantizeAmountSetting(globalSettings);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
        this.activateZoomStateSetting(globalSettings);
        this.activateChannelTouchSetting(globalSettings);
        this.activateKnobSpeedSetting(globalSettings);
    }

    private void activateHardwareSettings(ISettingsUI settingsUI) {
        IEnumSetting profileSetting = settingsUI.getEnumSetting("Profile", "Hardware Setup", DEVICE_OPTIONS, DEVICE_OPTIONS[0]);
        IEnumSetting mainDisplaySetting = settingsUI.getEnumSetting("Main display", "Hardware Setup", MAIN_DISPLAY_OPTIONS, MAIN_DISPLAY_OPTIONS[2]);
        mainDisplaySetting.addValueObserver(value -> {
            this.mainDisplay = MAIN_DISPLAY_OPTIONS[1].equals(value) ? MainDisplay.ASPARION : (MAIN_DISPLAY_OPTIONS[2].equals(value) ? MainDisplay.MACKIE_6_CHARACTERS : (MAIN_DISPLAY_OPTIONS[3].equals(value) ? MainDisplay.MACKIE_7_CHARACTERS : MainDisplay.OFF));
            this.notifyObservers(MAIN_DISPLAY);
        });
        this.isSettingActive.add(MAIN_DISPLAY);
        IEnumSetting secondDisplaySetting = settingsUI.getEnumSetting("Has a second display", "Hardware Setup", SECOND_DISPLAY_OPTIONS, SECOND_DISPLAY_OPTIONS[0]);
        secondDisplaySetting.addValueObserver(value -> {
            this.secondDisplay = SECOND_DISPLAY_OPTIONS[1].equals(value) ? SecondDisplay.ASPARION : (SECOND_DISPLAY_OPTIONS[2].equals(value) ? SecondDisplay.QCON : (SECOND_DISPLAY_OPTIONS[3].equals(value) ? SecondDisplay.V1M : SecondDisplay.OFF));
            this.notifyObservers(SECOND_DISPLAY);
        });
        this.isSettingActive.add(SECOND_DISPLAY);
        IEnumSetting hasSegmentDisplaySetting = settingsUI.getEnumSetting("Has a segment display", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        hasSegmentDisplaySetting.addValueObserver(value -> {
            this.hasSegmentDisplay = "On".equals(value);
            this.notifyObservers(HAS_SEGMENT_DISPLAY);
        });
        this.isSettingActive.add(HAS_SEGMENT_DISPLAY);
        IEnumSetting hasAssignmentDisplaySetting = settingsUI.getEnumSetting("Has an assignment display", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        hasAssignmentDisplaySetting.addValueObserver(value -> {
            this.hasAssignmentDisplay = "On".equals(value);
            this.notifyObservers(HAS_ASSIGNMENT_DISPLAY);
        });
        this.isSettingActive.add(HAS_ASSIGNMENT_DISPLAY);
        this.hasMotorFadersSetting = settingsUI.getEnumSetting("Has motor faders", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        this.hasMotorFadersSetting.addValueObserver(value -> {
            this.hasMotorFaders = "On".equals(value);
            this.notifyObservers(HAS_MOTOR_FADERS);
        });
        this.isSettingActive.add(HAS_MOTOR_FADERS);
        IEnumSetting hasOnly1FaderSetting = settingsUI.getEnumSetting("Has only 1 fader", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        hasOnly1FaderSetting.addValueObserver(value -> {
            this.hasOnly1Fader = "On".equals(value);
            this.notifyObservers(HAS_ONLY_1_FADER);
        });
        this.isSettingActive.add(HAS_ONLY_1_FADER);
        this.displayTrackNamesSetting = settingsUI.getEnumSetting("Display track names in 1st display", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.displayTrackNamesSetting.addValueObserver(value -> {
            this.displayTrackNames = "On".equals(value);
            this.notifyObservers(DISPLAY_TRACK_NAMES);
        });
        this.isSettingActive.add(DISPLAY_TRACK_NAMES);
        IEnumSetting useVertZoomForModesSetting = settingsUI.getEnumSetting("Use vertical zoom to change modes", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        useVertZoomForModesSetting.addValueObserver(value -> {
            this.useVertZoomForModes = "On".equals(value);
            this.notifyObservers(USE_VERT_ZOOM_FOR_MODES);
        });
        this.isSettingActive.add(USE_VERT_ZOOM_FOR_MODES);
        this.useFadersAsKnobsSetting = settingsUI.getEnumSetting("Use faders like editing knobs", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.useFadersAsKnobsSetting.addValueObserver(value -> {
            this.useFadersAsKnobs = "On".equals(value);
            this.notifyObservers(USE_FADERS_AS_KNOBS);
        });
        this.isSettingActive.add(USE_FADERS_AS_KNOBS);
        this.vuMeterStyleSetting = settingsUI.getEnumSetting("VU Meters", "Hardware Setup", VU_METER_STYLES, VU_METER_STYLES[0]);
        this.vuMeterStyleSetting.addValueObserver(value -> {
            this.vuMeterStyle = VU_METER_STYLES[1].equals(value) ? VUMeterStyle.ASPARION : (VU_METER_STYLES[2].equals(value) ? VUMeterStyle.ICON : (VU_METER_STYLES[3].equals(value) ? VUMeterStyle.MACKIE : VUMeterStyle.OFF));
            this.notifyObservers(ENABLE_VU_METERS);
        });
        this.isSettingActive.add(ENABLE_VU_METERS);
        IEnumSetting alwaysSendVuMetersSetting = settingsUI.getEnumSetting("Always send VU Meters", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        alwaysSendVuMetersSetting.addValueObserver(value -> {
            this.alwaysSendVuMeters = "On".equals(value);
            this.notifyObservers(ALWAYS_SEND_VU_METERS);
        });
        this.isSettingActive.add(ALWAYS_SEND_VU_METERS);
        IEnumSetting displayColorsSetting = settingsUI.getEnumSetting("Display colors", "Hardware Setup", DISPLAY_COLORS_OPTIONS, DISPLAY_COLORS_OPTIONS[0]);
        displayColorsSetting.addValueObserver(value -> {
            this.displayColors = DISPLAY_COLORS_OPTIONS[1].equals(value) ? DisplayColors.ASPARION : (DISPLAY_COLORS_OPTIONS[2].equals(value) ? DisplayColors.BEHRINGER : (DISPLAY_COLORS_OPTIONS[3].equals(value) ? DisplayColors.ICON : DisplayColors.OFF));
            this.notifyObservers(X_TOUCH_DISPLAY_COLORS);
        });
        this.isSettingActive.add(X_TOUCH_DISPLAY_COLORS);
        profileSetting.addValueObserver(value -> {
            String on = ON_OFF_OPTIONS[1];
            String off = ON_OFF_OPTIONS[0];
            switch (value) {
                case "Mackie MCU Pro": {
                    mainDisplaySetting.set(MAIN_DISPLAY_OPTIONS[2]);
                    secondDisplaySetting.set(SECOND_DISPLAY_OPTIONS[0]);
                    hasSegmentDisplaySetting.set(on);
                    hasAssignmentDisplaySetting.set(on);
                    this.hasMotorFadersSetting.set(on);
                    hasOnly1FaderSetting.set(off);
                    this.displayTrackNamesSetting.set(on);
                    useVertZoomForModesSetting.set(off);
                    this.useFadersAsKnobsSetting.set(off);
                    alwaysSendVuMetersSetting.set(off);
                    this.vuMeterStyleSetting.set(VU_METER_STYLES[3]);
                    displayColorsSetting.set(DISPLAY_COLORS_OPTIONS[0]);
                    break;
                }
                case "Asparion D700": {
                    mainDisplaySetting.set(MAIN_DISPLAY_OPTIONS[1]);
                    secondDisplaySetting.set(SECOND_DISPLAY_OPTIONS[1]);
                    hasSegmentDisplaySetting.set(off);
                    hasAssignmentDisplaySetting.set(off);
                    this.hasMotorFadersSetting.set(on);
                    hasOnly1FaderSetting.set(off);
                    this.displayTrackNamesSetting.set(on);
                    useVertZoomForModesSetting.set(off);
                    this.useFadersAsKnobsSetting.set(off);
                    alwaysSendVuMetersSetting.set(off);
                    this.vuMeterStyleSetting.set(VU_METER_STYLES[1]);
                    displayColorsSetting.set(DISPLAY_COLORS_OPTIONS[1]);
                    break;
                }
                case "Behringer X-Touch": {
                    mainDisplaySetting.set(MAIN_DISPLAY_OPTIONS[3]);
                    secondDisplaySetting.set(SECOND_DISPLAY_OPTIONS[0]);
                    hasSegmentDisplaySetting.set(on);
                    hasAssignmentDisplaySetting.set(on);
                    this.hasMotorFadersSetting.set(on);
                    hasOnly1FaderSetting.set(off);
                    this.displayTrackNamesSetting.set(on);
                    useVertZoomForModesSetting.set(off);
                    this.useFadersAsKnobsSetting.set(off);
                    alwaysSendVuMetersSetting.set(off);
                    this.vuMeterStyleSetting.set(VU_METER_STYLES[3]);
                    displayColorsSetting.set(DISPLAY_COLORS_OPTIONS[2]);
                    break;
                }
                case "Behringer X-Touch One": {
                    mainDisplaySetting.set(MAIN_DISPLAY_OPTIONS[3]);
                    secondDisplaySetting.set(SECOND_DISPLAY_OPTIONS[0]);
                    hasSegmentDisplaySetting.set(on);
                    hasAssignmentDisplaySetting.set(on);
                    this.hasMotorFadersSetting.set(on);
                    hasOnly1FaderSetting.set(on);
                    this.displayTrackNamesSetting.set(on);
                    useVertZoomForModesSetting.set(off);
                    this.useFadersAsKnobsSetting.set(off);
                    alwaysSendVuMetersSetting.set(off);
                    this.vuMeterStyleSetting.set(VU_METER_STYLES[3]);
                    displayColorsSetting.set(DISPLAY_COLORS_OPTIONS[0]);
                    break;
                }
                case "iCON Platform M / M+": {
                    mainDisplaySetting.set(MAIN_DISPLAY_OPTIONS[0]);
                    secondDisplaySetting.set(SECOND_DISPLAY_OPTIONS[0]);
                    hasSegmentDisplaySetting.set(off);
                    hasAssignmentDisplaySetting.set(off);
                    this.hasMotorFadersSetting.set(on);
                    hasOnly1FaderSetting.set(off);
                    this.displayTrackNamesSetting.set(off);
                    useVertZoomForModesSetting.set(on);
                    this.useFadersAsKnobsSetting.set(off);
                    alwaysSendVuMetersSetting.set(off);
                    this.vuMeterStyleSetting.set(VU_METER_STYLES[0]);
                    displayColorsSetting.set(DISPLAY_COLORS_OPTIONS[0]);
                    break;
                }
                case "iCON QConPro X": {
                    mainDisplaySetting.set(MAIN_DISPLAY_OPTIONS[2]);
                    secondDisplaySetting.set(SECOND_DISPLAY_OPTIONS[2]);
                    hasSegmentDisplaySetting.set(on);
                    hasAssignmentDisplaySetting.set(off);
                    this.hasMotorFadersSetting.set(on);
                    hasOnly1FaderSetting.set(off);
                    this.displayTrackNamesSetting.set(off);
                    useVertZoomForModesSetting.set(off);
                    this.useFadersAsKnobsSetting.set(off);
                    alwaysSendVuMetersSetting.set(off);
                    this.vuMeterStyleSetting.set(VU_METER_STYLES[2]);
                    displayColorsSetting.set(DISPLAY_COLORS_OPTIONS[0]);
                    break;
                }
                case "iCON V1-M": {
                    mainDisplaySetting.set(MAIN_DISPLAY_OPTIONS[3]);
                    secondDisplaySetting.set(SECOND_DISPLAY_OPTIONS[3]);
                    hasSegmentDisplaySetting.set(on);
                    hasAssignmentDisplaySetting.set(off);
                    this.hasMotorFadersSetting.set(on);
                    hasOnly1FaderSetting.set(off);
                    this.displayTrackNamesSetting.set(off);
                    useVertZoomForModesSetting.set(off);
                    this.useFadersAsKnobsSetting.set(off);
                    alwaysSendVuMetersSetting.set(off);
                    this.vuMeterStyleSetting.set(VU_METER_STYLES[2]);
                    displayColorsSetting.set(DISPLAY_COLORS_OPTIONS[3]);
                    break;
                }
                case "Zoom R16": {
                    mainDisplaySetting.set(MAIN_DISPLAY_OPTIONS[0]);
                    secondDisplaySetting.set(SECOND_DISPLAY_OPTIONS[0]);
                    hasSegmentDisplaySetting.set(off);
                    hasAssignmentDisplaySetting.set(off);
                    this.hasMotorFadersSetting.set(off);
                    hasOnly1FaderSetting.set(off);
                    this.displayTrackNamesSetting.set(off);
                    useVertZoomForModesSetting.set(off);
                    this.useFadersAsKnobsSetting.set(on);
                    alwaysSendVuMetersSetting.set(off);
                    this.vuMeterStyleSetting.set(VU_METER_STYLES[0]);
                    displayColorsSetting.set(DISPLAY_COLORS_OPTIONS[0]);
                    break;
                }
                default: {
                    return;
                }
            }
            profileSetting.set(DEVICE_SELECT);
        });
    }

    private void activateExtenderSettings(ISettingsUI settingsUI) {
        for (int i = 0; i < this.deviceTyes.length; ++i) {
            String label = MCU_DEVICE_DESCRIPTORS[this.deviceTyes.length - 1][i];
            IEnumSetting setting = settingsUI.getEnumSetting(label, CATEGORY_EXTENDER_SETUP, MCU_DEVICE_TYPE_OPTIONS, MCU_DEVICE_TYPE_OPTIONS[i == this.deviceTyes.length - 1 ? 0 : 1]);
            String value = (String)setting.get();
            if (MCU_DEVICE_TYPE_OPTIONS[0].equals(value)) {
                this.deviceTyes[i] = MCUDeviceType.MAIN;
                continue;
            }
            if (MCU_DEVICE_TYPE_OPTIONS[1].equals(value)) {
                this.deviceTyes[i] = MCUDeviceType.EXTENDER;
                continue;
            }
            if (!MCU_DEVICE_TYPE_OPTIONS[2].equals(value)) continue;
            this.deviceTyes[i] = MCUDeviceType.MACKIE_EXTENDER;
        }
    }

    private void activateSegmentDisplaySettings(ISettingsUI settingsUI) {
        this.displayTimeSetting = settingsUI.getEnumSetting("Display time or beats", CATEGORY_SEGMENT_DISPLAY, TIME_OR_BEATS_OPTIONS, TIME_OR_BEATS_OPTIONS[0]);
        this.displayTimeSetting.addValueObserver(value -> {
            this.displayTime = TIME_OR_BEATS_OPTIONS[0].equals(value);
            this.notifyObservers(DISPLAY_MODE_TIME_OR_BEATS);
        });
        this.isSettingActive.add(DISPLAY_MODE_TIME_OR_BEATS);
        this.tempoOrTicksSetting = settingsUI.getEnumSetting("Display tempo or ticks/milliseconds", CATEGORY_SEGMENT_DISPLAY, TEMPO_OR_TICKS_OPTIONS, TEMPO_OR_TICKS_OPTIONS[0]);
        this.tempoOrTicksSetting.addValueObserver(value -> {
            this.displayTicks = TEMPO_OR_TICKS_OPTIONS[0].equals(value);
            this.notifyObservers(DISPLAY_MODE_TICKS_OR_TEMPO);
        });
        this.isSettingActive.add(DISPLAY_MODE_TICKS_OR_TEMPO);
    }

    private void activateTracksSettings(ISettingsUI settingsUI) {
        this.activateTrackNavigationSetting(settingsUI, CATEGORY_TRACKS, true);
        IEnumSetting includeFXTracksSetting = settingsUI.getEnumSetting("Include FX and master tracks in track bank", CATEGORY_TRACKS, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.includeFXTracksInTrackBank = "On".equals(includeFXTracksSetting.get());
        if (this.deviceTyes.length > 1 && this.host.supports(Capability.HAS_EFFECT_BANK)) {
            IEnumSetting pinFXTracksToLastControllerSetting = settingsUI.getEnumSetting("Pin FX tracks to last device", CATEGORY_TRACKS, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
            pinFXTracksToLastControllerSetting.addValueObserver(value -> {
                this.pinFXTracksToLastController = "On".equals(value);
                this.notifyObservers(PIN_FXTRACKS_TO_LAST_CONTROLLER);
            });
            this.isSettingActive.add(PIN_FXTRACKS_TO_LAST_CONTROLLER);
        }
    }

    private void activateAssignableSettings(ISettingsUI settingsUI) {
        for (int i = 0; i < this.assignableFunctions.length; ++i) {
            int pos = i;
            IEnumSetting assignableSetting = settingsUI.getEnumSetting(ASSIGNABLE_BUTTON_NAMES[i], CATEGORY_ASSIGNABLE_BUTTONS, ASSIGNABLE_VALUES, ASSIGNABLE_VALUES[ASSIGNABLE_BUTTON_DEFAULTS[i]]);
            assignableSetting.addValueObserver(value -> {
                this.assignableFunctions[pos] = MCUConfiguration.lookupIndex(ASSIGNABLE_VALUES, value);
            });
            IActionSetting actionSetting = settingsUI.getActionSetting(ASSIGNABLE_BUTTON_NAMES[i] + " - Action", CATEGORY_ASSIGNABLE_BUTTONS);
            actionSetting.addValueObserver(value -> {
                this.assignableFunctionActions[pos] = (String)actionSetting.get();
            });
        }
    }

    protected void activateZoomStateSetting(ISettingsUI settingsUI) {
        this.zoomStateSetting = settingsUI.getEnumSetting("Zoom", "Workflow", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.zoomStateSetting.addValueObserver(value -> {
            this.zoomState = "On".equals(value);
            this.notifyObservers(ZOOM_STATE);
        });
        this.isSettingActive.add(ZOOM_STATE);
    }

    protected void activateChannelTouchSetting(ISettingsUI settingsUI) {
        IEnumSetting touchSelectsChannelSetting = settingsUI.getEnumSetting("Select Channel on Fader Touch", "Workflow", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        touchSelectsChannelSetting.addValueObserver(value -> {
            this.touchSelectsChannel = "On".equals(value);
            this.notifyObservers(TOUCH_SELECTS_CHANNEL);
        });
        this.isSettingActive.add(TOUCH_SELECTS_CHANNEL);
        IEnumSetting touchChannelVolumeModeSetting = settingsUI.getEnumSetting("Activate Volume mode on Fader Touch", "Workflow", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        touchChannelVolumeModeSetting.addValueObserver(value -> {
            this.touchChannelVolumeMode = "On".equals(value);
            this.notifyObservers(TOUCH_CHANNEL_VOLUME_MODE);
        });
        this.isSettingActive.add(TOUCH_CHANNEL_VOLUME_MODE);
    }

    public boolean isZoomState() {
        return this.zoomState;
    }

    public void toggleZoomState() {
        this.zoomStateSetting.set(this.zoomState ? ON_OFF_OPTIONS[0] : ON_OFF_OPTIONS[1]);
    }

    public boolean isDisplayTime() {
        return this.displayTime;
    }

    public void toggleDisplayTime() {
        this.displayTimeSetting.set(this.displayTime ? TIME_OR_BEATS_OPTIONS[1] : TIME_OR_BEATS_OPTIONS[0]);
    }

    public boolean isDisplayTicks() {
        return this.displayTicks;
    }

    public void toggleDisplayTicks() {
        this.tempoOrTicksSetting.set(this.displayTicks ? TEMPO_OR_TICKS_OPTIONS[1] : TEMPO_OR_TICKS_OPTIONS[0]);
    }

    public MainDisplay getMainDisplayType() {
        return this.mainDisplay;
    }

    public SecondDisplay getSecondDisplayType() {
        return this.secondDisplay;
    }

    public boolean hasSegmentDisplay() {
        return this.hasSegmentDisplay;
    }

    public boolean hasAssignmentDisplay() {
        return this.hasAssignmentDisplay;
    }

    public boolean hasMotorFaders() {
        return this.hasMotorFaders;
    }

    public void toggleMotorFaders() {
        this.hasMotorFadersSetting.set(ON_OFF_OPTIONS[this.hasMotorFaders ? 0 : 1]);
    }

    public boolean hasOnly1Fader() {
        return this.hasOnly1Fader;
    }

    public boolean isDisplayTrackNames() {
        return this.displayTrackNames;
    }

    public void toggleDisplayTrackNames() {
        this.displayTrackNamesSetting.set(ON_OFF_OPTIONS[this.displayTrackNames ? 0 : 1]);
    }

    public boolean useVertZoomForModes() {
        return this.useVertZoomForModes;
    }

    public boolean alwaysSendVuMeters() {
        return this.alwaysSendVuMeters;
    }

    @Override
    public boolean isEnableVUMeters() {
        return this.vuMeterStyle != VUMeterStyle.OFF;
    }

    public VUMeterStyle getVuMeterStyle() {
        return this.vuMeterStyle;
    }

    public DisplayColors hasDisplayColors() {
        return this.displayColors;
    }

    public boolean useFadersAsKnobs() {
        return this.useFadersAsKnobs;
    }

    public void toggleUseFadersAsKnobs() {
        this.useFadersAsKnobsSetting.set(ON_OFF_OPTIONS[this.useFadersAsKnobs ? 0 : 1]);
    }

    public int getAssignable(int index) {
        return this.assignableFunctions[index];
    }

    public String getAssignableAction(int index) {
        return this.assignableFunctionActions[index];
    }

    public boolean isTouchSelectsChannel() {
        return this.touchSelectsChannel;
    }

    public boolean isTouchChannelVolumeMode() {
        return this.touchChannelVolumeMode;
    }

    public boolean shouldIncludeFXTracksInTrackBank() {
        return this.includeFXTracksInTrackBank;
    }

    public boolean shouldPinFXTracksToLastController() {
        return this.pinFXTracksToLastController;
    }

    public MCUDeviceType getDeviceType(int index) {
        return this.deviceTyes[index];
    }

    public int getNumMCUDevices() {
        return this.deviceTyes.length;
    }

    public static enum MainDisplay {
        OFF,
        ASPARION,
        MACKIE_6_CHARACTERS,
        MACKIE_7_CHARACTERS;

    }

    public static enum SecondDisplay {
        OFF,
        ASPARION,
        QCON,
        V1M;

    }

    public static enum VUMeterStyle {
        OFF,
        ASPARION,
        ICON,
        MACKIE;

    }

    public static enum DisplayColors {
        OFF,
        ASPARION,
        BEHRINGER,
        ICON;

    }
}

