/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.hui.mode.track;

import de.mossgrabers.controller.mackie.hui.HUIConfiguration;
import de.mossgrabers.controller.mackie.hui.controller.HUIControlSurface;
import de.mossgrabers.controller.mackie.hui.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import java.util.Optional;

public class PanMode
extends AbstractTrackMode {
    public PanMode(HUIControlSurface surface, IModel model) {
        super("Panorama", surface, model);
    }

    @Override
    public void onKnobValue(int index, int value) {
        Optional<ITrack> track = this.getTrack(index);
        if (track.isPresent()) {
            track.get().changePan(value);
        }
    }

    @Override
    public void updateDisplay() {
        if (((HUIConfiguration)((HUIControlSurface)this.surface).getConfiguration()).hasDisplay1()) {
            this.drawTrackHeader().setCell(0, 8, "Pans").done(0);
        }
    }

    @Override
    public void updateKnobLEDs() {
        int upperBound = this.model.getValueChanger().getUpperBound();
        for (int i = 0; i < 8; ++i) {
            Optional<ITrack> t = this.getTrack(i);
            if (t.isPresent()) {
                ((HUIControlSurface)this.surface).setKnobLED(i, 1, Math.max(t.get().getPan(), 1), upperBound);
                continue;
            }
            ((HUIControlSurface)this.surface).setKnobLED(i, -1, 0, 0);
        }
    }

    @Override
    public void resetParameter(int index) {
        Optional<ITrack> track = this.getTrack(index);
        if (track.isPresent()) {
            track.get().resetPan();
        }
    }
}

