/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.hui;

import de.mossgrabers.controller.mackie.hui.HUIConfiguration;
import de.mossgrabers.controller.mackie.hui.command.trigger.AssignableCommand;
import de.mossgrabers.controller.mackie.hui.command.trigger.FaderTouchCommand;
import de.mossgrabers.controller.mackie.hui.command.trigger.WorkaroundFader;
import de.mossgrabers.controller.mackie.hui.command.trigger.WorkaroundMasterFader;
import de.mossgrabers.controller.mackie.hui.command.trigger.ZoomAndKeysCursorCommand;
import de.mossgrabers.controller.mackie.hui.command.trigger.ZoomCommand;
import de.mossgrabers.controller.mackie.hui.controller.HUIControlSurface;
import de.mossgrabers.controller.mackie.hui.controller.HUIDisplay;
import de.mossgrabers.controller.mackie.hui.controller.HUISegmentDisplay;
import de.mossgrabers.controller.mackie.hui.mode.HUIMode;
import de.mossgrabers.controller.mackie.hui.mode.device.DeviceParamsMode;
import de.mossgrabers.controller.mackie.hui.mode.track.PanMode;
import de.mossgrabers.controller.mackie.hui.mode.track.SendMode;
import de.mossgrabers.controller.mackie.hui.mode.track.TrackMode;
import de.mossgrabers.controller.mackie.hui.mode.track.VolumeMode;
import de.mossgrabers.framework.command.continuous.JogWheelCommand;
import de.mossgrabers.framework.command.continuous.KnobRowModeCommand;
import de.mossgrabers.framework.command.core.NopCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.command.trigger.ShiftCommand;
import de.mossgrabers.framework.command.trigger.application.PaneCommand;
import de.mossgrabers.framework.command.trigger.application.PanelLayoutCommand;
import de.mossgrabers.framework.command.trigger.application.SaveCommand;
import de.mossgrabers.framework.command.trigger.application.UndoCommand;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.command.trigger.device.AddEffectCommand;
import de.mossgrabers.framework.command.trigger.mode.ButtonRowModeCommand;
import de.mossgrabers.framework.command.trigger.mode.ModeCursorCommand;
import de.mossgrabers.framework.command.trigger.mode.ModeSelectCommand;
import de.mossgrabers.framework.command.trigger.track.AddTrackCommand;
import de.mossgrabers.framework.command.trigger.track.MuteCommand;
import de.mossgrabers.framework.command.trigger.track.RecArmAllCommand;
import de.mossgrabers.framework.command.trigger.track.RecArmCommand;
import de.mossgrabers.framework.command.trigger.track.SelectCommand;
import de.mossgrabers.framework.command.trigger.track.SoloCommand;
import de.mossgrabers.framework.command.trigger.transport.AutomationModeCommand;
import de.mossgrabers.framework.command.trigger.transport.MetronomeCommand;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.command.trigger.transport.PunchInCommand;
import de.mossgrabers.framework.command.trigger.transport.PunchOutCommand;
import de.mossgrabers.framework.command.trigger.transport.RecordCommand;
import de.mossgrabers.framework.command.trigger.transport.StopCommand;
import de.mossgrabers.framework.command.trigger.transport.TapTempoCommand;
import de.mossgrabers.framework.command.trigger.transport.ToggleLoopCommand;
import de.mossgrabers.framework.command.trigger.transport.WindCommand;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.controller.hardware.IHwFader;
import de.mossgrabers.framework.controller.hardware.IHwRelativeKnob;
import de.mossgrabers.framework.controller.valuechanger.TwosComplementValueChanger;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.constants.AutomationMode;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.ControlOnlyView;
import de.mossgrabers.framework.view.Views;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;

public class HUIControllerSetup
extends AbstractControllerSetup<HUIControlSurface, HUIConfiguration> {
    public static final int HUI_BUTTON_STATE_ON = 127;
    public static final int HUI_BUTTON_STATE_OFF = 0;
    private final int numHUIDevices;

    public HUIControllerSetup(IHost host, ISetupFactory factory, ISettingsUI globalSettings, ISettingsUI documentSettings, int numHUIDevices) {
        super(factory, host, globalSettings, documentSettings);
        this.numHUIDevices = numHUIDevices;
        this.colorManager = new ColorManager();
        this.colorManager.registerColor(0, ColorEx.BLACK);
        this.colorManager.registerColor(127, ColorEx.RED);
        this.colorManager.registerColorIndex("BUTTON_COLOR_OFF", 0);
        this.colorManager.registerColorIndex("BUTTON_COLOR_ON", 127);
        this.valueChanger = new TwosComplementValueChanger(16384, 100);
        this.configuration = new HUIConfiguration(host, this.valueChanger, factory.getArpeggiatorModes());
    }

    @Override
    public void flush() {
        super.flush();
        this.surfaces.forEach(surface -> {
            this.updateMode((HUIControlSurface)surface, (Modes)((Object)((Object)surface.getModeManager().getActiveID())));
            this.updateSegmentDisplay((HUIControlSurface)surface);
        });
        this.updateVUandFaders();
    }

    @Override
    protected void createModel() {
        ModelSetup ms = new ModelSetup();
        ms.enableMainDrumDevice(false);
        ms.enableDevice(DeviceID.EQ);
        ms.setHasFullFlatTrackList(true);
        ms.setNumTracks(8 * this.numHUIDevices);
        ms.setNumSends(6);
        ms.setNumScenes(0);
        ms.setNumFilterColumnEntries(8);
        ms.setNumResults(8);
        ms.setNumDeviceLayers(0);
        ms.setNumDrumPadLayers(0);
        ms.setNumScenes(8);
        ms.setNumMarkers(8 * this.numHUIDevices);
        this.model = this.factory.createModel(this.configuration, this.colorManager, this.valueChanger, this.scales, ms);
        this.model.getTrackBank().setIndication(true);
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        for (int i = 0; i < this.numHUIDevices; ++i) {
            IMidiOutput output = midiAccess.createOutput(i);
            IMidiInput input = midiAccess.createInput(i, null, new String[0]);
            HUIControlSurface surface = new HUIControlSurface(this.surfaces, this.host, this.colorManager, (HUIConfiguration)this.configuration, output, input, this.model, 8 * i);
            this.surfaces.add(surface);
            surface.addTextDisplay(new HUIDisplay(this.host, output));
            surface.addTextDisplay(new HUISegmentDisplay(this.host, output));
            surface.getModeManager().setDefaultID(Modes.VOLUME);
        }
    }

    @Override
    protected void createModes() {
        for (int index = 0; index < this.numHUIDevices; ++index) {
            HUIControlSurface surface = (HUIControlSurface)this.getSurface(index);
            ModeManager modeManager = surface.getModeManager();
            modeManager.register(Modes.TRACK, new TrackMode(surface, this.model));
            modeManager.register(Modes.VOLUME, new VolumeMode(surface, this.model));
            modeManager.register(Modes.PAN, new PanMode(surface, this.model));
            for (int i = 0; i < 5; ++i) {
                modeManager.register(Modes.get(Modes.SEND1, i), new SendMode(i, surface, this.model));
            }
            modeManager.register(Modes.DEVICE_PARAMS, new DeviceParamsMode(surface, this.model));
            modeManager.register(Modes.EQ_DEVICE_PARAMS, new DeviceParamsMode("Equalizer", this.model.getSpecificDevice(DeviceID.EQ), surface, this.model));
        }
    }

    @Override
    protected void createViews() {
        for (int index = 0; index < this.numHUIDevices; ++index) {
            HUIControlSurface surface = (HUIControlSurface)this.getSurface(index);
            surface.getViewManager().register(Views.CONTROL, new ControlOnlyView(surface, this.model));
        }
    }

    @Override
    protected void createObservers() {
        super.createObservers();
        for (int i = 0; i < this.numHUIDevices; ++i) {
            HUIControlSurface surface = (HUIControlSurface)this.getSurface(i);
            ModeManager mm = surface.getModeManager();
            for (int j = 0; j < this.numHUIDevices; ++j) {
                if (i == j) continue;
                ((HUIControlSurface)this.getSurface(j)).getModeManager().addConnectedManagerListener(mm);
            }
            mm.addChangeListener((oldMode, newMode) -> this.updateMode(surface, (Modes)newMode));
            ((HUIConfiguration)this.configuration).addSettingObserver(AbstractConfiguration.ENABLE_VU_METERS, () -> {
                IMode activeMode = (IMode)surface.getModeManager().getActive();
                if (activeMode != null) {
                    activeMode.updateDisplay();
                }
                ((HUIDisplay)surface.getDisplay()).forceFlush();
            });
        }
        ((HUIConfiguration)this.configuration).registerDeactivatedItemsHandler(this.model);
    }

    @Override
    protected void registerTriggerCommands() {
        for (int index = 0; index < this.numHUIDevices; ++index) {
            HUIControlSurface surface = (HUIControlSurface)this.getSurface(index);
            ModeManager modeManager = surface.getModeManager();
            ITransport t = this.model.getTransport();
            IApplication application = this.model.getApplication();
            for (int channel = 0; channel < 8; ++channel) {
                int channelIdx = index * 8 + channel;
                this.addButtonHUI(surface, ButtonID.get(ButtonID.FADER_TOUCH_1, channel), "Fader " + (channel + 1), new FaderTouchCommand(channelIdx, this.model, surface), 0 + channel * 8);
                ButtonID selectButtonID = ButtonID.get(ButtonID.ROW_SELECT_1, channel);
                this.addButtonHUI(surface, selectButtonID, "Select " + (channel + 1), new SelectCommand(channelIdx, this.model, surface), 1 + channel * 8, () -> this.getButtonColor(surface, selectButtonID));
                ButtonRowModeCommand knobPressCommand = new ButtonRowModeCommand(0, channel, this.model, surface);
                this.addButtonHUI(surface, ButtonID.get(ButtonID.ROW1_1, channel), "VSelect " + (channel + 1), knobPressCommand, 5 + channel * 8);
                ButtonID recArmButtonID = ButtonID.get(ButtonID.ROW2_1, channel);
                this.addButtonHUI(surface, recArmButtonID, "Arm " + (channel + 1), new RecArmCommand(channelIdx, this.model, surface), 7 + channel * 8, () -> this.getButtonColor(surface, recArmButtonID));
                ButtonID soloButtonID = ButtonID.get(ButtonID.ROW3_1, channel);
                this.addButtonHUI(surface, soloButtonID, "Solo " + (channel + 1), new SoloCommand(channelIdx, this.model, surface), 3 + channel * 8, () -> this.getButtonColor(surface, soloButtonID));
                ButtonID muteButtonID = ButtonID.get(ButtonID.ROW4_1, channel);
                this.addButtonHUI(surface, muteButtonID, "Mute " + (channel + 1), new MuteCommand(channelIdx, this.model, surface), 2 + channel * 8, () -> this.getButtonColor(surface, muteButtonID));
                ButtonID insertButtonID = ButtonID.get(ButtonID.ROW5_1, channel);
                this.addButtonHUI(surface, insertButtonID, "Insert " + (channel + 1), new SelectCommand(channelIdx, this.model, surface), 6 + channel * 8, () -> this.getButtonColor(surface, insertButtonID));
                ButtonID autoArmButtonID = ButtonID.get(ButtonID.ROW6_1, channel);
                this.addButtonHUI(surface, autoArmButtonID, "Auto " + (channel + 1), knobPressCommand, 4 + channel * 8);
            }
            this.addButtonHUI(surface, ButtonID.CONTROL, "Control", NopCommand.INSTANCE, 64);
            this.addButtonHUI(surface, ButtonID.SHIFT, "Shift", new ShiftCommand(this.model, surface), 65);
            this.addButtonHUI(surface, ButtonID.UNDO, "Undo", new UndoCommand(this.model, surface), 67);
            this.addButtonHUI(surface, ButtonID.ALT, "Alt", NopCommand.INSTANCE, 68);
            this.addButtonHUI(surface, ButtonID.SELECT, "Select", NopCommand.INSTANCE, 69);
            this.addButtonHUI(surface, ButtonID.SAVE, "Save", new SaveCommand(this.model, surface), 71);
            this.addButtonHUI(surface, ButtonID.MIXER, "Mixer", new PaneCommand(PaneCommand.Panels.MIXER, this.model, surface), 72);
            this.addButtonHUI(surface, ButtonID.NOTE_EDITOR, "Note", new PaneCommand(PaneCommand.Panels.NOTE, this.model, surface), 73);
            this.addButtonHUI(surface, ButtonID.AUTOMATION_EDITOR, "Automation", new PaneCommand(PaneCommand.Panels.AUTOMATION, this.model, surface), 74);
            this.addButtonHUI(surface, ButtonID.TOGGLE_DEVICE, "Device", new PanelLayoutCommand(this.model, surface), 76);
            this.addButtonHUI(surface, ButtonID.MOVE_TRACK_LEFT, "Channel Left", new ModeCursorCommand(Direction.LEFT, this.model, surface), 80);
            this.addButtonHUI(surface, ButtonID.MOVE_BANK_LEFT, "Bank Left", new ModeCursorCommand(Direction.DOWN, this.model, surface), 81);
            this.addButtonHUI(surface, ButtonID.MOVE_TRACK_RIGHT, "Channel Right", new ModeCursorCommand(Direction.RIGHT, this.model, surface), 82);
            this.addButtonHUI(surface, ButtonID.MOVE_BANK_RIGHT, "Bank Right", new ModeCursorCommand(Direction.UP, this.model, surface), 83);
            this.addButtonHUI(surface, ButtonID.TRACK, "Track", new ModeSelectCommand(this.model, surface, Modes.TRACK), 89, () -> modeManager.isActive(new Modes[]{Modes.TRACK}));
            this.addButtonHUI(surface, ButtonID.PAN_SEND, "Panorama", new ModeSelectCommand(this.model, surface, Modes.PAN), 90, () -> modeManager.isActive(new Modes[]{Modes.PAN}));
            this.addButtonHUI(surface, ButtonID.SEND1, "Send 1", new ModeSelectCommand(this.model, surface, Modes.SEND1), 95, () -> modeManager.isActive(new Modes[]{Modes.SEND1}));
            this.addButtonHUI(surface, ButtonID.SEND2, "Send 2", new ModeSelectCommand(this.model, surface, Modes.SEND2), 94, () -> modeManager.isActive(new Modes[]{Modes.SEND2}));
            this.addButtonHUI(surface, ButtonID.SEND3, "Send 3", new ModeSelectCommand(this.model, surface, Modes.SEND3), 93, () -> modeManager.isActive(new Modes[]{Modes.SEND3}));
            this.addButtonHUI(surface, ButtonID.SEND4, "Send 4", new ModeSelectCommand(this.model, surface, Modes.SEND4), 92, () -> modeManager.isActive(new Modes[]{Modes.SEND4}));
            this.addButtonHUI(surface, ButtonID.SEND5, "Send 5", new ModeSelectCommand(this.model, surface, Modes.SEND5), 91, () -> modeManager.isActive(new Modes[]{Modes.SEND5}));
            this.addButtonHUI(surface, ButtonID.PAGE_LEFT, "EQ", new ModeSelectCommand(this.model, surface, Modes.EQ_DEVICE_PARAMS), 88, () -> modeManager.isActive(new Modes[]{Modes.EQ_DEVICE_PARAMS}));
            this.addButtonHUI(surface, ButtonID.DEVICE, "Device", new ModeSelectCommand(this.model, surface, Modes.DEVICE_PARAMS), 101, () -> modeManager.isActive(new Modes[]{Modes.DEVICE_PARAMS}));
            this.addButtonHUI(surface, ButtonID.REC_ARM_ALL, "RecRdyAll", new RecArmAllCommand(this.model, surface), 102);
            this.addButtonHUI(surface, ButtonID.ARROW_DOWN, "Down", new ZoomAndKeysCursorCommand(Direction.DOWN, this.model, surface), 104);
            this.addButtonHUI(surface, ButtonID.ARROW_LEFT, "Left", new ZoomAndKeysCursorCommand(Direction.LEFT, this.model, surface), 105);
            this.addButtonHUI(surface, ButtonID.ZOOM, "Toggle", (TriggerCommand)new ZoomCommand(this.model, surface), 106, ((HUIConfiguration)surface.getConfiguration())::isZoomState);
            this.addButtonHUI(surface, ButtonID.ARROW_RIGHT, "Right", new ZoomAndKeysCursorCommand(Direction.RIGHT, this.model, surface), 107);
            this.addButtonHUI(surface, ButtonID.ARROW_UP, "Up", new ZoomAndKeysCursorCommand(Direction.UP, this.model, surface), 108);
            WindCommand rewindCommand = new WindCommand(this.model, surface, false);
            this.addButtonHUI(surface, ButtonID.REWIND, "<<", rewindCommand, 113, rewindCommand::isRewinding);
            WindCommand forwardCommand = new WindCommand(this.model, surface, true);
            this.addButtonHUI(surface, ButtonID.FORWARD, ">>", forwardCommand, 114, forwardCommand::isForwarding);
            this.addButtonHUI(surface, ButtonID.STOP, "Stop", new StopCommand(this.model, surface), 115, () -> !t.isPlaying());
            this.addButtonHUI(surface, ButtonID.PLAY, "Play", new PlayCommand(this.model, surface), 116, t::isPlaying);
            this.addButtonHUI(surface, ButtonID.RECORD, "Record", new RecordCommand(this.model, surface), 117, t::isRecording);
            this.addButtonHUI(surface, ButtonID.RETURN_TO_ZERO, "Return to Zero", (ButtonEvent event, int velocity) -> {
                if (event == ButtonEvent.DOWN) {
                    t.setPosition(0.0);
                }
            }, 120, () -> surface.getButton(ButtonID.RETURN_TO_ZERO).isPressed());
            this.addButtonHUI(surface, ButtonID.AUDIO_ENGINE, "Audio Engine", (ButtonEvent event, int velocity) -> {
                if (event == ButtonEvent.DOWN) {
                    application.toggleEngineActive();
                }
            }, 122, application::isEngineActive);
            this.addButtonHUI(surface, ButtonID.LOOP, "Loop", new ToggleLoopCommand(this.model, surface), 123, t::isLoop);
            this.addButtonHUI(surface, ButtonID.OVERDUB, "Quick Punch", new PunchInCommand(this.model, surface), 124, t::isPunchInEnabled);
            this.addButtonHUI(surface, ButtonID.METRONOME, "Metronome", new MetronomeCommand(this.model, surface, false), 129, t::isMetronomeOn);
            this.addButtonHUI(surface, ButtonID.PUNCH_IN, "In", new PunchInCommand(this.model, surface), 130, t::isPunchInEnabled);
            this.addButtonHUI(surface, ButtonID.PUNCH_OUT, "Out", new PunchOutCommand(this.model, surface), 131, t::isPunchOutEnabled);
            this.addButtonHUI(surface, ButtonID.TAP_TEMPO, "Tap Tempo", new TapTempoCommand(this.model, surface), 132, () -> false);
            this.addButtonHUI(surface, ButtonID.AUTOMATION_OFF, "Off", new AutomationModeCommand(AutomationMode.TRIM_READ, this.model, surface, true), 195, () -> false);
            this.addButtonHUI(surface, ButtonID.AUTOMATION_TRIM, "Trim", new AutomationModeCommand(AutomationMode.TRIM_READ, this.model, surface, true), 192, () -> t.getAutomationWriteMode() == AutomationMode.TRIM_READ);
            this.addButtonHUI(surface, ButtonID.AUTOMATION_READ, "Read", new AutomationModeCommand(AutomationMode.READ, this.model, surface, true), 194, () -> t.getAutomationWriteMode() == AutomationMode.READ);
            this.addButtonHUI(surface, ButtonID.AUTOMATION_LATCH, "Latch", new AutomationModeCommand(AutomationMode.LATCH, this.model, surface, true), 193, () -> t.getAutomationWriteMode() == AutomationMode.LATCH);
            this.addButtonHUI(surface, ButtonID.AUTOMATION_WRITE, "Write", new AutomationModeCommand(AutomationMode.WRITE, this.model, surface, true), 196, () -> t.getAutomationWriteMode() == AutomationMode.WRITE);
            this.addButtonHUI(surface, ButtonID.AUTOMATION_TOUCH, "Touch", new AutomationModeCommand(AutomationMode.TOUCH, this.model, surface, true), 197, () -> t.getAutomationWriteMode() == AutomationMode.TOUCH);
            this.addButtonHUI(surface, ButtonID.ADD_TRACK, "Paste", new AddTrackCommand(this.model, surface), 208);
            this.addButtonHUI(surface, ButtonID.ADD_EFFECT, "Copy", new AddEffectCommand(this.model, surface), 212);
            this.addButtonHUI(surface, ButtonID.F1, "F1", new AssignableCommand(2, this.model, surface), 216);
            this.addButtonHUI(surface, ButtonID.F2, "F2", new AssignableCommand(3, this.model, surface), 217);
            this.addButtonHUI(surface, ButtonID.F3, "F3", new AssignableCommand(4, this.model, surface), 218);
            this.addButtonHUI(surface, ButtonID.F4, "F4", new AssignableCommand(5, this.model, surface), 219);
            this.addButtonHUI(surface, ButtonID.F5, "F5", new AssignableCommand(6, this.model, surface), 220);
            this.addButtonHUI(surface, ButtonID.F6, "F6", new AssignableCommand(7, this.model, surface), 221);
            this.addButtonHUI(surface, ButtonID.F7, "F7", new AssignableCommand(8, this.model, surface), 222);
            this.addButtonHUI(surface, ButtonID.F8, "F8", new AssignableCommand(9, this.model, surface), 223);
            this.addButtonHUI(surface, ButtonID.FOOTSWITCH1, "Footswitch 1", new AssignableCommand(0, this.model, surface), 232);
            this.addButtonHUI(surface, ButtonID.FOOTSWITCH2, "Footswitch 2", new AssignableCommand(1, this.model, surface), 233);
            this.addButton(surface, ButtonID.NEW, "New", new NewCommand(this.model, surface), -1);
        }
    }

    private void addButtonHUI(HUIControlSurface surface, ButtonID buttonID, String label, TriggerCommand command, int huiControl) {
        this.addButtonHUI(surface, buttonID, label, command, huiControl, (IntSupplier)null);
    }

    private void addButtonHUI(HUIControlSurface surface, ButtonID buttonID, String label, TriggerCommand command, int huiControl, BooleanSupplier supplier) {
        this.addButtonHUI(surface, buttonID, label, command, huiControl, () -> supplier.getAsBoolean() ? 127 : 0);
    }

    private void addButtonHUI(HUIControlSurface surface, ButtonID buttonID, String label, TriggerCommand command, int huiControl, IntSupplier supplier) {
        IHwButton button = surface.createButton(buttonID, label);
        button.bind(command);
        surface.addHuiButton(huiControl, button);
        IntSupplier intSupplier = () -> button.isPressed() ? 127 : 0;
        IntSupplier supp = supplier == null ? intSupplier : supplier;
        surface.createLight(null, supp, color -> surface.setTrigger(0, huiControl, color), state -> this.colorManager.getColor(state, buttonID), button);
    }

    @Override
    protected void registerContinuousCommands() {
        for (int index = 0; index < this.numHUIDevices; ++index) {
            HUIControlSurface surface = (HUIControlSurface)this.getSurface(index);
            for (int channel = 0; channel < 8; ++channel) {
                IHwFader fader = surface.createFader(ContinuousID.get(ContinuousID.FADER1, channel), "Fader " + (channel + 1), true);
                fader.bind(new WorkaroundFader(index * 8 + channel, this.model, surface));
                IHwRelativeKnob knob = surface.createRelativeKnob(ContinuousID.get(ContinuousID.KNOB1, channel), "Knob " + (channel + 1));
                knob.bind(new KnobRowModeCommand(channel, this.model, surface));
            }
            IHwFader fader = surface.createFader(ContinuousID.FADER_MASTER, "Master", true);
            if (((HUIConfiguration)this.configuration).hasMotorFaders()) {
                fader.disableTakeOver();
            }
            fader.bind(new WorkaroundMasterFader(this.model, surface));
            surface.createRelativeKnob(ContinuousID.PLAY_POSITION, "Jog").bind(new JogWheelCommand(this.model, surface));
        }
    }

    @Override
    protected void layoutControls() {
        for (int index = 0; index < this.numHUIDevices; ++index) {
            HUIControlSurface surface = (HUIControlSurface)this.getSurface(index);
            surface.getButton(ButtonID.FADER_TOUCH_1).setBounds(12.75, 460.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW_SELECT_1).setBounds(12.75, 389.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW4_1).setBounds(12.75, 342.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW3_1).setBounds(12.75, 295.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW1_1).setBounds(12.75, 172.5, 65.0, 25.0);
            surface.getButton(ButtonID.ROW5_1).setBounds(12.75, 207.5, 65.0, 25.0);
            surface.getButton(ButtonID.ROW2_1).setBounds(12.75, 248.25, 65.0, 39.75);
            surface.getButton(ButtonID.FADER_TOUCH_2).setBounds(87.25, 460.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW_SELECT_2).setBounds(87.25, 389.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW4_2).setBounds(87.25, 342.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW3_2).setBounds(87.25, 295.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW1_2).setBounds(87.25, 172.5, 65.0, 25.0);
            surface.getButton(ButtonID.ROW5_2).setBounds(87.25, 207.5, 65.0, 25.0);
            surface.getButton(ButtonID.ROW2_2).setBounds(87.25, 248.25, 65.0, 39.75);
            surface.getButton(ButtonID.FADER_TOUCH_3).setBounds(163.75, 460.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW_SELECT_3).setBounds(163.75, 389.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW4_3).setBounds(163.75, 342.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW3_3).setBounds(163.75, 295.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW1_3).setBounds(163.75, 172.5, 65.0, 25.0);
            surface.getButton(ButtonID.ROW5_3).setBounds(163.75, 207.5, 65.0, 25.0);
            surface.getButton(ButtonID.ROW2_3).setBounds(163.75, 248.25, 65.0, 39.75);
            surface.getButton(ButtonID.FADER_TOUCH_4).setBounds(237.0, 460.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW_SELECT_4).setBounds(237.0, 389.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW4_4).setBounds(237.0, 342.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW3_4).setBounds(237.0, 295.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW1_4).setBounds(237.0, 172.5, 65.0, 25.0);
            surface.getButton(ButtonID.ROW5_4).setBounds(237.0, 207.5, 65.0, 25.0);
            surface.getButton(ButtonID.ROW2_4).setBounds(237.0, 248.25, 65.0, 39.75);
            surface.getButton(ButtonID.FADER_TOUCH_5).setBounds(311.25, 460.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW_SELECT_5).setBounds(311.25, 389.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW4_5).setBounds(311.25, 342.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW3_5).setBounds(311.25, 295.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW1_5).setBounds(311.25, 172.5, 65.0, 25.0);
            surface.getButton(ButtonID.ROW5_5).setBounds(311.25, 207.5, 65.0, 25.0);
            surface.getButton(ButtonID.ROW2_5).setBounds(311.25, 248.25, 65.0, 39.75);
            surface.getButton(ButtonID.FADER_TOUCH_6).setBounds(386.5, 460.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW_SELECT_6).setBounds(386.5, 389.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW4_6).setBounds(386.5, 342.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW3_6).setBounds(386.5, 295.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW1_6).setBounds(386.5, 172.5, 65.0, 25.0);
            surface.getButton(ButtonID.ROW5_6).setBounds(386.5, 207.5, 65.0, 25.0);
            surface.getButton(ButtonID.ROW2_6).setBounds(386.5, 248.25, 65.0, 39.75);
            surface.getButton(ButtonID.FADER_TOUCH_7).setBounds(459.0, 460.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW_SELECT_7).setBounds(459.0, 389.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW4_7).setBounds(459.0, 342.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW3_7).setBounds(459.0, 295.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW1_7).setBounds(459.0, 172.5, 65.0, 25.0);
            surface.getButton(ButtonID.ROW5_7).setBounds(459.0, 207.5, 65.0, 25.0);
            surface.getButton(ButtonID.ROW2_7).setBounds(459.0, 248.25, 65.0, 39.75);
            surface.getButton(ButtonID.FADER_TOUCH_8).setBounds(532.25, 460.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW_SELECT_8).setBounds(532.25, 389.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW4_8).setBounds(532.25, 342.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW3_8).setBounds(532.25, 295.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW1_8).setBounds(532.25, 172.5, 65.0, 25.0);
            surface.getButton(ButtonID.ROW5_8).setBounds(532.25, 207.5, 65.0, 25.0);
            surface.getButton(ButtonID.ROW2_8).setBounds(532.25, 248.25, 65.0, 39.75);
            surface.getButton(ButtonID.CONTROL).setBounds(921.0, 637.5, 65.0, 39.75);
            surface.getButton(ButtonID.SHIFT).setBounds(776.5, 637.5, 65.0, 39.75);
            surface.getButton(ButtonID.UNDO).setBounds(849.25, 320.25, 65.0, 39.75);
            surface.getButton(ButtonID.ALT).setBounds(847.75, 637.5, 65.0, 39.75);
            surface.getButton(ButtonID.SELECT).setBounds(703.75, 637.5, 65.0, 39.75);
            surface.getButton(ButtonID.SAVE).setBounds(921.5, 320.25, 65.0, 39.75);
            surface.getButton(ButtonID.MIXER).setBounds(921.5, 366.75, 65.0, 39.75);
            surface.getButton(ButtonID.NOTE_EDITOR).setBounds(705.0, 366.75, 65.0, 39.75);
            surface.getButton(ButtonID.AUTOMATION_EDITOR).setBounds(777.75, 366.75, 65.0, 39.75);
            surface.getButton(ButtonID.TOGGLE_DEVICE).setBounds(849.25, 366.75, 65.0, 39.75);
            surface.getButton(ButtonID.MOVE_TRACK_LEFT).setBounds(847.75, 542.0, 65.0, 39.75);
            surface.getButton(ButtonID.MOVE_BANK_LEFT).setBounds(703.75, 542.0, 65.0, 39.75);
            surface.getButton(ButtonID.MOVE_TRACK_RIGHT).setBounds(921.0, 542.0, 65.0, 39.75);
            surface.getButton(ButtonID.MOVE_BANK_RIGHT).setBounds(776.5, 542.0, 65.0, 39.75);
            surface.getButton(ButtonID.PAN_SEND).setBounds(632.5, 366.75, 65.0, 39.75);
            surface.getButton(ButtonID.SEND1).setBounds(632.5, 414.0, 65.0, 39.75);
            surface.getButton(ButtonID.SEND2).setBounds(705.0, 414.0, 65.0, 39.75);
            surface.getButton(ButtonID.SEND3).setBounds(777.75, 414.0, 65.0, 39.75);
            surface.getButton(ButtonID.SEND4).setBounds(849.25, 414.0, 65.0, 39.75);
            surface.getButton(ButtonID.SEND5).setBounds(921.5, 414.0, 65.0, 39.75);
            surface.getButton(ButtonID.ARROW_DOWN).setBounds(777.75, 797.0, 65.0, 39.75);
            surface.getButton(ButtonID.ARROW_LEFT).setBounds(705.0, 750.25, 65.0, 39.75);
            surface.getButton(ButtonID.ZOOM).setBounds(777.75, 750.25, 65.0, 39.75);
            surface.getButton(ButtonID.ARROW_RIGHT).setBounds(849.0, 750.25, 65.0, 39.75);
            surface.getButton(ButtonID.ARROW_UP).setBounds(777.75, 702.25, 65.0, 39.75);
            surface.getButton(ButtonID.REWIND).setBounds(556.0, 942.0, 65.0, 39.75);
            surface.getButton(ButtonID.FORWARD).setBounds(630.0, 942.0, 65.0, 39.75);
            surface.getButton(ButtonID.STOP).setBounds(779.0, 942.0, 65.0, 39.75);
            surface.getButton(ButtonID.PLAY).setBounds(850.25, 942.0, 65.0, 39.75);
            surface.getButton(ButtonID.RECORD).setBounds(923.5, 942.0, 65.0, 39.75);
            surface.getButton(ButtonID.RETURN_TO_ZERO).setBounds(399.75, 942.0, 65.0, 39.75);
            surface.getButton(ButtonID.AUDIO_ENGINE).setBounds(705.0, 320.25, 65.0, 39.75);
            surface.getButton(ButtonID.LOOP).setBounds(706.25, 942.0, 65.0, 39.75);
            surface.getButton(ButtonID.OVERDUB).setBounds(703.75, 590.25, 65.0, 39.75);
            surface.getButton(ButtonID.METRONOME).setBounds(921.0, 590.25, 65.0, 39.75);
            surface.getButton(ButtonID.PUNCH_IN).setBounds(776.5, 590.25, 65.0, 39.75);
            surface.getButton(ButtonID.PUNCH_OUT).setBounds(847.75, 590.25, 65.0, 39.75);
            surface.getButton(ButtonID.TAP_TEMPO).setBounds(481.25, 942.0, 65.0, 39.75);
            surface.getButton(ButtonID.AUTOMATION_OFF).setBounds(632.5, 272.25, 30.25, 39.75);
            surface.getButton(ButtonID.AUTOMATION_TRIM).setBounds(777.75, 272.25, 65.0, 39.75);
            surface.getButton(ButtonID.AUTOMATION_READ).setBounds(667.25, 272.25, 30.25, 39.75);
            surface.getButton(ButtonID.AUTOMATION_LATCH).setBounds(921.5, 272.25, 65.0, 39.75);
            surface.getButton(ButtonID.AUTOMATION_WRITE).setBounds(705.0, 272.25, 65.0, 39.75);
            surface.getButton(ButtonID.AUTOMATION_TOUCH).setBounds(849.25, 272.25, 65.0, 39.75);
            surface.getButton(ButtonID.REC_ARM_ALL).setBounds(632.5, 225.5, 65.0, 39.75);
            surface.getButton(ButtonID.F1).setBounds(632.5, 178.25, 65.0, 39.75);
            surface.getButton(ButtonID.F2).setBounds(705.0, 178.25, 65.0, 39.75);
            surface.getButton(ButtonID.F3).setBounds(777.75, 178.25, 65.0, 39.75);
            surface.getButton(ButtonID.F4).setBounds(849.25, 178.25, 65.0, 39.75);
            surface.getButton(ButtonID.F5).setBounds(921.5, 178.25, 65.0, 39.75);
            surface.getButton(ButtonID.F6).setBounds(777.75, 225.5, 65.0, 39.75);
            surface.getButton(ButtonID.F7).setBounds(849.25, 225.5, 65.0, 39.75);
            surface.getButton(ButtonID.F8).setBounds(921.5, 225.5, 65.0, 39.75);
            surface.getButton(ButtonID.FOOTSWITCH1).setBounds(12.5, 942.0, 77.75, 39.75);
            surface.getButton(ButtonID.FOOTSWITCH2).setBounds(102.5, 942.0, 77.75, 39.75);
            surface.getContinuous(ContinuousID.FADER1).setBounds(12.75, 501.5, 65.0, 419.0);
            surface.getContinuous(ContinuousID.KNOB1).setBounds(12.25, 93.5, 72.0, 74.75);
            surface.getContinuous(ContinuousID.FADER2).setBounds(87.25, 501.5, 65.0, 419.0);
            surface.getContinuous(ContinuousID.KNOB2).setBounds(86.25, 93.5, 72.0, 74.75);
            surface.getContinuous(ContinuousID.FADER3).setBounds(163.75, 501.5, 65.0, 419.0);
            surface.getContinuous(ContinuousID.KNOB3).setBounds(160.0, 93.5, 72.0, 74.75);
            surface.getContinuous(ContinuousID.FADER4).setBounds(237.0, 501.5, 65.0, 419.0);
            surface.getContinuous(ContinuousID.KNOB4).setBounds(234.0, 93.5, 72.0, 74.75);
            surface.getContinuous(ContinuousID.FADER5).setBounds(311.25, 501.5, 65.0, 419.0);
            surface.getContinuous(ContinuousID.KNOB5).setBounds(308.0, 93.5, 72.0, 74.75);
            surface.getContinuous(ContinuousID.FADER6).setBounds(386.5, 501.5, 65.0, 419.0);
            surface.getContinuous(ContinuousID.KNOB6).setBounds(381.75, 93.5, 72.0, 74.75);
            surface.getContinuous(ContinuousID.FADER7).setBounds(459.0, 501.5, 65.0, 419.0);
            surface.getContinuous(ContinuousID.KNOB7).setBounds(455.75, 93.5, 72.0, 74.75);
            surface.getContinuous(ContinuousID.FADER8).setBounds(532.25, 501.5, 65.0, 419.0);
            surface.getContinuous(ContinuousID.KNOB8).setBounds(529.5, 93.5, 72.0, 74.75);
            surface.getContinuous(ContinuousID.FADER_MASTER).setBounds(613.5, 501.5, 65.0, 419.0);
            surface.getContinuous(ContinuousID.PLAY_POSITION).setBounds(859.5, 806.5, 115.25, 115.75);
            surface.getTextDisplay(0).getHardwareDisplay().setBounds(11.75, 11.75, 601.0, 73.25);
            surface.getTextDisplay(1).getHardwareDisplay().setBounds(699.0, 27.0, 229.0, 57.75);
        }
    }

    @Override
    public void startup() {
        boolean shouldSendPing = ((HUIConfiguration)this.configuration).shouldSendPing();
        for (int index = 0; index < this.numHUIDevices; ++index) {
            HUIControlSurface surface = (HUIControlSurface)this.getSurface(index);
            surface.getViewManager().setActive(Views.CONTROL);
            surface.getModeManager().setActive(Modes.PAN);
            if (!shouldSendPing) continue;
            this.sendPing(surface);
        }
    }

    private void sendPing(HUIControlSurface surface) {
        surface.getMidiOutput().sendNote(0, 0);
        this.host.scheduleTask(() -> this.sendPing(surface), 1000L);
    }

    private void updateSegmentDisplay(HUIControlSurface surface) {
        if (!((HUIConfiguration)this.configuration).hasSegmentDisplay()) {
            return;
        }
        ITransport t = this.model.getTransport();
        String positionText = t.getPositionText();
        positionText = positionText.replace('.', ':');
        surface.getSegmentDisplay().setRow(0, positionText).allDone();
    }

    private void updateVUandFaders() {
        double upperBound = this.valueChanger.getUpperBound();
        boolean enableVUMeters = ((HUIConfiguration)this.configuration).isEnableVUMeters();
        boolean hasMotorFaders = ((HUIConfiguration)this.configuration).hasMotorFaders();
        ITrackBank tb = this.model.getCurrentTrackBank();
        for (int index = 0; index < this.surfaces.size(); ++index) {
            HUIControlSurface surface = (HUIControlSurface)this.surfaces.get(index);
            for (int channel = 0; channel < 8; ++channel) {
                ITrack track = (ITrack)tb.getItem(index * 8 + channel);
                if (enableVUMeters) {
                    surface.updateVuMeters(channel, track.getVuLeft(), track.getVuRight(), upperBound);
                }
                if (!hasMotorFaders) continue;
                surface.updateFaders(channel, track.getVolume());
            }
        }
    }

    private void updateMode(HUIControlSurface surface, Modes modeID) {
        if (modeID == null) {
            return;
        }
        IMode mode = (IMode)surface.getModeManager().get(modeID);
        if (mode instanceof HUIMode) {
            HUIMode huiMode = (HUIMode)((Object)mode);
            huiMode.updateKnobLEDs();
        }
        this.updateIndication(modeID);
    }

    protected void updateIndication(Modes mode) {
        if (this.currentMode != null && this.currentMode.equals((Object)mode)) {
            return;
        }
        this.currentMode = mode;
        boolean isTrack = mode == Modes.TRACK;
        boolean isVolume = mode == Modes.VOLUME;
        boolean isPan = mode == Modes.PAN;
        boolean isDevice = mode == Modes.DEVICE_PARAMS;
        boolean isEqDevice = mode == Modes.EQ_DEVICE_PARAMS;
        ITrackBank tb = this.model.getTrackBank();
        Optional selectedTrack = tb.getSelectedItem();
        IParameterBank parameterBank = this.model.getCursorDevice().getParameterBank();
        IParameterBank eqParameterBank = this.model.getSpecificDevice(DeviceID.EQ).getParameterBank();
        for (int i = 0; i < 8; ++i) {
            boolean hasTrackSel = selectedTrack.isPresent() && ((ITrack)selectedTrack.get()).getIndex() == i;
            ITrack track = (ITrack)tb.getItem(i);
            track.setVolumeIndication(isTrack && hasTrackSel || isVolume);
            track.setPanIndication(isTrack && hasTrackSel || isPan);
            ISendBank sendBank = track.getSendBank();
            for (int j = 0; j < 6; ++j) {
                ((ISend)sendBank.getItem(j)).setIndication(isTrack && hasTrackSel || mode == Modes.get(Modes.SEND1, j));
            }
            ((IParameter)parameterBank.getItem(i)).setIndication(isDevice);
            ((IParameter)eqParameterBank.getItem(i)).setIndication(isEqDevice);
        }
    }
}

