/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.command.trigger.track.ToggleTrackBanksCommand;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IClipLauncherNavigator;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class TrackHandler
extends AbstractHandler {
    private final TriggerCommand toggleTrackBankCommand;
    private final IClipLauncherNavigator clipLauncherNavigator;

    public TrackHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
        this.clipLauncherNavigator = this.model.getClipLauncherNavigator();
        this.toggleTrackBankCommand = new ToggleTrackBanksCommand(model, surface);
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.TRACK_TOGGLE_TRACK_BANK, FlexiCommand.TRACK_ADD_AUDIO_TRACK, FlexiCommand.TRACK_ADD_EFFECT_TRACK, FlexiCommand.TRACK_ADD_INSTRUMENT_TRACK, FlexiCommand.TRACK_SELECT_PREVIOUS_BANK_PAGE, FlexiCommand.TRACK_SELECT_NEXT_BANK_PAGE, FlexiCommand.TRACK_SELECT_PREVIOUS_TRACK, FlexiCommand.TRACK_SELECT_NEXT_TRACK, FlexiCommand.TRACK_SCROLL_BANK_PAGE_BY_1_LEFT, FlexiCommand.TRACK_SCROLL_BANK_PAGE_BY_1_RIGHT, FlexiCommand.TRACK_SCROLL_TRACKS, FlexiCommand.TRACK_1_SELECT, FlexiCommand.TRACK_2_SELECT, FlexiCommand.TRACK_3_SELECT, FlexiCommand.TRACK_4_SELECT, FlexiCommand.TRACK_5_SELECT, FlexiCommand.TRACK_6_SELECT, FlexiCommand.TRACK_7_SELECT, FlexiCommand.TRACK_8_SELECT, FlexiCommand.TRACK_1_TOGGLE_ACTIVE, FlexiCommand.TRACK_2_TOGGLE_ACTIVE, FlexiCommand.TRACK_3_TOGGLE_ACTIVE, FlexiCommand.TRACK_4_TOGGLE_ACTIVE, FlexiCommand.TRACK_5_TOGGLE_ACTIVE, FlexiCommand.TRACK_6_TOGGLE_ACTIVE, FlexiCommand.TRACK_7_TOGGLE_ACTIVE, FlexiCommand.TRACK_8_TOGGLE_ACTIVE, FlexiCommand.TRACK_1_SET_ACTIVE, FlexiCommand.TRACK_2_SET_ACTIVE, FlexiCommand.TRACK_3_SET_ACTIVE, FlexiCommand.TRACK_4_SET_ACTIVE, FlexiCommand.TRACK_5_SET_ACTIVE, FlexiCommand.TRACK_6_SET_ACTIVE, FlexiCommand.TRACK_7_SET_ACTIVE, FlexiCommand.TRACK_8_SET_ACTIVE, FlexiCommand.TRACK_SELECTED_TOGGLE_ACTIVE, FlexiCommand.TRACK_SELECTED_SET_ACTIVE, FlexiCommand.TRACK_1_SET_VOLUME, FlexiCommand.TRACK_2_SET_VOLUME, FlexiCommand.TRACK_3_SET_VOLUME, FlexiCommand.TRACK_4_SET_VOLUME, FlexiCommand.TRACK_5_SET_VOLUME, FlexiCommand.TRACK_6_SET_VOLUME, FlexiCommand.TRACK_7_SET_VOLUME, FlexiCommand.TRACK_8_SET_VOLUME, FlexiCommand.TRACK_SELECTED_SET_VOLUME_TRACK, FlexiCommand.TRACK_1_SET_PANORAMA, FlexiCommand.TRACK_2_SET_PANORAMA, FlexiCommand.TRACK_3_SET_PANORAMA, FlexiCommand.TRACK_4_SET_PANORAMA, FlexiCommand.TRACK_5_SET_PANORAMA, FlexiCommand.TRACK_6_SET_PANORAMA, FlexiCommand.TRACK_7_SET_PANORAMA, FlexiCommand.TRACK_8_SET_PANORAMA, FlexiCommand.TRACK_SELECTED_SET_PANORAMA, FlexiCommand.TRACK_1_TOGGLE_MUTE, FlexiCommand.TRACK_2_TOGGLE_MUTE, FlexiCommand.TRACK_3_TOGGLE_MUTE, FlexiCommand.TRACK_4_TOGGLE_MUTE, FlexiCommand.TRACK_5_TOGGLE_MUTE, FlexiCommand.TRACK_6_TOGGLE_MUTE, FlexiCommand.TRACK_7_TOGGLE_MUTE, FlexiCommand.TRACK_8_TOGGLE_MUTE, FlexiCommand.TRACK_1_SET_MUTE, FlexiCommand.TRACK_2_SET_MUTE, FlexiCommand.TRACK_3_SET_MUTE, FlexiCommand.TRACK_4_SET_MUTE, FlexiCommand.TRACK_5_SET_MUTE, FlexiCommand.TRACK_6_SET_MUTE, FlexiCommand.TRACK_7_SET_MUTE, FlexiCommand.TRACK_8_SET_MUTE, FlexiCommand.TRACK_SELECTED_TOGGLE_MUTE, FlexiCommand.TRACK_SELECTED_SET_MUTE, FlexiCommand.TRACK_1_TOGGLE_SOLO, FlexiCommand.TRACK_2_TOGGLE_SOLO, FlexiCommand.TRACK_3_TOGGLE_SOLO, FlexiCommand.TRACK_4_TOGGLE_SOLO, FlexiCommand.TRACK_5_TOGGLE_SOLO, FlexiCommand.TRACK_6_TOGGLE_SOLO, FlexiCommand.TRACK_7_TOGGLE_SOLO, FlexiCommand.TRACK_8_TOGGLE_SOLO, FlexiCommand.TRACK_1_SET_SOLO, FlexiCommand.TRACK_2_SET_SOLO, FlexiCommand.TRACK_3_SET_SOLO, FlexiCommand.TRACK_4_SET_SOLO, FlexiCommand.TRACK_5_SET_SOLO, FlexiCommand.TRACK_6_SET_SOLO, FlexiCommand.TRACK_7_SET_SOLO, FlexiCommand.TRACK_8_SET_SOLO, FlexiCommand.TRACK_SELECTED_TOGGLE_SOLO, FlexiCommand.TRACK_SELECTED_SET_SOLO, FlexiCommand.TRACK_1_TOGGLE_ARM, FlexiCommand.TRACK_2_TOGGLE_ARM, FlexiCommand.TRACK_3_TOGGLE_ARM, FlexiCommand.TRACK_4_TOGGLE_ARM, FlexiCommand.TRACK_5_TOGGLE_ARM, FlexiCommand.TRACK_6_TOGGLE_ARM, FlexiCommand.TRACK_7_TOGGLE_ARM, FlexiCommand.TRACK_8_TOGGLE_ARM, FlexiCommand.TRACK_1_SET_ARM, FlexiCommand.TRACK_2_SET_ARM, FlexiCommand.TRACK_3_SET_ARM, FlexiCommand.TRACK_4_SET_ARM, FlexiCommand.TRACK_5_SET_ARM, FlexiCommand.TRACK_6_SET_ARM, FlexiCommand.TRACK_7_SET_ARM, FlexiCommand.TRACK_8_SET_ARM, FlexiCommand.TRACK_SELECTED_TOGGLE_ARM, FlexiCommand.TRACK_SELECTED_SET_ARM, FlexiCommand.TRACK_1_TOGGLE_MONITOR, FlexiCommand.TRACK_2_TOGGLE_MONITOR, FlexiCommand.TRACK_3_TOGGLE_MONITOR, FlexiCommand.TRACK_4_TOGGLE_MONITOR, FlexiCommand.TRACK_5_TOGGLE_MONITOR, FlexiCommand.TRACK_6_TOGGLE_MONITOR, FlexiCommand.TRACK_7_TOGGLE_MONITOR, FlexiCommand.TRACK_8_TOGGLE_MONITOR, FlexiCommand.TRACK_1_SET_MONITOR, FlexiCommand.TRACK_2_SET_MONITOR, FlexiCommand.TRACK_3_SET_MONITOR, FlexiCommand.TRACK_4_SET_MONITOR, FlexiCommand.TRACK_5_SET_MONITOR, FlexiCommand.TRACK_6_SET_MONITOR, FlexiCommand.TRACK_7_SET_MONITOR, FlexiCommand.TRACK_8_SET_MONITOR, FlexiCommand.TRACK_SELECTED_TOGGLE_MONITOR, FlexiCommand.TRACK_SELECTED_SET_MONITOR, FlexiCommand.TRACK_1_TOGGLE_AUTO_MONITOR, FlexiCommand.TRACK_2_TOGGLE_AUTO_MONITOR, FlexiCommand.TRACK_3_TOGGLE_AUTO_MONITOR, FlexiCommand.TRACK_4_TOGGLE_AUTO_MONITOR, FlexiCommand.TRACK_5_TOGGLE_AUTO_MONITOR, FlexiCommand.TRACK_6_TOGGLE_AUTO_MONITOR, FlexiCommand.TRACK_7_TOGGLE_AUTO_MONITOR, FlexiCommand.TRACK_8_TOGGLE_AUTO_MONITOR, FlexiCommand.TRACK_1_SET_AUTO_MONITOR, FlexiCommand.TRACK_2_SET_AUTO_MONITOR, FlexiCommand.TRACK_3_SET_AUTO_MONITOR, FlexiCommand.TRACK_4_SET_AUTO_MONITOR, FlexiCommand.TRACK_5_SET_AUTO_MONITOR, FlexiCommand.TRACK_6_SET_AUTO_MONITOR, FlexiCommand.TRACK_7_SET_AUTO_MONITOR, FlexiCommand.TRACK_8_SET_AUTO_MONITOR, FlexiCommand.TRACK_SELECTED_TOGGLE_AUTO_MONITOR, FlexiCommand.TRACK_SELECTED_SET_AUTO_MONITOR, FlexiCommand.TRACK_SELECTED_TOGGLE_PIN, FlexiCommand.TRACK_SELECTED_SET_PIN, FlexiCommand.TRACK_1_SET_SEND_1, FlexiCommand.TRACK_2_SET_SEND_1, FlexiCommand.TRACK_3_SET_SEND_1, FlexiCommand.TRACK_4_SET_SEND_1, FlexiCommand.TRACK_5_SET_SEND_1, FlexiCommand.TRACK_6_SET_SEND_1, FlexiCommand.TRACK_7_SET_SEND_1, FlexiCommand.TRACK_8_SET_SEND_1, FlexiCommand.TRACK_1_SET_SEND_2, FlexiCommand.TRACK_2_SET_SEND_2, FlexiCommand.TRACK_3_SET_SEND_2, FlexiCommand.TRACK_4_SET_SEND_2, FlexiCommand.TRACK_5_SET_SEND_2, FlexiCommand.TRACK_6_SET_SEND_2, FlexiCommand.TRACK_7_SET_SEND_2, FlexiCommand.TRACK_8_SET_SEND_2, FlexiCommand.TRACK_1_SET_SEND_3, FlexiCommand.TRACK_2_SET_SEND_3, FlexiCommand.TRACK_3_SET_SEND_3, FlexiCommand.TRACK_4_SET_SEND_3, FlexiCommand.TRACK_5_SET_SEND_3, FlexiCommand.TRACK_6_SET_SEND_3, FlexiCommand.TRACK_7_SET_SEND_3, FlexiCommand.TRACK_8_SET_SEND_3, FlexiCommand.TRACK_1_SET_SEND_4, FlexiCommand.TRACK_2_SET_SEND_4, FlexiCommand.TRACK_3_SET_SEND_4, FlexiCommand.TRACK_4_SET_SEND_4, FlexiCommand.TRACK_5_SET_SEND_4, FlexiCommand.TRACK_6_SET_SEND_4, FlexiCommand.TRACK_7_SET_SEND_4, FlexiCommand.TRACK_8_SET_SEND_4, FlexiCommand.TRACK_1_SET_SEND_5, FlexiCommand.TRACK_2_SET_SEND_5, FlexiCommand.TRACK_3_SET_SEND_5, FlexiCommand.TRACK_4_SET_SEND_5, FlexiCommand.TRACK_5_SET_SEND_5, FlexiCommand.TRACK_6_SET_SEND_5, FlexiCommand.TRACK_7_SET_SEND_5, FlexiCommand.TRACK_8_SET_SEND_5, FlexiCommand.TRACK_1_SET_SEND_6, FlexiCommand.TRACK_2_SET_SEND_6, FlexiCommand.TRACK_3_SET_SEND_6, FlexiCommand.TRACK_4_SET_SEND_6, FlexiCommand.TRACK_5_SET_SEND_6, FlexiCommand.TRACK_6_SET_SEND_6, FlexiCommand.TRACK_7_SET_SEND_6, FlexiCommand.TRACK_8_SET_SEND_6, FlexiCommand.TRACK_1_SET_SEND_7, FlexiCommand.TRACK_2_SET_SEND_7, FlexiCommand.TRACK_3_SET_SEND_7, FlexiCommand.TRACK_4_SET_SEND_7, FlexiCommand.TRACK_5_SET_SEND_7, FlexiCommand.TRACK_6_SET_SEND_7, FlexiCommand.TRACK_7_SET_SEND_7, FlexiCommand.TRACK_8_SET_SEND_7, FlexiCommand.TRACK_1_SET_SEND_8, FlexiCommand.TRACK_2_SET_SEND_8, FlexiCommand.TRACK_3_SET_SEND_8, FlexiCommand.TRACK_4_SET_SEND_8, FlexiCommand.TRACK_5_SET_SEND_8, FlexiCommand.TRACK_6_SET_SEND_8, FlexiCommand.TRACK_7_SET_SEND_8, FlexiCommand.TRACK_8_SET_SEND_8, FlexiCommand.TRACK_SELECTED_SET_SEND_1, FlexiCommand.TRACK_SELECTED_SET_SEND_2, FlexiCommand.TRACK_SELECTED_SET_SEND_3, FlexiCommand.TRACK_SELECTED_SET_SEND_4, FlexiCommand.TRACK_SELECTED_SET_SEND_5, FlexiCommand.TRACK_SELECTED_SET_SEND_6, FlexiCommand.TRACK_SELECTED_SET_SEND_7, FlexiCommand.TRACK_SELECTED_SET_SEND_8};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        ITrackBank trackBank = this.model.getCurrentTrackBank();
        if (trackBank == null) {
            return -1;
        }
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        switch (command) {
            case TRACK_SELECT_PREVIOUS_BANK_PAGE: {
                return TrackHandler.toMidiValue(trackBank.canScrollPageBackwards());
            }
            case TRACK_SELECT_NEXT_BANK_PAGE: {
                return TrackHandler.toMidiValue(trackBank.canScrollPageForwards());
            }
            case TRACK_SELECT_PREVIOUS_TRACK: 
            case TRACK_SCROLL_BANK_PAGE_BY_1_LEFT: {
                return TrackHandler.toMidiValue(trackBank.canScrollBackwards());
            }
            case TRACK_SELECT_NEXT_TRACK: 
            case TRACK_SCROLL_BANK_PAGE_BY_1_RIGHT: {
                return TrackHandler.toMidiValue(trackBank.canScrollForwards());
            }
            case TRACK_1_SELECT: 
            case TRACK_2_SELECT: 
            case TRACK_3_SELECT: 
            case TRACK_4_SELECT: 
            case TRACK_5_SELECT: 
            case TRACK_6_SELECT: 
            case TRACK_7_SELECT: 
            case TRACK_8_SELECT: {
                return TrackHandler.toMidiValue(((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_SELECT.ordinal())).isSelected());
            }
            case TRACK_1_TOGGLE_ACTIVE: 
            case TRACK_2_TOGGLE_ACTIVE: 
            case TRACK_3_TOGGLE_ACTIVE: 
            case TRACK_4_TOGGLE_ACTIVE: 
            case TRACK_5_TOGGLE_ACTIVE: 
            case TRACK_6_TOGGLE_ACTIVE: 
            case TRACK_7_TOGGLE_ACTIVE: 
            case TRACK_8_TOGGLE_ACTIVE: {
                return TrackHandler.toMidiValue(((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_TOGGLE_ACTIVE.ordinal())).isActivated());
            }
            case TRACK_1_SET_ACTIVE: 
            case TRACK_2_SET_ACTIVE: 
            case TRACK_3_SET_ACTIVE: 
            case TRACK_4_SET_ACTIVE: 
            case TRACK_5_SET_ACTIVE: 
            case TRACK_6_SET_ACTIVE: 
            case TRACK_7_SET_ACTIVE: 
            case TRACK_8_SET_ACTIVE: {
                return TrackHandler.toMidiValue(((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_SET_ACTIVE.ordinal())).isActivated());
            }
            case TRACK_SELECTED_TOGGLE_ACTIVE: 
            case TRACK_SELECTED_SET_ACTIVE: {
                return TrackHandler.toMidiValue(cursorTrack.doesExist() && cursorTrack.isActivated());
            }
            case TRACK_1_SET_VOLUME: 
            case TRACK_2_SET_VOLUME: 
            case TRACK_3_SET_VOLUME: 
            case TRACK_4_SET_VOLUME: 
            case TRACK_5_SET_VOLUME: 
            case TRACK_6_SET_VOLUME: 
            case TRACK_7_SET_VOLUME: 
            case TRACK_8_SET_VOLUME: {
                return ((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_SET_VOLUME.ordinal())).getVolume();
            }
            case TRACK_SELECTED_SET_VOLUME_TRACK: {
                return cursorTrack.doesExist() ? cursorTrack.getVolume() : 0;
            }
            case TRACK_1_SET_PANORAMA: 
            case TRACK_2_SET_PANORAMA: 
            case TRACK_3_SET_PANORAMA: 
            case TRACK_4_SET_PANORAMA: 
            case TRACK_5_SET_PANORAMA: 
            case TRACK_6_SET_PANORAMA: 
            case TRACK_7_SET_PANORAMA: 
            case TRACK_8_SET_PANORAMA: {
                return ((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_SET_PANORAMA.ordinal())).getPan();
            }
            case TRACK_SELECTED_SET_PANORAMA: {
                return cursorTrack.doesExist() ? cursorTrack.getPan() : 0;
            }
            case TRACK_1_TOGGLE_MUTE: 
            case TRACK_2_TOGGLE_MUTE: 
            case TRACK_3_TOGGLE_MUTE: 
            case TRACK_4_TOGGLE_MUTE: 
            case TRACK_5_TOGGLE_MUTE: 
            case TRACK_6_TOGGLE_MUTE: 
            case TRACK_7_TOGGLE_MUTE: 
            case TRACK_8_TOGGLE_MUTE: {
                return TrackHandler.toMidiValue(((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_TOGGLE_MUTE.ordinal())).isMute());
            }
            case TRACK_1_SET_MUTE: 
            case TRACK_2_SET_MUTE: 
            case TRACK_3_SET_MUTE: 
            case TRACK_4_SET_MUTE: 
            case TRACK_5_SET_MUTE: 
            case TRACK_6_SET_MUTE: 
            case TRACK_7_SET_MUTE: 
            case TRACK_8_SET_MUTE: {
                return TrackHandler.toMidiValue(((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_SET_MUTE.ordinal())).isMute());
            }
            case TRACK_SELECTED_TOGGLE_MUTE: 
            case TRACK_SELECTED_SET_MUTE: {
                return TrackHandler.toMidiValue(cursorTrack.doesExist() && cursorTrack.isMute());
            }
            case TRACK_1_TOGGLE_SOLO: 
            case TRACK_2_TOGGLE_SOLO: 
            case TRACK_3_TOGGLE_SOLO: 
            case TRACK_4_TOGGLE_SOLO: 
            case TRACK_5_TOGGLE_SOLO: 
            case TRACK_6_TOGGLE_SOLO: 
            case TRACK_7_TOGGLE_SOLO: 
            case TRACK_8_TOGGLE_SOLO: {
                return TrackHandler.toMidiValue(((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_TOGGLE_SOLO.ordinal())).isSolo());
            }
            case TRACK_1_SET_SOLO: 
            case TRACK_2_SET_SOLO: 
            case TRACK_3_SET_SOLO: 
            case TRACK_4_SET_SOLO: 
            case TRACK_5_SET_SOLO: 
            case TRACK_6_SET_SOLO: 
            case TRACK_7_SET_SOLO: 
            case TRACK_8_SET_SOLO: {
                return TrackHandler.toMidiValue(((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_SET_SOLO.ordinal())).isSolo());
            }
            case TRACK_SELECTED_TOGGLE_SOLO: 
            case TRACK_SELECTED_SET_SOLO: {
                return TrackHandler.toMidiValue(cursorTrack.doesExist() && cursorTrack.isSolo());
            }
            case TRACK_1_TOGGLE_ARM: 
            case TRACK_2_TOGGLE_ARM: 
            case TRACK_3_TOGGLE_ARM: 
            case TRACK_4_TOGGLE_ARM: 
            case TRACK_5_TOGGLE_ARM: 
            case TRACK_6_TOGGLE_ARM: 
            case TRACK_7_TOGGLE_ARM: 
            case TRACK_8_TOGGLE_ARM: {
                return TrackHandler.toMidiValue(((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_TOGGLE_ARM.ordinal())).isRecArm());
            }
            case TRACK_1_SET_ARM: 
            case TRACK_2_SET_ARM: 
            case TRACK_3_SET_ARM: 
            case TRACK_4_SET_ARM: 
            case TRACK_5_SET_ARM: 
            case TRACK_6_SET_ARM: 
            case TRACK_7_SET_ARM: 
            case TRACK_8_SET_ARM: {
                return TrackHandler.toMidiValue(((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_SET_ARM.ordinal())).isRecArm());
            }
            case TRACK_SELECTED_TOGGLE_ARM: 
            case TRACK_SELECTED_SET_ARM: {
                return TrackHandler.toMidiValue(cursorTrack.doesExist() && cursorTrack.isRecArm());
            }
            case TRACK_1_TOGGLE_MONITOR: 
            case TRACK_2_TOGGLE_MONITOR: 
            case TRACK_3_TOGGLE_MONITOR: 
            case TRACK_4_TOGGLE_MONITOR: 
            case TRACK_5_TOGGLE_MONITOR: 
            case TRACK_6_TOGGLE_MONITOR: 
            case TRACK_7_TOGGLE_MONITOR: 
            case TRACK_8_TOGGLE_MONITOR: {
                return TrackHandler.toMidiValue(((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_TOGGLE_MONITOR.ordinal())).isMonitor());
            }
            case TRACK_1_SET_MONITOR: 
            case TRACK_2_SET_MONITOR: 
            case TRACK_3_SET_MONITOR: 
            case TRACK_4_SET_MONITOR: 
            case TRACK_5_SET_MONITOR: 
            case TRACK_6_SET_MONITOR: 
            case TRACK_7_SET_MONITOR: 
            case TRACK_8_SET_MONITOR: {
                return TrackHandler.toMidiValue(((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_SET_MONITOR.ordinal())).isMonitor());
            }
            case TRACK_SELECTED_TOGGLE_MONITOR: 
            case TRACK_SELECTED_SET_MONITOR: {
                return TrackHandler.toMidiValue(cursorTrack.doesExist() && cursorTrack.isMonitor());
            }
            case TRACK_1_TOGGLE_AUTO_MONITOR: 
            case TRACK_2_TOGGLE_AUTO_MONITOR: 
            case TRACK_3_TOGGLE_AUTO_MONITOR: 
            case TRACK_4_TOGGLE_AUTO_MONITOR: 
            case TRACK_5_TOGGLE_AUTO_MONITOR: 
            case TRACK_6_TOGGLE_AUTO_MONITOR: 
            case TRACK_7_TOGGLE_AUTO_MONITOR: 
            case TRACK_8_TOGGLE_AUTO_MONITOR: {
                return TrackHandler.toMidiValue(((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_TOGGLE_AUTO_MONITOR.ordinal())).isAutoMonitor());
            }
            case TRACK_1_SET_AUTO_MONITOR: 
            case TRACK_2_SET_AUTO_MONITOR: 
            case TRACK_3_SET_AUTO_MONITOR: 
            case TRACK_4_SET_AUTO_MONITOR: 
            case TRACK_5_SET_AUTO_MONITOR: 
            case TRACK_6_SET_AUTO_MONITOR: 
            case TRACK_7_SET_AUTO_MONITOR: 
            case TRACK_8_SET_AUTO_MONITOR: {
                return TrackHandler.toMidiValue(((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_SET_AUTO_MONITOR.ordinal())).isAutoMonitor());
            }
            case TRACK_SELECTED_TOGGLE_AUTO_MONITOR: 
            case TRACK_SELECTED_SET_AUTO_MONITOR: {
                return TrackHandler.toMidiValue(cursorTrack.doesExist() && cursorTrack.isAutoMonitor());
            }
            case TRACK_SELECTED_TOGGLE_PIN: 
            case TRACK_SELECTED_SET_PIN: {
                return TrackHandler.toMidiValue(cursorTrack.doesExist() && cursorTrack.isPinned());
            }
            case TRACK_1_SET_SEND_1: 
            case TRACK_2_SET_SEND_1: 
            case TRACK_3_SET_SEND_1: 
            case TRACK_4_SET_SEND_1: 
            case TRACK_5_SET_SEND_1: 
            case TRACK_6_SET_SEND_1: 
            case TRACK_7_SET_SEND_1: 
            case TRACK_8_SET_SEND_1: {
                return this.getSendValue(command.ordinal() - FlexiCommand.TRACK_1_SET_SEND_1.ordinal(), 0);
            }
            case TRACK_1_SET_SEND_2: 
            case TRACK_2_SET_SEND_2: 
            case TRACK_3_SET_SEND_2: 
            case TRACK_4_SET_SEND_2: 
            case TRACK_5_SET_SEND_2: 
            case TRACK_6_SET_SEND_2: 
            case TRACK_7_SET_SEND_2: 
            case TRACK_8_SET_SEND_2: {
                return this.getSendValue(command.ordinal() - FlexiCommand.TRACK_1_SET_SEND_2.ordinal(), 1);
            }
            case TRACK_1_SET_SEND_3: 
            case TRACK_2_SET_SEND_3: 
            case TRACK_3_SET_SEND_3: 
            case TRACK_4_SET_SEND_3: 
            case TRACK_5_SET_SEND_3: 
            case TRACK_6_SET_SEND_3: 
            case TRACK_7_SET_SEND_3: 
            case TRACK_8_SET_SEND_3: {
                return this.getSendValue(command.ordinal() - FlexiCommand.TRACK_1_SET_SEND_3.ordinal(), 2);
            }
            case TRACK_1_SET_SEND_4: 
            case TRACK_2_SET_SEND_4: 
            case TRACK_3_SET_SEND_4: 
            case TRACK_4_SET_SEND_4: 
            case TRACK_5_SET_SEND_4: 
            case TRACK_6_SET_SEND_4: 
            case TRACK_7_SET_SEND_4: 
            case TRACK_8_SET_SEND_4: {
                return this.getSendValue(command.ordinal() - FlexiCommand.TRACK_1_SET_SEND_4.ordinal(), 3);
            }
            case TRACK_1_SET_SEND_5: 
            case TRACK_2_SET_SEND_5: 
            case TRACK_3_SET_SEND_5: 
            case TRACK_4_SET_SEND_5: 
            case TRACK_5_SET_SEND_5: 
            case TRACK_6_SET_SEND_5: 
            case TRACK_7_SET_SEND_5: 
            case TRACK_8_SET_SEND_5: {
                return this.getSendValue(command.ordinal() - FlexiCommand.TRACK_1_SET_SEND_5.ordinal(), 4);
            }
            case TRACK_1_SET_SEND_6: 
            case TRACK_2_SET_SEND_6: 
            case TRACK_3_SET_SEND_6: 
            case TRACK_4_SET_SEND_6: 
            case TRACK_5_SET_SEND_6: 
            case TRACK_6_SET_SEND_6: 
            case TRACK_7_SET_SEND_6: 
            case TRACK_8_SET_SEND_6: {
                return this.getSendValue(command.ordinal() - FlexiCommand.TRACK_1_SET_SEND_6.ordinal(), 5);
            }
            case TRACK_1_SET_SEND_7: 
            case TRACK_2_SET_SEND_7: 
            case TRACK_3_SET_SEND_7: 
            case TRACK_4_SET_SEND_7: 
            case TRACK_5_SET_SEND_7: 
            case TRACK_6_SET_SEND_7: 
            case TRACK_7_SET_SEND_7: 
            case TRACK_8_SET_SEND_7: {
                return this.getSendValue(command.ordinal() - FlexiCommand.TRACK_1_SET_SEND_7.ordinal(), 6);
            }
            case TRACK_1_SET_SEND_8: 
            case TRACK_2_SET_SEND_8: 
            case TRACK_3_SET_SEND_8: 
            case TRACK_4_SET_SEND_8: 
            case TRACK_5_SET_SEND_8: 
            case TRACK_6_SET_SEND_8: 
            case TRACK_7_SET_SEND_8: 
            case TRACK_8_SET_SEND_8: {
                return this.getSendValue(command.ordinal() - FlexiCommand.TRACK_1_SET_SEND_8.ordinal(), 7);
            }
            case TRACK_SELECTED_SET_SEND_1: 
            case TRACK_SELECTED_SET_SEND_2: 
            case TRACK_SELECTED_SET_SEND_3: 
            case TRACK_SELECTED_SET_SEND_4: 
            case TRACK_SELECTED_SET_SEND_5: 
            case TRACK_SELECTED_SET_SEND_6: 
            case TRACK_SELECTED_SET_SEND_7: 
            case TRACK_SELECTED_SET_SEND_8: {
                return this.getSendValue(-1, command.ordinal() - FlexiCommand.TRACK_SELECTED_SET_SEND_1.ordinal());
            }
        }
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        ITrackBank trackBank = this.model.getCurrentTrackBank();
        if (trackBank == null) {
            return;
        }
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        boolean isButtonPressed = this.isButtonPressed(knobMode, value);
        switch (command) {
            case TRACK_TOGGLE_TRACK_BANK: {
                if (!isButtonPressed) break;
                this.toggleTrackBankCommand.execute(ButtonEvent.DOWN, 127);
                break;
            }
            case TRACK_ADD_AUDIO_TRACK: {
                if (!isButtonPressed) break;
                this.model.getTrackBank().addChannel(ChannelType.AUDIO);
                break;
            }
            case TRACK_ADD_EFFECT_TRACK: {
                if (!isButtonPressed) break;
                this.model.getApplication().addEffectTrack();
                break;
            }
            case TRACK_ADD_INSTRUMENT_TRACK: {
                if (!isButtonPressed) break;
                this.model.getTrackBank().addChannel(ChannelType.INSTRUMENT);
                break;
            }
            case TRACK_SELECT_PREVIOUS_BANK_PAGE: {
                if (!isButtonPressed) break;
                this.model.getCurrentTrackBank().selectPreviousPage();
                break;
            }
            case TRACK_SELECT_NEXT_BANK_PAGE: {
                if (!isButtonPressed) break;
                this.model.getCurrentTrackBank().selectNextPage();
                break;
            }
            case TRACK_SELECT_PREVIOUS_TRACK: {
                if (!isButtonPressed) break;
                this.clipLauncherNavigator.navigateTracks(true);
                break;
            }
            case TRACK_SELECT_NEXT_TRACK: {
                if (!isButtonPressed) break;
                this.clipLauncherNavigator.navigateTracks(false);
                break;
            }
            case TRACK_SCROLL_BANK_PAGE_BY_1_LEFT: {
                if (!isButtonPressed) break;
                trackBank.scrollBackwards();
                break;
            }
            case TRACK_SCROLL_BANK_PAGE_BY_1_RIGHT: {
                if (!isButtonPressed) break;
                trackBank.scrollForwards();
                break;
            }
            case TRACK_SCROLL_TRACKS: {
                this.scrollTrack(knobMode, value);
                break;
            }
            case TRACK_1_SELECT: 
            case TRACK_2_SELECT: 
            case TRACK_3_SELECT: 
            case TRACK_4_SELECT: 
            case TRACK_5_SELECT: 
            case TRACK_6_SELECT: 
            case TRACK_7_SELECT: 
            case TRACK_8_SELECT: {
                if (!isButtonPressed) break;
                this.clipLauncherNavigator.selectTrack(command.ordinal() - FlexiCommand.TRACK_1_SELECT.ordinal());
                this.mvHelper.notifySelectedTrack();
                break;
            }
            case TRACK_1_TOGGLE_ACTIVE: 
            case TRACK_2_TOGGLE_ACTIVE: 
            case TRACK_3_TOGGLE_ACTIVE: 
            case TRACK_4_TOGGLE_ACTIVE: 
            case TRACK_5_TOGGLE_ACTIVE: 
            case TRACK_6_TOGGLE_ACTIVE: 
            case TRACK_7_TOGGLE_ACTIVE: 
            case TRACK_8_TOGGLE_ACTIVE: {
                if (!isButtonPressed) break;
                ((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_TOGGLE_ACTIVE.ordinal())).toggleIsActivated();
                break;
            }
            case TRACK_1_SET_ACTIVE: 
            case TRACK_2_SET_ACTIVE: 
            case TRACK_3_SET_ACTIVE: 
            case TRACK_4_SET_ACTIVE: 
            case TRACK_5_SET_ACTIVE: 
            case TRACK_6_SET_ACTIVE: 
            case TRACK_7_SET_ACTIVE: 
            case TRACK_8_SET_ACTIVE: {
                if (!isButtonPressed) break;
                ((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_SET_ACTIVE.ordinal())).setIsActivated(value.isPositive());
                break;
            }
            case TRACK_SELECTED_TOGGLE_ACTIVE: {
                if (!isButtonPressed) break;
                cursorTrack.toggleIsActivated();
                break;
            }
            case TRACK_SELECTED_SET_ACTIVE: {
                if (!isButtonPressed) break;
                cursorTrack.setIsActivated(value.isPositive());
                break;
            }
            case TRACK_1_SET_VOLUME: 
            case TRACK_2_SET_VOLUME: 
            case TRACK_3_SET_VOLUME: 
            case TRACK_4_SET_VOLUME: 
            case TRACK_5_SET_VOLUME: 
            case TRACK_6_SET_VOLUME: 
            case TRACK_7_SET_VOLUME: 
            case TRACK_8_SET_VOLUME: {
                this.changeTrackVolume(knobMode, command.ordinal() - FlexiCommand.TRACK_1_SET_VOLUME.ordinal(), value);
                break;
            }
            case TRACK_SELECTED_SET_VOLUME_TRACK: {
                this.changeTrackVolume(knobMode, -1, value);
                break;
            }
            case TRACK_1_SET_PANORAMA: 
            case TRACK_2_SET_PANORAMA: 
            case TRACK_3_SET_PANORAMA: 
            case TRACK_4_SET_PANORAMA: 
            case TRACK_5_SET_PANORAMA: 
            case TRACK_6_SET_PANORAMA: 
            case TRACK_7_SET_PANORAMA: 
            case TRACK_8_SET_PANORAMA: {
                this.changeTrackPanorama(knobMode, command.ordinal() - FlexiCommand.TRACK_1_SET_PANORAMA.ordinal(), value);
                break;
            }
            case TRACK_SELECTED_SET_PANORAMA: {
                this.changeTrackPanorama(knobMode, -1, value);
                break;
            }
            case TRACK_1_TOGGLE_MUTE: 
            case TRACK_2_TOGGLE_MUTE: 
            case TRACK_3_TOGGLE_MUTE: 
            case TRACK_4_TOGGLE_MUTE: 
            case TRACK_5_TOGGLE_MUTE: 
            case TRACK_6_TOGGLE_MUTE: 
            case TRACK_7_TOGGLE_MUTE: 
            case TRACK_8_TOGGLE_MUTE: {
                if (!isButtonPressed) break;
                ((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_TOGGLE_MUTE.ordinal())).toggleMute();
                break;
            }
            case TRACK_1_SET_MUTE: 
            case TRACK_2_SET_MUTE: 
            case TRACK_3_SET_MUTE: 
            case TRACK_4_SET_MUTE: 
            case TRACK_5_SET_MUTE: 
            case TRACK_6_SET_MUTE: 
            case TRACK_7_SET_MUTE: 
            case TRACK_8_SET_MUTE: {
                if (!isButtonPressed) break;
                ((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_SET_MUTE.ordinal())).setMute(value.isPositive());
                break;
            }
            case TRACK_SELECTED_TOGGLE_MUTE: {
                if (!isButtonPressed) break;
                cursorTrack.toggleMute();
                break;
            }
            case TRACK_SELECTED_SET_MUTE: {
                if (!isButtonPressed) break;
                cursorTrack.setMute(value.isPositive());
                break;
            }
            case TRACK_1_TOGGLE_SOLO: 
            case TRACK_2_TOGGLE_SOLO: 
            case TRACK_3_TOGGLE_SOLO: 
            case TRACK_4_TOGGLE_SOLO: 
            case TRACK_5_TOGGLE_SOLO: 
            case TRACK_6_TOGGLE_SOLO: 
            case TRACK_7_TOGGLE_SOLO: 
            case TRACK_8_TOGGLE_SOLO: {
                if (!isButtonPressed) break;
                ((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_TOGGLE_SOLO.ordinal())).toggleSolo();
                break;
            }
            case TRACK_1_SET_SOLO: 
            case TRACK_2_SET_SOLO: 
            case TRACK_3_SET_SOLO: 
            case TRACK_4_SET_SOLO: 
            case TRACK_5_SET_SOLO: 
            case TRACK_6_SET_SOLO: 
            case TRACK_7_SET_SOLO: 
            case TRACK_8_SET_SOLO: {
                if (!isButtonPressed) break;
                ((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_SET_SOLO.ordinal())).setSolo(value.isPositive());
                break;
            }
            case TRACK_SELECTED_TOGGLE_SOLO: {
                if (!isButtonPressed) break;
                cursorTrack.toggleSolo();
                break;
            }
            case TRACK_SELECTED_SET_SOLO: {
                if (!isButtonPressed) break;
                cursorTrack.setSolo(value.isPositive());
                break;
            }
            case TRACK_1_TOGGLE_ARM: 
            case TRACK_2_TOGGLE_ARM: 
            case TRACK_3_TOGGLE_ARM: 
            case TRACK_4_TOGGLE_ARM: 
            case TRACK_5_TOGGLE_ARM: 
            case TRACK_6_TOGGLE_ARM: 
            case TRACK_7_TOGGLE_ARM: 
            case TRACK_8_TOGGLE_ARM: {
                if (!isButtonPressed) break;
                ((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_TOGGLE_ARM.ordinal())).toggleRecArm();
                break;
            }
            case TRACK_1_SET_ARM: 
            case TRACK_2_SET_ARM: 
            case TRACK_3_SET_ARM: 
            case TRACK_4_SET_ARM: 
            case TRACK_5_SET_ARM: 
            case TRACK_6_SET_ARM: 
            case TRACK_7_SET_ARM: 
            case TRACK_8_SET_ARM: {
                if (!isButtonPressed) break;
                ((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_SET_ARM.ordinal())).setRecArm(value.isPositive());
                break;
            }
            case TRACK_SELECTED_TOGGLE_ARM: {
                if (!isButtonPressed) break;
                cursorTrack.toggleRecArm();
                break;
            }
            case TRACK_SELECTED_SET_ARM: {
                if (!isButtonPressed) break;
                cursorTrack.setRecArm(value.isPositive());
                break;
            }
            case TRACK_1_TOGGLE_MONITOR: 
            case TRACK_2_TOGGLE_MONITOR: 
            case TRACK_3_TOGGLE_MONITOR: 
            case TRACK_4_TOGGLE_MONITOR: 
            case TRACK_5_TOGGLE_MONITOR: 
            case TRACK_6_TOGGLE_MONITOR: 
            case TRACK_7_TOGGLE_MONITOR: 
            case TRACK_8_TOGGLE_MONITOR: {
                if (!isButtonPressed) break;
                ((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_TOGGLE_MONITOR.ordinal())).toggleMonitor();
                break;
            }
            case TRACK_1_SET_MONITOR: 
            case TRACK_2_SET_MONITOR: 
            case TRACK_3_SET_MONITOR: 
            case TRACK_4_SET_MONITOR: 
            case TRACK_5_SET_MONITOR: 
            case TRACK_6_SET_MONITOR: 
            case TRACK_7_SET_MONITOR: 
            case TRACK_8_SET_MONITOR: {
                if (!isButtonPressed) break;
                ((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_SET_MONITOR.ordinal())).setMonitor(value.isPositive());
                break;
            }
            case TRACK_SELECTED_TOGGLE_MONITOR: {
                if (!isButtonPressed) break;
                cursorTrack.toggleMonitor();
                break;
            }
            case TRACK_SELECTED_SET_MONITOR: {
                if (!isButtonPressed) break;
                cursorTrack.setMonitor(value.isPositive());
                break;
            }
            case TRACK_1_TOGGLE_AUTO_MONITOR: 
            case TRACK_2_TOGGLE_AUTO_MONITOR: 
            case TRACK_3_TOGGLE_AUTO_MONITOR: 
            case TRACK_4_TOGGLE_AUTO_MONITOR: 
            case TRACK_5_TOGGLE_AUTO_MONITOR: 
            case TRACK_6_TOGGLE_AUTO_MONITOR: 
            case TRACK_7_TOGGLE_AUTO_MONITOR: 
            case TRACK_8_TOGGLE_AUTO_MONITOR: {
                if (!isButtonPressed) break;
                ((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_TOGGLE_AUTO_MONITOR.ordinal())).toggleAutoMonitor();
                break;
            }
            case TRACK_1_SET_AUTO_MONITOR: 
            case TRACK_2_SET_AUTO_MONITOR: 
            case TRACK_3_SET_AUTO_MONITOR: 
            case TRACK_4_SET_AUTO_MONITOR: 
            case TRACK_5_SET_AUTO_MONITOR: 
            case TRACK_6_SET_AUTO_MONITOR: 
            case TRACK_7_SET_AUTO_MONITOR: 
            case TRACK_8_SET_AUTO_MONITOR: {
                if (!isButtonPressed) break;
                ((ITrack)trackBank.getItem(command.ordinal() - FlexiCommand.TRACK_1_SET_AUTO_MONITOR.ordinal())).setAutoMonitor(value.isPositive());
                break;
            }
            case TRACK_SELECTED_TOGGLE_AUTO_MONITOR: {
                if (!isButtonPressed) break;
                cursorTrack.toggleAutoMonitor();
                break;
            }
            case TRACK_SELECTED_SET_AUTO_MONITOR: {
                if (!isButtonPressed) break;
                cursorTrack.setAutoMonitor(value.isPositive());
                break;
            }
            case TRACK_SELECTED_TOGGLE_PIN: {
                if (!isButtonPressed) break;
                cursorTrack.togglePinned();
                break;
            }
            case TRACK_SELECTED_SET_PIN: {
                if (!isButtonPressed) break;
                cursorTrack.setPinned(value.isPositive());
                break;
            }
            case TRACK_1_SET_SEND_1: 
            case TRACK_2_SET_SEND_1: 
            case TRACK_3_SET_SEND_1: 
            case TRACK_4_SET_SEND_1: 
            case TRACK_5_SET_SEND_1: 
            case TRACK_6_SET_SEND_1: 
            case TRACK_7_SET_SEND_1: 
            case TRACK_8_SET_SEND_1: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.TRACK_1_SET_SEND_1.ordinal(), 0, knobMode, value);
                break;
            }
            case TRACK_1_SET_SEND_2: 
            case TRACK_2_SET_SEND_2: 
            case TRACK_3_SET_SEND_2: 
            case TRACK_4_SET_SEND_2: 
            case TRACK_5_SET_SEND_2: 
            case TRACK_6_SET_SEND_2: 
            case TRACK_7_SET_SEND_2: 
            case TRACK_8_SET_SEND_2: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.TRACK_1_SET_SEND_2.ordinal(), 1, knobMode, value);
                break;
            }
            case TRACK_1_SET_SEND_3: 
            case TRACK_2_SET_SEND_3: 
            case TRACK_3_SET_SEND_3: 
            case TRACK_4_SET_SEND_3: 
            case TRACK_5_SET_SEND_3: 
            case TRACK_6_SET_SEND_3: 
            case TRACK_7_SET_SEND_3: 
            case TRACK_8_SET_SEND_3: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.TRACK_1_SET_SEND_3.ordinal(), 2, knobMode, value);
                break;
            }
            case TRACK_1_SET_SEND_4: 
            case TRACK_2_SET_SEND_4: 
            case TRACK_3_SET_SEND_4: 
            case TRACK_4_SET_SEND_4: 
            case TRACK_5_SET_SEND_4: 
            case TRACK_6_SET_SEND_4: 
            case TRACK_7_SET_SEND_4: 
            case TRACK_8_SET_SEND_4: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.TRACK_1_SET_SEND_4.ordinal(), 3, knobMode, value);
                break;
            }
            case TRACK_1_SET_SEND_5: 
            case TRACK_2_SET_SEND_5: 
            case TRACK_3_SET_SEND_5: 
            case TRACK_4_SET_SEND_5: 
            case TRACK_5_SET_SEND_5: 
            case TRACK_6_SET_SEND_5: 
            case TRACK_7_SET_SEND_5: 
            case TRACK_8_SET_SEND_5: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.TRACK_1_SET_SEND_5.ordinal(), 4, knobMode, value);
                break;
            }
            case TRACK_1_SET_SEND_6: 
            case TRACK_2_SET_SEND_6: 
            case TRACK_3_SET_SEND_6: 
            case TRACK_4_SET_SEND_6: 
            case TRACK_5_SET_SEND_6: 
            case TRACK_6_SET_SEND_6: 
            case TRACK_7_SET_SEND_6: 
            case TRACK_8_SET_SEND_6: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.TRACK_1_SET_SEND_6.ordinal(), 5, knobMode, value);
                break;
            }
            case TRACK_1_SET_SEND_7: 
            case TRACK_2_SET_SEND_7: 
            case TRACK_3_SET_SEND_7: 
            case TRACK_4_SET_SEND_7: 
            case TRACK_5_SET_SEND_7: 
            case TRACK_6_SET_SEND_7: 
            case TRACK_7_SET_SEND_7: 
            case TRACK_8_SET_SEND_7: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.TRACK_1_SET_SEND_7.ordinal(), 6, knobMode, value);
                break;
            }
            case TRACK_1_SET_SEND_8: 
            case TRACK_2_SET_SEND_8: 
            case TRACK_3_SET_SEND_8: 
            case TRACK_4_SET_SEND_8: 
            case TRACK_5_SET_SEND_8: 
            case TRACK_6_SET_SEND_8: 
            case TRACK_7_SET_SEND_8: 
            case TRACK_8_SET_SEND_8: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.TRACK_1_SET_SEND_8.ordinal(), 7, knobMode, value);
                break;
            }
            case TRACK_SELECTED_SET_SEND_1: 
            case TRACK_SELECTED_SET_SEND_2: 
            case TRACK_SELECTED_SET_SEND_3: 
            case TRACK_SELECTED_SET_SEND_4: 
            case TRACK_SELECTED_SET_SEND_5: 
            case TRACK_SELECTED_SET_SEND_6: 
            case TRACK_SELECTED_SET_SEND_7: 
            case TRACK_SELECTED_SET_SEND_8: {
                this.changeSendVolume(-1, command.ordinal() - FlexiCommand.TRACK_SELECTED_SET_SEND_1.ordinal(), knobMode, value);
                break;
            }
            default: {
                throw new FlexiHandlerException(command);
            }
        }
    }

    private int getSendValue(int trackIndex, int sendIndex) {
        Optional<ITrack> track = this.getTrack(trackIndex);
        if (track.isEmpty()) {
            return 0;
        }
        ISendBank sendBank = track.get().getSendBank();
        if (sendIndex >= sendBank.getPageSize()) {
            return 0;
        }
        ISend send = (ISend)sendBank.getItem(sendIndex);
        if (send == null) {
            return 0;
        }
        return send.getValue();
    }

    private Optional<ITrack> getTrack(int trackIndex) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        if (tb == null) {
            return Optional.empty();
        }
        if (trackIndex < 0) {
            return tb.getSelectedItem();
        }
        ITrack item = (ITrack)tb.getItem(trackIndex);
        return item.doesExist() ? Optional.of(item) : Optional.empty();
    }

    private void changeTrackVolume(KnobMode knobMode, int trackIndex, MidiValue value) {
        Optional<ITrack> track = this.getTrack(trackIndex);
        if (track.isEmpty()) {
            return;
        }
        int val = value.getValue();
        IParameter volumeParameter = track.get().getVolumeParameter();
        if (TrackHandler.isAbsolute(knobMode)) {
            volumeParameter.setValue(this.getAbsoluteValueChanger(value), val);
        } else {
            volumeParameter.changeValue(this.getRelativeValueChanger(knobMode), val);
        }
    }

    private void changeTrackPanorama(KnobMode knobMode, int trackIndex, MidiValue value) {
        Optional<ITrack> track = this.getTrack(trackIndex);
        if (track.isEmpty()) {
            return;
        }
        int val = value.getValue();
        IParameter panParameter = track.get().getPanParameter();
        if (TrackHandler.isAbsolute(knobMode)) {
            panParameter.setValue(this.getAbsoluteValueChanger(value), val);
        } else {
            panParameter.changeValue(this.getRelativeValueChanger(knobMode), val);
        }
    }

    private void changeSendVolume(int trackIndex, int sendIndex, KnobMode knobMode, MidiValue value) {
        Optional<ITrack> track = this.getTrack(trackIndex);
        if (track.isEmpty()) {
            return;
        }
        ISendBank sendBank = track.get().getSendBank();
        if (sendIndex >= sendBank.getPageSize()) {
            return;
        }
        ISend send = (ISend)sendBank.getItem(sendIndex);
        if (send == null) {
            return;
        }
        int val = value.getValue();
        if (TrackHandler.isAbsolute(knobMode)) {
            send.setValue(this.getAbsoluteValueChanger(value), val);
        } else {
            send.changeValue(this.getRelativeValueChanger(knobMode), val);
        }
    }

    private void scrollTrack(KnobMode knobMode, MidiValue value) {
        if (!TrackHandler.isAbsolute(knobMode)) {
            this.clipLauncherNavigator.navigateTracks(!this.isIncrease(knobMode, value));
        }
    }
}

