/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.parameter.IParameter;

public class DeviceHandler
extends AbstractHandler {
    public DeviceHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.DEVICE_TOGGLE_WINDOW, FlexiCommand.DEVICE_TOGGLE_BYPASS, FlexiCommand.DEVICE_TOGGLE_PIN, FlexiCommand.DEVICE_TOGGLE_EXPAND, FlexiCommand.DEVICE_TOGGLE_PARAMETERS, FlexiCommand.DEVICE_SELECT_PREVIOUS, FlexiCommand.DEVICE_SELECT_NEXT, FlexiCommand.DEVICE_SCROLL_DEVICES, FlexiCommand.DEVICE_SELECT_PREVIOUS_PARAMETER_PAGE, FlexiCommand.DEVICE_SELECT_NEXT_PARAMETER_PAGE, FlexiCommand.DEVICE_SELECT_PARAMETER_PAGE_1, FlexiCommand.DEVICE_SELECT_PARAMETER_PAGE_2, FlexiCommand.DEVICE_SELECT_PARAMETER_PAGE_3, FlexiCommand.DEVICE_SELECT_PARAMETER_PAGE_4, FlexiCommand.DEVICE_SELECT_PARAMETER_PAGE_5, FlexiCommand.DEVICE_SELECT_PARAMETER_PAGE_6, FlexiCommand.DEVICE_SELECT_PARAMETER_PAGE_7, FlexiCommand.DEVICE_SELECT_PARAMETER_PAGE_8, FlexiCommand.DEVICE_SCROLL_PARAMETER_PAGES, FlexiCommand.DEVICE_SELECT_PREVIOUS_PARAMETER_BANK, FlexiCommand.DEVICE_SELECT_NEXT_PARAMETER_BANK, FlexiCommand.DEVICE_SCROLL_PARAMETER_BANKS, FlexiCommand.DEVICE_SET_PARAMETER_1, FlexiCommand.DEVICE_SET_PARAMETER_2, FlexiCommand.DEVICE_SET_PARAMETER_3, FlexiCommand.DEVICE_SET_PARAMETER_4, FlexiCommand.DEVICE_SET_PARAMETER_5, FlexiCommand.DEVICE_SET_PARAMETER_6, FlexiCommand.DEVICE_SET_PARAMETER_7, FlexiCommand.DEVICE_SET_PARAMETER_8, FlexiCommand.DEVICE_TOGGLE_PARAMETER_1, FlexiCommand.DEVICE_TOGGLE_PARAMETER_2, FlexiCommand.DEVICE_TOGGLE_PARAMETER_3, FlexiCommand.DEVICE_TOGGLE_PARAMETER_4, FlexiCommand.DEVICE_TOGGLE_PARAMETER_5, FlexiCommand.DEVICE_TOGGLE_PARAMETER_6, FlexiCommand.DEVICE_TOGGLE_PARAMETER_7, FlexiCommand.DEVICE_TOGGLE_PARAMETER_8, FlexiCommand.DEVICE_RESET_PARAMETER_1, FlexiCommand.DEVICE_RESET_PARAMETER_2, FlexiCommand.DEVICE_RESET_PARAMETER_3, FlexiCommand.DEVICE_RESET_PARAMETER_4, FlexiCommand.DEVICE_RESET_PARAMETER_5, FlexiCommand.DEVICE_RESET_PARAMETER_6, FlexiCommand.DEVICE_RESET_PARAMETER_7, FlexiCommand.DEVICE_RESET_PARAMETER_8};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        switch (command) {
            case DEVICE_TOGGLE_WINDOW: {
                return DeviceHandler.toMidiValue(cursorDevice.isWindowOpen());
            }
            case DEVICE_TOGGLE_BYPASS: {
                return DeviceHandler.toMidiValue(!cursorDevice.isEnabled());
            }
            case DEVICE_TOGGLE_PIN: {
                return DeviceHandler.toMidiValue(cursorDevice.isPinned());
            }
            case DEVICE_TOGGLE_EXPAND: {
                return DeviceHandler.toMidiValue(cursorDevice.isExpanded());
            }
            case DEVICE_TOGGLE_PARAMETERS: {
                return DeviceHandler.toMidiValue(cursorDevice.isParameterPageSectionVisible());
            }
            case DEVICE_SET_PARAMETER_1: 
            case DEVICE_SET_PARAMETER_2: 
            case DEVICE_SET_PARAMETER_3: 
            case DEVICE_SET_PARAMETER_4: 
            case DEVICE_SET_PARAMETER_5: 
            case DEVICE_SET_PARAMETER_6: 
            case DEVICE_SET_PARAMETER_7: 
            case DEVICE_SET_PARAMETER_8: {
                return ((IParameter)cursorDevice.getParameterBank().getItem(command.ordinal() - FlexiCommand.DEVICE_SET_PARAMETER_1.ordinal())).getValue();
            }
            case DEVICE_TOGGLE_PARAMETER_1: 
            case DEVICE_TOGGLE_PARAMETER_2: 
            case DEVICE_TOGGLE_PARAMETER_3: 
            case DEVICE_TOGGLE_PARAMETER_4: 
            case DEVICE_TOGGLE_PARAMETER_5: 
            case DEVICE_TOGGLE_PARAMETER_6: 
            case DEVICE_TOGGLE_PARAMETER_7: 
            case DEVICE_TOGGLE_PARAMETER_8: {
                int value = ((IParameter)cursorDevice.getParameterBank().getItem(command.ordinal() - FlexiCommand.DEVICE_TOGGLE_PARAMETER_1.ordinal())).getValue();
                return DeviceHandler.toMidiValue(value > 0);
            }
            case DEVICE_SELECT_PARAMETER_PAGE_1: 
            case DEVICE_SELECT_PARAMETER_PAGE_2: 
            case DEVICE_SELECT_PARAMETER_PAGE_3: 
            case DEVICE_SELECT_PARAMETER_PAGE_4: 
            case DEVICE_SELECT_PARAMETER_PAGE_5: 
            case DEVICE_SELECT_PARAMETER_PAGE_6: 
            case DEVICE_SELECT_PARAMETER_PAGE_7: 
            case DEVICE_SELECT_PARAMETER_PAGE_8: {
                return ((IParameter)cursorDevice.getParameterBank().getItem(command.ordinal() - FlexiCommand.DEVICE_SELECT_PARAMETER_PAGE_1.ordinal())).isSelected() ? 127 : 0;
            }
        }
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        boolean isButtonPressed = this.isButtonPressed(knobMode, value);
        switch (command) {
            case DEVICE_TOGGLE_WINDOW: {
                if (!isButtonPressed) break;
                cursorDevice.toggleWindowOpen();
                break;
            }
            case DEVICE_TOGGLE_BYPASS: {
                if (!isButtonPressed) break;
                cursorDevice.toggleEnabledState();
                break;
            }
            case DEVICE_TOGGLE_PIN: {
                if (!isButtonPressed) break;
                cursorDevice.togglePinned();
                break;
            }
            case DEVICE_TOGGLE_EXPAND: {
                if (!isButtonPressed) break;
                cursorDevice.toggleExpanded();
                break;
            }
            case DEVICE_TOGGLE_PARAMETERS: {
                if (!isButtonPressed) break;
                cursorDevice.toggleParameterPageSectionVisible();
                break;
            }
            case DEVICE_SELECT_PREVIOUS: {
                if (!isButtonPressed) break;
                cursorDevice.selectPrevious();
                break;
            }
            case DEVICE_SELECT_NEXT: {
                if (!isButtonPressed) break;
                cursorDevice.selectNext();
                break;
            }
            case DEVICE_SCROLL_DEVICES: {
                this.scrollDevice(knobMode, value);
                break;
            }
            case DEVICE_SELECT_PREVIOUS_PARAMETER_PAGE: {
                if (!isButtonPressed) break;
                cursorDevice.getParameterBank().scrollBackwards();
                break;
            }
            case DEVICE_SELECT_NEXT_PARAMETER_PAGE: {
                if (!isButtonPressed) break;
                cursorDevice.getParameterBank().scrollForwards();
                break;
            }
            case DEVICE_SELECT_PARAMETER_PAGE_1: 
            case DEVICE_SELECT_PARAMETER_PAGE_2: 
            case DEVICE_SELECT_PARAMETER_PAGE_3: 
            case DEVICE_SELECT_PARAMETER_PAGE_4: 
            case DEVICE_SELECT_PARAMETER_PAGE_5: 
            case DEVICE_SELECT_PARAMETER_PAGE_6: 
            case DEVICE_SELECT_PARAMETER_PAGE_7: 
            case DEVICE_SELECT_PARAMETER_PAGE_8: {
                if (!isButtonPressed) break;
                cursorDevice.getParameterBank().getPageBank().selectPage(command.ordinal() - FlexiCommand.DEVICE_SELECT_PARAMETER_PAGE_1.ordinal());
                this.mvHelper.notifySelectedDeviceAndParameterPage();
                break;
            }
            case DEVICE_SCROLL_PARAMETER_PAGES: {
                this.scrollParameterPage(knobMode, value);
                break;
            }
            case DEVICE_SELECT_PREVIOUS_PARAMETER_BANK: {
                if (!isButtonPressed) break;
                cursorDevice.getParameterBank().selectPreviousPage();
                break;
            }
            case DEVICE_SELECT_NEXT_PARAMETER_BANK: {
                if (!isButtonPressed) break;
                cursorDevice.getParameterBank().selectNextPage();
                break;
            }
            case DEVICE_SCROLL_PARAMETER_BANKS: {
                this.scrollParameterBank(knobMode, value);
                break;
            }
            case DEVICE_SET_PARAMETER_1: 
            case DEVICE_SET_PARAMETER_2: 
            case DEVICE_SET_PARAMETER_3: 
            case DEVICE_SET_PARAMETER_4: 
            case DEVICE_SET_PARAMETER_5: 
            case DEVICE_SET_PARAMETER_6: 
            case DEVICE_SET_PARAMETER_7: 
            case DEVICE_SET_PARAMETER_8: {
                this.handleParameter(knobMode, command.ordinal() - FlexiCommand.DEVICE_SET_PARAMETER_1.ordinal(), value);
                break;
            }
            case DEVICE_TOGGLE_PARAMETER_1: 
            case DEVICE_TOGGLE_PARAMETER_2: 
            case DEVICE_TOGGLE_PARAMETER_3: 
            case DEVICE_TOGGLE_PARAMETER_4: 
            case DEVICE_TOGGLE_PARAMETER_5: 
            case DEVICE_TOGGLE_PARAMETER_6: 
            case DEVICE_TOGGLE_PARAMETER_7: 
            case DEVICE_TOGGLE_PARAMETER_8: {
                IParameter toggleParam = (IParameter)cursorDevice.getParameterBank().getItem(command.ordinal() - FlexiCommand.DEVICE_TOGGLE_PARAMETER_1.ordinal());
                if (!isButtonPressed) break;
                int v = toggleParam.getValue();
                toggleParam.setValue(v > 0 ? 0 : this.model.getValueChanger().getUpperBound() - 1);
                break;
            }
            case DEVICE_RESET_PARAMETER_1: 
            case DEVICE_RESET_PARAMETER_2: 
            case DEVICE_RESET_PARAMETER_3: 
            case DEVICE_RESET_PARAMETER_4: 
            case DEVICE_RESET_PARAMETER_5: 
            case DEVICE_RESET_PARAMETER_6: 
            case DEVICE_RESET_PARAMETER_7: 
            case DEVICE_RESET_PARAMETER_8: {
                if (!isButtonPressed) break;
                ((IParameter)cursorDevice.getParameterBank().getItem(command.ordinal() - FlexiCommand.DEVICE_RESET_PARAMETER_1.ordinal())).resetValue();
                break;
            }
            default: {
                throw new FlexiHandlerException(command);
            }
        }
    }

    private void scrollParameterPage(KnobMode knobMode, MidiValue value) {
        if (DeviceHandler.isAbsolute(knobMode) || !this.increaseKnobMovement()) {
            return;
        }
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        IParameterBank parameterBank = cursorDevice.getParameterBank();
        if (this.isIncrease(knobMode, value)) {
            parameterBank.scrollForwards();
        } else {
            parameterBank.scrollBackwards();
        }
        this.mvHelper.notifySelectedParameterPage();
    }

    private void scrollParameterBank(KnobMode knobMode, MidiValue value) {
        if (DeviceHandler.isAbsolute(knobMode) || !this.increaseKnobMovement()) {
            return;
        }
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        IParameterBank parameterBank = cursorDevice.getParameterBank();
        if (this.isIncrease(knobMode, value)) {
            parameterBank.selectNextPage();
        } else {
            parameterBank.selectPreviousPage();
        }
        this.mvHelper.notifySelectedParameterPage();
    }

    private void handleParameter(KnobMode knobMode, int index, MidiValue value) {
        IParameter fxParam = (IParameter)this.model.getCursorDevice().getParameterBank().getItem(index);
        int val = value.getValue();
        if (DeviceHandler.isAbsolute(knobMode)) {
            fxParam.setValue(this.getAbsoluteValueChanger(value), val);
        } else {
            fxParam.changeValue(this.getRelativeValueChanger(knobMode), val);
        }
    }

    private void scrollDevice(KnobMode knobMode, MidiValue value) {
        if (DeviceHandler.isAbsolute(knobMode) || !this.increaseKnobMovement()) {
            return;
        }
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        if (this.isIncrease(knobMode, value)) {
            cursorDevice.selectNext();
        } else {
            cursorDevice.selectPrevious();
        }
        this.mvHelper.notifySelectedDevice();
    }
}

