/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.ActionHandler;
import de.mossgrabers.controller.generic.flexihandler.BrowserHandler;
import de.mossgrabers.controller.generic.flexihandler.ClipHandler;
import de.mossgrabers.controller.generic.flexihandler.DeviceHandler;
import de.mossgrabers.controller.generic.flexihandler.EqHandler;
import de.mossgrabers.controller.generic.flexihandler.FxTrackHandler;
import de.mossgrabers.controller.generic.flexihandler.GlobalHandler;
import de.mossgrabers.controller.generic.flexihandler.GrooveHandler;
import de.mossgrabers.controller.generic.flexihandler.InstrumentDeviceHandler;
import de.mossgrabers.controller.generic.flexihandler.LayerHandler;
import de.mossgrabers.controller.generic.flexihandler.LayoutHandler;
import de.mossgrabers.controller.generic.flexihandler.MarkerHandler;
import de.mossgrabers.controller.generic.flexihandler.MasterHandler;
import de.mossgrabers.controller.generic.flexihandler.MidiCCHandler;
import de.mossgrabers.controller.generic.flexihandler.ModesHandler;
import de.mossgrabers.controller.generic.flexihandler.NoteInputHandler;
import de.mossgrabers.controller.generic.flexihandler.ProjectRemotesHandler;
import de.mossgrabers.controller.generic.flexihandler.SceneHandler;
import de.mossgrabers.controller.generic.flexihandler.TrackHandler;
import de.mossgrabers.controller.generic.flexihandler.TrackRemotesHandler;
import de.mossgrabers.controller.generic.flexihandler.TransportHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.ProgramBank;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.controller.valuechanger.OffsetBinaryRelativeValueChanger;
import de.mossgrabers.framework.controller.valuechanger.SignedBit2RelativeValueChanger;
import de.mossgrabers.framework.controller.valuechanger.SignedBitRelativeValueChanger;
import de.mossgrabers.framework.controller.valuechanger.TwosComplementValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.daw.midi.INoteInput;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.mode.device.BrowserMode;
import de.mossgrabers.framework.mode.device.ParameterMode;
import de.mossgrabers.framework.mode.track.TrackMode;
import de.mossgrabers.framework.mode.track.TrackPanMode;
import de.mossgrabers.framework.mode.track.TrackSendMode;
import de.mossgrabers.framework.mode.track.TrackVolumeMode;
import de.mossgrabers.framework.observer.IValueObserver;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.FileEx;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public class GenericFlexiControllerSetup
extends AbstractControllerSetup<GenericFlexiControlSurface, GenericFlexiConfiguration>
implements IValueObserver<FlexiCommand> {
    private static final String PROGRAM_NONE = "None";
    private final IValueChanger absoluteLowResValueChanger = new TwosComplementValueChanger(128, 1);
    private final IValueChanger signedBitRelativeValueChanger = new SignedBitRelativeValueChanger(16384, 100);
    private final IValueChanger signedBit2RelativeValueChanger = new SignedBit2RelativeValueChanger(16384, 100);
    private final IValueChanger offsetBinaryRelativeValueChanger = new OffsetBinaryRelativeValueChanger(16384, 100);
    private final List<ProgramBank> banks = new ArrayList<ProgramBank>();

    public GenericFlexiControllerSetup(IHost host, ISetupFactory factory, ISettingsUI globalSettings, ISettingsUI documentSettings) {
        super(factory, host, globalSettings, documentSettings);
        this.colorManager = new ColorManager();
        this.valueChanger = new TwosComplementValueChanger(16384, 100);
        this.configuration = new GenericFlexiConfiguration(host, this.valueChanger, factory.getArpeggiatorModes());
    }

    @Override
    public void init() {
        super.init();
        Optional<FileEx> programsFileOpt = ((GenericFlexiConfiguration)this.configuration).getProgramsFile();
        if (programsFileOpt.isEmpty()) {
            return;
        }
        try {
            FileEx programsFile = programsFileOpt.get();
            String nameWithoutType = programsFile.getNameWithoutType();
            this.banks.addAll(ProgramBank.parse(programsFile.readUTF8()));
            IEnumSetting[] bankSettings = new IEnumSetting[this.banks.size()];
            int i = 0;
            while (i < this.banks.size()) {
                int bankPos = i++;
                ProgramBank pb = this.banks.get(bankPos);
                String[] programs = pb.getPrograms();
                String[] opts = new String[programs.length + 1];
                System.arraycopy(programs, 0, opts, 1, programs.length);
                opts[0] = PROGRAM_NONE;
                bankSettings[bankPos] = this.documentSettings.getEnumSetting(pb.getName(), nameWithoutType + " Program Banks", opts, opts[0]);
                bankSettings[bankPos].addValueObserver(value -> {
                    int program = pb.lookupProgram((String)value);
                    if (program < 0) {
                        return;
                    }
                    GenericFlexiControlSurface surface = (GenericFlexiControlSurface)this.getSurface();
                    if (surface == null) {
                        return;
                    }
                    IMidiOutput midiOutput = surface.getMidiOutput();
                    if (midiOutput != null) {
                        midiOutput.sendProgramChange(pb.getMidiChannel(), pb.getMSB(), pb.getLSB(), program);
                    }
                    int channel = pb.getMidiChannel();
                    for (int b = 0; b < bankSettings.length; ++b) {
                        if (bankPos == b || this.banks.get(b).getMidiChannel() != channel) continue;
                        bankSettings[b].set(PROGRAM_NONE);
                    }
                });
            }
        }
        catch (IOException ex) {
            this.host.error("Could not load programs file.", ex);
        }
        catch (ParseException ex) {
            this.host.error("Could not parse programs file.", ex);
        }
    }

    @Override
    protected void createScales() {
        this.scales = new Scales(this.valueChanger, 0, 128, 128, 1);
        this.scales.setChromatic(true);
    }

    @Override
    protected void createModel() {
        ModelSetup ms = new ModelSetup();
        ms.setNumResults(1);
        ms.setNumFilterColumnEntries(1);
        ms.enableMainDrumDevice(false);
        ms.setNumMarkers(8);
        ms.enableDevice(DeviceID.EQ);
        ms.enableDevice(DeviceID.FIRST_INSTRUMENT);
        ms.setWantsClipLauncherNavigator(true);
        this.model = this.factory.createModel(this.configuration, this.colorManager, this.valueChanger, this.scales, ms);
        this.model.getTrackBank().setIndication(true);
    }

    @Override
    protected void createSurface() {
        String portName;
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput();
        String keyboardInputName = ((GenericFlexiConfiguration)this.configuration).getKeyboardInputName();
        String string = portName = keyboardInputName.isBlank() ? "Generic Flexi" : keyboardInputName;
        Object inputName = ((GenericFlexiConfiguration)this.configuration).isMPEEnabled() ? portName + " (MPE)" : (((GenericFlexiConfiguration)this.configuration).getKeyboardChannel() < 0 ? null : portName);
        List<String> filters = this.getMidiFilters();
        IMidiInput input = midiAccess.createInput((String)inputName, filters.toArray(new String[filters.size()]));
        GenericFlexiControlSurface surface = new GenericFlexiControlSurface(this.host, (GenericFlexiConfiguration)this.configuration, this.colorManager, output, input);
        this.surfaces.add(surface);
        this.registerHandlers(surface);
        ((GenericFlexiConfiguration)this.configuration).setCommandObserver(this);
    }

    @Override
    protected void createModes() {
        GenericFlexiControlSurface surface = (GenericFlexiControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        modeManager.register(Modes.TRACK, new TrackMode(surface, this.model, true));
        modeManager.register(Modes.VOLUME, new TrackVolumeMode(surface, this.model, true));
        modeManager.register(Modes.PAN, new TrackPanMode(surface, this.model, true));
        for (int i = 0; i < 8; ++i) {
            modeManager.register(Modes.get(Modes.SEND1, i), new TrackSendMode(i, surface, this.model, true));
        }
        modeManager.register(Modes.DEVICE_PARAMS, new ParameterMode("Device", surface, this.model, true, null, surface::isShiftPressed));
        modeManager.register(Modes.BROWSER, new BrowserMode(surface, this.model));
        modeManager.setDefaultID(Modes.VOLUME);
    }

    @Override
    protected void createObservers() {
        super.createObservers();
        GenericFlexiControlSurface surface = (GenericFlexiControlSurface)this.getSurface();
        ((GenericFlexiConfiguration)this.configuration).addSettingObserver(GenericFlexiConfiguration.SLOT_CHANGE, surface::updateKeyTranslation);
        ((GenericFlexiConfiguration)this.configuration).addSettingObserver(GenericFlexiConfiguration.SELECTED_MODE, this::selectMode);
        ITrackBank trackBank = this.model.getTrackBank();
        trackBank.addSelectionObserver((index, selected) -> this.handleTrackChange(selected));
        ITrackBank effectTrackBank = this.model.getEffectTrackBank();
        if (effectTrackBank != null) {
            effectTrackBank.addSelectionObserver((index, selected) -> this.handleTrackChange(selected));
        }
        surface.getModeManager().addChangeListener((oldMode, newMode) -> this.updateIndication());
        this.createNoteRepeatObservers((GenericFlexiConfiguration)this.configuration, surface);
        ((GenericFlexiConfiguration)this.configuration).registerDeactivatedItemsHandler(this.model);
        ((GenericFlexiConfiguration)this.configuration).addSettingObserver(AbstractConfiguration.ENABLED_MPE_ZONES, () -> surface.scheduleTask(() -> {
            INoteInput input = surface.getMidiInput().getDefaultNoteInput();
            IMidiOutput output = surface.getMidiOutput();
            if (input == null || output == null) {
                return;
            }
            boolean mpeEnabled = ((GenericFlexiConfiguration)this.configuration).isMPEEnabled();
            input.enableMPE(mpeEnabled);
            output.configureMPE(176, mpeEnabled ? 15 : 0);
            output.configureMPE(191, 0);
        }, 2000L));
        ((GenericFlexiConfiguration)this.configuration).addSettingObserver(AbstractConfiguration.MPE_PITCHBEND_RANGE, () -> surface.scheduleTask(() -> {
            INoteInput input = surface.getMidiInput().getDefaultNoteInput();
            IMidiOutput output = surface.getMidiOutput();
            if (input == null || output == null) {
                return;
            }
            int mpePitchBendRange = ((GenericFlexiConfiguration)this.configuration).getMPEPitchBendRange();
            input.setMPEPitchBendSensitivity(mpePitchBendRange);
            output.sendMPEPitchbendRange(176, mpePitchBendRange);
        }, 2000L));
        this.activateBrowserObserver(Modes.BROWSER);
    }

    @Override
    public void startup() {
        ((GenericFlexiConfiguration)this.configuration).clearNoteMap();
        GenericFlexiControlSurface surface = (GenericFlexiControlSurface)this.getSurface();
        this.host.scheduleTask(() -> this.host.println(surface.loadFile(((GenericFlexiConfiguration)this.configuration).getFilename())), 2000L);
    }

    @Override
    protected void updateRelativeKnobSensitivity() {
        int knobSensitivity = ((GenericFlexiControlSurface)this.getSurface()).isKnobSensitivitySlow() ? ((GenericFlexiConfiguration)this.configuration).getKnobSensitivitySlow() : ((GenericFlexiConfiguration)this.configuration).getKnobSensitivityDefault();
        this.absoluteLowResValueChanger.setSensitivity(knobSensitivity);
        this.signedBitRelativeValueChanger.setSensitivity(knobSensitivity);
        this.offsetBinaryRelativeValueChanger.setSensitivity(knobSensitivity);
        super.updateRelativeKnobSensitivity();
    }

    private void registerHandlers(GenericFlexiControlSurface surface) {
        surface.registerHandler(new GlobalHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new GrooveHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new TransportHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new LayoutHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new TrackHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new FxTrackHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new MasterHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new DeviceHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new InstrumentDeviceHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new LayerHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new EqHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new BrowserHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new SceneHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new ClipHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new MarkerHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new ModesHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger, this.host));
        surface.registerHandler(new MidiCCHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new NoteInputHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new ProjectRemotesHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new TrackRemotesHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
        surface.registerHandler(new ActionHandler(this.model, surface, (GenericFlexiConfiguration)this.configuration, this.absoluteLowResValueChanger, this.signedBitRelativeValueChanger, this.signedBit2RelativeValueChanger, this.offsetBinaryRelativeValueChanger));
    }

    @Override
    protected void handleTrackChange(boolean isSelected) {
        if (isSelected) {
            this.update(null);
        }
    }

    @Override
    public void update(FlexiCommand value) {
        this.updateIndication();
    }

    private List<String> getMidiFilters() {
        boolean isMPEEndabled = ((GenericFlexiConfiguration)this.configuration).isMPEEnabled();
        int keyboardChannel = ((GenericFlexiConfiguration)this.configuration).getKeyboardChannel();
        if (keyboardChannel < 0 && !isMPEEndabled) {
            return Collections.emptyList();
        }
        String midiChannel = isMPEEndabled || keyboardChannel >= 16 ? "?" : Integer.toHexString(keyboardChannel).toUpperCase(Locale.US);
        ArrayList<String> filters = new ArrayList<String>();
        Collections.addAll(filters, "8" + midiChannel + "????", "9" + midiChannel + "????", "A" + midiChannel + "????", "D" + midiChannel + "????");
        if (((GenericFlexiConfiguration)this.configuration).isKeyboardRouteModulation()) {
            filters.add("B" + midiChannel + "01??");
        }
        if (((GenericFlexiConfiguration)this.configuration).isKeyboardRouteExpression()) {
            filters.add("B" + midiChannel + "0B??");
        }
        if (((GenericFlexiConfiguration)this.configuration).isKeyboardRouteSustain()) {
            filters.add("B" + midiChannel + "40??");
        }
        if (((GenericFlexiConfiguration)this.configuration).isKeyboardRouteTimbre()) {
            filters.add("B" + midiChannel + "4A??");
        }
        if (((GenericFlexiConfiguration)this.configuration).isKeyboardRouteProgramChange()) {
            filters.add("C" + midiChannel + "????");
        }
        if (((GenericFlexiConfiguration)this.configuration).isKeyboardRoutePitchbend() || isMPEEndabled) {
            filters.add("E" + midiChannel + "????");
        }
        return filters;
    }

    private void selectMode() {
        String selectedModeName = ((GenericFlexiConfiguration)this.configuration).getSelectedModeName();
        if (selectedModeName == null) {
            return;
        }
        GenericFlexiControlSurface surface = (GenericFlexiControlSurface)this.getSurface();
        Modes modeID = (Modes)((Object)surface.getModeManager().get(selectedModeName));
        if (modeID != null) {
            surface.activateMode(modeID);
        }
    }

    protected void updateIndication() {
        Set<FlexiCommand> commands = ((GenericFlexiConfiguration)this.configuration).getMappedCommands();
        FlexiCommand[] allCommands = FlexiCommand.values();
        ITrackBank trackBank = this.model.getTrackBank();
        Optional selectedTrack = trackBank.getSelectedItem();
        for (int i = 0; i < trackBank.getPageSize(); ++i) {
            boolean hasTrackSel = selectedTrack.isPresent() && ((ITrack)selectedTrack.get()).getIndex() == i;
            ITrack track = (ITrack)trackBank.getItem(i);
            track.setVolumeIndication(this.testVolumeIndication(commands, allCommands, i, hasTrackSel));
            track.setPanIndication(this.testPanIndication(commands, allCommands, i, hasTrackSel));
            ISendBank sendBank = track.getSendBank();
            int sendPageSize = sendBank.getPageSize();
            for (int j = 0; j < sendPageSize; ++j) {
                ((ISend)sendBank.getItem(j)).setIndication(this.testSendIndication(commands, allCommands, i, hasTrackSel, sendPageSize, j));
            }
        }
        IMasterTrack masterTrack = this.model.getMasterTrack();
        masterTrack.setVolumeIndication(commands.contains((Object)FlexiCommand.MASTER_SET_VOLUME));
        masterTrack.setPanIndication(commands.contains((Object)FlexiCommand.MASTER_SET_PANORAMA));
        IParameterBank parameterBank = this.model.getCursorDevice().getParameterBank();
        for (int i = 0; i < parameterBank.getPageSize(); ++i) {
            ((IParameter)parameterBank.getItem(i)).setIndication(this.testParameterIndication(commands, allCommands, i));
        }
    }

    private boolean testVolumeIndication(Set<FlexiCommand> commands, FlexiCommand[] allCommands, int trackIndex, boolean hasTrackSel) {
        if (hasTrackSel && commands.contains((Object)FlexiCommand.TRACK_SELECTED_SET_VOLUME_TRACK) || commands.contains((Object)allCommands[FlexiCommand.TRACK_1_SET_VOLUME.ordinal() + trackIndex])) {
            return true;
        }
        return commands.contains((Object)allCommands[FlexiCommand.MODES_KNOB1.ordinal() + trackIndex]) && ((GenericFlexiControlSurface)this.getSurface()).getModeManager().isActive(new Modes[]{Modes.VOLUME});
    }

    private boolean testPanIndication(Set<FlexiCommand> commands, FlexiCommand[] allCommands, int trackIndex, boolean hasTrackSel) {
        if (hasTrackSel && commands.contains((Object)FlexiCommand.TRACK_SELECTED_SET_PANORAMA) || commands.contains((Object)allCommands[FlexiCommand.TRACK_1_SET_PANORAMA.ordinal() + trackIndex])) {
            return true;
        }
        return commands.contains((Object)allCommands[FlexiCommand.MODES_KNOB1.ordinal() + trackIndex]) && ((GenericFlexiControlSurface)this.getSurface()).getModeManager().isActive(new Modes[]{Modes.PAN});
    }

    private boolean testSendIndication(Set<FlexiCommand> commands, FlexiCommand[] allCommands, int trackIndex, boolean hasTrackSel, int sendPageSize, int sendIndex) {
        ModeManager modeManager = ((GenericFlexiControlSurface)this.getSurface()).getModeManager();
        if (hasTrackSel && commands.contains((Object)allCommands[FlexiCommand.TRACK_SELECTED_SET_SEND_1.ordinal() + sendIndex]) || modeManager.isActive(new Modes[]{Modes.TRACK}) && sendIndex < 6) {
            return true;
        }
        if (commands.contains((Object)allCommands[FlexiCommand.TRACK_1_SET_SEND_1.ordinal() + sendIndex * sendPageSize + trackIndex])) {
            return true;
        }
        return modeManager.isActive(new Modes[]{Modes.get(Modes.SEND1, sendIndex)});
    }

    private boolean testParameterIndication(Set<FlexiCommand> commands, FlexiCommand[] allCommands, int parameterIndex) {
        if (commands.contains((Object)allCommands[FlexiCommand.DEVICE_SET_PARAMETER_1.ordinal() + parameterIndex])) {
            return true;
        }
        return commands.contains((Object)allCommands[FlexiCommand.MODES_KNOB1.ordinal() + parameterIndex]) && ((GenericFlexiControlSurface)this.getSurface()).getModeManager().isActive(new Modes[]{Modes.DEVICE_PARAMS});
    }
}

