/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic;

import de.mossgrabers.controller.generic.controller.CommandCategory;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.CommandSlot;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IActionSetting;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.configuration.IStringSetting;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.observer.IValueObserver;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.FileEx;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class GenericFlexiConfiguration
extends AbstractConfiguration {
    private static final String TAG_TYPE = "TYPE";
    private static final String TAG_NUMBER = "NUMBER";
    private static final String TAG_MIDI_CHANNEL = "MIDI_CHANNEL";
    private static final String TAG_RESOLUTION = "RESOLUTION";
    private static final String TAG_KNOB_MODE = "KNOB_MODE";
    private static final String TAG_FUNCTION_LAYER = "FUNCTION_LAYER";
    private static final String TAG_SEND_VALUE = "SEND_VALUE";
    private static final String TAG_SEND_VALUE_WHEN_RECEIVED = "SEND_VALUE_WHEN_RECEIVED";
    private static final String TAG_COMMAND = "COMMAND";
    public static final Integer BUTTON_SAVE = 50;
    public static final Integer BUTTON_LOAD = 51;
    public static final Integer ENABLE_MMC = 52;
    public static final Integer SELECTED_MODE = 53;
    private static final String CATEGORY_KEYBOARD = "Keyboard / Pads (requires restart)";
    private static final String CATEGORY_OPTIONS = "Options";
    public static final List<String> OPTIONS_TYPE = List.of("Off", "CC", "Note", "Program Change", "Pitchbend", "MMC");
    static final List<String> NUMBER_NAMES = List.of("00  MMC Reserved for extensions, CC Bank Select (MSB)", "01  MMC Stop, CC Modulation Wheel (MSB)", "02  MMC Play, CC Breath Controller (MSB)", "03  MMC Deferred play, CC Undefined (MSB)", "04  MMC Fast forward, CC Foot Controller (MSB)", "05  MMC Rewind, CC Portamento Time (MSB)", "06  MMC Record strobe, CC Data Entry (MSB)", "07  MMC Record exit, CC Channel Volume (MSB)", "08  MMC Record pause, CC Balance (MSB)", "09  MMC Pause, CC Undefined (MSB)", "10  MMC Eject, CC Pan (MSB)", "11  MMC Chase, CC Expression (MSB)", "12  MMC Command error reset, CC Effect Control 1 (MSB)", "13  MMC MMC reset, CC Effect Control 2 (MSB)", "14  MMC Write, CC Undefined (MSB)", "15  MMC Masked write, CC Undefined (MSB)", "16  MMC Read, CC General Purpose Controller 1 (MSB)", "17  MMC Update, CC General Purpose Controller 2 (MSB)", "18  MMC Locate, CC General Purpose Controller 3 (MSB)", "19  MMC Variable play, CC General Purpose Controller 4 (MSB)", "20  MMC Search, CC Undefined (MSB)", "21  MMC Shuttle, CC Undefined (MSB)", "22  MMC Step, CC Undefined (MSB)", "23  MMC Assign system master, CC Undefined (MSB)", "24  MMC Generator command, CC Undefined (MSB)", "25  MMC Midi time code command, CC Undefined (MSB)", "26  MMC Move, CC Undefined (MSB)", "27  MMC Add, CC Undefined (MSB)", "28  MMC Subtract, CC Undefined (MSB)", "29  MMC Drop frame adjust, CC Undefined (MSB)", "30  MMC Procedure, CC Undefined (MSB)", "31  MMC Event, CC Undefined (MSB)", "32  MMC Group, CC Bank Select (LSB)", "33  MMC Command segment, CC Modulation Wheel (LSB)", "34  MMC Deferred variable play, CC Breath Controller (LSB)", "35  MMC Record strobe variable, CC Undefined (LSB)", "36  CC Foot Controller (LSB)", "37  CC Portamento Time (LSB)", "38  CC Data Entry (LSB)", "39  CC Channel Volume (LSB)", "40  CC Balance (LSB)", "41  CC Undefined (LSB)", "42  CC Pan (LSB)", "43  CC Expression (LSB)", "44  CC Effect Control 1 (LSB)", "45  CC Effect Control 2 (LSB)", "46  CC Undefined (LSB)", "47  CC Undefined (LSB)", "48  CC General Purpose Controller 1 (LSB)", "49  CC General Purpose Controller 2 (LSB)", "50  CC General Purpose Controller 3 (LSB)", "51  CC General Purpose Controller 4 (LSB)", "52  CC Undefined (LSB)", "53  CC Undefined (LSB)", "54  CC Undefined (LSB)", "55  CC Undefined (LSB)", "56  CC Undefined (LSB)", "57  CC Undefined (LSB)", "58  CC Undefined (LSB)", "59  CC Undefined (LSB)", "60  CC Undefined (LSB)", "61  CC Undefined (LSB)", "62  CC Undefined (LSB)", "63  CC Undefined (LSB)", "64  CC Sustain Pedal", "65  CC Portamento On/Off", "66  CC Sostenuto", "67  CC Soft Pedal", "68  CC Legato Footswitch", "69  CC Hold 2", "70  CC Sound Controller 1 - Sound Variation", "71  CC Sound Controller 2 - Timbre/Harmonic Intensity", "72  CC Sound Controller 3 - Release Time", "73  CC Sound Controller 4 - Attack Time", "74  CC Sound Controller 5 - Brightness", "75  CC Sound Controller 6 - Decay Time", "76  CC Sound Controller 7 - Vibrato Rate", "77  CC Sound Controller 8 - Vibrato Depth", "78  CC Sound Controller 9 - Vibrato Delay", "79  CC Sound Controller 10", "80  CC General Purpose 5", "81  CC General Purpose 6", "82  CC General Purpose 7", "83  CC General Purpose 8", "84  CC Portamento Control", "85  CC Undefined", "86  CC Undefined", "87  CC Undefined", "88  CC High Resolution Velocity Prefix", "89  CC Undefined", "90  CC Undefined", "91  CC Effect 1 Depth - Reverb Send Level", "92  CC Effect 2 Depth - Tremolo Depth", "93  CC Effect 3 Depth - Chorus Send Level", "94  CC Effect 4 Depth - Celeste [Detune] Depth", "95  CC Effect 5 Depth - Phaser Depth", "96  CC Data Increment", "97  CC Data Decrement", "98  CC Non-Registered Parameter Number (NRPN) LSB", "99  CC Non-Registered Parameter Number (NRPN) MSB", "100 CC Registered Parameter Number (RPN) LSB", "101 CC Registered Parameter Number (RPN) MSB", "102 CC Undefined", "103 CC Undefined", "104 CC Undefined", "105 CC Undefined", "106 CC Undefined", "107 CC Undefined", "108 CC Undefined", "109 CC Undefined", "110 CC Undefined", "111 CC Undefined", "112 CC Undefined", "113 CC Undefined", "114 CC Undefined", "115 CC Undefined", "116 CC Undefined", "117 CC Undefined", "118 CC Undefined", "119 CC Undefined", "120 CC All Sound Off", "121 CC Reset All Controllers", "122 CC Local On/Off Switch", "123 CC All Notes Off", "124 MMC Wait, CC Omni Mode Off", "125 MMC Resume, CC Omni Mode On", "126 CC Mono Mode", "127 CC Poly Mode");
    private static final List<String> MODES = List.of("Track", "Volume", "Panorama", "Send 1", "Send 2", "Send 3", "Send 4", "Send 5", "Send 6", "Send 7", "Send 8", "Device");
    private static final List<String> KEYBOARD_CHANNELS = List.of("Off", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "All");
    private static final List<String> CONTROLLER_CHANNELS = KEYBOARD_CHANNELS.subList(1, KEYBOARD_CHANNELS.size());
    private static final List<String> OPTIONS_RESOLUTION = List.of("7-bit", "14-bit");
    private static final List<String> FUNCTION_LAYERS = List.of("All", "Layer 1", "Layer 2", "Layer 3", "Layer 4", "Layer 5", "Layer 6", "Layer 7", "Layer 8", "Layer 9", "Layer 10");
    static final Integer SLOT_CHANGE = 1000;
    public static final int NUM_SLOTS = 300;
    private IEnumSetting slotSelectionSetting;
    private IEnumSetting typeSetting;
    private IEnumSetting numberSetting;
    private IEnumSetting midiChannelSetting;
    private IEnumSetting resolutionSetting;
    private IEnumSetting knobModeSetting;
    private IEnumSetting functionLayerSetting;
    private IEnumSetting sendValueSetting;
    private IEnumSetting sendValueWhenReceivedSetting;
    private final List<IEnumSetting> functionSettings = new ArrayList<IEnumSetting>(CommandCategory.values().length);
    private final Map<CommandCategory, IEnumSetting> functionSettingsMap = new EnumMap<CommandCategory, IEnumSetting>(CommandCategory.class);
    private IEnumSetting learnTypeSetting;
    private IEnumSetting learnNumberSetting;
    private IEnumSetting learnMidiChannelSetting;
    private IEnumSetting learnResolutionSetting;
    private IEnumSetting selectedModeSetting;
    private IStringSetting fileSetting;
    private final CommandSlot[] commandSlots = new CommandSlot[300];
    private IValueObserver<FlexiCommand> commandObserver;
    private String filename;
    private final Object syncMapUpdate = new Object();
    private int[] keyMap;
    private int selectedSlot = 0;
    private String learnTypeValue = null;
    private String learnNumberValue = null;
    private String learnMidiChannelValue = null;
    private boolean learnResolution = false;
    private final AtomicBoolean doNotFire = new AtomicBoolean(false);
    private final AtomicBoolean commandIsUpdating = new AtomicBoolean(false);
    private final String[] assignableFunctionActions = new String[8];
    private String selectedMode = MODES.get(0);
    private String keyboardInputName = "Generic Flexi";
    private int keyboardChannel = 0;
    private boolean keyboardRouteTimbre = false;
    private boolean keyboardRouteModulation = true;
    private boolean keyboardRouteExpression = false;
    private boolean keyboardRouteSustain = true;
    private boolean keyboardRouteProgramChange = false;
    private boolean keyboardRoutePitchbend = true;

    public GenericFlexiConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes) {
        super(host, valueChanger, arpeggiatorModes);
        Arrays.fill(this.assignableFunctionActions, "");
        this.dontNotifyAll.add(BUTTON_SAVE);
        this.dontNotifyAll.add(BUTTON_LOAD);
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        CommandCategory[] values;
        String category = "Slot";
        String[] slotEntries = new String[300];
        for (int i = 0; i < 300; ++i) {
            this.commandSlots[i] = new CommandSlot();
            slotEntries[i] = Integer.toString(i + 1);
        }
        this.slotSelectionSetting = globalSettings.getEnumSetting("Selected:", category, slotEntries, slotEntries[0]);
        category = "Use a knob/fader/button then click Set...";
        this.learnTypeSetting = globalSettings.getEnumSetting("Type:", category, OPTIONS_TYPE, OPTIONS_TYPE.get(0));
        this.learnNumberSetting = globalSettings.getEnumSetting("Number:", category, NUMBER_NAMES, NUMBER_NAMES.get(0));
        this.learnMidiChannelSetting = globalSettings.getEnumSetting("Midi Channel:", category, OPTIONS_MIDI_CHANNEL, OPTIONS_MIDI_CHANNEL[0]);
        this.learnResolutionSetting = globalSettings.getEnumSetting("Resolution:", category, OPTIONS_RESOLUTION, OPTIONS_RESOLUTION.get(0));
        this.learnTypeSetting.setEnabled(false);
        this.learnNumberSetting.setEnabled(false);
        this.learnMidiChannelSetting.setEnabled(false);
        this.learnResolutionSetting.setEnabled(false);
        globalSettings.getSignalSetting(" ", category, "Set").addSignalObserver(value -> {
            if (this.learnTypeValue == null) {
                return;
            }
            this.typeSetting.set(this.learnTypeValue);
            this.midiChannelSetting.set(this.learnMidiChannelValue);
            if (OPTIONS_TYPE.get(1).equals(this.learnTypeValue) && this.learnResolution) {
                int number = AbstractConfiguration.lookupIndex(NUMBER_NAMES, this.learnNumberValue);
                if (number >= 32 && number < 64) {
                    this.learnNumberValue = NUMBER_NAMES.get(number - 32);
                } else if (number >= 64) {
                    this.learnResolution = false;
                }
            }
            this.resolutionSetting.set(OPTIONS_RESOLUTION.get(this.learnResolution ? 1 : 0));
            this.numberSetting.set(this.learnNumberValue);
        });
        category = "Selected Slot - MIDI trigger";
        this.typeSetting = globalSettings.getEnumSetting("Type:", category, OPTIONS_TYPE, OPTIONS_TYPE.get(0));
        this.numberSetting = globalSettings.getEnumSetting("Number:", category, NUMBER_NAMES, NUMBER_NAMES.get(0));
        this.midiChannelSetting = globalSettings.getEnumSetting("Midi Channel:", category, CONTROLLER_CHANNELS, CONTROLLER_CHANNELS.get(0));
        this.resolutionSetting = globalSettings.getEnumSetting("Resolution:", category, OPTIONS_RESOLUTION, OPTIONS_RESOLUTION.get(0));
        String[] knobModeLabels = KnobMode.getLabels();
        this.knobModeSetting = globalSettings.getEnumSetting("Knob Mode:", category, knobModeLabels, knobModeLabels[0]);
        this.functionLayerSetting = globalSettings.getEnumSetting("Functions Layer:", category, FUNCTION_LAYERS, FUNCTION_LAYERS.get(0));
        category = "Selected Slot - MIDI device update";
        this.sendValueSetting = globalSettings.getEnumSetting("Send value to device:", category, AbstractConfiguration.ON_OFF_OPTIONS, AbstractConfiguration.ON_OFF_OPTIONS[1]);
        this.sendValueWhenReceivedSetting = globalSettings.getEnumSetting("Send value to device when received (only buttons):", category, AbstractConfiguration.ON_OFF_OPTIONS, AbstractConfiguration.ON_OFF_OPTIONS[1]);
        category = "Selected Slot - Function";
        for (CommandCategory value2 : values = CommandCategory.values()) {
            IEnumSetting fs = GenericFlexiConfiguration.createFunctionSetting(value2, category, globalSettings);
            this.functionSettings.add(fs);
            this.functionSettingsMap.put(value2, fs);
            fs.addValueObserver(this::handleFunctionChange);
        }
        category = "Load / Save";
        this.fileSetting = globalSettings.getStringSetting("Filename", category, -1, "");
        this.filename = (String)this.fileSetting.get();
        this.fileSetting.addValueObserver(value -> {
            this.filename = value;
        });
        globalSettings.getSignalSetting("  ", category, "Save").addSignalObserver(value -> this.notifyObservers(BUTTON_SAVE));
        globalSettings.getSignalSetting("   ", category, "Load").addSignalObserver(value -> this.notifyObservers(BUTTON_LOAD));
        this.learnTypeSetting.set(OPTIONS_TYPE.get(0));
        this.typeSetting.addValueObserver(value -> {
            int type = AbstractConfiguration.lookupIndex(OPTIONS_TYPE, value) - 1;
            this.getSelectedSlot().setType(type);
            int number = AbstractConfiguration.lookupIndex(NUMBER_NAMES, (String)this.numberSetting.get());
            if (type != 3 && (type != 0 || number >= 32)) {
                this.resolutionSetting.set(OPTIONS_RESOLUTION.get(0));
            }
            this.clearNoteMap();
            this.updateVisibility(!OPTIONS_TYPE.get(0).equals(value));
        });
        this.numberSetting.addValueObserver(value -> {
            int numberIndex = AbstractConfiguration.lookupIndex(NUMBER_NAMES, value);
            this.getSelectedSlot().setNumber(numberIndex);
            int type = AbstractConfiguration.lookupIndex(OPTIONS_TYPE, (String)this.typeSetting.get()) - 1;
            if (type == 0 && numberIndex >= 32) {
                this.resolutionSetting.set(OPTIONS_RESOLUTION.get(0));
            }
            this.clearNoteMap();
        });
        this.midiChannelSetting.addValueObserver(value -> {
            this.getSelectedSlot().setMidiChannel(AbstractConfiguration.lookupIndex(CONTROLLER_CHANNELS, value));
            this.clearNoteMap();
        });
        this.resolutionSetting.addValueObserver(value -> {
            boolean isHighRes = OPTIONS_RESOLUTION.get(1).equals(value);
            this.getSelectedSlot().setResolution(OPTIONS_RESOLUTION.get(1).equals(value));
            int type = AbstractConfiguration.lookupIndex(OPTIONS_TYPE, (String)this.typeSetting.get()) - 1;
            if (isHighRes) {
                int number = AbstractConfiguration.lookupIndex(NUMBER_NAMES, (String)this.numberSetting.get());
                if ((type != 0 || number >= 32) && type != 3) {
                    this.resolutionSetting.set(OPTIONS_RESOLUTION.get(0));
                }
            } else if (type == 3) {
                this.resolutionSetting.set(OPTIONS_RESOLUTION.get(1));
            }
        });
        this.knobModeSetting.addValueObserver(value -> {
            this.getSelectedSlot().setKnobMode(KnobMode.lookupByLabel(value));
            this.fixKnobMode();
        });
        this.functionLayerSetting.addValueObserver(value -> this.getSelectedSlot().setFunctionLayer(GenericFlexiConfiguration.lookupIndex(FUNCTION_LAYERS, value) - 1));
        this.sendValueSetting.addValueObserver(value -> this.getSelectedSlot().setSendValue(AbstractConfiguration.lookupIndex(AbstractConfiguration.ON_OFF_OPTIONS, value) > 0));
        this.sendValueWhenReceivedSetting.addValueObserver(value -> this.getSelectedSlot().setSendValueWhenReceived(AbstractConfiguration.lookupIndex(AbstractConfiguration.ON_OFF_OPTIONS, value) > 0));
        IStringSetting keyboardInputNameSetting = globalSettings.getStringSetting("Input Name", CATEGORY_KEYBOARD, 100, "Generic Flexi");
        this.keyboardInputName = (String)keyboardInputNameSetting.get();
        this.activateMPESetting(globalSettings, CATEGORY_KEYBOARD, false);
        IEnumSetting keyboardMidiChannelSetting = globalSettings.getEnumSetting("Midi Channel", CATEGORY_KEYBOARD, KEYBOARD_CHANNELS, KEYBOARD_CHANNELS.get(1));
        this.keyboardChannel = AbstractConfiguration.lookupIndex(KEYBOARD_CHANNELS, (String)keyboardMidiChannelSetting.get()) - 1;
        IEnumSetting routeTimbreSetting = globalSettings.getEnumSetting("Route Timbre (CC74)", CATEGORY_KEYBOARD, AbstractConfiguration.ON_OFF_OPTIONS, AbstractConfiguration.ON_OFF_OPTIONS[0]);
        this.keyboardRouteTimbre = "On".equals(routeTimbreSetting.get());
        IEnumSetting routeModulationSetting = globalSettings.getEnumSetting("Route Modulation (CC01)", CATEGORY_KEYBOARD, AbstractConfiguration.ON_OFF_OPTIONS, AbstractConfiguration.ON_OFF_OPTIONS[1]);
        this.keyboardRouteModulation = "On".equals(routeModulationSetting.get());
        IEnumSetting routeExpressionSetting = globalSettings.getEnumSetting("Route Expression (CC11)", CATEGORY_KEYBOARD, AbstractConfiguration.ON_OFF_OPTIONS, AbstractConfiguration.ON_OFF_OPTIONS[0]);
        this.keyboardRouteExpression = "On".equals(routeExpressionSetting.get());
        IEnumSetting routeSustainSetting = globalSettings.getEnumSetting("Route Sustain (CC64)", CATEGORY_KEYBOARD, AbstractConfiguration.ON_OFF_OPTIONS, AbstractConfiguration.ON_OFF_OPTIONS[1]);
        this.keyboardRouteSustain = "On".equals(routeSustainSetting.get());
        IEnumSetting routeProgramChangeSetting = globalSettings.getEnumSetting("Route Program Changes", CATEGORY_KEYBOARD, AbstractConfiguration.ON_OFF_OPTIONS, AbstractConfiguration.ON_OFF_OPTIONS[0]);
        this.keyboardRouteProgramChange = "On".equals(routeProgramChangeSetting.get());
        IEnumSetting routePitchbendSetting = globalSettings.getEnumSetting("Route Pitchbend", CATEGORY_KEYBOARD, AbstractConfiguration.ON_OFF_OPTIONS, AbstractConfiguration.ON_OFF_OPTIONS[1]);
        this.keyboardRoutePitchbend = "On".equals(routePitchbendSetting.get());
        this.addSettingObserver(ENABLED_MPE_ZONES, () -> {
            boolean isMPEEnabled = this.isMPEEnabled();
            keyboardMidiChannelSetting.setEnabled(!isMPEEnabled);
            routePitchbendSetting.setEnabled(!isMPEEnabled);
        });
        this.selectedModeSetting = globalSettings.getEnumSetting("Selected Mode", CATEGORY_OPTIONS, MODES, MODES.get(0));
        this.selectedModeSetting.addValueObserver(value -> {
            this.selectedMode = value;
            this.notifyObservers(SELECTED_MODE);
        });
        for (int i = 0; i < this.assignableFunctionActions.length; ++i) {
            int pos = i;
            IActionSetting actionSetting = globalSettings.getActionSetting("Action " + (i + 1), CATEGORY_OPTIONS);
            actionSetting.addValueObserver(value -> {
                this.assignableFunctionActions[pos] = (String)actionSetting.get();
            });
        }
        this.activateKnobSpeedSetting(globalSettings);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateNoteRepeatSetting(documentSettings);
        this.activateNewClipLengthSetting(globalSettings);
        this.slotSelectionSetting.addValueObserver(this::selectSlot);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateBehaviourOnStopSetting(globalSettings);
    }

    private void handleFunctionChange(String value) {
        if (this.commandIsUpdating.get()) {
            return;
        }
        if (this.doNotFire.get()) {
            this.doNotFire.set(false);
            return;
        }
        CommandSlot slot = this.getSelectedSlot();
        FlexiCommand oldCommand = slot.getCommand();
        FlexiCommand newCommand = FlexiCommand.lookupByName(value);
        slot.setCommand(newCommand);
        this.fixKnobMode();
        this.notifyCommandObserver();
        CommandCategory oldCategory = oldCommand.getCategory();
        if (oldCategory != null && oldCategory != newCommand.getCategory()) {
            this.doNotFire.set(true);
            this.functionSettingsMap.get((Object)oldCategory).set(FlexiCommand.OFF.getName());
        }
    }

    private void fixKnobMode() {
        CommandSlot slot = this.getSelectedSlot();
        FlexiCommand command = slot.getCommand();
        if (!command.isTrigger()) {
            return;
        }
        if (!AbstractHandler.isAbsolute(slot.getKnobMode()) || slot.getType() == 4) {
            this.knobModeSetting.set(KnobMode.ABSOLUTE.getLabel());
        }
    }

    private CommandSlot getSelectedSlot() {
        return this.commandSlots[this.selectedSlot];
    }

    public void setLearnValues(String type, int number, int midiChannel, boolean isHighRes) {
        this.learnTypeValue = type;
        this.learnNumberValue = NUMBER_NAMES.get(number);
        this.learnMidiChannelValue = Integer.toString(midiChannel + 1);
        this.learnResolution = isHighRes;
        this.learnTypeSetting.set(type);
        this.learnNumberSetting.set(this.learnNumberValue);
        this.learnMidiChannelSetting.set(this.learnMidiChannelValue);
        this.learnResolutionSetting.set(OPTIONS_RESOLUTION.get(this.learnResolution ? 1 : 0));
    }

    public List<CommandSlot> getSlotCommands(int type, int number, int midiChannel) {
        ArrayList<CommandSlot> results = new ArrayList<CommandSlot>();
        for (CommandSlot slot : this.commandSlots) {
            int channel;
            if (slot.getCommand() == FlexiCommand.OFF || slot.getType() != type || type != 3 && slot.getNumber() != number || (channel = slot.getMidiChannel()) != midiChannel && channel != 16) continue;
            results.add(slot);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getNoteMap() {
        Object object = this.syncMapUpdate;
        synchronized (object) {
            if (this.keyMap == null) {
                this.keyMap = Scales.getIdentityMatrix();
                for (CommandSlot slot : this.commandSlots) {
                    int midiChannel;
                    if (slot.getCommand() == FlexiCommand.OFF || slot.getType() != 1 || (midiChannel = slot.getMidiChannel()) != this.keyboardChannel && this.keyboardChannel != 16) continue;
                    this.keyMap[slot.getNumber()] = -1;
                }
            }
            return this.keyMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearNoteMap() {
        Object object = this.syncMapUpdate;
        synchronized (object) {
            this.keyMap = null;
        }
        this.notifyObservers(SLOT_CHANGE);
    }

    public CommandSlot[] getCommandSlots() {
        return this.commandSlots;
    }

    public Set<FlexiCommand> getMappedCommands() {
        HashSet<FlexiCommand> commands = new HashSet<FlexiCommand>();
        for (CommandSlot commandSlot : this.commandSlots) {
            FlexiCommand cmd = commandSlot.getCommand();
            if (cmd == null) continue;
            commands.add(cmd);
        }
        return commands;
    }

    public String getKeyboardInputName() {
        return this.keyboardInputName;
    }

    public int getKeyboardChannel() {
        return this.keyboardChannel;
    }

    public boolean isKeyboardRouteTimbre() {
        return this.keyboardRouteTimbre;
    }

    public boolean isKeyboardRouteModulation() {
        return this.keyboardRouteModulation;
    }

    public boolean isKeyboardRouteExpression() {
        return this.keyboardRouteExpression;
    }

    public boolean isKeyboardRouteSustain() {
        return this.keyboardRouteSustain;
    }

    public boolean isKeyboardRouteProgramChange() {
        return this.keyboardRouteProgramChange;
    }

    public boolean isKeyboardRoutePitchbend() {
        return this.keyboardRoutePitchbend;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.fileSetting.set(filename);
    }

    public Optional<FileEx> getProgramsFile() {
        if (this.filename == null || this.filename.isBlank()) {
            return Optional.empty();
        }
        FileEx file = new FileEx(this.filename);
        String name = file.getNameWithoutType();
        FileEx programsFile = new FileEx(file.getParent(), name + ".programs");
        boolean exists = programsFile.exists();
        this.host.println("Scanning for: " + programsFile.getAbsolutePath() + " (" + (exists ? "present" : "not present") + ")");
        return exists ? Optional.of(programsFile) : Optional.empty();
    }

    public void exportTo(File exportFile) throws IOException {
        Properties props = new Properties();
        for (int i = 0; i < this.commandSlots.length; ++i) {
            String slotName = "SLOT" + i + "_";
            CommandSlot slot = this.commandSlots[i];
            props.put(slotName + TAG_TYPE, Integer.toString(slot.getType()));
            props.put(slotName + TAG_NUMBER, Integer.toString(slot.getNumber()));
            props.put(slotName + TAG_MIDI_CHANNEL, Integer.toString(slot.getMidiChannel()));
            props.put(slotName + TAG_RESOLUTION, Boolean.toString(slot.getResolution()));
            props.put(slotName + TAG_KNOB_MODE, Integer.toString(slot.getKnobMode().ordinal()));
            props.put(slotName + TAG_FUNCTION_LAYER, Integer.toString(slot.getFunctionLayer()));
            props.put(slotName + TAG_COMMAND, slot.getCommand().getName());
            props.put(slotName + TAG_SEND_VALUE, Boolean.toString(slot.isSendValue()));
            props.put(slotName + TAG_SEND_VALUE_WHEN_RECEIVED, Boolean.toString(slot.isSendValueWhenReceived()));
        }
        try (FileWriter writer = new FileWriter(exportFile);){
            props.store(writer, "Generic Flexi");
        }
    }

    public void importFrom(File importFile) throws IOException {
        this.slotSelectionSetting.set("1");
        this.host.scheduleTask(() -> {
            try {
                Properties props = new Properties();
                try (FileReader reader = new FileReader(importFile);){
                    props.load(reader);
                }
                for (int i = 0; i < this.commandSlots.length; ++i) {
                    String slotName = "SLOT" + i + "_";
                    CommandSlot slot = this.commandSlots[i];
                    String typeProperty = props.getProperty(slotName + TAG_TYPE);
                    if (typeProperty == null) continue;
                    int type = Integer.parseInt(typeProperty);
                    FlexiCommand command = FlexiCommand.lookupByName(props.getProperty(slotName + TAG_COMMAND));
                    if (command == FlexiCommand.OFF) {
                        type = -1;
                    }
                    String numberProperty = props.getProperty(slotName + TAG_NUMBER);
                    String midiChannelProperty = props.getProperty(slotName + TAG_MIDI_CHANNEL);
                    String knobModeProperty = props.getProperty(slotName + TAG_KNOB_MODE);
                    String functionLayerProperty = props.getProperty(slotName + TAG_FUNCTION_LAYER);
                    slot.setType(type);
                    slot.setNumber(numberProperty == null ? 0 : Integer.parseInt(numberProperty));
                    slot.setMidiChannel(midiChannelProperty == null ? 0 : Integer.parseInt(midiChannelProperty));
                    slot.setResolution(Boolean.parseBoolean(props.getProperty(slotName + TAG_RESOLUTION)));
                    slot.setKnobMode(GenericFlexiConfiguration.readKnobMode(knobModeProperty));
                    slot.setFunctionLayer(functionLayerProperty == null ? 0 : Integer.parseInt(functionLayerProperty));
                    slot.setCommand(command);
                    slot.setSendValue(Boolean.parseBoolean(props.getProperty(slotName + TAG_SEND_VALUE)));
                    slot.setSendValueWhenReceived(Boolean.parseBoolean(props.getProperty(slotName + TAG_SEND_VALUE_WHEN_RECEIVED)));
                }
            }
            catch (IOException | NumberFormatException ex) {
                this.host.error("Could not import from file.", ex);
                this.host.showNotification("Could not import from file. Check Script Console for detailed error.");
                return;
            }
            this.clearNoteMap();
            this.selectSlot("1");
        }, 1000L);
    }

    public void setCommandObserver(IValueObserver<FlexiCommand> observer) {
        this.commandObserver = observer;
    }

    public String getSelectedModeName() {
        return this.selectedMode;
    }

    public void setSelectedMode(String selectedModeName) {
        this.selectedModeSetting.set(selectedModeName);
    }

    public String getAssignableAction(int index) {
        return this.assignableFunctionActions[index];
    }

    private void selectSlot(String value) {
        this.selectedSlot = Integer.parseInt(value) - 1;
        CommandSlot slot = this.commandSlots[this.selectedSlot];
        this.setType(slot.getType());
        this.setNumber(slot.getNumber());
        this.setMidiChannel(slot.getMidiChannel());
        this.setResolution(slot.getResolution());
        this.setKnobMode(slot.getKnobMode());
        this.setFunctionLayer(slot.getFunctionLayer() + 1);
        this.setSendValue(slot.isSendValue());
        this.setSendValueWhenReceived(slot.isSendValueWhenReceived());
        this.setCommand(slot.getCommand());
    }

    private void updateVisibility(boolean visible) {
        this.numberSetting.setVisible(visible);
        this.midiChannelSetting.setVisible(visible);
        this.resolutionSetting.setVisible(visible);
        this.knobModeSetting.setVisible(visible);
        this.functionLayerSetting.setVisible(visible);
        this.sendValueSetting.setVisible(visible);
        this.sendValueWhenReceivedSetting.setVisible(visible);
        for (IEnumSetting fs : this.functionSettings) {
            fs.setVisible(visible);
        }
    }

    private void setType(int value) {
        this.typeSetting.set(OPTIONS_TYPE.get(value + 1));
    }

    private void setNumber(int value) {
        this.numberSetting.set(NUMBER_NAMES.get(value));
    }

    private void setMidiChannel(int value) {
        this.midiChannelSetting.set(CONTROLLER_CHANNELS.get(value));
    }

    private void setResolution(boolean isHighRes) {
        this.resolutionSetting.set(OPTIONS_RESOLUTION.get(isHighRes ? 1 : 0));
    }

    private void setKnobMode(KnobMode value) {
        this.knobModeSetting.set(value.getLabel());
    }

    private void setFunctionLayer(int functionLayerIndex) {
        this.functionLayerSetting.set(FUNCTION_LAYERS.get(functionLayerIndex));
    }

    private void setSendValue(boolean value) {
        this.sendValueSetting.set(AbstractConfiguration.ON_OFF_OPTIONS[value ? 1 : 0]);
    }

    private void setSendValueWhenReceived(boolean value) {
        this.sendValueWhenReceivedSetting.set(AbstractConfiguration.ON_OFF_OPTIONS[value ? 1 : 0]);
    }

    private void setCommand(FlexiCommand value) {
        CommandCategory category = value.getCategory();
        CommandCategory[] values = CommandCategory.values();
        this.commandIsUpdating.set(true);
        for (int i = 0; i < values.length; ++i) {
            this.functionSettings.get(i).set(category == values[i] ? value.getName() : FlexiCommand.OFF.getName());
        }
        this.host.scheduleTask(() -> this.commandIsUpdating.set(false), 600L);
    }

    private void notifyCommandObserver() {
        if (this.commandObserver != null) {
            this.commandObserver.update(this.getSelectedSlot().getCommand());
        }
    }

    private static IEnumSetting createFunctionSetting(CommandCategory commandCategory, String settingCategory, ISettingsUI settingsUI) {
        ArrayList<String> functionsNames = new ArrayList<String>();
        functionsNames.add(FlexiCommand.OFF.getName());
        for (FlexiCommand command : FlexiCommand.values()) {
            if (command.getCategory() != commandCategory) continue;
            functionsNames.add(command.getName());
        }
        String[] array = functionsNames.toArray(new String[functionsNames.size()]);
        return settingsUI.getEnumSetting(commandCategory.getName() + ":", settingCategory, array, array[0]);
    }

    private static KnobMode readKnobMode(String knobModeProperty) {
        if (knobModeProperty == null) {
            return KnobMode.ABSOLUTE;
        }
        try {
            int knobModeID = Integer.parseInt(knobModeProperty);
            KnobMode[] knobModeValues = KnobMode.values();
            return knobModeID < knobModeValues.length ? knobModeValues[knobModeID] : KnobMode.ABSOLUTE;
        }
        catch (NumberFormatException ex) {
            return KnobMode.ABSOLUTE;
        }
    }
}

