/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.gamepad;

import com.studiohartman.jamepad.ControllerAxis;
import com.studiohartman.jamepad.ControllerButton;
import de.mossgrabers.controller.gamepad.GamepadConfiguration;
import de.mossgrabers.controller.gamepad.controller.GamepadControlSurface;
import de.mossgrabers.controller.gamepad.controller.IGamepadCallback;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.INoteRepeat;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class GamepadFunctionHandler
implements IGamepadCallback {
    private final GamepadControlSurface surface;
    private final IModel model;
    private final GamepadConfiguration configuration;
    private final IMidiInput input;
    private final INoteRepeat noteRepeat;
    private final NewCommand<GamepadControlSurface, GamepadConfiguration> newCommand;
    private final boolean[] playingNotes = new boolean[128];

    public GamepadFunctionHandler(GamepadControlSurface surface, IModel model) {
        this.surface = surface;
        this.model = model;
        this.configuration = (GamepadConfiguration)this.surface.getConfiguration();
        this.input = this.surface.getMidiInput();
        this.noteRepeat = this.input.getDefaultNoteInput().getNoteRepeat();
        this.newCommand = new NewCommand(model, surface);
    }

    @Override
    public void process(ControllerButton button, ButtonEvent event) {
        int function = this.configuration.getFunction(button);
        if (function <= 0) {
            return;
        }
        if (function <= 128) {
            this.handleMidiNote(function, event == ButtonEvent.DOWN ? 1.0 : 0.0);
            return;
        }
        if (function <= 256) {
            double v = event == ButtonEvent.DOWN ? 1.0 : 0.0;
            this.handleMidiCC(function, 0, v, v);
            return;
        }
        switch (function) {
            case 257: {
                this.handleMidiPitchbend(event == ButtonEvent.DOWN ? 1.0f : 0.0f);
                break;
            }
            case 258: {
                this.noteRepeat.setActive(event == ButtonEvent.DOWN);
                break;
            }
            case 259: {
                break;
            }
            case 260: {
                break;
            }
            case 261: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getCursorTrack().selectPrevious();
                break;
            }
            case 262: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getCursorTrack().selectNext();
                break;
            }
            case 263: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getCursorTrack().getSlotBank().selectPreviousItem();
                break;
            }
            case 264: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getCursorTrack().getSlotBank().selectNextItem();
                break;
            }
            case 266: {
                Optional selectedItem = this.model.getCursorTrack().getSlotBank().getSelectedItem();
                if (!selectedItem.isPresent()) break;
                ((ISlot)selectedItem.get()).launch(event == ButtonEvent.DOWN, false);
                break;
            }
            case 265: {
                if (event != ButtonEvent.DOWN) break;
                this.newCommand.execute();
                break;
            }
            case 267: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getTransport().play();
                break;
            }
            case 268: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getTransport().toggleMetronome();
                break;
            }
        }
    }

    @Override
    public void process(ControllerAxis axis, float value) {
        int function = this.configuration.getFunction(axis);
        if (function <= 0) {
            return;
        }
        double positive = Math.abs(value);
        if (function <= 128) {
            this.handleMidiNote(function, positive);
            return;
        }
        if (function <= 256) {
            int functionRange = this.configuration.getFunctionRange(axis);
            this.handleMidiCC(function, functionRange, value, positive);
            return;
        }
        switch (function) {
            case 257: {
                this.handleMidiPitchbend(value);
                break;
            }
            case 258: {
                this.noteRepeat.setActive(positive > 0.5);
                break;
            }
            case 259: {
                Resolution[] values = Resolution.values();
                int resolutionIndex = (int)Math.round(positive * (double)(values.length - 1));
                this.noteRepeat.setPeriod(values[resolutionIndex].getValue());
                break;
            }
            case 260: {
                Resolution[] values2 = Resolution.values();
                int resolutionIndex2 = (int)Math.round(positive * (double)(values2.length - 1));
                this.noteRepeat.setNoteLength(values2[values2.length - 1 - resolutionIndex2].getValue());
                break;
            }
            case 265: 
            case 266: 
            case 267: 
            case 268: {
                break;
            }
        }
    }

    private void handleMidiNote(int index, double value) {
        boolean isOff;
        boolean isOn;
        int note = index - 1;
        boolean bl = isOn = value > 0.9;
        if (isOn && this.playingNotes[note]) {
            return;
        }
        boolean bl2 = isOff = value < 0.09;
        if (isOff && !this.playingNotes[note]) {
            return;
        }
        this.playingNotes[note] = isOn;
        this.input.sendRawMidiEvent(isOn ? 144 : 128, note, isOn ? 127 : 0);
    }

    private void handleMidiCC(int function, int functionRange, double value, double positive) {
        int midiValue;
        switch (functionRange) {
            case 0: {
                midiValue = positive < 0.09 ? 0 : (int)Math.min(127L, Math.max(0L, Math.round(positive * 127.0)));
                break;
            }
            case 1: {
                if (positive < 0.09) {
                    midiValue = 64;
                    break;
                }
                int v = (int)Math.min(63L, Math.max(0L, Math.round(positive * 63.0)));
                midiValue = value < 0.0 ? 63 - v : 64 + v;
                break;
            }
            case 2: {
                if (positive < 0.09) {
                    midiValue = 64;
                    break;
                }
                int v = (int)Math.min(63L, Math.max(0L, Math.round(positive * 63.0)));
                midiValue = value < 0.0 ? 64 + v : 63 - v;
                break;
            }
            default: {
                return;
            }
        }
        this.model.getHost().println("" + midiValue);
        this.input.sendRawMidiEvent(176, function - 129, midiValue);
    }

    private void handleMidiPitchbend(float value) {
        int midiValue = (double)Math.abs(value) < 0.09 ? 8128 : (int)Math.max(Math.min(16383L, Math.round((double)(1.0f + value) / 2.0 * 16383.0)), 0L);
        int msb = midiValue >> 7;
        int lsb = midiValue & 0x7F;
        this.input.sendRawMidiEvent(224, lsb, msb);
    }
}

