/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.electra.one.mode;

import de.mossgrabers.controller.electra.one.controller.ElectraOneColorManager;
import de.mossgrabers.controller.electra.one.controller.ElectraOneControlSurface;
import de.mossgrabers.controller.electra.one.mode.AbstractElectraOneMode;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameter.PlayPositionParameter;
import de.mossgrabers.framework.parameter.TempoParameter;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.EmptyParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.RangeFilterParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class ProjectTrackMode
extends AbstractElectraOneMode {
    private final ITransport transport;
    private final IMasterTrack masterTrack;

    public ProjectTrackMode(ElectraOneControlSurface surface, IModel model) {
        super(6, "Project-Track", surface, model);
        this.transport = this.model.getTransport();
        this.masterTrack = this.model.getMasterTrack();
        BankParameterProvider projectParameterProvider = new BankParameterProvider(this.model.getProject().getParameterBank());
        BankParameterProvider trackParameterProvider = new BankParameterProvider(this.model.getCursorTrack().getParameterBank());
        EmptyParameterProvider emptyParameterProvider = new EmptyParameterProvider(1);
        this.setParameterProvider(new CombinedParameterProvider(emptyParameterProvider, new RangeFilterParameterProvider(projectParameterProvider, 0, 4), new FixedParameterProvider(this.masterTrack.getVolumeParameter()), emptyParameterProvider, new RangeFilterParameterProvider(projectParameterProvider, 4, 4), new FixedParameterProvider(new PlayPositionParameter(model.getValueChanger(), this.transport, surface)), new EmptyParameterProvider(5), new FixedParameterProvider(new TempoParameter(model.getValueChanger(), this.transport, surface)), new EmptyParameterProvider(6), emptyParameterProvider, new RangeFilterParameterProvider(trackParameterProvider, 0, 4), emptyParameterProvider, emptyParameterProvider, new RangeFilterParameterProvider(trackParameterProvider, 4, 4), emptyParameterProvider));
    }

    @Override
    public void onButton(int row, int column, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        switch (row) {
            case 2: {
                if (column >= 5) break;
                this.model.getProject().getParameterBank().getPageBank().selectPage(column);
                break;
            }
            case 3: {
                if (column < 5) {
                    this.model.getCursorTrack().getParameterBank().getPageBank().selectPage(column);
                    break;
                }
                this.transport.tapTempo();
                break;
            }
            case 4: {
                if (column != 5) break;
                this.transport.startRecording();
                break;
            }
            case 5: {
                if (column != 5) break;
                this.transport.play();
                break;
            }
        }
    }

    @Override
    public void updateDisplay() {
        IParameterBank projectParameterBank = this.model.getProject().getParameterBank();
        IParameterBank trackParameterBank = this.model.getCursorTrack().getParameterBank();
        for (int i = 0; i < 8; ++i) {
            IParameter param = (IParameter)projectParameterBank.getItem(i);
            boolean paramExists = param.doesExist();
            int row = i / 4;
            int column = 1 + i % 4;
            this.pageCache.updateElement(row, column, paramExists ? StringUtils.fixASCII(param.getName()) : "", paramExists ? ColorEx.PINK : ColorEx.BLACK, Boolean.TRUE);
            this.pageCache.updateValue(row, column, param.getValue(), paramExists ? StringUtils.optimizeName(StringUtils.fixASCII(param.getDisplayedValue()), 15) : " ");
            param = (IParameter)trackParameterBank.getItem(i);
            paramExists = param.doesExist();
            this.pageCache.updateElement(row += 4, column, paramExists ? StringUtils.fixASCII(param.getName()) : "", paramExists ? ColorEx.MINT : ColorEx.BLACK, Boolean.TRUE);
            this.pageCache.updateValue(row, column, param.getValue(), paramExists ? StringUtils.optimizeName(StringUtils.fixASCII(param.getDisplayedValue()), 15) : " ");
        }
        IParameterPageBank projectPageBank = projectParameterBank.getPageBank();
        IParameterPageBank trackPageBank = trackParameterBank.getPageBank();
        for (int column = 0; column < 5; ++column) {
            String paramPage = (String)projectPageBank.getItem(column);
            boolean isSelected = projectPageBank.getSelectedItemIndex() == column;
            boolean pageExists = !paramPage.isBlank();
            ColorEx color = isSelected ? ElectraOneColorManager.PROJECT_PARAM_PAGE_SELECTED : ElectraOneColorManager.PROJECT_PARAM_PAGE;
            this.pageCache.updateElement(2, column, pageExists ? StringUtils.fixASCII(paramPage) : " ", pageExists ? color : ColorEx.BLACK, Boolean.TRUE);
            paramPage = (String)trackPageBank.getItem(column);
            isSelected = trackPageBank.getSelectedItemIndex() == column;
            pageExists = !paramPage.isBlank();
            color = isSelected ? ElectraOneColorManager.TRACK_PARAM_PAGE_SELECTED : ElectraOneColorManager.TRACK_PARAM_PAGE;
            this.pageCache.updateElement(3, column, pageExists ? StringUtils.fixASCII(paramPage) : " ", pageExists ? color : ColorEx.BLACK, Boolean.TRUE);
        }
        this.pageCache.updateValue(2, 5, 0, this.transport.formatTempo(this.transport.getTempo()));
        this.pageCache.updateColor(0, 0, ColorEx.BLACK);
        this.pageCache.updateColor(1, 0, ColorEx.BLACK);
        this.pageCache.updateColor(4, 0, ColorEx.BLACK);
        this.pageCache.updateColor(5, 0, ColorEx.BLACK);
        this.pageCache.updateElement(0, 0, " ", ColorEx.BLACK, Boolean.FALSE);
        this.pageCache.updateElement(1, 0, " ", ColorEx.BLACK, Boolean.FALSE);
        this.pageCache.updateElement(4, 0, " ", ColorEx.BLACK, Boolean.FALSE);
        this.pageCache.updateElement(5, 0, " ", ColorEx.BLACK, Boolean.FALSE);
        this.pageCache.updateColor(0, 5, this.masterTrack.getColor());
        this.pageCache.updateValue(0, 5, this.masterTrack.getVolume(), StringUtils.optimizeName(StringUtils.fixASCII(this.masterTrack.getVolumeStr()), 15));
        this.pageCache.updateValue(1, 5, 0, StringUtils.optimizeName(StringUtils.fixASCII(this.transport.getBeatText()), 15));
        this.pageCache.updateElement(1, 5, StringUtils.optimizeName(StringUtils.fixASCII(this.transport.getPositionText()), 15), null, null);
        this.pageCache.updateColor(4, 5, this.transport.isRecording() ? ElectraOneColorManager.RECORD_ON : ElectraOneColorManager.RECORD_OFF);
        this.pageCache.updateColor(5, 5, this.transport.isPlaying() ? ElectraOneColorManager.PLAY_ON : ElectraOneColorManager.PLAY_OFF);
        this.pageCache.flush();
    }
}

