/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.electra.one.mode;

import de.mossgrabers.controller.electra.one.controller.ElectraOneColorManager;
import de.mossgrabers.controller.electra.one.controller.ElectraOneControlSurface;
import de.mossgrabers.controller.electra.one.mode.AbstractElectraOneMode;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.EqualizerBandType;
import de.mossgrabers.framework.daw.data.IEqualizerDevice;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameter.PlayPositionParameter;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.EmptyParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Optional;

public class EqualizerMode
extends AbstractElectraOneMode {
    private final ITransport transport;
    private final IMasterTrack masterTrack;
    private final IEqualizerDevice eqDevice;

    public EqualizerMode(ElectraOneControlSurface surface, IModel model) {
        super(3, "Equalizer", surface, model);
        this.transport = this.model.getTransport();
        this.masterTrack = this.model.getMasterTrack();
        this.eqDevice = (IEqualizerDevice)this.model.getSpecificDevice(DeviceID.EQ);
        EmptyParameterProvider emptyProvider = new EmptyParameterProvider(1);
        this.setParameterProvider(new CombinedParameterProvider(emptyProvider, new FixedParameterProvider(this.eqDevice.getTypeParameter(0), this.eqDevice.getFrequencyParameter(0), this.eqDevice.getGainParameter(0), this.eqDevice.getQParameter(0), this.masterTrack.getVolumeParameter()), emptyProvider, new FixedParameterProvider(this.eqDevice.getTypeParameter(1), this.eqDevice.getFrequencyParameter(1), this.eqDevice.getGainParameter(1), this.eqDevice.getQParameter(1), new PlayPositionParameter(model.getValueChanger(), this.transport, surface)), emptyProvider, new FixedParameterProvider(this.eqDevice.getTypeParameter(2), this.eqDevice.getFrequencyParameter(2), this.eqDevice.getGainParameter(2), this.eqDevice.getQParameter(2)), emptyProvider, emptyProvider, new FixedParameterProvider(this.eqDevice.getTypeParameter(3), this.eqDevice.getFrequencyParameter(3), this.eqDevice.getGainParameter(3), this.eqDevice.getQParameter(3)), emptyProvider, emptyProvider, new FixedParameterProvider(this.eqDevice.getTypeParameter(4), this.eqDevice.getFrequencyParameter(4), this.eqDevice.getGainParameter(4), this.eqDevice.getQParameter(4)), emptyProvider, emptyProvider, new FixedParameterProvider(this.eqDevice.getTypeParameter(5), this.eqDevice.getFrequencyParameter(5), this.eqDevice.getGainParameter(5), this.eqDevice.getQParameter(5)), emptyProvider));
    }

    @Override
    public void onButton(int row, int column, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (column == 0) {
            boolean isOff = this.eqDevice.getTypeID(row) == EqualizerBandType.OFF;
            this.eqDevice.setType(row, isOff ? EqualizerBandType.BELL : EqualizerBandType.OFF);
            return;
        }
        if (column == 5) {
            switch (row) {
                case 2: {
                    Optional track = this.model.getCurrentTrackBank().getSelectedItem();
                    if (!track.isPresent()) break;
                    ((ITrack)track.get()).addEqualizerDevice();
                    break;
                }
                case 3: {
                    this.eqDevice.toggleEnabledState();
                    break;
                }
                case 4: {
                    this.transport.startRecording();
                    break;
                }
                case 5: {
                    this.transport.play();
                    break;
                }
            }
        }
    }

    @Override
    public void updateDisplay() {
        for (int row = 0; row < 6; ++row) {
            EqualizerBandType typeID = this.eqDevice.getTypeID(row);
            boolean exists = typeID != EqualizerBandType.OFF;
            this.pageCache.updateColor(row, 0, exists ? ElectraOneColorManager.BAND_ON : ElectraOneColorManager.BAND_OFF);
            IParameter typeParameter = this.eqDevice.getTypeParameter(row);
            IParameter frequencyParameter = this.eqDevice.getFrequencyParameter(row);
            IParameter gainParameter = this.eqDevice.getGainParameter(row);
            IParameter qParameter = this.eqDevice.getQParameter(row);
            this.pageCache.updateValue(row, 1, typeParameter.getValue(), StringUtils.optimizeName(StringUtils.fixASCII(typeParameter.getDisplayedValue()), 15));
            this.pageCache.updateValue(row, 2, frequencyParameter.getValue(), StringUtils.optimizeName(StringUtils.fixASCII(frequencyParameter.getDisplayedValue()), 15));
            this.pageCache.updateValue(row, 3, gainParameter.getValue(), StringUtils.optimizeName(StringUtils.fixASCII(gainParameter.getDisplayedValue()), 15));
            this.pageCache.updateValue(row, 4, qParameter.getValue(), StringUtils.optimizeName(StringUtils.fixASCII(qParameter.getDisplayedValue()), 15));
            this.pageCache.updateElement(row, 2, null, null, Boolean.TRUE);
            this.pageCache.updateElement(row, 3, null, null, Boolean.TRUE);
            this.pageCache.updateElement(row, 4, null, null, Boolean.TRUE);
        }
        this.pageCache.updateColor(3, 5, this.eqDevice.doesExist() && this.eqDevice.isEnabled() ? ElectraOneColorManager.BAND_ON : ElectraOneColorManager.BAND_OFF);
        this.pageCache.updateColor(0, 5, this.masterTrack.getColor());
        this.pageCache.updateValue(0, 5, this.masterTrack.getVolume(), StringUtils.optimizeName(StringUtils.fixASCII(this.masterTrack.getVolumeStr()), 15));
        this.pageCache.updateValue(1, 5, 0, StringUtils.optimizeName(StringUtils.fixASCII(this.transport.getBeatText()), 15));
        this.pageCache.updateElement(1, 5, StringUtils.optimizeName(StringUtils.fixASCII(this.transport.getPositionText()), 15), null, null);
        this.pageCache.updateColor(4, 5, this.transport.isRecording() ? ElectraOneColorManager.RECORD_ON : ElectraOneColorManager.RECORD_OFF);
        this.pageCache.updateColor(5, 5, this.transport.isPlaying() ? ElectraOneColorManager.PLAY_ON : ElectraOneColorManager.PLAY_OFF);
        this.pageCache.flush();
    }
}

