/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.electra.one.mode;

import de.mossgrabers.controller.electra.one.ElectraOneConfiguration;
import de.mossgrabers.controller.electra.one.controller.ElectraOneControlSurface;
import de.mossgrabers.controller.electra.one.mode.PageCache;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.mode.track.DefaultTrackMode;
import java.util.Optional;

public abstract class AbstractElectraOneMode
extends DefaultTrackMode<ElectraOneControlSurface, ElectraOneConfiguration> {
    protected final PageCache pageCache;

    protected AbstractElectraOneMode(int pageIndex, String name, ElectraOneControlSurface surface, IModel model) {
        super(name, surface, model, false, ElectraOneControlSurface.KNOB_IDS);
        this.pageCache = new PageCache(pageIndex, surface);
    }

    @Override
    public void onActivate() {
        this.pageCache.reset();
        super.onActivate();
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        return 0;
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        this.getParameterProvider().get(index).touchValue(isTouched);
    }

    public void setEditing(int controlID, boolean isTouched) {
        int index = this.pageCache.getIndex(controlID);
        if (index < 0 || index >= 36) {
            ((ElectraOneControlSurface)this.surface).getHost().error("Control ID out of bounds: " + controlID);
            return;
        }
        this.onKnobTouch(index, isTouched);
    }

    public Optional<String> getActiveDeviceName() {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        return cursorDevice.doesExist() ? Optional.of(cursorDevice.getName()) : Optional.empty();
    }
}

