/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.arturia.beatstep;

import de.mossgrabers.controller.arturia.beatstep.BeatstepConfiguration;
import de.mossgrabers.controller.arturia.beatstep.command.continuous.KnobRowViewCommand;
import de.mossgrabers.controller.arturia.beatstep.controller.BeatstepColorManager;
import de.mossgrabers.controller.arturia.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.arturia.beatstep.controller.BeatstepPadGrid;
import de.mossgrabers.controller.arturia.beatstep.view.BrowserView;
import de.mossgrabers.controller.arturia.beatstep.view.DeviceView;
import de.mossgrabers.controller.arturia.beatstep.view.DrumView;
import de.mossgrabers.controller.arturia.beatstep.view.PlayView;
import de.mossgrabers.controller.arturia.beatstep.view.SequencerView;
import de.mossgrabers.controller.arturia.beatstep.view.SessionView;
import de.mossgrabers.controller.arturia.beatstep.view.ShiftView;
import de.mossgrabers.controller.arturia.beatstep.view.TrackView;
import de.mossgrabers.framework.command.aftertouch.AftertouchViewCommand;
import de.mossgrabers.framework.command.continuous.PlayPositionCommand;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.valuechanger.OffsetBinaryRelativeValueChanger;
import de.mossgrabers.framework.controller.valuechanger.RelativeEncoding;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.daw.midi.INoteInput;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;
import java.util.Optional;

public class BeatstepControllerSetup
extends AbstractControllerSetup<BeatstepControlSurface, BeatstepConfiguration> {
    private static final int[] DRUM_MATRIX = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public BeatstepControllerSetup(IHost host, ISetupFactory factory, ISettingsUI globalSettings, ISettingsUI documentSettings) {
        super(factory, host, globalSettings, documentSettings);
        this.colorManager = new BeatstepColorManager();
        this.valueChanger = new OffsetBinaryRelativeValueChanger(128, 1);
        this.configuration = new BeatstepConfiguration(host, this.valueChanger, factory.getArpeggiatorModes());
    }

    @Override
    protected void createScales() {
        this.scales = new Scales(this.valueChanger, 36, 52, 8, 2);
        this.scales.setDrumMatrix(DRUM_MATRIX);
        this.scales.setDrumNoteEnd(52);
    }

    @Override
    protected void createModel() {
        ModelSetup ms = new ModelSetup();
        this.model = this.factory.createModel(this.configuration, this.colorManager, this.valueChanger, this.scales, ms);
        ITrackBank trackBank = this.model.getTrackBank();
        trackBank.addSelectionObserver((index, value) -> this.handleTrackChange(value));
        trackBank.setIndication(true);
    }

    @Override
    protected void recallLastView() {
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput();
        IMidiInput input = midiAccess.createInput("Control/Pads", "82????", "92????", "A2????");
        INoteInput seqNoteInput = input.createNoteInput("Hardware Sequencer", "90????", "80????");
        Integer[] table = new Integer[128];
        for (int i = 0; i < 128; ++i) {
            table[i] = i == 7 ? -1 : i;
        }
        seqNoteInput.setKeyTranslationTable(table);
        this.surfaces.add(new BeatstepControlSurface(this.host, this.colorManager, (BeatstepConfiguration)this.configuration, output, input));
    }

    @Override
    protected void createViews() {
        BeatstepControlSurface surface = (BeatstepControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.register(Views.TRACK, new TrackView(surface, this.model));
        viewManager.register(Views.DEVICE, new DeviceView(surface, this.model));
        viewManager.register(Views.PLAY, new PlayView(surface, this.model));
        viewManager.register(Views.DRUM, new DrumView(surface, this.model));
        viewManager.register(Views.SEQUENCER, new SequencerView(surface, this.model));
        viewManager.register(Views.SESSION, new SessionView(surface, this.model));
        viewManager.register(Views.BROWSER, new BrowserView(surface, this.model));
        viewManager.register(Views.SHIFT, new ShiftView(surface, this.model));
    }

    @Override
    protected void createObservers() {
        super.createObservers();
        ((BeatstepControlSurface)this.getSurface()).getViewManager().addChangeListener((previousViewId, activeViewId) -> this.updateIndication());
        this.createScaleObservers((BeatstepConfiguration)this.configuration);
        ((BeatstepConfiguration)this.configuration).registerDeactivatedItemsHandler(this.model);
        this.activateBrowserObserver(Views.BROWSER);
    }

    @Override
    protected BindType getTriggerBindType(ButtonID buttonID) {
        return BindType.NOTE;
    }

    @Override
    protected void registerTriggerCommands() {
        BeatstepControlSurface surface = (BeatstepControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        this.addButton(ButtonID.SHIFT, "Shift", (event, value) -> {
            if (event == ButtonEvent.DOWN) {
                viewManager.setActive(Views.SHIFT);
                return;
            }
            if (event == ButtonEvent.UP) {
                if (viewManager.isActive(new Views[]{Views.SHIFT})) {
                    viewManager.restore();
                }
                BeatstepPadGrid beatstepPadGrid = (BeatstepPadGrid)surface.getPadGrid();
                for (int note = 36; note < 52; ++note) {
                    LightInfo lightInfo = beatstepPadGrid.getLightInfo(note);
                    beatstepPadGrid.lightPad(note, lightInfo.getColor());
                }
            }
        }, 7);
    }

    @Override
    protected void registerContinuousCommands() {
        BeatstepControlSurface surface = (BeatstepControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        for (int i = 0; i < 8; ++i) {
            this.addRelativeKnob(ContinuousID.get(ContinuousID.KNOB1, i), "Knob " + (i + 1), new KnobRowViewCommand(i, this.model, surface), BindType.CC, 2, 20 + i, RelativeEncoding.OFFSET_BINARY);
            this.addRelativeKnob(ContinuousID.get(ContinuousID.DEVICE_KNOB1, i), "Knob " + (i + 9), new KnobRowViewCommand(i + 8, this.model, surface), BindType.CC, 2, 30 + i, RelativeEncoding.OFFSET_BINARY);
        }
        this.addRelativeKnob(ContinuousID.MASTER_KNOB, "Master", new PlayPositionCommand(this.model, surface), BindType.CC, 2, 40, RelativeEncoding.OFFSET_BINARY);
        PlayView playView = (PlayView)viewManager.get(Views.PLAY);
        playView.registerAftertouchCommand(new AftertouchViewCommand(playView, this.model, surface));
    }

    @Override
    protected void layoutControls() {
        BeatstepControlSurface surface = (BeatstepControlSurface)this.getSurface();
        surface.getButton(ButtonID.PAD1).setBounds(145.25, 232.75, 57.0, 55.5);
        surface.getButton(ButtonID.PAD2).setBounds(222.5, 232.75, 57.0, 55.5);
        surface.getButton(ButtonID.PAD3).setBounds(302.75, 232.75, 57.0, 55.5);
        surface.getButton(ButtonID.PAD4).setBounds(382.75, 232.75, 57.0, 55.5);
        surface.getButton(ButtonID.PAD5).setBounds(463.0, 232.75, 57.0, 55.5);
        surface.getButton(ButtonID.PAD6).setBounds(543.0, 232.75, 57.0, 55.5);
        surface.getButton(ButtonID.PAD7).setBounds(623.25, 232.75, 57.0, 55.5);
        surface.getButton(ButtonID.PAD8).setBounds(703.25, 232.75, 57.0, 55.5);
        surface.getButton(ButtonID.PAD9).setBounds(145.25, 151.75, 57.0, 55.5);
        surface.getButton(ButtonID.PAD10).setBounds(222.5, 151.75, 57.0, 55.5);
        surface.getButton(ButtonID.PAD11).setBounds(302.75, 151.75, 57.0, 55.5);
        surface.getButton(ButtonID.PAD12).setBounds(382.75, 151.75, 57.0, 55.5);
        surface.getButton(ButtonID.PAD13).setBounds(463.0, 151.75, 57.0, 55.5);
        surface.getButton(ButtonID.PAD14).setBounds(543.0, 151.75, 57.0, 55.5);
        surface.getButton(ButtonID.PAD15).setBounds(623.25, 151.75, 57.0, 55.5);
        surface.getButton(ButtonID.PAD16).setBounds(703.25, 151.75, 57.0, 55.5);
        surface.getButton(ButtonID.SHIFT).setBounds(45.5, 262.0, 30.25, 30.25);
        surface.getContinuous(ContinuousID.DEVICE_KNOB1).setBounds(155.25, 92.25, 35.0, 32.5);
        surface.getContinuous(ContinuousID.DEVICE_KNOB2).setBounds(237.0, 92.25, 35.0, 32.5);
        surface.getContinuous(ContinuousID.DEVICE_KNOB3).setBounds(318.75, 92.25, 35.0, 32.5);
        surface.getContinuous(ContinuousID.DEVICE_KNOB4).setBounds(400.5, 92.25, 35.0, 32.5);
        surface.getContinuous(ContinuousID.DEVICE_KNOB5).setBounds(482.25, 92.25, 35.0, 32.5);
        surface.getContinuous(ContinuousID.DEVICE_KNOB6).setBounds(564.0, 92.25, 35.0, 32.5);
        surface.getContinuous(ContinuousID.DEVICE_KNOB7).setBounds(646.0, 92.25, 35.0, 32.5);
        surface.getContinuous(ContinuousID.DEVICE_KNOB8).setBounds(727.75, 92.25, 35.0, 32.5);
        surface.getContinuous(ContinuousID.KNOB1).setBounds(155.25, 19.5, 35.0, 32.5);
        surface.getContinuous(ContinuousID.KNOB2).setBounds(237.0, 19.5, 35.0, 32.5);
        surface.getContinuous(ContinuousID.KNOB3).setBounds(318.75, 19.5, 35.0, 32.5);
        surface.getContinuous(ContinuousID.KNOB4).setBounds(400.5, 19.5, 35.0, 32.5);
        surface.getContinuous(ContinuousID.KNOB5).setBounds(482.25, 19.5, 35.0, 32.5);
        surface.getContinuous(ContinuousID.KNOB6).setBounds(564.0, 19.5, 35.0, 32.5);
        surface.getContinuous(ContinuousID.KNOB7).setBounds(646.0, 19.5, 35.0, 32.5);
        surface.getContinuous(ContinuousID.KNOB8).setBounds(727.75, 19.5, 35.0, 32.5);
        surface.getContinuous(ContinuousID.MASTER_KNOB).setBounds(39.75, 30.5, 75.5, 77.75);
    }

    @Override
    public void startup() {
        BeatstepControlSurface surface = (BeatstepControlSurface)this.getSurface();
        surface.getMidiOutput().sendSysex("F0 00 20 6B 7F 42 02 00 01 5E 09 F7");
        surface.getViewManager().setActive(Views.TRACK);
    }

    protected void updateIndication() {
        BeatstepControlSurface surface = (BeatstepControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        boolean isTrack = viewManager.isActive(new Views[]{Views.TRACK});
        boolean isDevice = viewManager.isActive(new Views[]{Views.DEVICE});
        IMasterTrack mt = this.model.getMasterTrack();
        mt.setVolumeIndication(!isDevice);
        ITrackBank tb = this.model.getTrackBank();
        Optional selectedTrack = tb.getSelectedItem();
        ITrackBank tbe = this.model.getEffectTrackBank();
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        boolean isEffect = this.model.isEffectTrackBankActive();
        IParameterBank parameterBank = cursorDevice.getParameterBank();
        for (int i = 0; i < 8; ++i) {
            boolean hasTrackSel = selectedTrack.isPresent() && ((ITrack)selectedTrack.get()).getIndex() == i;
            ITrack track = (ITrack)tb.getItem(i);
            track.setVolumeIndication(!isEffect && hasTrackSel && !isDevice);
            track.setPanIndication(!isEffect && hasTrackSel && !isDevice);
            ISendBank sendBank = track.getSendBank();
            for (int j = 0; j < 6; ++j) {
                ((ISend)sendBank.getItem(j)).setIndication(!isEffect && hasTrackSel && isTrack);
            }
            if (tbe != null) {
                Optional selectedFXTrack = tbe.getSelectedItem();
                boolean hasFXTrackSel = selectedFXTrack.isPresent() && ((ITrack)selectedFXTrack.get()).getIndex() == i;
                ITrack fxTrack = (ITrack)tbe.getItem(i);
                fxTrack.setVolumeIndication(isEffect && hasFXTrackSel && isTrack);
                fxTrack.setPanIndication(isEffect && hasFXTrackSel && isTrack);
            }
            ((IParameter)parameterBank.getItem(i)).setIndication(isDevice);
        }
    }
}

