/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.view;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.controller.akai.fire.view.IFireView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractSessionView;
import de.mossgrabers.framework.view.TransposeView;

public class SessionView
extends AbstractSessionView<FireControlSurface, FireConfiguration>
implements TransposeView,
IFireView {
    public SessionView(FireControlSurface surface, IModel model) {
        super("Session", surface, model, 4, 16, true);
        LightInfo isRecording = new LightInfo(62, 64, false);
        LightInfo isRecordingQueued = new LightInfo(62, 75, true);
        LightInfo isPlaying = new LightInfo(60, 61, false);
        LightInfo isPlayingQueued = new LightInfo(60, 75, true);
        LightInfo hasContent = new LightInfo(68, 59, false);
        LightInfo noContent = new LightInfo(0, -1, false);
        LightInfo recArmed = new LightInfo(63, -1, false);
        this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, hasContent, noContent, recArmed);
        this.birdColorHasContent = hasContent;
        this.birdColorSelected = isPlaying;
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (this.isBirdsEyeActive()) {
            if (velocity == 0) {
                return;
            }
            int index = note - 36;
            int x = index % this.columns;
            int y = this.rows - 1 - index / this.columns;
            this.onGridNoteBirdsEyeView(x, y, 0);
            return;
        }
        super.onGridNote(note, velocity);
    }

    @Override
    public int getSoloButtonColor(int index) {
        ISceneBank sceneBank = this.model.getSceneBank();
        IScene s = (IScene)sceneBank.getItem(index);
        return s.doesExist() && s.isSelected() ? 4 : 0;
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int scene = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        if (scene < 0 || scene >= 4) {
            return 0;
        }
        ISceneBank sceneBank = this.model.getSceneBank();
        IScene s = (IScene)sceneBank.getItem(scene);
        if (!s.doesExist()) {
            return 0;
        }
        return ((FireControlSurface)this.surface).isPressed(buttonID) ? 2 : 1;
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        ITrackBank trackBank = this.model.getCurrentTrackBank();
        if (ButtonID.isSceneButton(buttonID) && event == ButtonEvent.UP && ((FireControlSurface)this.surface).isShiftPressed()) {
            this.setAlternateInteractionUsed(true);
            if (((FireControlSurface)this.surface).isPressed(ButtonID.ALT)) {
                trackBank.stop(false);
                return;
            }
        }
        switch (buttonID) {
            case ARROW_LEFT: {
                if (event != ButtonEvent.DOWN) break;
                trackBank.selectPreviousPage();
                break;
            }
            case ARROW_RIGHT: {
                if (event != ButtonEvent.DOWN) break;
                trackBank.selectNextPage();
                break;
            }
            default: {
                super.onButton(buttonID, event, velocity);
            }
        }
    }

    @Override
    protected boolean isSceneSelectAction() {
        return ((FireControlSurface)this.surface).isPressed(ButtonID.ALT);
    }

    @Override
    protected boolean handleButtonCombinations(ITrack track, ISlot slot) {
        boolean result = super.handleButtonCombinations(track, slot);
        if (result) {
            return true;
        }
        if (this.isButtonCombination(ButtonID.ALT)) {
            slot.select();
            return true;
        }
        if (this.isButtonCombination(ButtonID.STOP)) {
            track.stop(false);
            return true;
        }
        FireConfiguration configuration = (FireConfiguration)((FireControlSurface)this.surface).getConfiguration();
        if (this.isButtonCombination(ButtonID.DELETE) && configuration.isDeleteModeActive()) {
            configuration.toggleDeleteModeActive();
            return true;
        }
        if (this.isButtonCombination(ButtonID.DUPLICATE) && configuration.isDuplicateModeActive() && (!slot.doesExist() || !slot.hasContent())) {
            configuration.toggleDuplicateModeActive();
            return true;
        }
        return false;
    }

    @Override
    protected boolean isButtonCombination(ButtonID buttonID) {
        if (super.isButtonCombination(buttonID)) {
            return true;
        }
        FireConfiguration configuration = (FireConfiguration)((FireControlSurface)this.surface).getConfiguration();
        if (buttonID == ButtonID.DELETE && configuration.isDeleteModeActive()) {
            return true;
        }
        return buttonID == ButtonID.DUPLICATE && configuration.isDuplicateModeActive();
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
    }

    @Override
    public boolean isOctaveUpButtonOn() {
        return false;
    }

    @Override
    public boolean isOctaveDownButtonOn() {
        return false;
    }

    @Override
    public void onSelectKnobValue(int value) {
        ISceneBank sceneBank = this.model.getSceneBank();
        if (this.model.getValueChanger().isIncrease(value)) {
            if (((FireControlSurface)this.surface).isPressed(ButtonID.SELECT)) {
                int index;
                IScene lastItem;
                if (sceneBank.canScrollPageForwards()) {
                    sceneBank.selectNextPage();
                    return;
                }
                int positionOfLastItem = sceneBank.getPositionOfLastItem();
                if (positionOfLastItem >= 0 && !(lastItem = (IScene)sceneBank.getItem(index = positionOfLastItem % sceneBank.getPageSize())).isSelected()) {
                    lastItem.select();
                }
                return;
            }
            sceneBank.scrollForwards();
            this.model.getHost().scheduleTask(() -> {
                ((FireControlSurface)this.surface).println("Pos: " + sceneBank.getScrollPosition());
                ((FireControlSurface)this.surface).println("Track 1 Pos: " + ((ITrack)this.model.getTrackBank().getItem(0)).getSlotBank().getScrollPosition());
                ((FireControlSurface)this.surface).println("CurTrack Pos: " + this.model.getCursorTrack().getSlotBank().getScrollPosition());
            }, 100L);
            return;
        }
        if (((FireControlSurface)this.surface).isPressed(ButtonID.SELECT)) {
            if (sceneBank.canScrollPageBackwards()) {
                sceneBank.selectPreviousPage();
                return;
            }
            IScene firstItem = (IScene)sceneBank.getItem(0);
            if (!firstItem.isSelected()) {
                firstItem.select();
            }
            return;
        }
        sceneBank.scrollBackwards();
    }

    @Override
    public void resetOctave() {
    }
}

