/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.mode;

import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.controller.akai.fire.mode.FireLayerMode;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.bank.ILayerBank;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleChannelsComponent;
import de.mossgrabers.framework.mode.Modes;
import java.util.Optional;

public class FireLayerMixerMode
extends FireLayerMode {
    public FireLayerMixerMode(FireControlSurface surface, IModel model) {
        super("Mixer", surface, model);
    }

    @Override
    public void updateDisplay() {
        boolean isMode;
        int[] values;
        boolean[] selected;
        Object label;
        IGraphicDisplay display;
        block11: {
            int size;
            ILayerBank layerBank;
            block10: {
                this.updateMode();
                display = ((FireControlSurface)this.surface).getGraphicsDisplay();
                IDrumDevice cd = this.model.getDrumDevice();
                layerBank = cd.getLayerBank();
                Optional channelOptional = layerBank.getSelectedItem();
                label = "None";
                if (channelOptional.isPresent()) {
                    IChannel channel = (IChannel)channelOptional.get();
                    label = channel.getPosition() + 1 + ": " + channel.getName(9);
                }
                size = layerBank.getPageSize();
                selected = new boolean[size];
                values = new int[size];
                boolean bl = isMode = this.isAnyKnobTouched() || !this.model.getTransport().isPlaying();
                if (!isMode) break block10;
                switch (this.selectedParameter) {
                    case VOLUME: {
                        for (int i = 0; i < size; ++i) {
                            IChannel channel = (IChannel)layerBank.getItem(i);
                            selected[i] = channel.isSelected();
                            values[i] = channel.getVolume();
                        }
                        break block11;
                    }
                    case PAN: {
                        for (int i = 0; i < size; ++i) {
                            IChannel channel = (IChannel)layerBank.getItem(i);
                            selected[i] = channel.isSelected();
                            values[i] = channel.getPan();
                        }
                        break block11;
                    }
                    case SEND1: 
                    case SEND2: 
                    case SEND3: 
                    case SEND4: 
                    case SEND5: 
                    case SEND6: {
                        int sendIndex = this.selectedParameter.ordinal() - Modes.SEND1.ordinal();
                        for (int i = 0; i < size; ++i) {
                            ISend send;
                            IChannel channel = (IChannel)layerBank.getItem(i);
                            selected[i] = channel.isSelected();
                            ISendBank sendBank = channel.getSendBank();
                            if (sendBank == null || !(send = (ISend)sendBank.getItem(sendIndex)).doesExist()) continue;
                            values[i] = send.getValue();
                        }
                        break block11;
                    }
                }
                break block11;
            }
            for (int i = 0; i < size; ++i) {
                IChannel channel = (IChannel)layerBank.getItem(i);
                selected[i] = channel.isSelected();
                values[i] = channel.getVu();
            }
        }
        display.addElement(new TitleChannelsComponent((String)label, selected, values, this.selectedParameter == Modes.PAN && isMode));
        display.send();
    }
}

