/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.controller;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.controller.FirePadGrid;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.OutputID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.graphics.canvas.component.LabelComponent;

public class FireControlSurface
extends AbstractControlSurface<FireConfiguration> {
    public static final int CC_VOLUME = 16;
    public static final int CC_PAN = 17;
    public static final int CC_FILTER = 18;
    public static final int CC_RESONANCE = 19;
    public static final int CC_SELECT = 118;
    public static final int TOUCH_VOLUME = 16;
    public static final int TOUCH_PAN = 17;
    public static final int TOUCH_FILTER = 18;
    public static final int TOUCH_RESONANCE = 19;
    public static final int SELECT = 25;
    public static final int FIRE_BANK = 26;
    public static final int FIRE_PAT_UP = 31;
    public static final int FIRE_PAT_DOWN = 32;
    public static final int FIRE_BROWSER = 33;
    public static final int FIRE_GRID_LEFT = 34;
    public static final int FIRE_GRID_RIGHT = 35;
    public static final int FIRE_SOLO_1 = 36;
    public static final int FIRE_SOLO_2 = 37;
    public static final int FIRE_SOLO_3 = 38;
    public static final int FIRE_SOLO_4 = 39;
    public static final int FIRE_STEP = 44;
    public static final int FIRE_NOTE = 45;
    public static final int FIRE_DRUM = 46;
    public static final int FIRE_PERFORM = 47;
    public static final int FIRE_SHIFT = 48;
    public static final int FIRE_ALT = 49;
    public static final int FIRE_PATTERN = 50;
    public static final int FIRE_PLAY = 51;
    public static final int FIRE_STOP = 52;
    public static final int FIRE_REC = 53;

    public FireControlSurface(IHost host, ColorManager colorManager, FireConfiguration configuration, IMidiOutput output, IMidiInput input) {
        super(host, configuration, colorManager, output, input, new FirePadGrid(colorManager, output), 306.0, 154.0);
    }

    @Override
    protected void flushHardware() {
        super.flushHardware();
        ((FirePadGrid)this.padGrid).flush();
    }

    @Override
    protected void internalShutdown() {
        IGraphicDisplay display = this.getGraphicsDisplay();
        display.addElement(new LabelComponent("Goodbye", null, ColorEx.BLACK, false, false, LabelComponent.LabelLayout.PLAIN));
        display.send();
        for (int i = 4; i < 8; ++i) {
            this.getLight(OutputID.get(OutputID.LED1, i)).turnOff();
        }
        this.setTrigger(0, 27, 16);
        super.internalShutdown();
    }

    @Override
    public FirePadGrid getPadGrid() {
        return (FirePadGrid)this.padGrid;
    }

    public void configureLEDs() {
        double padBrightness = Math.max(0.1, Math.min(1.0, 0.1 + 0.9 * (double)((FireConfiguration)this.configuration).getPadBrightness() / 100.0));
        double padSaturation = (double)((FireConfiguration)this.configuration).getPadSaturation() / 100.0;
        FirePadGrid padGrid = this.getPadGrid();
        padGrid.configureLEDs(padBrightness, padSaturation);
        for (int i = 0; i < this.padGrid.getRows() * this.padGrid.getCols(); ++i) {
            this.getButton(ButtonID.get(ButtonID.PAD1, i)).getLight().forceFlush();
        }
    }

    @Override
    public boolean isDeletePressed() {
        boolean pressed = this.isPressed(ButtonID.BANK_RIGHT);
        if (pressed) {
            this.setTriggerConsumed(ButtonID.BANK_RIGHT);
        }
        return pressed;
    }

    @Override
    public void setTrigger(BindType bindType, int channel, int cc, int value) {
        this.output.sendCCEx(channel, cc, value);
    }
}

