/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.command.trigger;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.controller.akai.fire.view.SessionView;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class SessionSelectCommand
extends AbstractTriggerCommand<FireControlSurface, FireConfiguration> {
    private Views sessionViewID = Views.SESSION;

    public SessionSelectCommand(IModel model, FireControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ViewManager viewManager = ((FireControlSurface)this.surface).getViewManager();
        if (viewManager.isActive(new Views[]{Views.SESSION})) {
            this.sessionViewID = Views.MIX;
        } else if (viewManager.isActive(new Views[]{Views.MIX})) {
            this.sessionViewID = Views.SESSION;
        }
        viewManager.setActive(this.sessionViewID);
        ((FireControlSurface)this.surface).getDisplay().notify(((IView)viewManager.get(this.sessionViewID)).getName());
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        ViewManager viewManager = ((FireControlSurface)this.surface).getViewManager();
        IView view = (IView)viewManager.get(Views.SESSION);
        if (view instanceof SessionView) {
            SessionView sessionView = (SessionView)view;
            sessionView.toggleBirdsEyeView();
            ((FireControlSurface)this.surface).getDisplay().notify(sessionView.isBirdsEyeActive() ? "Birds Eye" : "Clips");
            if (viewManager.isActive(new Views[]{Views.SHIFT})) {
                viewManager.restore();
            }
            ((FireControlSurface)this.surface).setTriggerConsumed(ButtonID.SHIFT);
        }
    }
}

