/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.view;

import de.mossgrabers.controller.akai.apc.APCConfiguration;
import de.mossgrabers.controller.akai.apc.controller.APCControlSurface;
import de.mossgrabers.controller.akai.apc.mode.NoteMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractDrumExView;

public class DrumView
extends AbstractDrumExView<APCControlSurface, APCConfiguration> {
    public DrumView(APCControlSurface surface, IModel model) {
        super("Drum", surface, model, 2, 3, surface.isMkII());
        this.useExtraToggleButton = false;
        this.buttonSelect = ButtonID.PAD13;
        this.buttonMute = ButtonID.PAD14;
        this.buttonSolo = ButtonID.PAD15;
        this.buttonBrowse = ButtonID.PAD16;
    }

    @Override
    protected void handleSequencerArea(int index, int x, int y, int offsetY, int velocity) {
        if (!this.isActive()) {
            return;
        }
        ModeManager modeManager = ((APCControlSurface)this.surface).getModeManager();
        if (velocity > 0) {
            INoteClip cursorClip = this.getClip();
            int step = this.numColumns * (this.allRows - 1 - y) + x;
            NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), step, offsetY + this.selectedPad);
            StepState state = cursorClip.getStep(notePosition).getState();
            if (state == StepState.START) {
                NoteMode noteMode = (NoteMode)modeManager.get(Modes.NOTE);
                noteMode.setValues(cursorClip, notePosition);
                modeManager.setActive(Modes.NOTE);
            }
        } else {
            if (modeManager.isActive(new Modes[]{Modes.NOTE})) {
                modeManager.restore();
            }
            if (this.isNoteEdited) {
                this.isNoteEdited = false;
                return;
            }
        }
        super.handleSequencerArea(index, x, y, offsetY, velocity);
    }

    @Override
    protected String getPadContentColor(IChannel drumPad) {
        return ((APCControlSurface)this.surface).isMkII() ? DAWColor.getColorID(drumPad.getColor()) : "COLOR_PAD_HAS_CONTENT";
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN || !this.isActive()) {
            return;
        }
        switch (buttonID) {
            case SCENE1: {
                this.changeOctave(event, true, 4);
                break;
            }
            case SCENE2: {
                this.changeOctave(event, false, 4);
                break;
            }
            case SCENE3: {
                this.toggleExtraButtons();
                break;
            }
            case SCENE4: {
                this.onOctaveUp(event);
                break;
            }
            case SCENE5: {
                this.onOctaveDown(event);
                break;
            }
        }
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        if (buttonID == ButtonID.SCENE3) {
            return this.extraButtonsOn ? "BUTTON_STATE_HI" : "BUTTON_STATE_OFF";
        }
        return this.isActive() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF";
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int velocity) {
        boolean isUpPressed = ((APCControlSurface)this.surface).isPressed(ButtonID.ARROW_UP);
        if (isUpPressed || ((APCControlSurface)this.surface).isPressed(ButtonID.ARROW_DOWN)) {
            ((APCControlSurface)this.surface).setTriggerConsumed(isUpPressed ? ButtonID.ARROW_UP : ButtonID.ARROW_DOWN);
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, isUpPressed);
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, velocity);
    }

    public void handleStopButtons(int index) {
        if (this.noteRepeatPeriodOn) {
            this.configuration.setNoteRepeatPeriod(Resolution.values()[index]);
            this.mvHelper.delayDisplay(() -> "Period: " + Resolution.getNameAt(index));
            return;
        }
        if (this.noteRepeatLengthOn) {
            this.configuration.setNoteRepeatLength(Resolution.values()[index]);
            this.mvHelper.delayDisplay(() -> "Note Length: " + Resolution.getNameAt(index));
            return;
        }
        this.setResolutionIndex(index);
    }

    public int getStopButtonColor(int index) {
        if (this.noteRepeatPeriodOn) {
            return this.configuration.getNoteRepeatPeriod().ordinal() == index ? 1 : 0;
        }
        if (this.noteRepeatLengthOn) {
            return this.configuration.getNoteRepeatLength().ordinal() == index ? 1 : 0;
        }
        return this.getResolutionIndex() == index ? 1 : 0;
    }

    @Override
    protected void playNote(int drumPad, int velocity) {
        if (!((APCControlSurface)this.surface).isMkII()) {
            ((APCControlSurface)this.surface).sendMidiEvent(144, drumPad, velocity);
        }
    }
}

