/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.controller;

import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.DAWColor;

public class APCColorManager
extends ColorManager {
    public static final int APC_COLOR_BLACK = 0;
    public static final int APC_COLOR_GREEN = 1;
    public static final int APC_COLOR_GREEN_BLINK = 2;
    public static final int APC_COLOR_RED = 3;
    public static final int APC_COLOR_RED_BLINK = 4;
    public static final int APC_COLOR_YELLOW = 5;
    public static final int APC_COLOR_YELLOW_BLINK = 6;
    public static final int APC_MKII_COLOR_BLACK = 0;
    public static final int APC_MKII_COLOR_GREY_LO = 1;
    public static final int APC_MKII_COLOR_GREY_MD = 103;
    public static final int APC_MKII_COLOR_GREY_LT = 2;
    public static final int APC_MKII_COLOR_WHITE = 3;
    public static final int APC_MKII_COLOR_ROSE = 4;
    public static final int APC_MKII_COLOR_RED_HI = 5;
    public static final int APC_MKII_COLOR_RED = 6;
    public static final int APC_MKII_COLOR_RED_LO = 7;
    public static final int APC_MKII_COLOR_RED_AMBER = 8;
    public static final int APC_MKII_COLOR_AMBER_HI = 9;
    public static final int APC_MKII_COLOR_AMBER = 10;
    public static final int APC_MKII_COLOR_AMBER_LO = 11;
    public static final int APC_MKII_COLOR_AMBER_YELLOW = 12;
    public static final int APC_MKII_COLOR_YELLOW_HI = 13;
    public static final int APC_MKII_COLOR_YELLOW = 14;
    public static final int APC_MKII_COLOR_YELLOW_LO = 15;
    public static final int APC_MKII_COLOR_YELLOW_LIME = 16;
    public static final int APC_MKII_COLOR_LIME_HI = 17;
    public static final int APC_MKII_COLOR_LIME = 18;
    public static final int APC_MKII_COLOR_LIME_LO = 19;
    public static final int APC_MKII_COLOR_LIME_GREEN = 20;
    public static final int APC_MKII_COLOR_GREEN_HI = 21;
    public static final int APC_MKII_COLOR_GREEN = 22;
    public static final int APC_MKII_COLOR_GREEN_LO = 23;
    public static final int APC_MKII_COLOR_GREEN_SPRING = 24;
    public static final int APC_MKII_COLOR_SPRING_HI = 25;
    public static final int APC_MKII_COLOR_SPRING = 26;
    public static final int APC_MKII_COLOR_SPRING_LO = 27;
    public static final int APC_MKII_COLOR_SPRING_TURQUOISE = 28;
    public static final int APC_MKII_COLOR_TURQUOISE_LO = 29;
    public static final int APC_MKII_COLOR_TURQUOISE = 30;
    public static final int APC_MKII_COLOR_TURQUOISE_HI = 31;
    public static final int APC_MKII_COLOR_TURQUOISE_CYAN = 32;
    public static final int APC_MKII_COLOR_CYAN_HI = 33;
    public static final int APC_MKII_COLOR_CYAN = 34;
    public static final int APC_MKII_COLOR_CYAN_LO = 35;
    public static final int APC_MKII_COLOR_CYAN_SKY = 36;
    public static final int APC_MKII_COLOR_SKY_HI = 37;
    public static final int APC_MKII_COLOR_SKY = 38;
    public static final int APC_MKII_COLOR_SKY_LO = 39;
    public static final int APC_MKII_COLOR_SKY_OCEAN = 40;
    public static final int APC_MKII_COLOR_OCEAN_HI = 41;
    public static final int APC_MKII_COLOR_OCEAN = 42;
    public static final int APC_MKII_COLOR_OCEAN_LO = 43;
    public static final int APC_MKII_COLOR_OCEAN_BLUE = 44;
    public static final int APC_MKII_COLOR_BLUE_HI = 45;
    public static final int APC_MKII_COLOR_BLUE = 46;
    public static final int APC_MKII_COLOR_BLUE_LO = 47;
    public static final int APC_MKII_COLOR_BLUE_ORCHID = 48;
    public static final int APC_MKII_COLOR_ORCHID_HI = 49;
    public static final int APC_MKII_COLOR_ORCHID = 50;
    public static final int APC_MKII_COLOR_ORCHID_LO = 51;
    public static final int APC_MKII_COLOR_ORCHID_MAGENTA = 52;
    public static final int APC_MKII_COLOR_MAGENTA_HI = 53;
    public static final int APC_MKII_COLOR_MAGENTA = 54;
    public static final int APC_MKII_COLOR_MAGENTA_LO = 55;
    public static final int APC_MKII_COLOR_MAGENTA_PINK = 56;
    public static final int APC_MKII_COLOR_PINK_HI = 57;
    public static final int APC_MKII_COLOR_PINK = 58;
    public static final int APC_MKII_COLOR_PINK_LO = 59;
    public static final String COLOR_VIEW_SELECTED = "COLOR_VIEW_SELECTED";
    public static final String COLOR_VIEW_UNSELECTED = "COLOR_VIEW_UNSELECTED";
    public static final String COLOR_VIEW_OFF = "COLOR_VIEW_OFF";
    public static final String COLOR_KEY_WHITE = "COLOR_KEY_WHITE";
    public static final String COLOR_KEY_BLACK = "COLOR_KEY_BLACK";
    public static final String COLOR_KEY_SELECTED = "COLOR_KEY_SELECTED";
    public static final String BUTTON_STATE_BLINK = "BUTTON_STATE_BLINK";
    private final boolean isMkII;

    public APCColorManager(boolean isMkII) {
        this.isMkII = isMkII;
        this.registerColorIndex("SCALE_COLOR_OFF", isMkII ? 0 : 0);
        this.registerColorIndex("SCALE_COLOR_OCTAVE", isMkII ? 41 : 5);
        this.registerColorIndex("SCALE_COLOR_NOTE", isMkII ? 3 : 0);
        this.registerColorIndex("SCALE_COLOR_OUT_OF_SCALE", isMkII ? 0 : 0);
        this.registerColorIndex("BUTTON_COLOR_OFF", isMkII ? 0 : 0);
        this.registerColorIndex("COLOR_SCENE", isMkII ? 22 : 1);
        this.registerColorIndex("COLOR_SELECTED_SCENE", isMkII ? 21 : 2);
        this.registerColorIndex("COLOR_SELECTED_OFF", isMkII ? 0 : 0);
        this.registerColorIndex("COLOR_STEP_HILITE_NO_CONTENT", isMkII ? 21 : 1);
        this.registerColorIndex("COLOR_STEP_HILITE_CONTENT", isMkII ? 23 : 1);
        this.registerColorIndex("COLOR_STEP_MUTED", isMkII ? 103 : 1);
        this.registerColorIndex("COLOR_STEP_MUTED_CONT", isMkII ? 1 : 1);
        this.registerColorIndex("COLOR_STEP_SELECTED", isMkII ? 14 : 1);
        this.registerColorIndex("COLOR_NO_CONTENT", isMkII ? 0 : 0);
        this.registerColorIndex("COLOR_NO_CONTENT_4", isMkII ? 0 : 0);
        this.registerColorIndex("COLOR_CONTENT", isMkII ? 45 : 3);
        this.registerColorIndex("COLOR_CONTENT_CONT", isMkII ? 47 : 3);
        this.registerColorIndex("COLOR_PAGE", isMkII ? 3 : 1);
        this.registerColorIndex("COLOR_ACTIVE_PAGE", isMkII ? 21 : 5);
        this.registerColorIndex("COLOR_SELECTED_PAGE", isMkII ? 47 : 3);
        this.registerColorIndex("COLOR_PAD_OFF", isMkII ? 0 : 0);
        this.registerColorIndex("COLOR_PAD_RECORD", isMkII ? 5 : 3);
        this.registerColorIndex("COLOR_PAD_PLAY", isMkII ? 21 : 1);
        this.registerColorIndex("COLOR_PAD_SELECTED", isMkII ? 45 : 6);
        this.registerColorIndex("COLOR_PAD_MUTED", isMkII ? 11 : 0);
        this.registerColorIndex("COLOR_PAD_HAS_CONTENT", isMkII ? 13 : 5);
        this.registerColorIndex("COLOR_PAD_NO_CONTENT", isMkII ? 15 : 0);
        this.registerColorIndex("COLOR_EX_SELECT_ON", isMkII ? 3 : 2);
        this.registerColorIndex("COLOR_EX_SELECT_OFF", isMkII ? 1 : 1);
        this.registerColorIndex("COLOR_EX_MUTE_ON", isMkII ? 13 : 4);
        this.registerColorIndex("COLOR_EX_MUTE_OFF", isMkII ? 15 : 3);
        this.registerColorIndex("COLOR_EX_SOLO_ON", isMkII ? 45 : 6);
        this.registerColorIndex("COLOR_EX_SOLO_OFF", isMkII ? 47 : 5);
        this.registerColorIndex("COLOR_EX_BROWSE_ON", isMkII ? 33 : 2);
        this.registerColorIndex("COLOR_EX_BROWSE_OFF", isMkII ? 35 : 1);
        this.registerColorIndex("COLOR_EX_NOTE_REPEAT_ON", isMkII ? 49 : 4);
        this.registerColorIndex("COLOR_EX_NOTE_REPEAT_OFF", isMkII ? 51 : 3);
        this.registerColorIndex("COLOR_EX_NOTE_REPEAT_PERIOD_ON", isMkII ? 37 : 6);
        this.registerColorIndex("COLOR_EX_NOTE_REPEAT_PERIOD_OFF", isMkII ? 39 : 5);
        this.registerColorIndex("COLOR_EX_NOTE_REPEAT_LENGTH_ON", isMkII ? 57 : 2);
        this.registerColorIndex("COLOR_EX_NOTE_REPEAT_LENGTH_OFF", isMkII ? 59 : 1);
        this.registerColorIndex("COLOR_EX_TOGGLE_ON", isMkII ? 0 : 0);
        this.registerColorIndex("COLOR_EX_TOGGLE_OFF", isMkII ? 0 : 0);
        this.registerColorIndex("PLAY_VIEW_COLOR_PLAY", isMkII ? 22 : 1);
        this.registerColorIndex("PLAY_VIEW_COLOR_RECORD", isMkII ? 6 : 3);
        this.registerColorIndex("PLAY_VIEW_COLOR_OFF", isMkII ? 0 : 0);
        this.registerColorIndex("GRID_COLOR_OFF", isMkII ? 0 : 0);
        this.registerColorIndex(DAWColor.COLOR_OFF, isMkII ? 0 : 0);
        if (isMkII) {
            this.registerColorIndex(DAWColor.DAW_COLOR_GRAY_HALF, 103);
            this.registerColorIndex(DAWColor.DAW_COLOR_DARK_GRAY, 1);
            this.registerColorIndex(DAWColor.DAW_COLOR_GRAY, 103);
            this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_GRAY, 2);
            this.registerColorIndex(DAWColor.DAW_COLOR_SILVER, 40);
            this.registerColorIndex(DAWColor.DAW_COLOR_DARK_BROWN, 11);
            this.registerColorIndex(DAWColor.DAW_COLOR_BROWN, 12);
            this.registerColorIndex(DAWColor.DAW_COLOR_DARK_BLUE, 42);
            this.registerColorIndex(DAWColor.DAW_COLOR_PURPLE_BLUE, 44);
            this.registerColorIndex(DAWColor.DAW_COLOR_PURPLE, 58);
            this.registerColorIndex(DAWColor.DAW_COLOR_PINK, 57);
            this.registerColorIndex(DAWColor.DAW_COLOR_RED, 6);
            this.registerColorIndex(DAWColor.DAW_COLOR_ORANGE, 10);
            this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_ORANGE, 14);
            this.registerColorIndex(DAWColor.DAW_COLOR_MOSS_GREEN, 26);
            this.registerColorIndex(DAWColor.DAW_COLOR_GREEN, 19);
            this.registerColorIndex(DAWColor.DAW_COLOR_COLD_GREEN, 30);
            this.registerColorIndex(DAWColor.DAW_COLOR_BLUE, 37);
            this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_PURPLE, 48);
            this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_PINK, 56);
            this.registerColorIndex(DAWColor.DAW_COLOR_ROSE, 4);
            this.registerColorIndex(DAWColor.DAW_COLOR_REDDISH_BROWN, 10);
            this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_BROWN, 9);
            this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_GREEN, 18);
            this.registerColorIndex(DAWColor.DAW_COLOR_BLUISH_GREEN, 32);
            this.registerColorIndex(DAWColor.DAW_COLOR_GREEN_BLUE, 25);
            this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_BLUE, 41);
        }
        this.registerColorIndex("BUTTON_STATE_OFF", isMkII ? 0 : 0);
        this.registerColorIndex("BUTTON_STATE_ON", 1);
        this.registerColorIndex("BUTTON_STATE_HI", 2);
        this.registerColorIndex(BUTTON_STATE_BLINK, 3);
        this.registerColorIndex(COLOR_VIEW_SELECTED, isMkII ? 22 : 1);
        this.registerColorIndex(COLOR_VIEW_UNSELECTED, isMkII ? 10 : 0);
        this.registerColorIndex(COLOR_VIEW_OFF, isMkII ? 0 : 0);
        this.registerColorIndex(COLOR_KEY_WHITE, isMkII ? 11 : 1);
        this.registerColorIndex(COLOR_KEY_BLACK, isMkII ? 5 : 3);
        this.registerColorIndex(COLOR_KEY_SELECTED, isMkII ? 21 : 5);
        if (isMkII) {
            for (int i = 0; i < 128; ++i) {
                this.registerColor(i, ColorEx.BLACK);
            }
            for (DAWColor dc : DAWColor.values()) {
                String name = dc.name();
                this.registerColor(this.getColorIndex(name), DAWColor.getColorEntry(name));
            }
            this.registerColor(0, ColorEx.BLACK);
            this.registerColor(3, ColorEx.WHITE);
            this.registerColor(5, ColorEx.RED);
            this.registerColor(13, ColorEx.YELLOW);
            this.registerColor(15, ColorEx.evenDarker(ColorEx.YELLOW));
            this.registerColor(21, ColorEx.GREEN);
            this.registerColor(22, ColorEx.darker(ColorEx.GREEN));
            this.registerColor(23, ColorEx.evenDarker(ColorEx.GREEN));
            this.registerColor(45, ColorEx.brighter(ColorEx.BLUE));
            this.registerColor(46, ColorEx.BLUE);
            this.registerColor(47, ColorEx.evenDarker(ColorEx.BLUE));
        } else {
            this.registerColor(0, ColorEx.BLACK);
            this.registerColor(1, ColorEx.GREEN);
            this.registerColor(2, ColorEx.GREEN);
            this.registerColor(3, ColorEx.RED);
            this.registerColor(4, ColorEx.RED);
            this.registerColor(5, ColorEx.YELLOW);
            this.registerColor(6, ColorEx.YELLOW);
            for (int i = 7; i < 128; ++i) {
                this.registerColor(i, ColorEx.BLACK);
            }
        }
    }

    @Override
    public ColorEx getColor(int colorIndex, ButtonID buttonID) {
        switch (buttonID) {
            case ROW1_1: 
            case ROW1_2: 
            case ROW1_3: 
            case ROW1_4: 
            case ROW1_5: 
            case ROW1_6: 
            case ROW1_7: 
            case ROW1_8: 
            case ROW3_1: 
            case ROW3_2: 
            case ROW3_3: 
            case ROW3_4: 
            case ROW3_5: 
            case ROW3_6: 
            case ROW3_7: 
            case ROW3_8: 
            case ROW6_1: 
            case ROW6_2: 
            case ROW6_3: 
            case ROW6_4: 
            case ROW6_5: 
            case ROW6_6: 
            case ROW6_7: 
            case ROW6_8: 
            case MASTERTRACK: 
            case METRONOME: 
            case BANK_LEFT: 
            case BANK_RIGHT: 
            case DEVICE_LEFT: 
            case DEVICE_RIGHT: 
            case LAYOUT: 
            case DEVICE_ON_OFF: 
            case TOGGLE_DEVICES_PANE: 
            case BROWSE: 
            case QUANTIZE: 
            case PAN_SEND: 
            case SEND1: 
            case SEND2: 
            case SEND3: 
            case STOP_ALL_CLIPS: {
                if (this.isMkII) {
                    return colorIndex > 0 ? ColorEx.ORANGE : ColorEx.BLACK;
                }
                return colorIndex > 0 ? ColorEx.GREEN : ColorEx.BLACK;
            }
            case ROW2_1: 
            case ROW2_2: 
            case ROW2_3: 
            case ROW2_4: 
            case ROW2_5: 
            case ROW2_6: 
            case ROW2_7: 
            case ROW2_8: {
                return colorIndex > 0 ? ColorEx.BLUE : ColorEx.BLACK;
            }
            case ROW4_1: 
            case ROW4_2: 
            case ROW4_3: 
            case ROW4_4: 
            case ROW4_5: 
            case ROW4_6: 
            case ROW4_7: 
            case ROW4_8: {
                return colorIndex > 0 ? ColorEx.RED : ColorEx.BLACK;
            }
            case PLAY: 
            case STOP: {
                return colorIndex > 0 ? ColorEx.GREEN : ColorEx.BLACK;
            }
            case RECORD: {
                return colorIndex > 0 ? ColorEx.RED : ColorEx.BLACK;
            }
            case CLIP: {
                if (this.isMkII) {
                    return colorIndex > 0 ? ColorEx.RED : ColorEx.BLACK;
                }
                return colorIndex > 0 ? ColorEx.GREEN : ColorEx.BLACK;
            }
        }
        return super.getColor(colorIndex, buttonID);
    }
}

