/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.acvs.mode;

import de.mossgrabers.controller.akai.acvs.ACVSConfiguration;
import de.mossgrabers.controller.akai.acvs.ACVSDevice;
import de.mossgrabers.controller.akai.acvs.controller.ACVSControlSurface;
import de.mossgrabers.controller.akai.acvs.controller.ACVSDisplay;
import de.mossgrabers.controller.akai.acvs.controller.ScreenItem;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IArranger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.constants.LaunchQuantization;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.VolumeParameterProvider;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ControlMode
extends AbstractParameterMode<ACVSControlSurface, ACVSConfiguration, IChannel> {
    private static final Map<Modes, Integer> MODE_COLORS = new EnumMap<Modes, Integer>(Modes.class);
    private int currentMaxScene = 0;

    public ControlMode(ACVSControlSurface surface, IModel model) {
        super("Control", surface, model);
        ACVSConfiguration configuration = (ACVSConfiguration)((ACVSControlSurface)this.surface).getConfiguration();
        if (configuration.isActiveACVSDevice(ACVSDevice.FORCE) || configuration.isActiveACVSDevice(ACVSDevice.MPC_X)) {
            List<ContinuousID> knobs = ContinuousID.createSequentialList(ContinuousID.VOLUME_KNOB1, 8);
            knobs.addAll(ContinuousID.createSequentialList(ContinuousID.PARAM_KNOB1, 8));
            this.setControls(knobs);
            VolumeParameterProvider provider1 = new VolumeParameterProvider(model.getTrackBank());
            BankParameterProvider provider2 = new BankParameterProvider(model.getCursorDevice().getParameterBank());
            this.setParameterProvider(new CombinedParameterProvider(provider1, provider2));
        }
    }

    @Override
    public void updateDisplay() {
        ACVSDisplay d = (ACVSDisplay)((ACVSControlSurface)this.surface).getDisplay();
        ACVSConfiguration configuration = (ACVSConfiguration)((ACVSControlSurface)this.surface).getConfiguration();
        boolean isForce = configuration.isActiveACVSDevice(ACVSDevice.FORCE);
        boolean isMPC = !isForce;
        ITrackBank tb = this.model.getCurrentTrackBank();
        ICursorDevice device = this.model.getCursorDevice();
        int maxScene = ControlMode.calcMaxScene(this.model.getSceneBank());
        d.setScreenItem(ScreenItem.TRACK_NUMBER_OF_SCENES, maxScene);
        d.setScreenItem(ScreenItem.TRACK_SENDS_NO, ControlMode.calcNumberOfSends(tb));
        for (int i = 0; i < 8; ++i) {
            ITrack track = (ITrack)tb.getItem(i);
            ControlMode.sendTrackData(d, i, track);
            this.sendClipData(d, isMPC, i, track.getSlotBank());
        }
        this.sendSceneData(d, isMPC);
        boolean exists = device.doesExist();
        IParameterBank parameterBank = device.getParameterBank();
        Optional<String> selectedPage = parameterBank.getPageBank().getSelectedItem();
        d.setRow(512, exists ? selectedPage.orElse("") : "");
        d.setRow(513, exists ? device.getName() : "");
        d.setScreenItem(ScreenItem.DEVICE_COUNT, device.doesExist() ? device.getDeviceBank().getItemCount() : 0);
        int devicePosition = device.getPosition();
        d.setScreenItem(ScreenItem.CURRENT_DEVICE_INDEX, devicePosition >= 0 ? devicePosition : 0);
        d.setScreenItem(ScreenItem.CURRENT_DEVICE_ACTIVE, device.isEnabled() ? 127 : 0);
        for (int i = 0; i < 8; ++i) {
            IParameter param = (IParameter)parameterBank.getItem(i);
            d.setRow(528 + i, param.getName());
            d.setRow(544 + i, param.getDisplayedValue());
            d.setScreenItem(ScreenItem.get(ScreenItem.DEVICE_PARAM1_ENABLED, i), param.doesExist() ? 127 : 0);
            d.setScreenItem(ScreenItem.get(ScreenItem.DEVICE_PARAM1_VALUE, i), param.getValue());
            d.setScreenItem(ScreenItem.get(ScreenItem.KNOBSTYLE1_COLOR, 8 + i), param.doesExist() ? 1 : 0);
            d.setScreenItem(ScreenItem.get(ScreenItem.KNOB_VALUE1, 8 + i), param.getValue());
            d.setRow(4632 + i, param.getName());
            d.setRow(4663 + i, param.getDisplayedValue());
            ITrack track = (ITrack)tb.getItem(i);
            d.setScreenItem(ScreenItem.get(ScreenItem.KNOBSTYLE1_COLOR, i), track.doesExist() ? 1 : 0);
            d.setScreenItem(ScreenItem.get(ScreenItem.KNOB_VALUE1, i), track.getVolume());
            d.setRow(4624 + i, track.getName());
            d.setRow(4655 + i, track.getVolumeStr());
        }
        ITransport transport = this.model.getTransport();
        d.setRow(768, transport.formatTempo(transport.getTempo()));
        d.setRow(784, transport.getBeatText().split(":")[0].replace('.', ':'));
        d.setRow(785, transport.getLoopStartBeatText().split(":")[0].replace('.', ':'));
        d.setRow(786, transport.getLoopLengthBeatText().split(":")[0].replace('.', ':'));
        this.sendAdditionalMPCParameters(d);
        if (!isMPC) {
            this.sendAdditionalForceParameters(d);
        }
        d.allDone();
        if (this.currentMaxScene != maxScene) {
            this.currentMaxScene = maxScene;
            ((ACVSControlSurface)this.surface).forceFlush();
        }
    }

    private static void sendTrackData(ACVSDisplay d, int trackIndex, ITrack track) {
        d.setRow(0 + trackIndex, track.getName());
        d.setColor(0 + trackIndex, track.getColor());
        d.setRow(256 + trackIndex, track.getVolumeStr());
        d.setRow(272 + trackIndex, track.getPanStr());
        d.setScreenItem(ScreenItem.get(ScreenItem.TRACK1_SELECT, trackIndex), track.isSelected() ? 127 : 0);
        d.setScreenItem(ScreenItem.get(ScreenItem.TRACK1_TYPE, trackIndex), ControlMode.getTrackType(track));
        d.setScreenItem(ScreenItem.get(ScreenItem.TRACK1_SOLO, trackIndex), track.isSolo() ? 127 : 0);
        d.setScreenItem(ScreenItem.get(ScreenItem.TRACK1_MUTE, trackIndex), track.isMute() ? 127 : 0);
        d.setScreenItem(ScreenItem.get(ScreenItem.TRACK1_SOLOMUTE, trackIndex), track.isMutedBySolo() ? 127 : 0);
        d.setScreenItem(ScreenItem.get(ScreenItem.TRACK1_CROSSFADER, trackIndex), ControlMode.getCrossfade(track.getCrossfadeParameter().getValue()));
        d.setScreenItem(ScreenItem.get(ScreenItem.TRACK1_REC_ARM, trackIndex), track.isRecArm() ? 127 : 0);
        d.setScreenItem(ScreenItem.get(ScreenItem.TRACK1_LEVEL, trackIndex), track.getVolume());
        d.setScreenItem(ScreenItem.get(ScreenItem.TRACK1_PAN, trackIndex), track.getPan());
        d.setScreenItem(ScreenItem.get(ScreenItem.TRACK1_VU_LEFT, trackIndex), track.getVuLeft());
        d.setScreenItem(ScreenItem.get(ScreenItem.TRACK1_VU_RIGHT, trackIndex), track.getVuRight());
        d.setScreenItem(ScreenItem.get(ScreenItem.TRACK1_VU_PEAK_LEFT, trackIndex), track.getVuPeakLeft());
        d.setScreenItem(ScreenItem.get(ScreenItem.TRACK1_VU_PEAK_RIGHT, trackIndex), track.getVuPeakRight());
        ISendBank sendBank = track.getSendBank();
        ISend send1 = (ISend)sendBank.getItem(0);
        ISend send2 = (ISend)sendBank.getItem(1);
        ISend send3 = (ISend)sendBank.getItem(2);
        ISend send4 = (ISend)sendBank.getItem(3);
        d.setRow(280 + trackIndex, send1.getName());
        d.setRow(288 + trackIndex, send2.getName());
        d.setRow(296 + trackIndex, send3.getName());
        d.setRow(304 + trackIndex, send4.getName());
        d.setScreenItem(ScreenItem.get(ScreenItem.TRACK1_SEND1_LEVEL, trackIndex), send1.getValue());
        d.setScreenItem(ScreenItem.get(ScreenItem.TRACK1_SEND2_LEVEL, trackIndex), send2.getValue());
        d.setScreenItem(ScreenItem.get(ScreenItem.TRACK1_SEND3_LEVEL, trackIndex), send3.getValue());
        d.setScreenItem(ScreenItem.get(ScreenItem.TRACK1_SEND4_LEVEL, trackIndex), send4.getValue());
    }

    private void sendClipData(ACVSDisplay d, boolean isMPC, int trackIndex, ISlotBank slotBank) {
        int slotState;
        int position;
        ISlot slot;
        int clipIndex;
        for (clipIndex = 0; clipIndex < 8; ++clipIndex) {
            slot = (ISlot)slotBank.getItem(clipIndex);
            position = clipIndex * 8 + trackIndex;
            slotState = ControlMode.convertSlotState(slot);
            d.setRow(16 + position, slot.getName());
            d.setScreenItem(ScreenItem.get(ScreenItem.CLIP1_STATE, position), slotState);
            d.setColor(16 + position, slot.getColor());
        }
        d.setScreenItem(ScreenItem.get(ScreenItem.TRACK1_CLIP_PROGRESS, trackIndex), 0);
        if (!((ACVSConfiguration)((ACVSControlSurface)this.surface).getConfiguration()).isLaunchClips()) {
            return;
        }
        for (clipIndex = 0; clipIndex < 8; ++clipIndex) {
            slot = (ISlot)slotBank.getItem(clipIndex);
            position = clipIndex * 8 + trackIndex;
            slotState = ControlMode.convertSlotState(slot);
            int slotColor = this.convertSlotStateToColor(slot);
            if (isMPC) {
                d.setScreenItem(ScreenItem.get(ScreenItem.MPC_PAD1_STATE, position), slotState);
                d.setScreenItem(ScreenItem.get(ScreenItem.MPC_PAD1_COLOR, position), slotColor);
                continue;
            }
            d.setScreenItem(ScreenItem.get(ScreenItem.FORCE_PAD1_STATE, position), slotState);
            d.setScreenItem(ScreenItem.get(ScreenItem.FORCE_PAD1_COLOR, position), slotColor);
        }
    }

    private void sendSceneData(ACVSDisplay d, boolean isMPC) {
        IScene scene;
        int sceneIndex;
        ISceneBank sceneBank = this.model.getSceneBank();
        for (sceneIndex = 0; sceneIndex < 8; ++sceneIndex) {
            scene = (IScene)sceneBank.getItem(sceneIndex);
            d.setRow(80 + sceneIndex, scene.getName());
            d.setColor(80 + sceneIndex, scene.getColor());
            d.setScreenItem(ScreenItem.get(ScreenItem.SCENE1_SELECT, sceneIndex), scene.isSelected() ? 127 : 0);
        }
        if (isMPC) {
            if (((ACVSConfiguration)((ACVSControlSurface)this.surface).getConfiguration()).isLaunchClips()) {
                return;
            }
            for (sceneIndex = 0; sceneIndex < 8; ++sceneIndex) {
                scene = (IScene)sceneBank.getItem(sceneIndex);
                int sceneColor = scene.doesExist() ? this.colorManager.getColorIndex(DAWColor.getColorID(scene.getColor())) : 0;
                int offset = sceneIndex < 4 ? 0 : 4;
                d.setScreenItem(ScreenItem.get(ScreenItem.MPC_PAD1_STATE, offset + sceneIndex), 2);
                d.setScreenItem(ScreenItem.get(ScreenItem.MPC_PAD1_COLOR, offset + sceneIndex), sceneColor);
            }
            for (int padIndex = 0; padIndex < 4; ++padIndex) {
                d.setScreenItem(ScreenItem.get(ScreenItem.MPC_PAD1_STATE, 16 + padIndex), 0);
                d.setScreenItem(ScreenItem.get(ScreenItem.MPC_PAD1_COLOR, 16 + padIndex), 0);
                d.setScreenItem(ScreenItem.get(ScreenItem.MPC_PAD1_STATE, 24 + padIndex), 0);
                d.setScreenItem(ScreenItem.get(ScreenItem.MPC_PAD1_COLOR, 24 + padIndex), 0);
            }
            return;
        }
        for (sceneIndex = 0; sceneIndex < 8; ++sceneIndex) {
            scene = (IScene)sceneBank.getItem(sceneIndex);
            int color = 0;
            if (scene.doesExist()) {
                color = scene.isSelected() ? 1 : 2;
            }
            d.setScreenItem(ScreenItem.get(ScreenItem.FORCE_SCENE1, sceneIndex), color);
        }
    }

    private void sendAdditionalMPCParameters(ACVSDisplay d) {
        ITransport transport = this.model.getTransport();
        IApplication application = this.model.getApplication();
        IArranger arranger = this.model.getArranger();
        ICursorDevice device = this.model.getCursorDevice();
        d.setScreenItem(ScreenItem.MPC_METRONOME, transport.isMetronomeOn() ? 127 : 0);
        boolean isOverdub = ((ACVSControlSurface)this.surface).isShiftPressed() ? transport.isLauncherOverdub() : transport.isArrangerOverdub();
        d.setScreenItem(ScreenItem.MPC_ARRANGE_OVERDUB, isOverdub ? 127 : 0);
        boolean isAutomation = ((ACVSControlSurface)this.surface).isShiftPressed() ? transport.isWritingClipLauncherAutomation() : transport.isWritingArrangerAutomation();
        d.setScreenItem(ScreenItem.MPC_ARRANGER_AUTOMATION_ARM, isAutomation ? 127 : 0);
        d.setScreenItem(ScreenItem.MPC_LOOP_SWITCH, transport.isLoop() ? 127 : 0);
        d.setScreenItem(ScreenItem.MPC_LAUNCH_QUANTIZE, ControlMode.convertLaunchQuantization(transport.getDefaultLaunchQuantization()));
        d.setScreenItem(ScreenItem.MPC_ARRANGEMENT_SESSION, application.isArrangeLayout() ? 1 : 0);
        d.setScreenItem(ScreenItem.MPC_FOLLOW, arranger.isPlaybackFollowEnabled() ? 127 : 0);
        d.setScreenItem(ScreenItem.MPC_DEVICE_LOCK, device.isPinned() ? 127 : 0);
        d.setScreenItem(ScreenItem.MPC_DETAIL_VIEW, device.isExpanded() ? 127 : 0);
        d.setScreenItem(ScreenItem.MPC_QUANTIZE_INTERVAL, Math.max(0, Math.min(7, 10 - ((ACVSConfiguration)((ACVSControlSurface)this.surface).getConfiguration()).getQuantizeAmount() / 10)));
        d.setScreenItem(ScreenItem.MPC_CLIP_SCENE_LAUNCH, ((ACVSConfiguration)((ACVSControlSurface)this.surface).getConfiguration()).isLaunchClips() ? 0 : 1);
    }

    private void sendAdditionalForceParameters(ACVSDisplay d) {
        Modes activeMode = (Modes)((Object)((ACVSControlSurface)this.surface).getTrackModeManager().getActiveID());
        int modeColor = MODE_COLORS.getOrDefault((Object)activeMode, 0);
        for (int trackIndex = 0; trackIndex < 8; ++trackIndex) {
            ITrack track = (ITrack)this.model.getTrackBank().getItem(trackIndex);
            int color = ((ACVSControlSurface)this.surface).isShiftPressed() ? (LaunchQuantization.values()[trackIndex] == this.model.getTransport().getDefaultLaunchQuantization() ? 33 : 0) : (!track.doesExist() ? 0 : (track.isSelected() ? 33 : this.colorManager.getColorIndex(DAWColor.getColorID(track.getColor()))));
            d.setScreenItem(ScreenItem.get(ScreenItem.FORCE_TRACK1_COLOR, trackIndex), color);
            switch (activeMode) {
                case CROSSFADE_MODE_A: {
                    double value1 = this.model.getValueChanger().toNormalizedValue(track.getCrossfadeParameter().getValue());
                    color = value1 < 0.1 ? modeColor : 0;
                    break;
                }
                case CROSSFADE_MODE_B: {
                    double value2 = this.model.getValueChanger().toNormalizedValue(track.getCrossfadeParameter().getValue());
                    color = value2 > 0.9 ? modeColor : 0;
                    break;
                }
                case MUTE: {
                    color = track.isMute() ? modeColor : 0;
                    break;
                }
                case SOLO: {
                    color = track.isSolo() ? modeColor : 0;
                    break;
                }
                case REC_ARM: {
                    color = track.isRecArm() ? modeColor : 0;
                    break;
                }
                default: {
                    color = modeColor;
                }
            }
            d.setScreenItem(ScreenItem.get(ScreenItem.FORCE_TRACK1_ASSIGN, trackIndex), color);
        }
    }

    private static int getCrossfade(int value) {
        if (value == 0) {
            return 1;
        }
        if (value == 127) {
            return 2;
        }
        return 0;
    }

    private static int convertLaunchQuantization(LaunchQuantization launchQuantization) {
        switch (launchQuantization) {
            default: {
                return 0;
            }
            case RES_1_16: {
                return 11;
            }
            case RES_1_8: {
                return 9;
            }
            case RES_1_4: {
                return 7;
            }
            case RES_1_2: {
                return 5;
            }
            case RES_1: {
                return 4;
            }
            case RES_2: {
                return 3;
            }
            case RES_4: {
                return 2;
            }
            case RES_8: 
        }
        return 1;
    }

    private static int getTrackType(ITrack track) {
        if (!track.doesExist()) {
            return 0;
        }
        switch (track.getType()) {
            case AUDIO: {
                return 6;
            }
            case INSTRUMENT: {
                return track.hasDrumDevice() ? 2 : 4;
            }
            case HYBRID: {
                return 4;
            }
            case GROUP: 
            case GROUP_OPEN: {
                return 7;
            }
            case EFFECT: {
                return 8;
            }
            case MASTER: {
                return 9;
            }
        }
        return 0;
    }

    private static int convertSlotState(ISlot slot) {
        if (!slot.doesExist()) {
            return 0;
        }
        if (!slot.hasContent()) {
            return 1;
        }
        if (slot.isStopQueued()) {
            return slot.isRecording() ? 8 : 5;
        }
        if (slot.isRecording()) {
            return 7;
        }
        if (slot.isRecordingQueued()) {
            return 6;
        }
        if (slot.isPlaying()) {
            return 4;
        }
        if (slot.isPlayingQueued()) {
            return 3;
        }
        return 2;
    }

    private int convertSlotStateToColor(ISlot slot) {
        if (!slot.doesExist() || !slot.hasContent()) {
            return 0;
        }
        ColorEx color = slot.getColor();
        return this.colorManager.getColorIndex(DAWColor.getColorID(color));
    }

    private static int calcNumberOfSends(ITrackBank tb) {
        int numSends = 0;
        for (int i = 0; i < 4 && tb.canEditSend(i); ++i) {
            numSends = i + 1;
        }
        return numSends;
    }

    private static int calcMaxScene(ISceneBank sceneBank) {
        int maxScene = 0;
        for (int i = 0; i < 8; ++i) {
            IScene scene = (IScene)sceneBank.getItem(i);
            if (!scene.doesExist()) continue;
            maxScene = i + 1;
        }
        return maxScene;
    }

    @Override
    public void selectPreviousItem() {
        if (((ACVSControlSurface)this.surface).isShiftPressed()) {
            this.model.getTrackBank().selectPreviousPage();
        } else {
            this.model.getTrackBank().scrollBackwards();
        }
    }

    @Override
    public void selectNextItem() {
        if (((ACVSControlSurface)this.surface).isShiftPressed()) {
            this.model.getTrackBank().selectNextPage();
        } else {
            this.model.getTrackBank().scrollForwards();
        }
    }

    @Override
    public boolean hasPreviousItem() {
        return this.model.getTrackBank().canScrollBackwards();
    }

    @Override
    public boolean hasNextItem() {
        return this.model.getTrackBank().canScrollForwards();
    }

    @Override
    public boolean hasPreviousItemPage() {
        return this.model.getTrackBank().canScrollPageBackwards();
    }

    @Override
    public boolean hasNextItemPage() {
        return this.model.getTrackBank().canScrollPageForwards();
    }

    static {
        MODE_COLORS.put(Modes.MUTE, 23);
        MODE_COLORS.put(Modes.SOLO, 17);
        MODE_COLORS.put(Modes.REC_ARM, 3);
        MODE_COLORS.put(Modes.STOP_CLIP, 69);
        MODE_COLORS.put(Modes.CROSSFADE_MODE_A, 5);
        MODE_COLORS.put(Modes.CROSSFADE_MODE_B, 3);
    }
}

